/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal;

import com.intellij.ide.IdeBundle;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.terminal.JBTerminalWidgetListener;
import com.intellij.terminal.TerminalUiSettingsManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.jediterm.terminal.CursorShape;
import com.jediterm.terminal.TerminalColor;
import com.jediterm.terminal.TextStyle;
import com.jediterm.terminal.emulator.ColorPalette;
import com.jediterm.terminal.ui.TerminalAction;
import com.jediterm.terminal.ui.TerminalActionPresentation;
import com.jediterm.terminal.ui.settings.DefaultTabbedSettingsProvider;
import java.awt.Color;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JBTerminalSystemSettingsProviderBase
extends DefaultTabbedSettingsProvider {
    public static final TextAttributesKey COMMAND_TO_RUN_USING_IDE_KEY = TextAttributesKey.createTextAttributesKey((String)"TERMINAL_COMMAND_TO_RUN_USING_IDE");
    private final TerminalUiSettingsManager myUiSettingsManager = TerminalUiSettingsManager.getInstance();

    @NotNull
    TerminalUiSettingsManager getUiSettingsManager() {
        TerminalUiSettingsManager terminalUiSettingsManager = this.myUiSettingsManager;
        if (terminalUiSettingsManager == null) {
            JBTerminalSystemSettingsProviderBase.$$$reportNull$$$0(0);
        }
        return terminalUiSettingsManager;
    }

    @NotNull
    EditorColorsScheme getColorsScheme() {
        EditorColorsScheme editorColorsScheme = this.myUiSettingsManager.getEditorColorsScheme();
        if (editorColorsScheme == null) {
            JBTerminalSystemSettingsProviderBase.$$$reportNull$$$0(1);
        }
        return editorColorsScheme;
    }

    @NotNull
    public TerminalActionPresentation getNewSessionActionPresentation() {
        TerminalActionPresentation presentation2 = super.getNewSessionActionPresentation();
        return new TerminalActionPresentation(IdeBundle.message((String)"terminal.action.NewSession.text", (Object[])new Object[0]), presentation2.getKeyStrokes());
    }

    @NotNull
    public TerminalActionPresentation getOpenUrlActionPresentation() {
        return new TerminalActionPresentation(IdeBundle.message((String)"terminal.action.OpenAsUrl.text", (Object[])new Object[0]), Collections.emptyList());
    }

    @NotNull
    public TerminalActionPresentation getCopyActionPresentation() {
        List<KeyStroke> strokes = JBTerminalSystemSettingsProviderBase.getKeyStrokesByActionId("Terminal.CopySelectedText");
        if (strokes.isEmpty()) {
            strokes = JBTerminalSystemSettingsProviderBase.getKeyStrokesByActionId("$Copy");
        }
        return new TerminalActionPresentation(UIUtil.removeMnemonic((String)ActionsBundle.message((String)"action.$Copy.text", (Object[])new Object[0])), strokes);
    }

    @NotNull
    public TerminalActionPresentation getPasteActionPresentation() {
        List<KeyStroke> strokes = JBTerminalSystemSettingsProviderBase.getKeyStrokesByActionId("Terminal.Paste");
        if (strokes.isEmpty()) {
            strokes = JBTerminalSystemSettingsProviderBase.getKeyStrokesByActionId("$Paste");
        }
        return new TerminalActionPresentation(UIUtil.removeMnemonic((String)ActionsBundle.message((String)"action.$Paste.text", (Object[])new Object[0])), strokes);
    }

    @NotNull
    public TerminalActionPresentation getSelectAllActionPresentation() {
        List<KeyStroke> strokes = JBTerminalSystemSettingsProviderBase.getKeyStrokesByActionId("Terminal.SelectAll");
        return new TerminalActionPresentation(UIUtil.removeMnemonic((String)ActionsBundle.message((String)"action.$SelectAll.text", (Object[])new Object[0])), strokes);
    }

    @NotNull
    public TerminalActionPresentation getClearBufferActionPresentation() {
        List<KeyStroke> strokes = JBTerminalSystemSettingsProviderBase.getKeyStrokesByActionId("Terminal.ClearBuffer");
        if (strokes.isEmpty()) {
            TerminalActionPresentation terminalActionPresentation = super.getClearBufferActionPresentation();
            if (terminalActionPresentation == null) {
                JBTerminalSystemSettingsProviderBase.$$$reportNull$$$0(2);
            }
            return terminalActionPresentation;
        }
        return new TerminalActionPresentation(IdeBundle.message((String)"terminal.action.ClearBuffer.text", (Object[])new Object[0]), strokes);
    }

    @NotNull
    public TerminalActionPresentation getPageUpActionPresentation() {
        TerminalActionPresentation presentation2 = super.getPageUpActionPresentation();
        return new TerminalActionPresentation(IdeBundle.message((String)"terminal.action.PageUp.text", (Object[])new Object[0]), presentation2.getKeyStrokes());
    }

    @NotNull
    public TerminalActionPresentation getPageDownActionPresentation() {
        TerminalActionPresentation presentation2 = super.getPageDownActionPresentation();
        return new TerminalActionPresentation(IdeBundle.message((String)"terminal.action.PageDown.text", (Object[])new Object[0]), presentation2.getKeyStrokes());
    }

    @NotNull
    public TerminalActionPresentation getLineUpActionPresentation() {
        TerminalActionPresentation presentation2 = super.getLineUpActionPresentation();
        return new TerminalActionPresentation(IdeBundle.message((String)"terminal.action.LineUp.text", (Object[])new Object[0]), presentation2.getKeyStrokes());
    }

    @NotNull
    public TerminalActionPresentation getLineDownActionPresentation() {
        TerminalActionPresentation presentation2 = super.getLineDownActionPresentation();
        return new TerminalActionPresentation(IdeBundle.message((String)"terminal.action.LineDown.text", (Object[])new Object[0]), presentation2.getKeyStrokes());
    }

    @NotNull
    public TerminalActionPresentation getCloseSessionActionPresentation() {
        List keyStrokes = ContainerUtil.concat((List)super.getCloseSessionActionPresentation().getKeyStrokes(), JBTerminalSystemSettingsProviderBase.getKeyStrokesByActionId("CloseActiveTab"));
        return new TerminalActionPresentation(IdeBundle.message((String)"terminal.action.CloseSession.text", (Object[])new Object[0]), keyStrokes);
    }

    @NotNull
    public TerminalActionPresentation getFindActionPresentation() {
        return new TerminalActionPresentation(IdeBundle.message((String)"terminal.action.Find.text", (Object[])new Object[0]), JBTerminalSystemSettingsProviderBase.getKeyStrokesByActionId("Find"));
    }

    @NotNull
    public ColorPalette getTerminalColorPalette() {
        ColorPalette colorPalette = this.myUiSettingsManager.getTerminalColorPalette();
        if (colorPalette == null) {
            JBTerminalSystemSettingsProviderBase.$$$reportNull$$$0(3);
        }
        return colorPalette;
    }

    @NotNull
    @Nls
    public static String getGotoNextSplitTerminalActionText(boolean forward) {
        String string = forward ? ActionsBundle.message((String)"action.NextSplitter.text", (Object[])new Object[0]) : ActionsBundle.message((String)"action.PrevSplitter.text", (Object[])new Object[0]);
        if (string == null) {
            JBTerminalSystemSettingsProviderBase.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public TerminalAction getGotoNextSplitTerminalAction(@Nullable JBTerminalWidgetListener listener2, boolean forward) {
        String actionId = forward ? "Terminal.NextSplitter" : "Terminal.PrevSplitter";
        String text2 = UIUtil.removeMnemonic((String)JBTerminalSystemSettingsProviderBase.getGotoNextSplitTerminalActionText(forward));
        return new TerminalAction(new TerminalActionPresentation(text2, JBTerminalSystemSettingsProviderBase.getKeyStrokesByActionId(actionId)), event -> {
            if (listener2 != null) {
                listener2.gotoNextSplitTerminal(forward);
            }
            return true;
        });
    }

    @NotNull
    public static List<KeyStroke> getKeyStrokesByActionId(@NotNull String actionId) {
        Shortcut[] shortcuts;
        if (actionId == null) {
            JBTerminalSystemSettingsProviderBase.$$$reportNull$$$0(5);
        }
        ArrayList<KeyStroke> keyStrokes = new ArrayList<KeyStroke>();
        for (Shortcut sc : shortcuts = KeymapUtil.getActiveKeymapShortcuts((String)actionId).getShortcuts()) {
            if (!(sc instanceof KeyboardShortcut)) continue;
            KeyStroke ks = ((KeyboardShortcut)sc).getFirstKeyStroke();
            keyStrokes.add(ks);
        }
        ArrayList<KeyStroke> arrayList = keyStrokes;
        if (arrayList == null) {
            JBTerminalSystemSettingsProviderBase.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    @NotNull
    public TerminalActionPresentation getNextTabActionPresentation() {
        return new TerminalActionPresentation(IdeBundle.message((String)"terminal.action.SelectNextTab.text", (Object[])new Object[0]), JBTerminalSystemSettingsProviderBase.getKeyStrokesByActionId("NextTab"));
    }

    @NotNull
    public TerminalActionPresentation getPreviousTabActionPresentation() {
        return new TerminalActionPresentation(IdeBundle.message((String)"terminal.action.SelectPreviousTab.text", (Object[])new Object[0]), JBTerminalSystemSettingsProviderBase.getKeyStrokesByActionId("PreviousTab"));
    }

    @NotNull
    public TerminalActionPresentation getMoveTabRightActionPresentation() {
        return new TerminalActionPresentation(IdeBundle.message((String)"terminal.action.MoveRight.text", (Object[])new Object[0]), JBTerminalSystemSettingsProviderBase.getKeyStrokesByActionId("Terminal.MoveToolWindowTabRight"));
    }

    @NotNull
    public TerminalActionPresentation getMoveTabLeftActionPresentation() {
        return new TerminalActionPresentation(IdeBundle.message((String)"terminal.action.MoveLeft.text", (Object[])new Object[0]), JBTerminalSystemSettingsProviderBase.getKeyStrokesByActionId("Terminal.MoveToolWindowTabLeft"));
    }

    @NotNull
    public TerminalActionPresentation getShowTabsActionPresentation() {
        return new TerminalActionPresentation(IdeBundle.message((String)"terminal.action.ShowTabs.text", (Object[])new Object[0]), JBTerminalSystemSettingsProviderBase.getKeyStrokesByActionId("ShowContent"));
    }

    public float getLineSpacing() {
        return this.getColorsScheme().getConsoleLineSpacing();
    }

    public TextStyle getSelectionColor() {
        return new TextStyle(TerminalColor.awt((Color)this.getColorsScheme().getColor(EditorColors.SELECTION_FOREGROUND_COLOR)), TerminalColor.awt((Color)this.getColorsScheme().getColor(EditorColors.SELECTION_BACKGROUND_COLOR)));
    }

    public TextStyle getFoundPatternColor() {
        return new TextStyle(TerminalColor.awt((Color)this.getColorsScheme().getAttributes(EditorColors.TEXT_SEARCH_RESULT_ATTRIBUTES).getForegroundColor()), TerminalColor.awt((Color)this.getColorsScheme().getAttributes(EditorColors.TEXT_SEARCH_RESULT_ATTRIBUTES).getBackgroundColor()));
    }

    public TextStyle getHyperlinkColor() {
        return new TextStyle(TerminalColor.awt((Color)this.getColorsScheme().getAttributes(EditorColors.REFERENCE_HYPERLINK_COLOR).getForegroundColor()), TerminalColor.awt((Color)this.getColorsScheme().getAttributes(EditorColors.REFERENCE_HYPERLINK_COLOR).getBackgroundColor()));
    }

    public TextStyle getDefaultStyle() {
        return new TextStyle(new TerminalColor(() -> this.myUiSettingsManager.getDefaultForeground()), new TerminalColor(() -> this.myUiSettingsManager.getDefaultBackground()));
    }

    public Font getTerminalFont() {
        Font font = this.getColorsScheme().getFont(EditorFontType.CONSOLE_PLAIN);
        return font.deriveFont(this.getTerminalFontSize());
    }

    public float getTerminalFontSize() {
        return this.myUiSettingsManager.getFontSize();
    }

    public boolean useAntialiasing() {
        return true;
    }

    public int getBufferMaxLinesCount() {
        int linesCount = AdvancedSettings.getInt((String)"terminal.buffer.max.lines.count");
        if (linesCount > 0) {
            return linesCount;
        }
        return super.getBufferMaxLinesCount();
    }

    public boolean overrideIdeShortcuts() {
        return false;
    }

    public boolean useInverseSelectionColor() {
        return false;
    }

    public int caretBlinkingMs() {
        return EditorSettingsExternalizable.getInstance().getBlinkPeriod();
    }

    @NotNull
    public CursorShape getCursorShape() {
        EditorSettingsExternalizable editorSettings = EditorSettingsExternalizable.getInstance();
        TerminalUiSettingsManager.CursorShape shape = TerminalUiSettingsManager.getInstance().getCursorShape();
        if (shape == TerminalUiSettingsManager.CursorShape.BLOCK) {
            CursorShape cursorShape = editorSettings.isBlinkCaret() ? CursorShape.BLINK_BLOCK : CursorShape.STEADY_BLOCK;
            if (cursorShape == null) {
                JBTerminalSystemSettingsProviderBase.$$$reportNull$$$0(7);
            }
            return cursorShape;
        }
        if (shape == TerminalUiSettingsManager.CursorShape.UNDERLINE) {
            CursorShape cursorShape = editorSettings.isBlinkCaret() ? CursorShape.BLINK_UNDERLINE : CursorShape.STEADY_UNDERLINE;
            if (cursorShape == null) {
                JBTerminalSystemSettingsProviderBase.$$$reportNull$$$0(8);
            }
            return cursorShape;
        }
        CursorShape cursorShape = editorSettings.isBlinkCaret() ? CursorShape.BLINK_VERTICAL_BAR : CursorShape.STEADY_VERTICAL_BAR;
        if (cursorShape == null) {
            JBTerminalSystemSettingsProviderBase.$$$reportNull$$$0(9);
        }
        return cursorShape;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/terminal/JBTerminalSystemSettingsProviderBase";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getUiSettingsManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getColorsScheme";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getClearBufferActionPresentation";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTerminalColorPalette";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getGotoNextSplitTerminalActionText";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/terminal/JBTerminalSystemSettingsProviderBase";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyStrokesByActionId";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getCursorShape";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getKeyStrokesByActionId";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

