/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.ui.PrevNextActionsDescriptor;
import com.intellij.ui.TabbedPane;
import com.intellij.ui.tabs.JBEditorTabsBase;
import com.intellij.ui.tabs.JBTabs;
import com.intellij.ui.tabs.JBTabsFactory;
import com.intellij.ui.tabs.JBTabsPosition;
import com.intellij.ui.tabs.JBTabsPresentation;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.TabsListener;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseListener;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JBTabsPaneImpl
implements TabbedPane {
    private final JBEditorTabsBase myTabs;
    private final CopyOnWriteArraySet<ChangeListener> myListeners;

    public JBTabsPaneImpl(@Nullable Project project, int tabPlacement, @NotNull Disposable parent) {
        if (parent == null) {
            JBTabsPaneImpl.$$$reportNull$$$0(0);
        }
        this.myListeners = new CopyOnWriteArraySet();
        this.myTabs = JBTabsFactory.createEditorTabs((Project)project, (Disposable)parent);
        this.myTabs.getPresentation().setAlphabeticalMode(false).setSupportsCompression(false).setFirstTabOffset(10);
        this.myTabs.setEmptySpaceColorCallback(() -> UIUtil.getBgFillColor((Component)this.myTabs.getComponent().getParent()));
        this.myTabs.addListener(new TabsListener(){

            public void selectionChanged(TabInfo oldSelection, TabInfo newSelection) {
                JBTabsPaneImpl.this.fireChanged(new ChangeEvent(JBTabsPaneImpl.this.myTabs));
            }
        }).getPresentation().setPaintBorder(1, 1, 1, 1).setTabSidePaintBorder(2).setPaintFocus(StartupUiUtil.isUnderDarcula() || UIUtil.isUnderIntelliJLaF());
        this.setTabPlacement(tabPlacement);
    }

    private void fireChanged(ChangeEvent event) {
        for (ChangeListener each : this.myListeners) {
            each.stateChanged(event);
        }
    }

    @Override
    public JComponent getComponent() {
        return this.myTabs.getComponent();
    }

    @Override
    public void putClientProperty(@NotNull Object key, Object value2) {
        if (key == null) {
            JBTabsPaneImpl.$$$reportNull$$$0(1);
        }
        this.myTabs.getComponent().putClientProperty(key, value2);
    }

    @Override
    public void setKeyboardNavigation(@NotNull PrevNextActionsDescriptor installKeyboardNavigation) {
        if (installKeyboardNavigation == null) {
            JBTabsPaneImpl.$$$reportNull$$$0(2);
        }
        this.myTabs.setNavigationActionBinding(installKeyboardNavigation.getPrevActionId(), installKeyboardNavigation.getNextActionId());
    }

    @Override
    public void addChangeListener(@NotNull ChangeListener listener2) {
        if (listener2 == null) {
            JBTabsPaneImpl.$$$reportNull$$$0(3);
        }
        this.myListeners.add(listener2);
    }

    @Override
    public int getTabCount() {
        return this.myTabs.getTabCount();
    }

    @Override
    public void insertTab(@NotNull String title2, Icon icon2, @NotNull Component c, String tip, int index2) {
        if (title2 == null) {
            JBTabsPaneImpl.$$$reportNull$$$0(4);
        }
        if (c == null) {
            JBTabsPaneImpl.$$$reportNull$$$0(5);
        }
        assert (c instanceof JComponent);
        this.myTabs.addTab(new TabInfo((JComponent)c).setText(title2).setTooltipText(tip).setIcon(icon2), index2);
    }

    @Override
    public void setTabPlacement(int tabPlacement) {
        JBTabsPresentation presentation2 = this.myTabs.getPresentation();
        switch (tabPlacement) {
            case 1: {
                presentation2.setTabsPosition(JBTabsPosition.top);
                break;
            }
            case 3: {
                presentation2.setTabsPosition(JBTabsPosition.bottom);
                break;
            }
            case 2: {
                presentation2.setTabsPosition(JBTabsPosition.left);
                break;
            }
            case 4: {
                presentation2.setTabsPosition(JBTabsPosition.right);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid tab placement code=" + tabPlacement);
            }
        }
    }

    @Override
    public void addMouseListener(@NotNull MouseListener listener2) {
        if (listener2 == null) {
            JBTabsPaneImpl.$$$reportNull$$$0(6);
        }
        this.myTabs.getComponent().addMouseListener(listener2);
    }

    @Override
    public int getSelectedIndex() {
        return this.myTabs.getIndexOf(this.myTabs.getSelectedInfo());
    }

    @Override
    public Component getSelectedComponent() {
        TabInfo selected2 = this.myTabs.getSelectedInfo();
        return selected2 != null ? selected2.getComponent() : null;
    }

    @Override
    public void setSelectedIndex(int index2) {
        this.myTabs.select(this.getTabAt(index2), false);
    }

    @Override
    public Component getTabComponentAt(int index2) {
        TabInfo tabInfo = this.myTabs.getTabAt(index2);
        return this.myTabs.getTabLabel(tabInfo);
    }

    @Override
    public void removeTabAt(int index2) {
        this.myTabs.removeTab(this.getTabAt(index2));
    }

    private TabInfo getTabAt(int index2) {
        this.checkIndex(index2);
        return this.myTabs.getTabAt(index2);
    }

    private void checkIndex(int index2) {
        if (index2 < 0 || index2 >= this.getTabCount()) {
            throw new ArrayIndexOutOfBoundsException("tabCount=" + this.getTabCount() + " index=" + index2);
        }
    }

    @Override
    public void revalidate() {
        this.myTabs.getComponent().revalidate();
    }

    @Override
    public Color getForegroundAt(int index2) {
        return this.getTabAt(index2).getDefaultForeground();
    }

    @Override
    public void setForegroundAt(int index2, Color color) {
        this.getTabAt(index2).setDefaultForeground(color);
    }

    @Override
    public Component getComponentAt(int i2) {
        return this.getTabAt(i2).getComponent();
    }

    @Override
    public void setTitleAt(int index2, @NotNull String title2) {
        if (title2 == null) {
            JBTabsPaneImpl.$$$reportNull$$$0(7);
        }
        this.getTabAt(index2).setText(title2);
    }

    @Override
    public void setToolTipTextAt(int index2, String toolTipText) {
        this.getTabAt(index2).setTooltipText(toolTipText);
    }

    @Override
    public void setComponentAt(int index2, Component c) {
        this.getTabAt(index2).setComponent(c);
    }

    @Override
    public void setIconAt(int index2, Icon icon2) {
        this.getTabAt(index2).setIcon(icon2);
    }

    @Override
    public void setEnabledAt(int index2, boolean enabled) {
        this.getTabAt(index2).setEnabled(enabled);
    }

    @Override
    public int getTabLayoutPolicy() {
        return this.myTabs.getPresentation().isSingleRow() ? 1 : 0;
    }

    @Override
    public void setTabLayoutPolicy(int policy) {
        switch (policy) {
            case 1: {
                this.myTabs.getPresentation().setSingleRow(true);
                break;
            }
            case 0: {
                this.myTabs.getPresentation().setSingleRow(false);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported tab layout policy: " + policy);
            }
        }
    }

    @Override
    public void scrollTabToVisible(int index2) {
    }

    @Override
    public String getTitleAt(int i2) {
        return this.getTabAt(i2).getText();
    }

    @Override
    public void removeAll() {
        this.myTabs.removeAllTabs();
    }

    @Override
    public void updateUI() {
        this.myTabs.getComponent().updateUI();
    }

    @Override
    public void removeChangeListener(ChangeListener listener2) {
        this.myListeners.remove(listener2);
    }

    @NotNull
    public JBTabs getTabs() {
        JBEditorTabsBase jBEditorTabsBase = this.myTabs;
        if (jBEditorTabsBase == null) {
            JBTabsPaneImpl.$$$reportNull$$$0(8);
        }
        return jBEditorTabsBase;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "installKeyboardNavigation";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/JBTabsPaneImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/JBTabsPaneImpl";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getTabs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "putClientProperty";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setKeyboardNavigation";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addChangeListener";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "insertTab";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addMouseListener";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setTitleAt";
                break;
            }
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

