/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.SpeedSearchBase;
import com.intellij.util.Function;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.Arrays;
import java.util.ListIterator;
import javax.swing.JList;
import javax.swing.ListSelectionModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ListSpeedSearch<T>
extends SpeedSearchBase<JList<T>> {
    @Nullable
    private final Function<? super T, String> myToStringConvertor;

    public ListSpeedSearch(@NotNull JList<T> list2) {
        if (list2 == null) {
            ListSpeedSearch.$$$reportNull$$$0(0);
        }
        super(list2);
        this.myToStringConvertor = null;
        this.registerSelectAll(list2);
    }

    public ListSpeedSearch(@NotNull JList<T> list2, @NotNull Function<? super T, String> convertor) {
        if (list2 == null) {
            ListSpeedSearch.$$$reportNull$$$0(1);
        }
        if (convertor == null) {
            ListSpeedSearch.$$$reportNull$$$0(2);
        }
        super(list2);
        this.myToStringConvertor = convertor;
        this.registerSelectAll(list2);
    }

    private void registerSelectAll(@NotNull JList<T> list2) {
        if (list2 == null) {
            ListSpeedSearch.$$$reportNull$$$0(3);
        }
        new MySelectAllAction<T>(list2, this).registerCustomShortcutSet(list2, null);
    }

    @Override
    protected void selectElement(Object element2, String selectedText) {
        if (element2 != null) {
            ScrollingUtil.selectItem((JList)((JList)this.myComponent), (Object)element2);
        } else {
            ((JList)this.myComponent).clearSelection();
        }
    }

    @Override
    protected int getSelectedIndex() {
        return ((JList)this.myComponent).getSelectedIndex();
    }

    @Override
    protected int getElementCount() {
        return ((JList)this.myComponent).getModel().getSize();
    }

    @Override
    protected Object getElementAt(int viewIndex) {
        return ((JList)this.myComponent).getModel().getElementAt(viewIndex);
    }

    @Override
    protected String getElementText(Object element2) {
        if (this.myToStringConvertor != null) {
            return (String)this.myToStringConvertor.fun(element2);
        }
        return element2 == null ? null : element2.toString();
    }

    @NotNull
    private IntList findAllFilteredElements(@NotNull String s) {
        if (s == null) {
            ListSpeedSearch.$$$reportNull$$$0(4);
        }
        IntArrayList indices = new IntArrayList();
        String trimmed = s.trim();
        ListIterator<Object> iterator2 = this.getElementIterator(0);
        while (iterator2.hasNext()) {
            Object element2 = iterator2.next();
            if (!this.isMatchingElement(element2, trimmed)) continue;
            indices.add(iterator2.previousIndex());
        }
        IntArrayList intArrayList = indices;
        if (intArrayList == null) {
            ListSpeedSearch.$$$reportNull$$$0(5);
        }
        return intArrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "convertor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/ListSpeedSearch";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/ListSpeedSearch";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "findAllFilteredElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "registerSelectAll";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findAllFilteredElements";
                break;
            }
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class MySelectAllAction<T>
    extends DumbAwareAction {
        @NotNull
        private final JList<T> myList;
        @NotNull
        private final ListSpeedSearch<T> mySearch;

        MySelectAllAction(@NotNull JList<T> list2, @NotNull ListSpeedSearch<T> search2) {
            if (list2 == null) {
                MySelectAllAction.$$$reportNull$$$0(0);
            }
            if (search2 == null) {
                MySelectAllAction.$$$reportNull$$$0(1);
            }
            this.myList = list2;
            this.mySearch = search2;
            AnAction action2 = ActionManager.getInstance().getAction("$SelectAll");
            if (action2 != null) {
                this.copyShortcutFrom(action2);
            }
            this.setEnabledInModalContext(true);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                MySelectAllAction.$$$reportNull$$$0(2);
            }
            e.getPresentation().setEnabled(this.mySearch.isPopupActive() && this.myList.getSelectionModel().getSelectionMode() == 2);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                MySelectAllAction.$$$reportNull$$$0(3);
            }
            ListSelectionModel sm = this.myList.getSelectionModel();
            String query2 = this.mySearch.getEnteredPrefix();
            if (query2 == null) {
                return;
            }
            IntList filtered2 = this.mySearch.findAllFilteredElements(query2);
            if (filtered2.isEmpty()) {
                return;
            }
            boolean alreadySelected = Arrays.equals(filtered2.toIntArray(), this.myList.getSelectedIndices());
            if (alreadySelected) {
                int anchor2 = this.myList.getAnchorSelectionIndex();
                this.myList.setSelectedIndex(anchor2);
                sm.setAnchorSelectionIndex(anchor2);
                this.mySearch.findAndSelectElement(query2);
            } else {
                int anchor3 = -1;
                Object currentElement = this.mySearch.findElement(query2);
                if (currentElement != null) {
                    ListIterator<Object> iterator2 = this.mySearch.getElementIterator(0);
                    while (iterator2.hasNext()) {
                        if (iterator2.next() != currentElement) continue;
                        anchor3 = iterator2.previousIndex();
                        break;
                    }
                }
                if (anchor3 == -1) {
                    anchor3 = filtered2.getInt(0);
                }
                this.myList.setSelectedIndices(filtered2.toIntArray());
                sm.setAnchorSelectionIndex(anchor3);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "search";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ui/ListSpeedSearch$MySelectAllAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

