/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ui.ListSpeedSearch;
import com.intellij.ui.SelectionSaver;
import com.intellij.ui.SmartExpander;
import com.intellij.ui.TreeExpandableItemsHandler;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.TreeUIHelper;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.EditSourceOnEnterKeyHandler;
import com.intellij.util.containers.Convertor;
import javax.swing.JList;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

final class TreeUIHelperImpl
extends TreeUIHelper {
    TreeUIHelperImpl() {
    }

    @Override
    public void installToolTipHandler(JTree tree) {
        if (tree instanceof Tree) {
            return;
        }
        new TreeExpandableItemsHandler(tree);
    }

    @Override
    public void installEditSourceOnDoubleClick(JTree tree) {
        EditSourceOnDoubleClickHandler.install((JTree)tree);
    }

    @Override
    public void installTreeSpeedSearch(JTree tree) {
        new TreeSpeedSearch(tree);
    }

    @Override
    public void installTreeSpeedSearch(JTree tree, Convertor<? super TreePath, String> convertor, boolean canExpand) {
        new TreeSpeedSearch(tree, convertor, canExpand);
    }

    @Override
    public void installListSpeedSearch(JList<?> list2) {
        new ListSpeedSearch(list2);
    }

    @Override
    public <T> void installListSpeedSearch(JList<T> list2, Convertor<? super T, String> convertor) {
        new ListSpeedSearch<T>(list2, arg_0 -> convertor.convert(arg_0));
    }

    @Override
    public void installEditSourceOnEnterKeyHandler(JTree tree) {
        EditSourceOnEnterKeyHandler.install((JTree)tree);
    }

    @Override
    public void installSmartExpander(JTree tree) {
        SmartExpander.installOn((JTree)tree);
    }

    @Override
    public void installSelectionSaver(JTree tree) {
        SelectionSaver.installOn((JTree)tree);
    }
}

