/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.mac.touchbar;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.ui.mac.touchbar.ActionsLoader;
import com.intellij.ui.mac.touchbar.Customizer;
import com.intellij.ui.mac.touchbar.TouchBar;
import com.intellij.ui.mac.touchbar.TouchBarsManager;
import java.awt.Component;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CtxEditors {
    private static Map<Editor, WeakReference<Component>> ourEditors = null;
    private static Map<Long, ActionGroup> ourEditorSearchActions = null;
    private static Customizer ourCustomizer = null;

    CtxEditors() {
    }

    private static void initialize() {
        if (ourEditors != null) {
            return;
        }
        ourEditors = new WeakHashMap<Editor, WeakReference<Component>>();
        ourEditorSearchActions = ActionsLoader.getActionGroup("EditorSearch");
        if (ourEditorSearchActions == null) {
            Logger.getInstance(CtxEditors.class).debug("null action group for editor-search");
            return;
        }
        EditorFactory.getInstance().addEditorFactoryListener(new EditorFactoryListener(){

            public void editorReleased(@NotNull EditorFactoryEvent event) {
                WeakReference<Component> cmpRef;
                Component cmp;
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                Component component2 = cmp = (cmpRef = ourEditors.remove(event.getEditor())) != null ? (Component)cmpRef.get() : null;
                if (cmp != null) {
                    TouchBarsManager.unregister(cmp);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ui/mac/touchbar/CtxEditors$1", "editorReleased"));
            }
        }, (Disposable)ApplicationManager.getApplication());
        ourCustomizer = new Customizer(new TouchBar.CrossEscInfo(false, false), null);
    }

    static void onUpdateEditorHeader(@NotNull Editor editor) {
        Component oldCmp;
        if (editor == null) {
            CtxEditors.$$$reportNull$$$0(0);
        }
        CtxEditors.initialize();
        if (ourEditorSearchActions == null) {
            return;
        }
        @Nullable JComponent newCmp = editor.getHeaderComponent();
        @Nullable WeakReference<JComponent> oldCmpRef = ourEditors.put(editor, new WeakReference<JComponent>(newCmp));
        Component component2 = oldCmp = oldCmpRef != null ? (Component)oldCmpRef.get() : null;
        if (oldCmp != null) {
            TouchBarsManager.unregister(oldCmp);
        }
        if (newCmp != null) {
            TouchBarsManager.register((Component)newCmp, ourEditorSearchActions, ourCustomizer);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/ui/mac/touchbar/CtxEditors", "onUpdateEditorHeader"));
    }
}

