/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.mac.touchbar;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.ui.mac.foundation.ID;
import com.intellij.ui.mac.touchbar.SpacingItem;
import com.intellij.ui.mac.touchbar.TBItem;
import com.intellij.ui.mac.touchbar.TBItemAnActionButton;
import com.intellij.ui.mac.touchbar.TBItemGroup;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ItemsContainer {
    @NotNull
    private final String myName;
    @NotNull
    private final @NotNull List<@NotNull TBItem> myItems;
    private long myCounter;

    ItemsContainer(@NotNull String name) {
        if (name == null) {
            ItemsContainer.$$$reportNull$$$0(0);
        }
        this.myItems = new ArrayList<TBItem>();
        this.myCounter = 0L;
        this.myName = name;
    }

    synchronized boolean isEmpty() {
        return this.myItems.isEmpty();
    }

    synchronized int size() {
        return this.myItems.size();
    }

    synchronized TBItem get(int index2) {
        return this.myItems.get(index2);
    }

    public String toString() {
        return this.myName;
    }

    @NotNull
    synchronized String getDescription() {
        if (this.myItems.isEmpty()) {
            return "empty_container";
        }
        StringBuilder res2 = new StringBuilder(String.format("items [%d]: ", this.myItems.size()));
        for (TBItem item : this.myItems) {
            res2.append(item.getUid());
            res2.append(", ");
        }
        String string = res2.toString();
        if (string == null) {
            ItemsContainer.$$$reportNull$$$0(1);
        }
        return string;
    }

    void addItem(@NotNull TBItem item) {
        if (item == null) {
            ItemsContainer.$$$reportNull$$$0(2);
        }
        this.addItem(item, -1);
    }

    synchronized void addItem(@NotNull TBItem item, int index2) {
        if (item == null) {
            ItemsContainer.$$$reportNull$$$0(3);
        }
        if (item.getUid() == null || item.getUid().isEmpty()) {
            item.setUid(this._genNewID(item.getName()));
        }
        if (index2 >= 0 && index2 < this.myItems.size()) {
            this.myItems.add(index2, item);
        } else {
            this.myItems.add(item);
        }
    }

    synchronized void addItem(@NotNull TBItem item, @Nullable TBItem positionAnchor) {
        if (item == null) {
            ItemsContainer.$$$reportNull$$$0(4);
        }
        int index2 = positionAnchor != null ? this.myItems.indexOf(positionAnchor) : -1;
        this.addItem(item, index2);
    }

    void addSpacing(boolean large) {
        this.addSpacing(large, -1);
    }

    synchronized void addSpacing(boolean large, int index2) {
        SpacingItem spacing = new SpacingItem();
        spacing.setUid(large ? "static_touchbar_item_large_space" : "static_touchbar_item_small_space");
        if (index2 >= 0 && index2 < this.myItems.size()) {
            this.myItems.add(index2, spacing);
        } else {
            this.myItems.add(spacing);
        }
    }

    void addFlexibleSpacing() {
        this.addFlexibleSpacing(-1);
    }

    synchronized void addFlexibleSpacing(int index2) {
        SpacingItem spacing = new SpacingItem();
        spacing.setUid("static_touchbar_item_flexible_space");
        if (index2 >= 0 && index2 < this.myItems.size()) {
            this.myItems.add(index2, spacing);
        } else {
            this.myItems.add(spacing);
        }
    }

    synchronized void releaseAll() {
        this.myItems.forEach(item -> item.releaseNativePeer());
        this.myItems.clear();
    }

    @NotNull
    synchronized @NotNull String @NotNull [] getVisibleIds() {
        String[] ids = new String[this.myItems.size()];
        int c = 0;
        for (TBItem item : this.myItems) {
            if (!item.myIsVisible) continue;
            ids[c++] = item.getUid();
        }
        String[] stringArray = c == this.myItems.size() ? ids : Arrays.copyOf(ids, c);
        if (stringArray == null) {
            ItemsContainer.$$$reportNull$$$0(5);
        }
        return stringArray;
    }

    synchronized ID @NotNull [] getNativePeers() {
        ID[] ids = new ID[this.myItems.size()];
        int c = 0;
        for (TBItem item : this.myItems) {
            ID nativePeer = item.createNativePeer();
            if (ID.NIL.equals((Object)nativePeer)) continue;
            ids[c++] = nativePeer;
        }
        ID[] iDArray = c == this.myItems.size() ? ids : Arrays.copyOf(ids, c);
        if (iDArray == null) {
            ItemsContainer.$$$reportNull$$$0(6);
        }
        return iDArray;
    }

    synchronized void softClear(@NotNull Map<AnAction, TBItemAnActionButton> actPool, @NotNull Map<Integer, TBItemGroup> groupPool) {
        if (actPool == null) {
            ItemsContainer.$$$reportNull$$$0(7);
        }
        if (groupPool == null) {
            ItemsContainer.$$$reportNull$$$0(8);
        }
        this.myItems.forEach(item -> {
            TBItemGroup group2;
            TBItemAnActionButton actItem;
            TBItem prev2;
            if (item instanceof TBItemAnActionButton && (prev2 = actPool.put((actItem = (TBItemAnActionButton)item).getAnAction(), actItem)) != null) {
                prev2.releaseNativePeer();
            }
            if (item instanceof TBItemGroup && (prev2 = groupPool.put((group2 = (TBItemGroup)item).size(), group2)) != null) {
                ((TBItemGroup)prev2).releaseNativePeer();
            }
        });
        this.myItems.clear();
    }

    @Nullable
    synchronized TBItem findItem(String uid) {
        for (TBItem item : this.myItems) {
            String itemUid = item.getUid();
            if (itemUid == null || !itemUid.equals(uid)) continue;
            return item;
        }
        return null;
    }

    @NotNull
    private String _genNewID(String desc) {
        String string = String.format("%s.%s.%d", this.myName, desc, this.myCounter++);
        if (string == null) {
            ItemsContainer.$$$reportNull$$$0(9);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/mac/touchbar/ItemsContainer";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actPool";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupPool";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/mac/touchbar/ItemsContainer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisibleIds";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getNativePeers";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "_genNewID";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 9: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addItem";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "softClear";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

