/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tree.ui;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.ui.tree.ChildrenProvider;
import com.intellij.ui.tree.LeafState;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.concurrency.Invoker;
import com.intellij.util.concurrency.InvokerSupplier;
import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.IntFunction;
import javax.swing.tree.TreeModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.CancellablePromise;
import org.jetbrains.concurrency.Obsolescent;

final class ModelAccessor {
    private static final Logger LOG = Logger.getInstance(ModelAccessor.class);
    private final TreeModel model;
    private final Invoker invoker;

    ModelAccessor(@NotNull TreeModel model2) {
        if (model2 == null) {
            ModelAccessor.$$$reportNull$$$0(0);
        }
        this.model = model2;
        if (model2 instanceof InvokerSupplier) {
            InvokerSupplier supplier2 = (InvokerSupplier)((Object)model2);
            this.invoker = supplier2.getInvoker();
        } else {
            this.invoker = null;
        }
    }

    public boolean isActualModel(@Nullable TreeModel model2) {
        return this.model == model2;
    }

    @NotNull
    public CancellablePromise<NodeContent> promiseRootContent() {
        return this.compute(obsolescent -> this.getRootContent((Obsolescent)obsolescent));
    }

    @NotNull
    public CancellablePromise<NodeStructure> promiseNodeStructure(@NotNull Object node2) {
        if (node2 == null) {
            ModelAccessor.$$$reportNull$$$0(1);
        }
        return this.compute(obsolescent -> this.getNodeStructure((Obsolescent)obsolescent, node2));
    }

    @NotNull
    private <T> CancellablePromise<T> compute(@NotNull Function<? super Obsolescent, ? extends T> function) {
        if (function == null) {
            ModelAccessor.$$$reportNull$$$0(2);
        }
        AsyncPromise promise = new AsyncPromise();
        if (this.invoker != null) {
            this.invoker.compute(() -> function.apply(() -> ((AsyncPromise)promise).isDone())).onError(arg_0 -> ((AsyncPromise)promise).setError(arg_0)).onSuccess(result2 -> EventQueue.invokeLater(() -> {
                if (!promise.isDone()) {
                    promise.setResult(result2);
                }
            }));
        } else if (!EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(() -> ModelAccessor.computeOnEDT(function, promise));
        } else {
            ModelAccessor.computeOnEDT(function, promise);
        }
        AsyncPromise asyncPromise = promise;
        if (asyncPromise == null) {
            ModelAccessor.$$$reportNull$$$0(3);
        }
        return asyncPromise;
    }

    private static <T> void computeOnEDT(@NotNull Function<? super Obsolescent, ? extends T> function, @NotNull AsyncPromise<T> promise) {
        T result2;
        if (function == null) {
            ModelAccessor.$$$reportNull$$$0(4);
        }
        if (promise == null) {
            ModelAccessor.$$$reportNull$$$0(5);
        }
        assert (EventQueue.isDispatchThread());
        try {
            result2 = function.apply((Obsolescent)((Obsolescent)() -> promise.isDone()));
        }
        catch (ProcessCanceledException | IndexNotReadyException exception) {
            EdtExecutorService.getScheduledExecutorInstance().schedule(() -> ModelAccessor.computeOnEDT(function, promise), 10L, TimeUnit.MILLISECONDS);
            return;
        }
        catch (Throwable error2) {
            promise.setError(error2);
            return;
        }
        promise.setResult(result2);
    }

    @Nullable
    private NodeContent getRootContent(@NotNull Obsolescent obsolescent) {
        if (obsolescent == null) {
            ModelAccessor.$$$reportNull$$$0(6);
        }
        assert (this.invoker == null ? EventQueue.isDispatchThread() : this.invoker.isValidThread());
        if (obsolescent.isObsolete()) {
            return null;
        }
        Object root = this.model.getRoot();
        if (root == null || obsolescent.isObsolete()) {
            return null;
        }
        return new NodeContent(root, LeafState.get((Object)root, (TreeModel)this.model));
    }

    @Nullable
    private NodeStructure getNodeStructure(@NotNull Obsolescent obsolescent, @NotNull Object node2) {
        if (obsolescent == null) {
            ModelAccessor.$$$reportNull$$$0(7);
        }
        if (node2 == null) {
            ModelAccessor.$$$reportNull$$$0(8);
        }
        assert (this.invoker == null ? EventQueue.isDispatchThread() : this.invoker.isValidThread());
        if (obsolescent.isObsolete()) {
            return null;
        }
        LeafState state = LeafState.get((Object)node2, (TreeModel)this.model);
        if (obsolescent.isObsolete()) {
            return null;
        }
        List<NodeContent> list2 = Collections.emptyList();
        if (state != LeafState.ALWAYS) {
            if (this.model instanceof ChildrenProvider) {
                ChildrenProvider provider2 = (ChildrenProvider)((Object)this.model);
                List children2 = provider2.getChildren(node2);
                if (children2 == null) {
                    throw new ProcessCanceledException();
                }
                list2 = this.getChildren(obsolescent, children2.size(), children2::get);
            } else {
                list2 = this.getChildren(obsolescent, this.model.getChildCount(node2), index2 -> this.model.getChild(node2, index2));
            }
        }
        if (state == LeafState.ASYNC) {
            state = list2.isEmpty() ? LeafState.ALWAYS : LeafState.NEVER;
        }
        return new NodeStructure(new NodeContent(node2, state), list2);
    }

    @NotNull
    private List<NodeContent> getChildren(@NotNull Obsolescent obsolescent, int count, @NotNull IntFunction<?> function) {
        if (obsolescent == null) {
            ModelAccessor.$$$reportNull$$$0(9);
        }
        if (function == null) {
            ModelAccessor.$$$reportNull$$$0(10);
        }
        if (count < 0) {
            LOG.warn("illegal child count: " + count);
        }
        if (count <= 0) {
            List<NodeContent> list2 = Collections.emptyList();
            if (list2 == null) {
                ModelAccessor.$$$reportNull$$$0(11);
            }
            return list2;
        }
        ArrayList<NodeContent> list3 = new ArrayList<NodeContent>(count);
        for (int index2 = 0; index2 < count; ++index2) {
            ProgressManager.checkCanceled();
            if (obsolescent.isObsolete()) {
                List<NodeContent> list4 = Collections.emptyList();
                if (list4 == null) {
                    ModelAccessor.$$$reportNull$$$0(12);
                }
                return list4;
            }
            Object node2 = function.apply(index2);
            if (node2 == null) {
                LOG.warn("ignore null child at " + index2);
                continue;
            }
            if (list3.stream().anyMatch(content2 -> content2.hasUserNode(node2))) {
                LOG.warn("ignore duplicated child at " + index2 + ": " + node2);
                continue;
            }
            if (obsolescent.isObsolete()) {
                List<NodeContent> list5 = Collections.emptyList();
                if (list5 == null) {
                    ModelAccessor.$$$reportNull$$$0(13);
                }
                return list5;
            }
            list3.add(new NodeContent(node2, LeafState.get(node2, (TreeModel)this.model)));
        }
        ArrayList<NodeContent> arrayList = list3;
        if (arrayList == null) {
            ModelAccessor.$$$reportNull$$$0(14);
        }
        return arrayList;
    }

    public String toString() {
        return this.model.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 2: 
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 3: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/tree/ui/ModelAccessor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "promise";
                break;
            }
            case 6: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "obsolescent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/tree/ui/ModelAccessor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "compute";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "promiseNodeStructure";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "compute";
                break;
            }
            case 3: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "computeOnEDT";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getRootContent";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getNodeStructure";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getChildren";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static final class NodeStructure {
        private final NodeContent content;
        private final List<NodeContent> children;

        private NodeStructure(@NotNull NodeContent content2, @NotNull List<NodeContent> children2) {
            if (content2 == null) {
                NodeStructure.$$$reportNull$$$0(0);
            }
            if (children2 == null) {
                NodeStructure.$$$reportNull$$$0(1);
            }
            this.content = content2;
            this.children = children2;
        }

        @NotNull
        public NodeContent getContent() {
            NodeContent nodeContent = this.content;
            if (nodeContent == null) {
                NodeStructure.$$$reportNull$$$0(2);
            }
            return nodeContent;
        }

        @NotNull
        public List<NodeContent> getChildren() {
            List<NodeContent> list2 = this.children;
            if (list2 == null) {
                NodeStructure.$$$reportNull$$$0(3);
            }
            return list2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "content";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "children";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/tree/ui/ModelAccessor$NodeStructure";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/tree/ui/ModelAccessor$NodeStructure";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getContent";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static final class NodeContent {
        private final int hashCode;
        private final Object userNode;
        private final LeafState leafState;

        private NodeContent(@NotNull Object node2, @NotNull LeafState state) {
            if (node2 == null) {
                NodeContent.$$$reportNull$$$0(0);
            }
            if (state == null) {
                NodeContent.$$$reportNull$$$0(1);
            }
            assert (state != LeafState.DEFAULT) : "resolved state required";
            this.hashCode = node2.hashCode();
            this.userNode = node2;
            this.leafState = state;
        }

        @NotNull
        public Object getUserNode() {
            Object object = this.userNode;
            if (object == null) {
                NodeContent.$$$reportNull$$$0(2);
            }
            return object;
        }

        @NotNull
        public LeafState getLeafState() {
            LeafState leafState = this.leafState;
            if (leafState == null) {
                NodeContent.$$$reportNull$$$0(3);
            }
            return leafState;
        }

        boolean hasUserNodeFrom(@NotNull NodeContent content2) {
            if (content2 == null) {
                NodeContent.$$$reportNull$$$0(4);
            }
            return this.hasUserNode(content2.userNode, content2.hashCode);
        }

        boolean hasUserNode(@NotNull Object node2) {
            if (node2 == null) {
                NodeContent.$$$reportNull$$$0(5);
            }
            return this.hasUserNode(node2, node2.hashCode());
        }

        boolean hasUserNode(@NotNull Object node2, int hash) {
            if (node2 == null) {
                NodeContent.$$$reportNull$$$0(6);
            }
            return this.hashCode == hash && (this.userNode == node2 || this.userNode.equals(node2));
        }

        public boolean equals(Object object) {
            return object == this || object instanceof NodeContent && this.hasUserNodeFrom((NodeContent)object);
        }

        public int hashCode() {
            return this.hashCode;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/tree/ui/ModelAccessor$NodeContent";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "content";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/tree/ui/ModelAccessor$NodeContent";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUserNode";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLeafState";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "hasUserNodeFrom";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "hasUserNode";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

