/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.unscramble;

import com.intellij.execution.Executor;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.impl.ConsoleViewUtil;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ClipboardUtil;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ProjectExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AnalyzeStacktraceUtil {
    public static final ProjectExtensionPointName<Filter> EP_NAME = new ProjectExtensionPointName("com.intellij.analyzeStacktraceFilter");

    private AnalyzeStacktraceUtil() {
    }

    public static void printStacktrace(@NotNull ConsoleView consoleView, @NotNull String unscrambledTrace) {
        if (consoleView == null) {
            AnalyzeStacktraceUtil.$$$reportNull$$$0(0);
        }
        if (unscrambledTrace == null) {
            AnalyzeStacktraceUtil.$$$reportNull$$$0(1);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        consoleView.clear();
        consoleView.print(unscrambledTrace + "\n", ConsoleViewContentType.ERROR_OUTPUT);
        consoleView.scrollTo(0);
    }

    public static void addConsole(Project project, @Nullable ConsoleFactory consoleFactory, @NlsContexts.TabTitle String tabTitle, String text2) {
        AnalyzeStacktraceUtil.addConsole(project, consoleFactory, tabTitle, text2, null);
    }

    public static RunContentDescriptor addConsole(Project project, @Nullable ConsoleFactory consoleFactory, @NlsContexts.TabTitle String tabTitle, String text2, @Nullable Icon icon2) {
        TextConsoleBuilder builder2 = TextConsoleBuilderFactory.getInstance().createBuilder(project);
        builder2.filters(EP_NAME.getExtensions((AreaInstance)project));
        ConsoleView consoleView = builder2.getConsole();
        DefaultActionGroup toolbarActions = new DefaultActionGroup();
        JComponent consoleComponent = consoleFactory != null ? consoleFactory.createConsoleComponent(consoleView, toolbarActions) : new MyConsolePanel((ExecutionConsole)consoleView, (ActionGroup)toolbarActions);
        RunContentDescriptor descriptor2 = new RunContentDescriptor((ExecutionConsole)consoleView, null, consoleComponent, tabTitle, icon2){

            public boolean isContentReuseProhibited() {
                return true;
            }
        };
        Executor executor = DefaultRunExecutor.getRunExecutorInstance();
        for (AnAction action2 : consoleView.createConsoleActions()) {
            toolbarActions.add(action2);
        }
        ConsoleViewImpl console2 = (ConsoleViewImpl)consoleView;
        ConsoleViewUtil.enableReplaceActionForConsoleViewEditor(console2.getEditor());
        console2.getEditor().getSettings().setCaretRowShown(true);
        toolbarActions.add(ActionManager.getInstance().getAction("AnalyzeStacktraceToolbar"));
        RunContentManager.getInstance((Project)project).showRunContent(executor, descriptor2);
        consoleView.allowHeavyFilters();
        if (consoleFactory == null) {
            AnalyzeStacktraceUtil.printStacktrace(consoleView, text2);
        }
        return descriptor2;
    }

    public static StacktraceEditorPanel createEditorPanel(Project project, @NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            AnalyzeStacktraceUtil.$$$reportNull$$$0(2);
        }
        EditorFactory editorFactory = EditorFactory.getInstance();
        Document document = editorFactory.createDocument((CharSequence)"");
        Editor editor = editorFactory.createEditor(document, project);
        EditorSettings settings2 = editor.getSettings();
        settings2.setFoldingOutlineShown(false);
        settings2.setLineMarkerAreaShown(false);
        settings2.setIndentGuidesShown(false);
        settings2.setLineNumbersShown(false);
        settings2.setRightMarginShown(false);
        StacktraceEditorPanel editorPanel = new StacktraceEditorPanel(project, editor);
        editorPanel.setPreferredSize((Dimension)JBUI.size((int)600, (int)400));
        Disposer.register((Disposable)parentDisposable, (Disposable)editorPanel);
        return editorPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleView";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unscrambledTrace";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
        }
        objectArray2[1] = "com/intellij/unscramble/AnalyzeStacktraceUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "printStacktrace";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createEditorPanel";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static final class StacktraceEditorPanel
    extends JPanel
    implements DataProvider,
    Disposable {
        private final Project myProject;
        private final Editor myEditor;

        public StacktraceEditorPanel(Project project, Editor editor) {
            super(new BorderLayout());
            this.myProject = project;
            this.myEditor = editor;
            this.add(this.myEditor.getComponent());
        }

        @Override
        public Object getData(@NotNull String dataId) {
            if (dataId == null) {
                StacktraceEditorPanel.$$$reportNull$$$0(0);
            }
            if (CommonDataKeys.EDITOR.is(dataId)) {
                return this.myEditor;
            }
            return null;
        }

        public Editor getEditor() {
            return this.myEditor;
        }

        public void setText(@NotNull String text2) {
            if (text2 == null) {
                StacktraceEditorPanel.$$$reportNull$$$0(1);
            }
            Runnable runnable2 = () -> ApplicationManager.getApplication().runWriteAction(() -> {
                Document document = this.myEditor.getDocument();
                document.replaceString(0, document.getTextLength(), (CharSequence)StringUtil.convertLineSeparators((String)text2));
            });
            CommandProcessor.getInstance().executeCommand(this.myProject, runnable2, "", (Object)this);
        }

        public void pasteTextFromClipboard() {
            String text2 = ClipboardUtil.getTextInClipboard();
            if (text2 != null) {
                this.setText(text2);
            }
        }

        public void dispose() {
            EditorFactory.getInstance().releaseEditor(this.myEditor);
        }

        public String getText() {
            return this.myEditor.getDocument().getText();
        }

        public JComponent getEditorComponent() {
            return this.myEditor.getContentComponent();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataId";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/unscramble/AnalyzeStacktraceUtil$StacktraceEditorPanel";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getData";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setText";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class MyConsolePanel
    extends JPanel {
        MyConsolePanel(ExecutionConsole consoleView, ActionGroup toolbarActions) {
            super(new BorderLayout());
            JPanel toolbarPanel = new JPanel(new BorderLayout());
            ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("ANALYZE_STACKTRACE_PANEL_TOOLBAR", toolbarActions, false);
            toolbar.setTargetComponent(consoleView.getComponent());
            toolbarPanel.add(toolbar.getComponent());
            this.add((Component)toolbarPanel, "West");
            this.add((Component)consoleView.getComponent(), "Center");
        }
    }

    public static interface ConsoleFactory {
        public JComponent createConsoleComponent(ConsoleView var1, DefaultActionGroup var2);
    }
}

