/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.unscramble;

import com.intellij.execution.filters.FileHyperlinkInfo;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.impl.EditorHyperlinkSupport;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorGutterAction;
import com.intellij.openapi.editor.TextAnnotationGutterProvider;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.actions.VcsContextFactory;
import com.intellij.openapi.vcs.annotate.AnnotationSource;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vcs.annotate.ShowAllAffectedGenericAction;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsHistoryProvider;
import com.intellij.openapi.vcs.history.VcsHistorySession;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.intellij.vcs.history.VcsHistoryProviderEx;
import com.intellij.vcsUtil.VcsUtil;
import com.intellij.xml.util.XmlStringUtil;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.awt.Color;
import java.awt.Cursor;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AnnotateStackTraceAction
extends DumbAwareAction {
    private static final Logger LOG = Logger.getInstance(AnnotateStackTraceAction.class);
    private boolean myIsLoading = false;

    public void update(@NotNull AnActionEvent e) {
        ConsoleViewImpl consoleView;
        if (e == null) {
            AnnotateStackTraceAction.$$$reportNull$$$0(0);
        }
        Editor editor = (consoleView = (ConsoleViewImpl)ObjectUtils.tryCast((Object)e.getData(LangDataKeys.CONSOLE_VIEW), ConsoleViewImpl.class)) != null ? consoleView.getEditor() : null;
        boolean isShown = editor != null && editor.getGutter().isAnnotationsShown();
        e.getPresentation().setEnabled(editor != null && !isShown && !this.myIsLoading);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Editor editor;
        if (e == null) {
            AnnotateStackTraceAction.$$$reportNull$$$0(1);
        }
        this.myIsLoading = true;
        final Project project = e.getProject();
        ConsoleViewImpl consoleView = (ConsoleViewImpl)e.getData(LangDataKeys.CONSOLE_VIEW);
        Editor editor2 = editor = consoleView != null ? consoleView.getEditor() : null;
        if (project == null || editor == null) {
            return;
        }
        final EditorHyperlinkSupport hyperlinks = consoleView.getHyperlinks();
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, LangBundle.message((String)"progress.title.getting.file.history", (Object[])new Object[0]), true){
            private final Object LOCK;
            private final MergingUpdateQueue myUpdateQueue;
            private MyActiveAnnotationGutter myGutter;
            {
                super(arg0, arg1, arg2);
                this.LOCK = new Object();
                this.myUpdateQueue = new MergingUpdateQueue("AnnotateStackTraceAction", 200, true, null);
            }

            public void onCancel() {
                editor.getGutter().closeAllAnnotations();
            }

            public void onFinished() {
                AnnotateStackTraceAction.this.myIsLoading = false;
                Disposer.dispose((Disposable)this.myUpdateQueue);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(final @NotNull ProgressIndicator indicator2) {
                if (indicator2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                Map files2lines = CollectionFactory.createSmallMemoryFootprintMap();
                Int2ObjectOpenHashMap revisions = new Int2ObjectOpenHashMap();
                ApplicationManager.getApplication().runReadAction(() -> {
                    for (int line = 0; line < editor.getDocument().getLineCount(); ++line) {
                        indicator2.checkCanceled();
                        VirtualFile file2 = AnnotateStackTraceAction.getHyperlinkVirtualFile(hyperlinks.findAllHyperlinksOnLine(line));
                        if (file2 == null) continue;
                        files2lines.computeIfAbsent(file2, __ -> new IntArrayList()).add(line);
                    }
                });
                for (Map.Entry entry2 : files2lines.entrySet()) {
                    VirtualFile file2 = (VirtualFile)entry2.getKey();
                    IntList value2 = (IntList)entry2.getValue();
                    indicator2.checkCanceled();
                    LastRevision revision = this.getLastRevision(file2);
                    if (revision == null) continue;
                    Object object = this.LOCK;
                    synchronized (object) {
                        IntListIterator iterator2 = value2.iterator();
                        while (iterator2.hasNext()) {
                            revisions.put(iterator2.nextInt(), (Object)revision);
                        }
                    }
                    this.myUpdateQueue.queue(new Update("update", (Int2ObjectMap)revisions){
                        final /* synthetic */ Int2ObjectMap val$revisions;
                        {
                            this.val$revisions = int2ObjectMap;
                            super(arg0);
                        }

                        public void run() {
                            this.updateGutter(indicator2, (Map<Integer, LastRevision>)this.val$revisions);
                        }
                    });
                }
                ApplicationManager.getApplication().invokeLater(() -> this.lambda$run$2(indicator2, (Int2ObjectMap)revisions));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            @RequiresEdt
            private void updateGutter(@NotNull ProgressIndicator progressIndicator, @NotNull Map<Integer, LastRevision> map2) {
                HashMap<Integer, LastRevision> revisionsCopy;
                void revisions;
                void indicator2;
                ApplicationManager.getApplication().assertIsDispatchThread();
                if (indicator2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (revisions == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (indicator2.isCanceled()) {
                    return;
                }
                if (this.myGutter == null) {
                    this.myGutter = new MyActiveAnnotationGutter(this.getProject(), hyperlinks, (ProgressIndicator)indicator2);
                    editor.getGutter().registerTextAnnotation((TextAnnotationGutterProvider)this.myGutter, (EditorGutterAction)this.myGutter);
                }
                Object object = this.LOCK;
                synchronized (object) {
                    revisionsCopy = new HashMap<Integer, LastRevision>((Map<Integer, LastRevision>)revisions);
                }
                this.myGutter.updateData(revisionsCopy);
                ((EditorGutterComponentEx)editor.getGutter()).revalidateMarkup();
            }

            @Nullable
            private LastRevision getLastRevision(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    1.$$$reportNull$$$0(3);
                }
                try {
                    AbstractVcs vcs = VcsUtil.getVcsFor((Project)project, (VirtualFile)file2);
                    if (vcs == null) {
                        return null;
                    }
                    VcsHistoryProvider historyProvider = vcs.getVcsHistoryProvider();
                    if (historyProvider == null) {
                        return null;
                    }
                    FilePath filePath = VcsContextFactory.SERVICE.getInstance().createFilePathOn(file2);
                    if (historyProvider instanceof VcsHistoryProviderEx) {
                        VcsFileRevision revision = ((VcsHistoryProviderEx)historyProvider).getLastRevision(filePath);
                        if (revision == null) {
                            return null;
                        }
                        return LastRevision.create(revision);
                    }
                    VcsHistorySession session2 = historyProvider.createSessionFor(filePath);
                    if (session2 == null) {
                        return null;
                    }
                    List list2 = session2.getRevisionList();
                    if (list2 == null || list2.isEmpty()) {
                        return null;
                    }
                    return LastRevision.create((VcsFileRevision)list2.get(0));
                }
                catch (VcsException e) {
                    LOG.warn((Throwable)e);
                    return null;
                }
            }

            private /* synthetic */ void lambda$run$2(ProgressIndicator indicator2, Int2ObjectMap revisions) {
                this.updateGutter(indicator2, (Map<Integer, LastRevision>)revisions);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "indicator";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "revisions";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/unscramble/AnnotateStackTraceAction$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "run";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "updateGutter";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getLastRevision";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @Nullable
    @RequiresReadLock
    private static VirtualFile getHyperlinkVirtualFile(@NotNull List<RangeHighlighter> list2) {
        RangeHighlighter key;
        List<RangeHighlighter> links;
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (links == null) {
            AnnotateStackTraceAction.$$$reportNull$$$0(2);
        }
        if ((key = (RangeHighlighter)ContainerUtil.getLastItem(links)) == null) {
            return null;
        }
        HyperlinkInfo info2 = EditorHyperlinkSupport.getHyperlinkInfo(key);
        if (!(info2 instanceof FileHyperlinkInfo)) {
            return null;
        }
        OpenFileDescriptor descriptor2 = ((FileHyperlinkInfo)info2).getDescriptor();
        return descriptor2 != null ? descriptor2.getFile() : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "links";
                break;
            }
        }
        objectArray2[1] = "com/intellij/unscramble/AnnotateStackTraceAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getHyperlinkVirtualFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyActiveAnnotationGutter
    implements TextAnnotationGutterProvider,
    EditorGutterAction {
        @NotNull
        private final Project myProject;
        @NotNull
        private final EditorHyperlinkSupport myHyperlinks;
        @NotNull
        private final ProgressIndicator myIndicator;
        @NotNull
        private Map<Integer, LastRevision> myRevisions;
        private Date myNewestDate;
        private int myMaxDateLength;

        MyActiveAnnotationGutter(@NotNull Project project, @NotNull EditorHyperlinkSupport hyperlinks, @NotNull ProgressIndicator indicator2) {
            if (project == null) {
                MyActiveAnnotationGutter.$$$reportNull$$$0(0);
            }
            if (hyperlinks == null) {
                MyActiveAnnotationGutter.$$$reportNull$$$0(1);
            }
            if (indicator2 == null) {
                MyActiveAnnotationGutter.$$$reportNull$$$0(2);
            }
            this.myRevisions = Collections.emptyMap();
            this.myNewestDate = null;
            this.myMaxDateLength = 0;
            this.myProject = project;
            this.myHyperlinks = hyperlinks;
            this.myIndicator = indicator2;
        }

        public void doAction(int lineNum) {
            LastRevision revision = this.myRevisions.get(lineNum);
            if (revision == null) {
                return;
            }
            VirtualFile file2 = AnnotateStackTraceAction.getHyperlinkVirtualFile(this.myHyperlinks.findAllHyperlinksOnLine(lineNum));
            if (file2 == null) {
                return;
            }
            AbstractVcs vcs = ProjectLevelVcsManager.getInstance((Project)this.myProject).getVcsFor(file2);
            if (vcs != null) {
                VcsRevisionNumber number = revision.getNumber();
                VcsKey vcsKey = vcs.getKeyInstanceMethod();
                ShowAllAffectedGenericAction.showSubmittedFiles((Project)this.myProject, (VcsRevisionNumber)number, (VirtualFile)file2, (VcsKey)vcsKey);
            }
        }

        public Cursor getCursor(int lineNum) {
            return this.myRevisions.containsKey(lineNum) ? Cursor.getPredefinedCursor(12) : Cursor.getDefaultCursor();
        }

        public String getLineText(int line, Editor editor) {
            LastRevision revision = this.myRevisions.get(line);
            if (revision != null) {
                return String.format("%" + this.myMaxDateLength + "s", FileAnnotation.formatDate((Date)revision.getDate())) + " " + revision.getAuthor();
            }
            return "";
        }

        public String getToolTip(int line, Editor editor) {
            LastRevision revision = this.myRevisions.get(line);
            if (revision != null) {
                return XmlStringUtil.escapeString((String)(revision.getAuthor() + " " + DateFormatUtil.formatDateTime((Date)revision.getDate()) + "\n" + VcsUtil.trimCommitMessageToSaneSize((String)revision.getMessage())));
            }
            return null;
        }

        public EditorFontType getStyle(int line, Editor editor) {
            LastRevision revision = this.myRevisions.get(line);
            return revision != null && revision.getDate().equals(this.myNewestDate) ? EditorFontType.BOLD : EditorFontType.PLAIN;
        }

        public ColorKey getColor(int line, Editor editor) {
            return AnnotationSource.LOCAL.getColor();
        }

        public Color getBgColor(int line, Editor editor) {
            return null;
        }

        public List<AnAction> getPopupActions(int line, Editor editor) {
            return Collections.emptyList();
        }

        public void gutterClosed() {
            this.myIndicator.cancel();
        }

        /*
         * WARNING - void declaration
         */
        @RequiresEdt
        public void updateData(@NotNull Map<Integer, LastRevision> map2) {
            void revisions;
            ApplicationManager.getApplication().assertIsDispatchThread();
            if (revisions == null) {
                MyActiveAnnotationGutter.$$$reportNull$$$0(3);
            }
            this.myRevisions = revisions;
            Date newestDate = null;
            int maxDateLength = 0;
            for (LastRevision revision : this.myRevisions.values()) {
                int length;
                Date date = revision.getDate();
                if (newestDate == null || date.after(newestDate)) {
                    newestDate = date;
                }
                if ((length = DateFormatUtil.formatPrettyDate((Date)date).length()) <= maxDateLength) continue;
                maxDateLength = length;
            }
            this.myNewestDate = newestDate;
            this.myMaxDateLength = maxDateLength;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "hyperlinks";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "revisions";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/unscramble/AnnotateStackTraceAction$MyActiveAnnotationGutter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateData";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class LastRevision {
        @NotNull
        private final VcsRevisionNumber myNumber;
        @NotNull
        private final String myAuthor;
        @NotNull
        private final Date myDate;
        @NotNull
        private final String myMessage;

        LastRevision(@NotNull VcsRevisionNumber number, @NotNull String author, @NotNull Date date, @NotNull String message2) {
            if (number == null) {
                LastRevision.$$$reportNull$$$0(0);
            }
            if (author == null) {
                LastRevision.$$$reportNull$$$0(1);
            }
            if (date == null) {
                LastRevision.$$$reportNull$$$0(2);
            }
            if (message2 == null) {
                LastRevision.$$$reportNull$$$0(3);
            }
            this.myNumber = number;
            this.myAuthor = author;
            this.myDate = date;
            this.myMessage = message2;
        }

        @NotNull
        public static LastRevision create(@NotNull VcsFileRevision revision) {
            if (revision == null) {
                LastRevision.$$$reportNull$$$0(4);
            }
            VcsRevisionNumber number = revision.getRevisionNumber();
            String author = StringUtil.notNullize((String)revision.getAuthor(), (String)VcsBundle.message((String)"vfs.revision.author.unknown", (Object[])new Object[0]));
            Date date = revision.getRevisionDate();
            String message2 = StringUtil.notNullize((String)revision.getCommitMessage());
            return new LastRevision(number, author, date, message2);
        }

        @NotNull
        public VcsRevisionNumber getNumber() {
            VcsRevisionNumber vcsRevisionNumber = this.myNumber;
            if (vcsRevisionNumber == null) {
                LastRevision.$$$reportNull$$$0(5);
            }
            return vcsRevisionNumber;
        }

        @NotNull
        @NlsSafe
        public String getAuthor() {
            String string = this.myAuthor;
            if (string == null) {
                LastRevision.$$$reportNull$$$0(6);
            }
            return string;
        }

        @NotNull
        public Date getDate() {
            Date date = this.myDate;
            if (date == null) {
                LastRevision.$$$reportNull$$$0(7);
            }
            return date;
        }

        @NotNull
        public String getMessage() {
            String string = this.myMessage;
            if (string == null) {
                LastRevision.$$$reportNull$$$0(8);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "number";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "author";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "date";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "revision";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/unscramble/AnnotateStackTraceAction$LastRevision";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/unscramble/AnnotateStackTraceAction$LastRevision";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNumber";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAuthor";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDate";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMessage";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

