/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbModeTask;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.indexing.FbiSnapshot;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.FileTypeTracker;
import com.intellij.util.indexing.IndexingBundle;
import com.intellij.util.indexing.IndexingFlag;
import com.intellij.util.indexing.IndexingStamp;
import com.intellij.util.indexing.RebuildStatus;
import com.intellij.util.indexing.UnindexedFilesUpdater;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\r\u001a\u00020\u000eJ%\u0010\u000f\u001a\u00020\u000e2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u000f\b\u0002\u0010\u0012\u001a\t\u0018\u00010\u0013\u00a2\u0006\u0002\b\u0014H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/util/indexing/FileBasedIndexTumbler;", "", "()V", "dumbModeSemaphore", "Lcom/intellij/util/concurrency/Semaphore;", "fileBasedIndex", "Lcom/intellij/util/indexing/FileBasedIndexImpl;", "fileTypeTracker", "Lcom/intellij/util/indexing/FileTypeTracker;", "nestedLevelCount", "", "snapshot", "Lcom/intellij/util/indexing/FbiSnapshot;", "turnOff", "", "turnOn", "beforeIndexTasksStarted", "Ljava/lang/Runnable;", "reason", "", "Lorg/jetbrains/annotations/NonNls;", "Companion", "intellij.platform.lang.impl"})
public final class FileBasedIndexTumbler {
    private final FileBasedIndexImpl fileBasedIndex;
    private final Semaphore dumbModeSemaphore;
    private int nestedLevelCount;
    private FbiSnapshot snapshot;
    private FileTypeTracker fileTypeTracker;
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void turnOff() {
        Application app;
        Application application = app = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"app");
        LOG.assertTrue(application.isDispatchThread());
        LOG.assertTrue(!app.isWriteAccessAllowed());
        try {
            if (this.nestedLevelCount == 0) {
                boolean unitTestMode = app.isUnitTestMode();
                if (!unitTestMode) {
                    boolean wasUp = this.dumbModeSemaphore.isUp();
                    this.dumbModeSemaphore.down();
                    if (wasUp) {
                        for (Project project : ProjectUtil.getOpenProjects()) {
                            DumbService dumbService = DumbService.getInstance((Project)project);
                            dumbService.cancelAllTasksAndWait();
                            dumbService.queueTask(new DumbModeTask(this, this.dumbModeSemaphore){
                                final /* synthetic */ FileBasedIndexTumbler this$0;

                                public void performInDumbMode(@NotNull ProgressIndicator indicator2) {
                                    Intrinsics.checkNotNullParameter((Object)indicator2, (String)"indicator");
                                    indicator2.setText(IndexingBundle.message((String)"indexes.reloading", (Object[])new Object[0]));
                                    FileBasedIndexTumbler.access$getDumbModeSemaphore$p(this.this$0).waitFor();
                                }

                                @NotNull
                                public String toString() {
                                    return "Plugin loading/unloading";
                                }
                                {
                                    this.this$0 = this$0;
                                    super($super_call_param$1);
                                }
                            });
                        }
                    }
                }
                LOG.assertTrue(this.fileTypeTracker == null);
                this.fileTypeTracker = new FileTypeTracker();
                this.fileBasedIndex.waitUntilIndicesAreInitialized();
                this.fileBasedIndex.performShutdown(true);
                this.fileBasedIndex.dropRegisteredIndexes();
                boolean indexesAreOk = RebuildStatus.isOk();
                RebuildStatus.reset();
                IndexingStamp.dropTimestampMemoryCaches();
                LOG.assertTrue(this.snapshot == null);
                this.snapshot = indexesAreOk ? (FbiSnapshot)FbiSnapshot.Impl.Companion.capture() : (FbiSnapshot)FbiSnapshot.RebuildRequired.INSTANCE;
            }
        }
        finally {
            int n = this.nestedLevelCount;
            this.nestedLevelCount = n + 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @JvmOverloads
    public final void turnOn(@Nullable Runnable beforeIndexTasksStarted, @Nullable String reason) {
        block13: {
            v0 = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"ApplicationManager.getApplication()");
            FileBasedIndexTumbler.LOG.assertTrue(v0.isWriteThread());
            var3_3 = this.nestedLevelCount;
            this.nestedLevelCount = var3_3 + -1;
            if (this.nestedLevelCount != 0) break block13;
            try {
                this.fileBasedIndex.loadIndexes();
                v1 = ApplicationManager.getApplication();
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"ApplicationManager.getApplication()");
                unitTestMode = v1.isUnitTestMode();
                if (unitTestMode) {
                    this.fileBasedIndex.waitUntilIndicesAreInitialized();
                }
                if (!unitTestMode) {
                    this.dumbModeSemaphore.up();
                }
                if (Registry.is((String)"run.index.rescanning.on.plugin.load.unload") || !RebuildStatus.isOk() || this.snapshot instanceof FbiSnapshot.RebuildRequired) ** GOTO lbl-1000
                v2 = this.snapshot;
                if (v2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.intellij.util.indexing.FbiSnapshot.Impl");
                }
                if (FbiSnapshot.Impl.Companion.isRescanningRequired((FbiSnapshot.Impl)v2, FbiSnapshot.Impl.Companion.capture())) lbl-1000:
                // 2 sources

                {
                    v3 = true;
                } else {
                    v3 = runRescanning = false;
                }
                if (runRescanning) {
                    v4 = beforeIndexTasksStarted;
                    if (v4 != null) {
                        v4.run();
                    }
                    IndexingFlag.cleanupProcessedFlag();
                    for (Project project : ProjectUtil.getOpenProjects()) {
                        DumbService.getInstance((Project)project).queueTask((DumbModeTask)new UnindexedFilesUpdater(project, reason));
                    }
                    FileBasedIndexTumbler.LOG.info("Index rescanning has been started after plugin load/unload");
                } else {
                    FileBasedIndexTumbler.LOG.info("Index rescanning has been skipped after plugin load/unload");
                }
            }
            finally {
                v5 = this.fileTypeTracker;
                if (v5 != null) {
                    var3_4 = v5;
                    var4_6 = false;
                    var5_17 = false;
                    it = var3_4;
                    $i$a$-let-FileBasedIndexTumbler$turnOn$1 = false;
                    Disposer.dispose((Disposable)it);
                }
                this.fileTypeTracker = null;
                this.snapshot = null;
            }
        }
    }

    public static /* synthetic */ void turnOn$default(FileBasedIndexTumbler fileBasedIndexTumbler, Runnable runnable2, String string, int n, Object object) {
        if ((n & 1) != 0) {
            runnable2 = null;
        }
        if ((n & 2) != 0) {
            string = null;
        }
        fileBasedIndexTumbler.turnOn(runnable2, string);
    }

    @JvmOverloads
    public final void turnOn(@Nullable Runnable beforeIndexTasksStarted) {
        FileBasedIndexTumbler.turnOn$default(this, beforeIndexTasksStarted, null, 2, null);
    }

    @JvmOverloads
    public final void turnOn() {
        FileBasedIndexTumbler.turnOn$default(this, null, null, 3, null);
    }

    public FileBasedIndexTumbler() {
        FileBasedIndex fileBasedIndex = FileBasedIndex.getInstance();
        if (fileBasedIndex == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.util.indexing.FileBasedIndexImpl");
        }
        this.fileBasedIndex = (FileBasedIndexImpl)fileBasedIndex;
        this.dumbModeSemaphore = new Semaphore();
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(FileBasedIndexTumbler.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ Semaphore access$getDumbModeSemaphore$p(FileBasedIndexTumbler $this) {
        return $this.dumbModeSemaphore;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/util/indexing/FileBasedIndexTumbler$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.platform.lang.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

