/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.util.SmartList;
import com.intellij.util.indexing.CustomInputsIndexFileBasedIndexExtension;
import com.intellij.util.indexing.IndexExtension;
import com.intellij.util.indexing.ScalarIndexExtension;
import com.intellij.util.indexing.impl.InputIndexDataExternalizer;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class InputMapExternalizer<Key, Value>
implements DataExternalizer<Map<Key, Value>> {
    private final DataExternalizer<Value> myValueExternalizer;
    private final DataExternalizer<Collection<Key>> myKeysExternalizer;
    private final boolean myValuesAreNullAlways;

    public InputMapExternalizer(@NotNull IndexExtension<Key, Value, ?> extension2) {
        if (extension2 == null) {
            InputMapExternalizer.$$$reportNull$$$0(0);
        }
        this.myValueExternalizer = extension2.getValueExternalizer();
        this.myKeysExternalizer = extension2 instanceof CustomInputsIndexFileBasedIndexExtension ? ((CustomInputsIndexFileBasedIndexExtension)extension2).createExternalizer() : new InputIndexDataExternalizer(extension2.getKeyDescriptor(), extension2.getName());
        this.myValuesAreNullAlways = extension2 instanceof ScalarIndexExtension;
    }

    public void save(@NotNull DataOutput stream, Map<Key, Value> data2) throws IOException {
        if (stream == null) {
            InputMapExternalizer.$$$reportNull$$$0(1);
        }
        int size2 = data2.size();
        DataInputOutputUtil.writeINT((DataOutput)stream, (int)size2);
        SmartList keysForNullValue = null;
        HashMap<Object, SmartList> values2 = null;
        if (size2 <= 0) {
            return;
        }
        if (this.myValuesAreNullAlways) {
            keysForNullValue = data2.keySet();
        } else {
            values2 = new HashMap<Object, SmartList>();
            for (Map.Entry<Object, Object> entry2 : data2.entrySet()) {
                SmartList keys2;
                Object value2 = entry2.getValue();
                Object object = keys2 = value2 != null ? (Collection)values2.get(value2) : keysForNullValue;
                if (keys2 == null) {
                    if (value2 != null) {
                        keys2 = new SmartList();
                        values2.put(value2, keys2);
                    } else {
                        keys2 = keysForNullValue = new SmartList();
                    }
                }
                keys2.add(entry2.getKey());
            }
        }
        if (keysForNullValue != null) {
            this.myValueExternalizer.save(stream, null);
            this.myKeysExternalizer.save(stream, keysForNullValue);
        }
        if (values2 != null) {
            for (Map.Entry<Object, Object> entry3 : values2.keySet()) {
                this.myValueExternalizer.save(stream, entry3);
                this.myKeysExternalizer.save(stream, (Object)((Collection)values2.get(entry3)));
            }
        }
    }

    public Map<Key, Value> read(@NotNull DataInput in) throws IOException {
        int pairs;
        if (in == null) {
            InputMapExternalizer.$$$reportNull$$$0(2);
        }
        if ((pairs = DataInputOutputUtil.readINT((DataInput)in)) == 0) {
            return Collections.emptyMap();
        }
        HashMap result2 = new HashMap(pairs);
        while (((InputStream)((Object)in)).available() > 0) {
            Object value2 = this.myValueExternalizer.read(in);
            Collection keys2 = (Collection)this.myKeysExternalizer.read(in);
            for (Object k : keys2) {
                result2.put(k, value2);
            }
        }
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "in";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/indexing/InputMapExternalizer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "save";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "read";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

