/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.diagnostic;

import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.IntEventField;
import com.intellij.internal.statistic.eventLog.events.LongEventField;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import com.intellij.internal.statistic.utils.StatisticsUtil;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0012\u001a\u00020\u0004H\u0016JN\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0007\u001a\u00020\u00172\u0006\u0010\n\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u00172\u0006\u0010\u000b\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u00182\u0006\u0010\r\u001a\u00020\u00182\u0006\u0010\u000e\u001a\u00020\u00182\u0006\u0010\u000f\u001a\u00020\u0018J\u0016\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0007\u001a\u00020\u0017R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/util/indexing/diagnostic/ProjectIndexingHistoryFusReporter;", "Lcom/intellij/internal/statistic/service/fus/collectors/CounterUsagesCollector;", "()V", "GROUP", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "indexingFinished", "Lcom/intellij/internal/statistic/eventLog/events/VarargEventId;", "indexingSessionId", "Lcom/intellij/internal/statistic/eventLog/events/LongEventField;", "indexingStarted", "indexingTime", "numberOfFileProviders", "Lcom/intellij/internal/statistic/eventLog/events/IntEventField;", "numberOfFilesIndexedByExtensionsDuringScan", "numberOfFilesIndexedByExtensionsWithLoadingContent", "numberOfFilesIndexedWithLoadingContent", "numberOfScannedFiles", "scanningTime", "getGroup", "reportIndexingFinished", "", "project", "Lcom/intellij/openapi/project/Project;", "", "", "reportIndexingStarted", "intellij.platform.lang.impl"})
public final class ProjectIndexingHistoryFusReporter
extends CounterUsagesCollector {
    private static final EventLogGroup GROUP;
    private static final LongEventField indexingSessionId;
    private static final LongEventField indexingTime;
    private static final LongEventField scanningTime;
    private static final IntEventField numberOfFileProviders;
    private static final IntEventField numberOfScannedFiles;
    private static final IntEventField numberOfFilesIndexedByExtensionsDuringScan;
    private static final IntEventField numberOfFilesIndexedByExtensionsWithLoadingContent;
    private static final IntEventField numberOfFilesIndexedWithLoadingContent;
    private static final VarargEventId indexingStarted;
    private static final VarargEventId indexingFinished;
    @NotNull
    public static final ProjectIndexingHistoryFusReporter INSTANCE;

    @NotNull
    public EventLogGroup getGroup() {
        return GROUP;
    }

    public final void reportIndexingStarted(@NotNull Project project, long indexingSessionId) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        indexingStarted.log(project, new EventPair[]{ProjectIndexingHistoryFusReporter.indexingSessionId.with((Object)indexingSessionId)});
    }

    public final void reportIndexingFinished(@NotNull Project project, long indexingSessionId, long indexingTime, long scanningTime, int numberOfFileProviders, int numberOfScannedFiles, int numberOfFilesIndexedByExtensionsDuringScan, int numberOfFilesIndexedByExtensionsWithLoadingContent, int numberOfFilesIndexedWithLoadingContent) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        indexingFinished.log(project, new EventPair[]{ProjectIndexingHistoryFusReporter.indexingSessionId.with((Object)indexingSessionId), ProjectIndexingHistoryFusReporter.indexingTime.with((Object)indexingTime), ProjectIndexingHistoryFusReporter.scanningTime.with((Object)scanningTime), ProjectIndexingHistoryFusReporter.numberOfFileProviders.with((Object)numberOfFileProviders), ProjectIndexingHistoryFusReporter.numberOfScannedFiles.with((Object)StatisticsUtil.getNextPowerOfTwo((int)numberOfScannedFiles)), ProjectIndexingHistoryFusReporter.numberOfFilesIndexedByExtensionsDuringScan.with((Object)numberOfFilesIndexedByExtensionsDuringScan), ProjectIndexingHistoryFusReporter.numberOfFilesIndexedByExtensionsWithLoadingContent.with((Object)numberOfFilesIndexedByExtensionsWithLoadingContent), ProjectIndexingHistoryFusReporter.numberOfFilesIndexedWithLoadingContent.with((Object)numberOfFilesIndexedWithLoadingContent)});
    }

    private ProjectIndexingHistoryFusReporter() {
    }

    static {
        ProjectIndexingHistoryFusReporter projectIndexingHistoryFusReporter;
        INSTANCE = projectIndexingHistoryFusReporter = new ProjectIndexingHistoryFusReporter();
        GROUP = new EventLogGroup("indexing.statistics", 1);
        indexingSessionId = EventFields.Long((String)"indexing_session_id");
        indexingTime = EventFields.Long((String)"indexing_time");
        scanningTime = EventFields.Long((String)"scanning_time");
        numberOfFileProviders = EventFields.Int((String)"number_of_file_providers");
        numberOfScannedFiles = EventFields.Int((String)"number_of_scanned_files");
        numberOfFilesIndexedByExtensionsDuringScan = EventFields.Int((String)"number_of_files_indexed_by_extensions_during_scan");
        numberOfFilesIndexedByExtensionsWithLoadingContent = EventFields.Int((String)"number_of_files_indexed_by_extensions_with_loading_content");
        numberOfFilesIndexedWithLoadingContent = EventFields.Int((String)"number_of_files_indexed_with_loading_content");
        indexingStarted = GROUP.registerVarargEvent("started", new EventField[]{(EventField)indexingSessionId});
        indexingFinished = GROUP.registerVarargEvent("finished", new EventField[]{(EventField)indexingSessionId, (EventField)indexingTime, (EventField)scanningTime, (EventField)numberOfFileProviders, (EventField)numberOfScannedFiles, (EventField)numberOfFilesIndexedByExtensionsDuringScan, (EventField)numberOfFilesIndexedByExtensionsWithLoadingContent, (EventField)numberOfFilesIndexedWithLoadingContent});
    }
}

