/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.impl.storage;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ConcurrentIntObjectMap;
import com.intellij.util.indexing.IdFilter;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.DataOutputStream;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.keyStorage.AppendableObjectStorage;
import com.intellij.util.io.keyStorage.AppendableStorageBackedByResizableMappedFile;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

class KeyHashLog<Key>
implements Closeable {
    private static final Logger LOG = Logger.getInstance(KeyHashLog.class);
    private static final boolean ENABLE_CACHED_HASH_IDS = SystemProperties.getBooleanProperty((String)"idea.index.cashed.hashids", (boolean)true);
    @NotNull
    private final KeyDescriptor<Key> myKeyDescriptor;
    @NotNull
    private final Path myBaseStorageFile;
    @NotNull
    private final AppendableObjectStorage<int[]> myKeyHashToVirtualFileMapping;
    @NotNull
    private final ConcurrentIntObjectMap<Boolean> myInvalidatedSessionIds;
    private volatile int myLastScannedId;
    private static volatile Path mySessionDirectory;
    private static final Object mySessionDirectoryLock;

    KeyHashLog(@NotNull KeyDescriptor<Key> descriptor2, @NotNull Path baseStorageFile) throws IOException {
        if (descriptor2 == null) {
            KeyHashLog.$$$reportNull$$$0(0);
        }
        if (baseStorageFile == null) {
            KeyHashLog.$$$reportNull$$$0(1);
        }
        this(descriptor2, baseStorageFile, true);
    }

    private KeyHashLog(@NotNull KeyDescriptor<Key> descriptor2, @NotNull Path baseStorageFile, boolean compact) throws IOException {
        if (descriptor2 == null) {
            KeyHashLog.$$$reportNull$$$0(2);
        }
        if (baseStorageFile == null) {
            KeyHashLog.$$$reportNull$$$0(3);
        }
        this.myInvalidatedSessionIds = ConcurrentCollectionFactory.createConcurrentIntObjectMap();
        this.myKeyDescriptor = descriptor2;
        this.myBaseStorageFile = baseStorageFile;
        if (compact && this.isRequiresCompaction()) {
            this.performCompaction();
        }
        this.myKeyHashToVirtualFileMapping = KeyHashLog.openMapping(this.getDataFile(), 4096);
    }

    @NotNull
    private static AppendableStorageBackedByResizableMappedFile<int[]> openMapping(@NotNull Path dataFile, int size2) throws IOException {
        if (dataFile == null) {
            KeyHashLog.$$$reportNull$$$0(4);
        }
        return new AppendableStorageBackedByResizableMappedFile(dataFile, size2, null, 0x100000, true, (DataExternalizer)IntPairInArrayKeyDescriptor.INSTANCE);
    }

    void addKeyHashToVirtualFileMapping(Key key, int inputId) throws StorageException {
        this.appendKeyHashToVirtualFileMappingToLog(key, inputId);
    }

    void removeKeyHashToVirtualFileMapping(Key key, int inputId) throws StorageException {
        this.appendKeyHashToVirtualFileMappingToLog(key, -inputId);
    }

    @Nullable
    IntSet getSuitableKeyHashes(@NotNull IdFilter filter, @NotNull Project project) throws StorageException {
        IdFilter.FilterScopeType filteringScopeType;
        if (filter == null) {
            KeyHashLog.$$$reportNull$$$0(5);
        }
        if (project == null) {
            KeyHashLog.$$$reportNull$$$0(6);
        }
        if ((filteringScopeType = filter.getFilteringScopeType()) == IdFilter.FilterScopeType.OTHER) {
            filteringScopeType = IdFilter.FilterScopeType.PROJECT_AND_LIBRARIES;
        }
        IntSet hashMaskSet = null;
        long l = System.currentTimeMillis();
        @NotNull Path sessionProjectCacheFile = this.getSavedProjectFileValueIds(this.myLastScannedId, filteringScopeType, project);
        int id2 = this.myKeyHashToVirtualFileMapping.getCurrentLength();
        boolean useCachedHashIds = ENABLE_CACHED_HASH_IDS;
        if (useCachedHashIds && id2 == this.myLastScannedId && this.myInvalidatedSessionIds.remove(id2) == null) {
            try {
                hashMaskSet = KeyHashLog.loadProjectHashes(sessionProjectCacheFile);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (hashMaskSet == null) {
            if (useCachedHashIds && this.myLastScannedId != 0) {
                try {
                    Files.delete(sessionProjectCacheFile);
                }
                catch (NoSuchFileException noSuchFileException) {
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                }
            }
            hashMaskSet = this.getSuitableKeyHashes(filter);
            if (useCachedHashIds) {
                this.saveHashedIds(hashMaskSet, id2, filteringScopeType, project);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Scanned keyHashToVirtualFileMapping of " + this.myBaseStorageFile + " for " + (System.currentTimeMillis() - l));
        }
        return hashMaskSet;
    }

    private void appendKeyHashToVirtualFileMappingToLog(Key key, int inputId) throws StorageException {
        if (inputId == 0) {
            return;
        }
        try {
            this.withLock(() -> this.myKeyHashToVirtualFileMapping.append((Object)new int[]{this.myKeyDescriptor.getHashCode(key), inputId}), false);
        }
        catch (IOException e) {
            throw new StorageException((Throwable)e);
        }
        this.invalidateKeyHashToVirtualFileMappingCache();
    }

    @NotNull
    IntSet getSuitableKeyHashes(@NotNull IdFilter idFilter) throws StorageException {
        IntSet intSet;
        if (idFilter == null) {
            KeyHashLog.$$$reportNull$$$0(7);
        }
        try {
            this.doForce();
            Int2ObjectOpenHashMap hash2inputIds = new Int2ObjectOpenHashMap(1000);
            AtomicInteger uselessRecords = new AtomicInteger();
            this.withLock(() -> this.lambda$getSuitableKeyHashes$3(idFilter, (Int2ObjectMap)hash2inputIds, uselessRecords), true);
            if (uselessRecords.get() >= hash2inputIds.size()) {
                this.setRequiresCompaction();
            }
            intSet = hash2inputIds.keySet();
        }
        catch (IOException e) {
            throw new StorageException((Throwable)e);
        }
        if (intSet == null) {
            KeyHashLog.$$$reportNull$$$0(8);
        }
        return intSet;
    }

    void force() throws IOException {
        if (this.myKeyHashToVirtualFileMapping.isDirty()) {
            this.doForce();
        }
    }

    private void doForce() throws IOException {
        this.withLock(() -> this.myKeyHashToVirtualFileMapping.force(), false);
    }

    @Override
    public void close() throws IOException {
        this.withLock(() -> this.myKeyHashToVirtualFileMapping.close(), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performCompaction() throws IOException {
        try {
            Int2ObjectOpenHashMap data2 = new Int2ObjectOpenHashMap();
            Path oldDataFile = this.getDataFile();
            AppendableStorageBackedByResizableMappedFile<int[]> oldMapping = KeyHashLog.openMapping(oldDataFile, 0);
            oldMapping.lockRead();
            try {
                oldMapping.processAll(arg_0 -> KeyHashLog.lambda$performCompaction$7((Int2ObjectMap)data2, arg_0));
                oldMapping.close();
            }
            finally {
                oldMapping.unlockRead();
            }
            String dataFileName = oldDataFile.getFileName().toString();
            String newDataFileName = "new." + dataFileName;
            Path newDataFile = oldDataFile.resolveSibling(newDataFileName);
            AppendableStorageBackedByResizableMappedFile<int[]> newMapping = KeyHashLog.openMapping(newDataFile, 64 * data2.size());
            newMapping.lockWrite();
            try {
                for (Int2ObjectMap.Entry entry2 : data2.int2ObjectEntrySet()) {
                    int keyHash = entry2.getIntKey();
                    IntIterator inputIdIterator = ((IntSet)entry2.getValue()).iterator();
                    while (inputIdIterator.hasNext()) {
                        int inputId = inputIdIterator.nextInt();
                        newMapping.append((Object)new int[]{keyHash, inputId});
                    }
                }
                newMapping.close();
            }
            finally {
                newMapping.unlockWrite();
            }
            IOUtil.deleteAllFilesStartingWith((File)oldDataFile.toFile());
            try (DirectoryStream<Path> paths2 = Files.newDirectoryStream(newDataFile.getParent());){
                for (Path path2 : paths2) {
                    String name = path2.getFileName().toString();
                    if (!name.startsWith(newDataFileName)) continue;
                    FileUtil.rename((File)path2.toFile(), (String)(dataFileName + name.substring(newDataFileName.length())));
                }
            }
            try {
                Files.delete(this.getCompactionMarker());
            }
            catch (IOException iOException) {}
        }
        catch (ProcessCanceledException e) {
            LOG.error((Throwable)e);
            throw e;
        }
    }

    @NotNull
    private static IntSet loadProjectHashes(@NotNull Path fileWithCaches) throws IOException {
        int capacity;
        if (fileWithCaches == null) {
            KeyHashLog.$$$reportNull$$$0(9);
        }
        DataInputStream inputStream2 = new DataInputStream(new BufferedInputStream(Files.newInputStream(fileWithCaches, new OpenOption[0])));
        IntOpenHashSet hashMaskSet = new IntOpenHashSet(capacity);
        for (capacity = DataInputOutputUtil.readINT((DataInput)inputStream2); capacity > 0; --capacity) {
            hashMaskSet.add(DataInputOutputUtil.readINT((DataInput)inputStream2));
        }
        IntOpenHashSet intOpenHashSet = hashMaskSet;
        IntOpenHashSet intOpenHashSet2 = intOpenHashSet;
        if (intOpenHashSet2 == null) {
            KeyHashLog.$$$reportNull$$$0(10);
        }
        return intOpenHashSet2;
        finally {
            inputStream2.close();
        }
    }

    private void saveHashedIds(@NotNull IntSet hashMaskSet, int largestId, @NotNull IdFilter.FilterScopeType scopeType2, @NotNull Project project) {
        if (hashMaskSet == null) {
            KeyHashLog.$$$reportNull$$$0(11);
        }
        if (scopeType2 == null) {
            KeyHashLog.$$$reportNull$$$0(12);
        }
        if (project == null) {
            KeyHashLog.$$$reportNull$$$0(13);
        }
        @NotNull Path newFileWithCaches = this.getSavedProjectFileValueIds(largestId, scopeType2, project);
        boolean savedSuccessfully = true;
        try (DataOutputStream stream = new DataOutputStream((OutputStream)new BufferedOutputStream(Files.newOutputStream(newFileWithCaches, new OpenOption[0])));){
            DataInputOutputUtil.writeINT((DataOutput)stream, (int)hashMaskSet.size());
            IntIterator iterator2 = hashMaskSet.iterator();
            while (iterator2.hasNext()) {
                DataInputOutputUtil.writeINT((DataOutput)stream, (int)iterator2.nextInt());
            }
        }
        catch (IOException ignored) {
            savedSuccessfully = false;
        }
        if (savedSuccessfully) {
            this.myLastScannedId = largestId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Path getSessionDir() {
        Path sessionDirectory = mySessionDirectory;
        if (sessionDirectory == null) {
            Object object = mySessionDirectoryLock;
            synchronized (object) {
                sessionDirectory = mySessionDirectory;
                if (sessionDirectory == null) {
                    try {
                        mySessionDirectory = sessionDirectory = FileUtil.createTempDirectory((File)new File(PathManager.getTempPath()), (String)Long.toString(System.currentTimeMillis()), (String)"", (boolean)true).toPath();
                    }
                    catch (IOException ex) {
                        throw new RuntimeException("Can not create temp directory", ex);
                    }
                }
            }
        }
        return sessionDirectory;
    }

    @NotNull
    private Path getSavedProjectFileValueIds(int id2, @NotNull IdFilter.FilterScopeType scopeType2, @NotNull Project project) {
        if (scopeType2 == null) {
            KeyHashLog.$$$reportNull$$$0(14);
        }
        if (project == null) {
            KeyHashLog.$$$reportNull$$$0(15);
        }
        Path path2 = KeyHashLog.getSessionDir().resolve(this.getDataFile().getFileName().toString() + "." + project.hashCode() + "." + id2 + "." + scopeType2.getId());
        if (path2 == null) {
            KeyHashLog.$$$reportNull$$$0(16);
        }
        return path2;
    }

    private void invalidateKeyHashToVirtualFileMappingCache() {
        int lastScannedId = this.myLastScannedId;
        if (lastScannedId != 0) {
            this.myInvalidatedSessionIds.putIfAbsent(lastScannedId, (Object)Boolean.TRUE);
            this.myLastScannedId = 0;
        }
    }

    private <T extends Throwable> void withLock(ThrowableRunnable<T> r, boolean read) throws T {
        if (read) {
            this.myKeyHashToVirtualFileMapping.lockRead();
        } else {
            this.myKeyHashToVirtualFileMapping.lockWrite();
        }
        try {
            r.run();
        }
        finally {
            if (read) {
                this.myKeyHashToVirtualFileMapping.unlockRead();
            } else {
                this.myKeyHashToVirtualFileMapping.unlockWrite();
            }
        }
    }

    private void setRequiresCompaction() {
        Path marker = this.getCompactionMarker();
        if (Files.exists(marker, new LinkOption[0])) {
            return;
        }
        try {
            Files.createFile(marker, new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    @VisibleForTesting
    boolean isRequiresCompaction() {
        return Files.exists(this.getCompactionMarker(), new LinkOption[0]);
    }

    @NotNull
    private Path getCompactionMarker() {
        Path dataFile = this.getDataFile();
        Path path2 = dataFile.resolveSibling(dataFile.getFileName().toString() + ".require.compaction");
        if (path2 == null) {
            KeyHashLog.$$$reportNull$$$0(17);
        }
        return path2;
    }

    @NotNull
    private Path getDataFile() {
        Path path2 = this.myBaseStorageFile.resolveSibling(this.myBaseStorageFile.getFileName() + ".project");
        if (path2 == null) {
            KeyHashLog.$$$reportNull$$$0(18);
        }
        return path2;
    }

    public static void main(String[] args) throws Exception {
        String indexPath = args[0];
        EnumeratorStringDescriptor enumeratorStringDescriptor = EnumeratorStringDescriptor.INSTANCE;
        try (KeyHashLog keyHashLog = new KeyHashLog(enumeratorStringDescriptor, Path.of(indexPath, new String[0]), false);){
            IntSet allHashes = keyHashLog.getSuitableKeyHashes(new IdFilter(){

                public boolean containsFileId(int id2) {
                    return true;
                }
            });
            for (Integer hash : allHashes) {
                System.out.println("key hash = " + hash);
            }
        }
    }

    private static /* synthetic */ boolean lambda$performCompaction$7(Int2ObjectMap data2, int[] key) {
        int inputId = key[1];
        int keyHash = key[0];
        int absInputId = Math.abs(inputId);
        if (inputId > 0) {
            ((IntSet)data2.computeIfAbsent(keyHash, __ -> new IntOpenHashSet())).add(absInputId);
        } else {
            IntSet associatedInputIds = (IntSet)data2.get(keyHash);
            if (associatedInputIds != null) {
                associatedInputIds.remove(absInputId);
            }
        }
        return true;
    }

    private /* synthetic */ void lambda$getSuitableKeyHashes$3(IdFilter idFilter, Int2ObjectMap hash2inputIds, AtomicInteger uselessRecords) throws IOException {
        ProgressManager.checkCanceled();
        this.myKeyHashToVirtualFileMapping.processAll(key -> {
            ProgressManager.checkCanceled();
            int inputId = key[1];
            int absInputId = Math.abs(inputId);
            if (!idFilter.containsFileId(absInputId)) {
                return true;
            }
            int keyHash = key[0];
            if (inputId > 0) {
                if (!((IntSet)hash2inputIds.computeIfAbsent(keyHash, __ -> new IntOpenHashSet())).add(inputId)) {
                    uselessRecords.incrementAndGet();
                }
            } else {
                IntSet inputIds = (IntSet)hash2inputIds.get(keyHash);
                if (inputIds != null) {
                    inputIds.remove(absInputId);
                    if (inputIds.isEmpty()) {
                        hash2inputIds.remove(keyHash);
                    }
                }
                uselessRecords.incrementAndGet();
            }
            return true;
        });
    }

    static {
        mySessionDirectoryLock = new Object();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 10: 
            case 16: 
            case 17: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 10: 
            case 16: 
            case 17: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseStorageFile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataFile";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 6: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "idFilter";
                break;
            }
            case 8: 
            case 10: 
            case 16: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/impl/storage/KeyHashLog";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileWithCaches";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hashMaskSet";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/impl/storage/KeyHashLog";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuitableKeyHashes";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "loadProjectHashes";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getSavedProjectFileValueIds";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompactionMarker";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "openMapping";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getSuitableKeyHashes";
                break;
            }
            case 8: 
            case 10: 
            case 16: 
            case 17: 
            case 18: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "loadProjectHashes";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "saveHashedIds";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getSavedProjectFileValueIds";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 10: 
            case 16: 
            case 17: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class IntPairInArrayKeyDescriptor
    implements DataExternalizer<int[]> {
        private static final IntPairInArrayKeyDescriptor INSTANCE = new IntPairInArrayKeyDescriptor();

        private IntPairInArrayKeyDescriptor() {
        }

        public void save(@NotNull DataOutput out, int[] value2) throws IOException {
            if (out == null) {
                IntPairInArrayKeyDescriptor.$$$reportNull$$$0(0);
            }
            DataInputOutputUtil.writeINT((DataOutput)out, (int)value2[0]);
            DataInputOutputUtil.writeINT((DataOutput)out, (int)value2[1]);
        }

        public int[] read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                IntPairInArrayKeyDescriptor.$$$reportNull$$$0(1);
            }
            return new int[]{DataInputOutputUtil.readINT((DataInput)in), DataInputOutputUtil.readINT((DataInput)in)};
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/util/indexing/impl/storage/KeyHashLog$IntPairInArrayKeyDescriptor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

