/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.highlighting;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import com.intellij.util.xml.highlighting.DomElementProblemDescriptor;
import com.intellij.util.xml.highlighting.DomElementProblemDescriptorImpl;
import com.intellij.util.xml.highlighting.DomElementResolveProblemDescriptor;
import com.intellij.xml.util.XmlStringUtil;
import org.jetbrains.annotations.Nullable;

public final class DomElementsHighlightingUtil {
    private DomElementsHighlightingUtil() {
    }

    @Nullable
    public static ProblemDescriptor createProblemDescriptors(InspectionManager manager2, DomElementProblemDescriptor problemDescriptor) {
        ProblemHighlightType type = DomElementsHighlightingUtil.getProblemHighlightType(problemDescriptor);
        return (ProblemDescriptor)DomElementsHighlightingUtil.createProblemDescriptors(problemDescriptor, s -> manager2.createProblemDescriptor((PsiElement)s.second, (TextRange)s.first, problemDescriptor.getDescriptionTemplate(), type, true, problemDescriptor.getFixes()));
    }

    private static ProblemHighlightType getProblemHighlightType(DomElementProblemDescriptor problemDescriptor) {
        TextRange range2;
        if (problemDescriptor.getHighlightType() != null) {
            return problemDescriptor.getHighlightType();
        }
        if (problemDescriptor instanceof DomElementResolveProblemDescriptor && (range2 = ((DomElementResolveProblemDescriptor)problemDescriptor).getPsiReference().getRangeInElement()).getStartOffset() != range2.getEndOffset()) {
            return ProblemHighlightType.LIKE_UNKNOWN_SYMBOL;
        }
        return ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
    }

    @Nullable
    public static Annotation createAnnotation(DomElementProblemDescriptor problemDescriptor) {
        return (Annotation)DomElementsHighlightingUtil.createProblemDescriptors(problemDescriptor, s -> {
            String text2 = problemDescriptor.getDescriptionTemplate();
            if (StringUtil.isEmpty((String)text2)) {
                text2 = null;
            }
            HighlightSeverity severity = problemDescriptor.getHighlightSeverity();
            TextRange range2 = (TextRange)s.first;
            if (text2 == null) {
                range2 = TextRange.from((int)range2.getStartOffset(), (int)0);
            }
            range2 = range2.shiftRight(((PsiElement)s.second).getTextRange().getStartOffset());
            String tooltip2 = text2 == null ? null : XmlStringUtil.wrapInHtml((CharSequence)XmlStringUtil.escapeString((String)text2));
            Annotation annotation = new Annotation(range2.getStartOffset(), range2.getEndOffset(), severity, text2, tooltip2);
            if (problemDescriptor instanceof DomElementResolveProblemDescriptor) {
                annotation.setTextAttributes(CodeInsightColors.WRONG_REFERENCES_ATTRIBUTES);
            }
            for (LocalQuickFix fix : problemDescriptor.getFixes()) {
                if (!(fix instanceof IntentionAction)) continue;
                annotation.registerFix((IntentionAction)fix);
            }
            return annotation;
        });
    }

    @Nullable
    private static <T> T createProblemDescriptors(DomElementProblemDescriptor problemDescriptor, Function<? super Pair<TextRange, PsiElement>, ? extends T> creator) {
        Pair<TextRange, PsiElement> range2 = ((DomElementProblemDescriptorImpl)problemDescriptor).getProblemRange();
        return (T)(range2 == DomElementProblemDescriptorImpl.NO_PROBLEM || !((PsiElement)range2.second).isPhysical() ? null : creator.fun(range2));
    }
}

