/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.impl.source.xml.XmlTagImpl;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.Convert;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomNameStrategy;
import com.intellij.util.xml.DomReflectionUtil;
import com.intellij.util.xml.EvaluatedXmlName;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.HyphenNameStrategy;
import com.intellij.util.xml.JavaMethod;
import com.intellij.util.xml.JavaNameStrategy;
import com.intellij.util.xml.NameStrategy;
import com.intellij.util.xml.NameStrategyForAttributes;
import com.intellij.util.xml.Namespace;
import com.intellij.util.xml.Resolve;
import com.intellij.util.xml.SubTag;
import com.intellij.util.xml.SubTagList;
import com.intellij.util.xml.TagValue;
import com.intellij.util.xml.XmlName;
import com.intellij.util.xml.impl.DomFileElementImpl;
import com.intellij.util.xml.impl.DomGenericInfoEx;
import com.intellij.util.xml.impl.DomInvocationHandler;
import com.intellij.util.xml.impl.DomManagerImpl;
import com.intellij.util.xml.impl.DomRootInvocationHandler;
import com.intellij.util.xml.impl.PhysicalDomParentStrategy;
import com.intellij.util.xml.reflect.DomCollectionChildDescription;
import com.intellij.util.xml.reflect.DomFixedChildDescription;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DomImplUtil {
    private static final Logger LOG = Logger.getInstance(DomImplUtil.class);

    private DomImplUtil() {
    }

    public static void assertValidity(DomElement element2, String msg) {
        if (element2 instanceof DomFileElementImpl) {
            String s = ((DomFileElementImpl)element2).checkValidity();
            if (s != null) {
                throw new AssertionError((Object)s);
            }
            return;
        }
        DomInvocationHandler handler2 = DomManagerImpl.getDomInvocationHandler(element2);
        assert (handler2 != null);
        try {
            handler2.assertValid();
        }
        catch (AssertionError e) {
            throw new AssertionError((Object)(msg + ((Throwable)((Object)e)).getMessage()));
        }
    }

    public static boolean isTagValueGetter(JavaMethod method2) {
        if (!DomImplUtil.isGetter(method2)) {
            return false;
        }
        if (DomImplUtil.hasTagValueAnnotation(method2)) {
            return true;
        }
        if ("getValue".equals(method2.getName())) {
            if (method2.getAnnotation(SubTag.class) != null) {
                return false;
            }
            if (method2.getAnnotation(SubTagList.class) != null) {
                return false;
            }
            if (method2.getAnnotation(Convert.class) != null || method2.getAnnotation(Resolve.class) != null) {
                return !ReflectionUtil.isAssignable(GenericDomValue.class, (Class)method2.getReturnType());
            }
            return !ReflectionUtil.isAssignable(DomElement.class, (Class)method2.getReturnType());
        }
        return false;
    }

    private static boolean hasTagValueAnnotation(JavaMethod method2) {
        return method2.getAnnotation(TagValue.class) != null;
    }

    public static boolean isGetter(JavaMethod method2) {
        boolean isIs;
        @NonNls String name = method2.getName();
        boolean isGet = name.startsWith("get");
        boolean bl = isIs = !isGet && name.startsWith("is");
        if (!isGet && !isIs) {
            return false;
        }
        if (method2.getGenericParameterTypes().length != 0) {
            return false;
        }
        Type returnType = method2.getGenericReturnType();
        if (isGet) {
            return returnType != Void.TYPE;
        }
        return DomReflectionUtil.canHaveIsPropertyGetterPrefix((Type)returnType);
    }

    public static boolean isTagValueSetter(JavaMethod method2) {
        boolean setter = method2.getName().startsWith("set") && method2.getGenericParameterTypes().length == 1 && method2.getReturnType() == Void.TYPE;
        return setter && (DomImplUtil.hasTagValueAnnotation(method2) || "setValue".equals(method2.getName()));
    }

    @Nullable
    public static DomNameStrategy getDomNameStrategy(Class<?> rawType, boolean isAttribute) {
        NameStrategyForAttributes annotation;
        Class aClass = null;
        if (isAttribute && (annotation = (NameStrategyForAttributes)DomReflectionUtil.findAnnotationDFS(rawType, NameStrategyForAttributes.class)) != null) {
            aClass = annotation.value();
        }
        if (aClass == null && (annotation = (NameStrategy)DomReflectionUtil.findAnnotationDFS(rawType, NameStrategy.class)) != null) {
            aClass = annotation.value();
        }
        if (aClass != null) {
            if (HyphenNameStrategy.class.equals(aClass)) {
                return DomNameStrategy.HYPHEN_STRATEGY;
            }
            if (JavaNameStrategy.class.equals((Object)aClass)) {
                return DomNameStrategy.JAVA_STRATEGY;
            }
            try {
                return (DomNameStrategy)aClass.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                LOG.error((Throwable)e);
            }
        }
        return null;
    }

    public static List<XmlTag> findSubTags(@NotNull XmlTag tag2, EvaluatedXmlName name, XmlFile file2) {
        if (tag2 == null) {
            DomImplUtil.$$$reportNull$$$0(0);
        }
        return DomImplUtil.findSubTags(tag2, name, file2, false);
    }

    static List<XmlTag> findSubTags(@NotNull XmlTag tag2, EvaluatedXmlName name, XmlFile file2, boolean processIncludes) {
        Object[] tags;
        if (tag2 == null) {
            DomImplUtil.$$$reportNull$$$0(1);
        }
        if (!tag2.isValid()) {
            throw new AssertionError((Object)"Invalid tag");
        }
        Object[] objectArray = tags = tag2 instanceof XmlTagImpl ? ((XmlTagImpl)tag2).getSubTags(processIncludes) : tag2.getSubTags();
        if (tags.length == 0) {
            return Collections.emptyList();
        }
        return ContainerUtil.findAll((Object[])tags, childTag -> {
            ProgressManager.checkCanceled();
            try {
                return DomImplUtil.isNameSuitable(name, childTag, file2);
            }
            catch (PsiInvalidElementAccessException e) {
                if (!childTag.isValid()) {
                    LOG.error("tag.getSubTags() returned invalid, tag=" + tag2 + ", containing file: " + tag2.getContainingFile() + "subTag.parent=" + childTag.getNode().getTreeParent());
                    return false;
                }
                throw e;
            }
        });
    }

    public static List<XmlTag> findSubTags(XmlTag[] tags, EvaluatedXmlName name, XmlFile file2) {
        if (tags.length == 0) {
            return Collections.emptyList();
        }
        return ContainerUtil.findAll((Object[])tags, childTag -> DomImplUtil.isNameSuitable(name, childTag, file2));
    }

    public static boolean isNameSuitable(XmlName name, XmlTag tag2, @NotNull DomInvocationHandler handler2, XmlFile file2) {
        if (handler2 == null) {
            DomImplUtil.$$$reportNull$$$0(2);
        }
        return DomImplUtil.isNameSuitable(handler2.createEvaluatedXmlName(name), tag2, file2);
    }

    private static boolean isNameSuitable(EvaluatedXmlName evaluatedXmlName, XmlTag tag2, XmlFile file2) {
        String evaluatedLocalName = evaluatedXmlName.getXmlName().getLocalName();
        boolean qNameMatch = evaluatedLocalName.equals(tag2.getName());
        return (qNameMatch || evaluatedLocalName.equals(tag2.getLocalName())) && evaluatedXmlName.isNamespaceAllowed(tag2.getNamespace(), file2, !qNameMatch);
    }

    @Nullable
    public static XmlName createXmlName(@NotNull String name, Type type, @Nullable JavaMethod javaMethod) {
        Class<?> aClass;
        if (name == null) {
            DomImplUtil.$$$reportNull$$$0(3);
        }
        if ((aClass = DomImplUtil.getErasure(type)) == null) {
            return null;
        }
        String key = DomImplUtil.getNamespaceKey(aClass);
        if (key == null && javaMethod != null) {
            for (Method method2 : javaMethod.getHierarchy()) {
                String key1 = DomImplUtil.getNamespaceKey(method2.getDeclaringClass());
                if (key1 == null) continue;
                return new XmlName(name, key1);
            }
        }
        return new XmlName(name, key);
    }

    @Nullable
    private static Class<?> getErasure(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return DomImplUtil.getErasure(((ParameterizedType)type).getRawType());
        }
        if (type instanceof TypeVariable) {
            for (Type bound : ((TypeVariable)type).getBounds()) {
                Class<?> aClass = DomImplUtil.getErasure(bound);
                if (aClass == null) continue;
                return aClass;
            }
        }
        if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            for (Type bound : wildcardType.getUpperBounds()) {
                Class<?> aClass = DomImplUtil.getErasure(bound);
                if (aClass == null) continue;
                return aClass;
            }
        }
        return null;
    }

    @Nullable
    private static String getNamespaceKey(@NotNull Class<?> type) {
        Namespace namespace;
        if (type == null) {
            DomImplUtil.$$$reportNull$$$0(4);
        }
        return (namespace = (Namespace)DomReflectionUtil.findAnnotationDFS(type, Namespace.class)) != null ? namespace.value() : null;
    }

    @Nullable
    public static XmlName createXmlName(@NotNull String name, JavaMethod method2) {
        if (name == null) {
            DomImplUtil.$$$reportNull$$$0(5);
        }
        return DomImplUtil.createXmlName(name, method2.getGenericReturnType(), method2);
    }

    public static List<XmlTag> getCustomSubTags(DomInvocationHandler handler2, XmlTag[] subTags, XmlFile file2) {
        if (subTags.length == 0) {
            return Collections.emptyList();
        }
        DomGenericInfoEx info2 = handler2.getGenericInfo();
        HashSet<XmlName> usedNames = new HashSet<XmlName>();
        List collectionChildrenDescriptions = info2.getCollectionChildrenDescriptions();
        int size2 = collectionChildrenDescriptions.size();
        for (int i2 = 0; i2 < size2; ++i2) {
            DomCollectionChildDescription description2 = (DomCollectionChildDescription)collectionChildrenDescriptions.get(i2);
            usedNames.add(description2.getXmlName());
        }
        List fixedChildrenDescriptions = info2.getFixedChildrenDescriptions();
        int size3 = fixedChildrenDescriptions.size();
        for (int i3 = 0; i3 < size3; ++i3) {
            DomFixedChildDescription description3 = (DomFixedChildDescription)fixedChildrenDescriptions.get(i3);
            usedNames.add(description3.getXmlName());
        }
        return ContainerUtil.findAll((Object[])subTags, tag2 -> {
            if (StringUtil.isEmpty((String)tag2.getLocalName())) {
                return false;
            }
            for (XmlName name : usedNames) {
                if (!DomImplUtil.isNameSuitable(name, tag2, handler2, file2)) continue;
                return false;
            }
            return true;
        });
    }

    static XmlFile getFile(DomElement domElement) {
        if (domElement instanceof DomFileElement) {
            return ((DomFileElement)domElement).getFile();
        }
        DomInvocationHandler handler2 = DomManagerImpl.getDomInvocationHandler(domElement);
        assert (handler2 != null) : domElement;
        while (!(handler2 instanceof DomRootInvocationHandler)) {
            XmlTag tag2 = handler2.getXmlTag();
            if (tag2 != null) {
                return DomImplUtil.getContainingFile(tag2);
            }
            DomInvocationHandler parent = handler2.getParentHandler();
            if (parent == null) {
                throw new AssertionError((Object)("No parent for " + handler2.toStringEx()));
            }
            handler2 = parent;
        }
        return ((DomRootInvocationHandler)handler2).getParent().getFile();
    }

    private static XmlFile getContainingFile(XmlTag tag2) {
        PsiElement parentTag;
        while ((parentTag = PhysicalDomParentStrategy.getParentTagCandidate((XmlElement)tag2)) instanceof XmlTag) {
            tag2 = (XmlTag)parentTag;
        }
        return (XmlFile)tag2.getContainingFile();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/xml/impl/DomImplUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findSubTags";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isNameSuitable";
                break;
            }
            case 3: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "createXmlName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getNamespaceKey";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

