/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.ide.highlighter.DomSupportEnabled;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.ide.plugins.DynamicPluginListener;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.pom.PomManager;
import com.intellij.pom.PomModel;
import com.intellij.pom.PomModelAspect;
import com.intellij.pom.event.PomModelEvent;
import com.intellij.pom.event.PomModelListener;
import com.intellij.pom.tree.TreeAspect;
import com.intellij.pom.tree.events.TreeChangeEvent;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.file.impl.FileManager;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.reference.SoftReference;
import com.intellij.util.ArrayUtil;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.xml.ConverterManager;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomEventListener;
import com.intellij.util.xml.DomFileDescription;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.ModelMerger;
import com.intellij.util.xml.ModelMergerImpl;
import com.intellij.util.xml.StableElement;
import com.intellij.util.xml.TypeChooserManager;
import com.intellij.util.xml.events.DomEvent;
import com.intellij.util.xml.impl.DomApplicationComponent;
import com.intellij.util.xml.impl.DomCreator;
import com.intellij.util.xml.impl.DomFileElementImpl;
import com.intellij.util.xml.impl.DomInvocationHandler;
import com.intellij.util.xml.impl.MockDomFileDescription;
import com.intellij.util.xml.impl.StableInvocationHandler;
import com.intellij.util.xml.reflect.AbstractDomChildrenDescription;
import com.intellij.util.xml.reflect.DomGenericInfo;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sf.cglib.proxy.AdvancedProxy;
import net.sf.cglib.proxy.InvocationHandler;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class DomManagerImpl
extends DomManager
implements Disposable {
    private static final Key<Object> MOCK = Key.create((String)"MockElement");
    static final Key<WeakReference<DomFileElementImpl<?>>> CACHED_FILE_ELEMENT = Key.create((String)"CACHED_FILE_ELEMENT");
    static final Key<DomFileDescription<?>> MOCK_DESCRIPTION = Key.create((String)"MockDescription");
    private static final Key<CachedValue<DomFileElementImpl<?>>> FILE_ELEMENT_KEY = Key.create((String)"DomFileElement");
    private static final Key<CachedValue<DomFileElementImpl<?>>> FILE_ELEMENT_KEY_FOR_INDEX = Key.create((String)"DomFileElementForIndex");
    private static final Key<CachedValue<DomInvocationHandler>> HANDLER_KEY = Key.create((String)"DomInvocationHandler");
    private static final Key<CachedValue<DomInvocationHandler>> HANDLER_KEY_FOR_INDEX = Key.create((String)"DomInvocationHandlerForIndex");
    private final EventDispatcher<DomEventListener> myListeners = EventDispatcher.create(DomEventListener.class);
    private final Project myProject;
    private final DomApplicationComponent myApplicationComponent;
    private boolean myChanging;
    private boolean myBulkChange;

    public DomManagerImpl(Project project) {
        super(project);
        this.myProject = project;
        this.myApplicationComponent = DomApplicationComponent.getInstance();
        final PomModel pomModel = PomManager.getModel((Project)project);
        pomModel.addModelListener(new PomModelListener(){

            public void modelChanged(@NotNull PomModelEvent event) {
                DomFileElementImpl element2;
                PsiFile file2;
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (DomManagerImpl.this.myChanging) {
                    return;
                }
                TreeChangeEvent changeSet = (TreeChangeEvent)event.getChangeSet(pomModel.getModelAspect(TreeAspect.class));
                if (changeSet != null && (file2 = changeSet.getRootElement().getPsi().getContainingFile()) instanceof XmlFile && (element2 = DomManagerImpl.getCachedFileElement((XmlFile)file2)) != null) {
                    DomManagerImpl.this.fireEvent(new DomEvent(element2, false));
                }
            }

            public boolean isAspectChangeInteresting(@NotNull PomModelAspect aspect) {
                if (aspect == null) {
                    1.$$$reportNull$$$0(1);
                }
                return aspect instanceof TreeAspect;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "aspect";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/util/xml/impl/DomManagerImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "modelChanged";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isAspectChangeInteresting";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (Disposable)this);
        VirtualFileManager.getInstance().addAsyncFileListener(new AsyncFileListener(){

            @Nullable
            public AsyncFileListener.ChangeApplier prepareChange(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
                if (events == null) {
                    2.$$$reportNull$$$0(0);
                }
                final ArrayList<DomEvent> domEvents = new ArrayList<DomEvent>();
                for (VFileEvent vFileEvent : events) {
                    if (!this.shouldFireDomEvents(vFileEvent)) continue;
                    ProgressManager.checkCanceled();
                    domEvents.addAll(DomManagerImpl.this.calcDomChangeEvents(vFileEvent.getFile()));
                }
                return domEvents.isEmpty() ? null : new AsyncFileListener.ChangeApplier(){

                    public void afterVfsChange() {
                        DomManagerImpl.this.fireEvents(domEvents);
                    }
                };
            }

            private boolean shouldFireDomEvents(VFileEvent event) {
                if (event instanceof VFileContentChangeEvent) {
                    return !event.isFromSave();
                }
                if (event instanceof VFilePropertyChangeEvent) {
                    return "name".equals(((VFilePropertyChangeEvent)event).getPropertyName()) && !((VFilePropertyChangeEvent)event).getFile().isDirectory();
                }
                return event instanceof VFileMoveEvent || event instanceof VFileDeleteEvent;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/util/xml/impl/DomManagerImpl$2", "prepareChange"));
            }
        }, (Disposable)this);
        project.getMessageBus().connect((Disposable)this).subscribe(DynamicPluginListener.TOPIC, (Object)new DynamicPluginListener(){

            @Override
            public void beforePluginUnload(@NotNull IdeaPluginDescriptor pluginDescriptor, boolean isUpdate) {
                if (pluginDescriptor == null) {
                    3.$$$reportNull$$$0(0);
                }
                DomUtil.clearCaches();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginDescriptor", "com/intellij/util/xml/impl/DomManagerImpl$3", "beforePluginUnload"));
            }
        });
    }

    public void dispose() {
    }

    public long getPsiModificationCount() {
        return PsiManager.getInstance((Project)this.getProject()).getModificationTracker().getModificationCount();
    }

    private List<DomEvent> calcDomChangeEvents(VirtualFile file2) {
        if (!(file2 instanceof NewVirtualFile) || this.myProject.isDisposed()) {
            return Collections.emptyList();
        }
        final FileManager fileManager = PsiManagerEx.getInstanceEx(this.myProject).getFileManager();
        final ArrayList<DomEvent> events = new ArrayList<DomEvent>();
        VfsUtilCore.visitChildrenRecursively((VirtualFile)file2, (VirtualFileVisitor)new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[0]){

            public boolean visitFile(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (!file2.isDirectory() && FileTypeRegistry.getInstance().isFileOfType(file2, (FileType)XmlFileType.INSTANCE)) {
                    DomFileElementImpl domElement;
                    PsiFile psiFile = fileManager.getCachedPsiFile(file2);
                    DomFileElementImpl domFileElementImpl = domElement = psiFile instanceof XmlFile ? DomManagerImpl.getCachedFileElement((XmlFile)psiFile) : null;
                    if (domElement != null) {
                        events.add(new DomEvent(domElement, false));
                    }
                }
                return true;
            }

            public Iterable<VirtualFile> getChildrenIterable(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    4.$$$reportNull$$$0(1);
                }
                return ((NewVirtualFile)file2).getCachedChildren();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "file";
                objectArray2[1] = "com/intellij/util/xml/impl/DomManagerImpl$4";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitFile";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getChildrenIterable";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        return events;
    }

    boolean isInsideAtomicChange() {
        return this.myBulkChange;
    }

    public static DomManagerImpl getDomManager(Project project) {
        return (DomManagerImpl)DomManager.getDomManager((Project)project);
    }

    public void addDomEventListener(DomEventListener listener2, Disposable parentDisposable) {
        this.myListeners.addListener((EventListener)listener2, parentDisposable);
    }

    public ConverterManager getConverterManager() {
        return (ConverterManager)ApplicationManager.getApplication().getService(ConverterManager.class);
    }

    public ModelMerger createModelMerger() {
        return new ModelMergerImpl();
    }

    void fireEvent(@NotNull DomEvent event) {
        if (event == null) {
            DomManagerImpl.$$$reportNull$$$0(0);
        }
        if (this.isInsideAtomicChange()) {
            return;
        }
        this.clearCache();
        ((DomEventListener)this.myListeners.getMulticaster()).eventOccured(event);
    }

    private void fireEvents(@NotNull Collection<? extends DomEvent> events) {
        if (events == null) {
            DomManagerImpl.$$$reportNull$$$0(1);
        }
        for (DomEvent domEvent : events) {
            this.fireEvent(domEvent);
        }
    }

    public DomGenericInfo getGenericInfo(Type type) {
        return this.myApplicationComponent.getStaticGenericInfo(type);
    }

    @Nullable
    public static DomInvocationHandler getDomInvocationHandler(DomElement proxy) {
        if (proxy instanceof DomFileElement) {
            return null;
        }
        if (proxy instanceof DomInvocationHandler) {
            return (DomInvocationHandler)proxy;
        }
        InvocationHandler handler2 = AdvancedProxy.getInvocationHandler(proxy);
        if (handler2 instanceof StableInvocationHandler) {
            DomElement element2 = (DomElement)((StableInvocationHandler)handler2).getWrappedElement();
            return element2 == null ? null : DomManagerImpl.getDomInvocationHandler(element2);
        }
        if (handler2 instanceof DomInvocationHandler) {
            return (DomInvocationHandler)handler2;
        }
        return null;
    }

    @NotNull
    public static DomInvocationHandler getNotNullHandler(DomElement proxy) {
        DomInvocationHandler handler2 = DomManagerImpl.getDomInvocationHandler(proxy);
        if (handler2 == null) {
            throw new AssertionError((Object)("null handler for " + proxy));
        }
        DomInvocationHandler domInvocationHandler = handler2;
        if (domInvocationHandler == null) {
            DomManagerImpl.$$$reportNull$$$0(2);
        }
        return domInvocationHandler;
    }

    public static StableInvocationHandler<?> getStableInvocationHandler(Object proxy) {
        return (StableInvocationHandler)AdvancedProxy.getInvocationHandler(proxy);
    }

    public DomApplicationComponent getApplicationComponent() {
        return this.myApplicationComponent;
    }

    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public <T extends DomElement> DomFileElementImpl<T> getFileElement(XmlFile file2, Class<T> aClass, String rootTagName) {
        if (file2.getUserData(MOCK_DESCRIPTION) == null) {
            file2.putUserData(MOCK_DESCRIPTION, new MockDomFileDescription<T>(aClass, rootTagName, file2.getViewProvider().getVirtualFile()));
            this.clearCache();
        }
        DomFileElement fileElement = this.getFileElement(file2);
        assert (fileElement != null);
        DomFileElement domFileElement = fileElement;
        if (domFileElement == null) {
            DomManagerImpl.$$$reportNull$$$0(3);
        }
        return domFileElement;
    }

    public Set<DomFileDescription<?>> getFileDescriptions(String rootTagName) {
        return this.myApplicationComponent.getFileDescriptions(rootTagName);
    }

    public Set<DomFileDescription<?>> getAcceptingOtherRootTagNameDescriptions() {
        return this.myApplicationComponent.getAcceptingOtherRootTagNameDescriptions();
    }

    @NotNull
    @NonNls
    public String getComponentName() {
        String string = ((Object)((Object)this)).getClass().getName();
        if (string == null) {
            DomManagerImpl.$$$reportNull$$$0(4);
        }
        return string;
    }

    void runChange(Runnable change) {
        boolean b = this.setChanging(true);
        try {
            change.run();
        }
        finally {
            this.setChanging(b);
        }
    }

    boolean setChanging(boolean changing) {
        boolean oldChanging = this.myChanging;
        if (changing) assert (!oldChanging);
        this.myChanging = changing;
        return oldChanging;
    }

    @Nullable
    public <T extends DomElement> DomFileElementImpl<T> getFileElement(@Nullable XmlFile file2) {
        if (file2 == null || !(file2.getFileType() instanceof DomSupportEnabled)) {
            return null;
        }
        return (DomFileElementImpl)CachedValuesManager.getCachedValue((PsiElement)file2, DomManagerImpl.chooseKey(FILE_ELEMENT_KEY, FILE_ELEMENT_KEY_FOR_INDEX), () -> CachedValueProvider.Result.create(DomCreator.createFileElement(file2), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT, this}));
    }

    private static <T> T chooseKey(T base, T forIndex) {
        return FileBasedIndex.getInstance().getFileBeingCurrentlyIndexed() != null ? forIndex : base;
    }

    @Nullable
    static <T extends DomElement> DomFileElementImpl<T> getCachedFileElement(@NotNull XmlFile file2) {
        if (file2 == null) {
            DomManagerImpl.$$$reportNull$$$0(5);
        }
        return (DomFileElementImpl)SoftReference.dereference((Reference)((Reference)file2.getUserData(CACHED_FILE_ELEMENT)));
    }

    @Nullable
    public <T extends DomElement> DomFileElementImpl<T> getFileElement(XmlFile file2, Class<T> domClass) {
        DomFileDescription description2 = this.getDomFileDescription(file2);
        if (description2 != null && this.myApplicationComponent.assignabilityCache.isAssignable(domClass, description2.getRootElementClass())) {
            return this.getFileElement(file2);
        }
        return null;
    }

    @Nullable
    public DomElement getDomElement(XmlTag element2) {
        if (this.myChanging) {
            return null;
        }
        DomInvocationHandler handler2 = this.getDomHandler((XmlElement)element2);
        return handler2 != null ? handler2.getProxy() : null;
    }

    @Nullable
    public GenericAttributeValue<?> getDomElement(XmlAttribute attribute) {
        if (this.myChanging) {
            return null;
        }
        DomInvocationHandler handler2 = this.getDomHandler((XmlElement)attribute);
        return handler2 == null ? null : (GenericAttributeValue)handler2.getProxy();
    }

    @Nullable
    public DomInvocationHandler getDomHandler(@Nullable XmlElement xml) {
        if (xml instanceof XmlTag) {
            return (DomInvocationHandler)((Object)CachedValuesManager.getCachedValue((PsiElement)xml, DomManagerImpl.chooseKey(HANDLER_KEY, HANDLER_KEY_FOR_INDEX), () -> {
                DomInvocationHandler handler2 = DomCreator.createTagHandler((XmlTag)xml);
                if (handler2 != null && handler2.getXmlTag() != xml) {
                    throw new AssertionError((Object)("Inconsistent dom, stub=" + handler2.getStub()));
                }
                return CachedValueProvider.Result.create((Object)((Object)handler2), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT, this});
            }));
        }
        if (xml instanceof XmlAttribute) {
            return (DomInvocationHandler)((Object)CachedValuesManager.getCachedValue((PsiElement)xml, DomManagerImpl.chooseKey(HANDLER_KEY, HANDLER_KEY_FOR_INDEX), () -> CachedValueProvider.Result.create((Object)((Object)DomCreator.createAttributeHandler((XmlAttribute)xml)), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT, this})));
        }
        return null;
    }

    @Nullable
    public AbstractDomChildrenDescription findChildrenDescription(@NotNull XmlTag tag2, @NotNull DomElement parent) {
        if (tag2 == null) {
            DomManagerImpl.$$$reportNull$$$0(6);
        }
        if (parent == null) {
            DomManagerImpl.$$$reportNull$$$0(7);
        }
        DomInvocationHandler parentHandler = DomManagerImpl.getDomInvocationHandler(parent);
        assert (parentHandler != null);
        return parentHandler.getGenericInfo().findChildrenDescription(parentHandler, tag2);
    }

    public boolean isDomFile(@Nullable PsiFile file2) {
        return file2 instanceof XmlFile && this.getFileElement((XmlFile)file2) != null;
    }

    @Nullable
    public DomFileDescription<?> getDomFileDescription(PsiElement element2) {
        PsiFile psiFile;
        if (element2 instanceof XmlElement && (psiFile = element2.getContainingFile()) instanceof XmlFile) {
            return this.getDomFileDescription((XmlFile)psiFile);
        }
        return null;
    }

    public <T extends DomElement> T createMockElement(Class<T> aClass, Module module, boolean physical) {
        XmlFile file2 = (XmlFile)PsiFileFactory.getInstance((Project)this.myProject).createFileFromText("a.xml", (FileType)XmlFileType.INSTANCE, (CharSequence)"", 0L, physical);
        file2.putUserData(MOCK_ELEMENT_MODULE, (Object)module);
        file2.putUserData(MOCK, new Object());
        return this.getFileElement(file2, (Class)aClass, "I_sincerely_hope_that_nobody_will_have_such_a_root_tag_name").getRootElement();
    }

    public boolean isMockElement(DomElement element2) {
        return DomUtil.getFile((DomElement)element2).getUserData(MOCK) != null;
    }

    public <T extends DomElement> T createStableValue(Factory<? extends T> provider2) {
        return (T)((DomElement)this.createStableValue(provider2, t -> t.isValid()));
    }

    public <T> T createStableValue(Factory<? extends T> provider2, Condition<? super T> validator) {
        Object initial = provider2.create();
        assert (initial != null);
        StableInvocationHandler<? super T> handler2 = new StableInvocationHandler<T>(initial, provider2, validator);
        HashSet<Class<StableElement>> intf = new HashSet<Class<StableElement>>();
        ContainerUtil.addAll(intf, (Object[])initial.getClass().getInterfaces());
        intf.add(StableElement.class);
        return (T)AdvancedProxy.createProxy(initial.getClass().getSuperclass(), intf.toArray(ArrayUtil.EMPTY_CLASS_ARRAY), handler2, new Object[0]);
    }

    @TestOnly
    public <T extends DomElement> void registerFileDescription(DomFileDescription<T> description2, Disposable parentDisposable) {
        this.registerFileDescription(description2);
        Disposer.register((Disposable)parentDisposable, () -> this.myApplicationComponent.removeDescription(description2));
    }

    public void registerFileDescription(DomFileDescription<?> description2) {
        this.clearCache();
        this.myApplicationComponent.registerFileDescription(description2);
    }

    @NotNull
    public DomElement getResolvingScope(GenericDomValue<?> element2) {
        DomFileDescription description2 = DomUtil.getFileElement(element2).getFileDescription();
        DomElement domElement = description2.getResolveScope(element2);
        if (domElement == null) {
            DomManagerImpl.$$$reportNull$$$0(8);
        }
        return domElement;
    }

    @NotNull
    public DomElement getIdentityScope(DomElement element2) {
        DomFileDescription description2 = DomUtil.getFileElement((DomElement)element2).getFileDescription();
        DomElement domElement = description2.getIdentityScope(element2);
        if (domElement == null) {
            DomManagerImpl.$$$reportNull$$$0(9);
        }
        return domElement;
    }

    public TypeChooserManager getTypeChooserManager() {
        return this.myApplicationComponent.getTypeChooserManager();
    }

    void performAtomicChange(@NotNull Runnable change) {
        if (change == null) {
            DomManagerImpl.$$$reportNull$$$0(10);
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        boolean oldValue = this.myBulkChange;
        this.myBulkChange = true;
        try {
            change.run();
        }
        finally {
            this.myBulkChange = oldValue;
            if (!oldValue) {
                this.clearCache();
            }
        }
        if (!this.isInsideAtomicChange()) {
            this.clearCache();
        }
    }

    private void clearCache() {
        this.incModificationCount();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "events";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/xml/impl/DomManagerImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/xml/impl/DomManagerImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotNullHandler";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileElement";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolvingScope";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getIdentityScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "fireEvent";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "fireEvents";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getCachedFileElement";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findChildrenDescription";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "performAtomicChange";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

