/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.utils.impl;

import com.intellij.vcs.log.graph.utils.IntList;
import com.intellij.vcs.log.graph.utils.TimestampGetter;
import com.intellij.vcs.log.graph.utils.impl.FullIntList;
import com.intellij.vcs.log.graph.utils.impl.SmartDeltaCompressor;
import it.unimi.dsi.fastutil.ints.Int2LongMap;
import it.unimi.dsi.fastutil.ints.Int2LongOpenHashMap;
import org.jetbrains.annotations.NotNull;

public final class IntTimestampGetter
implements TimestampGetter {
    private static final int DEFAULT_BLOCK_SIZE = 30;
    private static final long MAX_DELTA = 0x7FFFFFF5L;
    private static final int BROKEN_DELTA = Integer.MAX_VALUE;
    private final IntList myDeltas;
    @NotNull
    private final Int2LongMap myBrokenDeltas;
    private final int myBlockSize;
    private final long[] mySaveTimestamps;

    @NotNull
    public static IntTimestampGetter newInstance(@NotNull TimestampGetter delegateGetter) {
        if (delegateGetter == null) {
            IntTimestampGetter.$$$reportNull$$$0(0);
        }
        return IntTimestampGetter.newInstance(delegateGetter, 30);
    }

    @NotNull
    public static IntTimestampGetter newInstance(@NotNull TimestampGetter delegateGetter, int blockSize) {
        if (delegateGetter == null) {
            IntTimestampGetter.$$$reportNull$$$0(1);
        }
        if (delegateGetter.size() < 0) {
            throw new NegativeArraySizeException("delegateGetter.size() < 0: " + delegateGetter.size());
        }
        if (delegateGetter.size() == 0) {
            throw new IllegalArgumentException("Empty TimestampGetter not supported");
        }
        long[] saveTimestamps = new long[(delegateGetter.size() - 1) / blockSize + 1];
        for (int i2 = 0; i2 < saveTimestamps.length; ++i2) {
            saveTimestamps[i2] = delegateGetter.getTimestamp(blockSize * i2);
        }
        Int2LongOpenHashMap brokenDeltas = new Int2LongOpenHashMap();
        int[] deltas = new int[delegateGetter.size()];
        for (int i3 = 0; i3 < delegateGetter.size(); ++i3) {
            int intDelta;
            int blockIndex = i3 - i3 % blockSize;
            long delta = delegateGetter.getTimestamp(i3) - delegateGetter.getTimestamp(blockIndex);
            deltas[i3] = intDelta = IntTimestampGetter.deltaToInt(delta);
            if (intDelta != Integer.MAX_VALUE) continue;
            brokenDeltas.put(i3, delta);
        }
        brokenDeltas.trim();
        return new IntTimestampGetter(deltas, blockSize, saveTimestamps, (Int2LongMap)brokenDeltas);
    }

    private static int deltaToInt(long delta) {
        if (delta >= 0L && delta <= 0x7FFFFFF5L) {
            return (int)delta;
        }
        if (delta < 0L && -delta <= 0x7FFFFFF5L) {
            return (int)delta;
        }
        return Integer.MAX_VALUE;
    }

    private IntTimestampGetter(int[] deltas, int blockSize, long[] saveTimestamps, @NotNull Int2LongMap brokenDeltas) {
        if (brokenDeltas == null) {
            IntTimestampGetter.$$$reportNull$$$0(2);
        }
        this.myDeltas = SmartDeltaCompressor.newInstance(new FullIntList(deltas));
        this.myBlockSize = blockSize;
        this.mySaveTimestamps = saveTimestamps;
        this.myBrokenDeltas = brokenDeltas;
    }

    @Override
    public int size() {
        return this.myDeltas.size();
    }

    @Override
    public long getTimestamp(int index2) {
        this.checkRange(index2);
        int relativeSaveIndex = index2 / this.myBlockSize;
        long timestamp = this.mySaveTimestamps[relativeSaveIndex];
        return timestamp + this.getDelta(index2);
    }

    private long getDelta(int index2) {
        int delta = this.myDeltas.get(index2);
        if (delta != Integer.MAX_VALUE) {
            return delta;
        }
        return this.myBrokenDeltas.get(index2);
    }

    private void checkRange(int index2) {
        if (index2 < 0) {
            throw new IndexOutOfBoundsException("index < 0:" + index2);
        }
        if (index2 >= this.size()) {
            throw new IndexOutOfBoundsException("index: " + index2 + " >= size: " + this.size());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegateGetter";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "brokenDeltas";
                break;
            }
        }
        objectArray2[1] = "com/intellij/vcs/log/graph/utils/impl/IntTimestampGetter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "newInstance";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

