/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.utils.impl;

import com.intellij.util.BooleanFunction;
import com.intellij.vcs.log.graph.utils.UpdatableIntToIntMap;
import com.intellij.vcs.log.graph.utils.impl.AbstractIntToIntMap;
import com.intellij.vcs.log.graph.utils.impl.IDIntToIntMap;
import org.jetbrains.annotations.NotNull;

public final class TreeIntToIntMap
extends AbstractIntToIntMap
implements UpdatableIntToIntMap {
    @NotNull
    private final BooleanFunction<? super Integer> myThisIsVisible;
    private final int myLongSize;
    private final int myCountLevels;
    private final int[] myTree;

    public static UpdatableIntToIntMap newInstance(@NotNull BooleanFunction<? super Integer> thisIsVisible, int longSize) {
        if (thisIsVisible == null) {
            TreeIntToIntMap.$$$reportNull$$$0(0);
        }
        if (longSize < 0) {
            throw new NegativeArraySizeException("size < 0: " + longSize);
        }
        if (longSize == 0) {
            return IDIntToIntMap.EMPTY;
        }
        int countLevels = longSize == 1 ? 2 : TreeIntToIntMap.countDigits(longSize - 1) + 1;
        int[] emptyTree = new int[1 << countLevels - 1];
        TreeIntToIntMap intToIntMap = new TreeIntToIntMap(thisIsVisible, longSize, countLevels, emptyTree);
        intToIntMap.update(0, longSize - 1);
        return intToIntMap;
    }

    private static int countDigits(int longSize) {
        int count = 0;
        while (longSize != 0) {
            ++count;
            longSize >>= 1;
        }
        return count;
    }

    private TreeIntToIntMap(@NotNull BooleanFunction<? super Integer> thisIsVisible, int longSize, int countLevels, int[] tree) {
        if (thisIsVisible == null) {
            TreeIntToIntMap.$$$reportNull$$$0(1);
        }
        this.myThisIsVisible = thisIsVisible;
        this.myLongSize = longSize;
        this.myCountLevels = countLevels;
        this.myTree = tree;
    }

    @Override
    public int shortSize() {
        return this.myTree[1];
    }

    @Override
    public int longSize() {
        return this.myLongSize;
    }

    @Override
    public int getLongIndex(int shortIndex) {
        this.checkShortIndex(shortIndex);
        int node2 = 1;
        for (int level = 0; level < this.myCountLevels - 1; ++level) {
            int child2 = node2 << 1;
            int countInChildNode = this.getCountInNode(child2);
            if (countInChildNode > shortIndex) {
                node2 = child2;
                continue;
            }
            node2 = child2 + 1;
            shortIndex -= countInChildNode;
        }
        return node2 - this.myTree.length;
    }

    @Override
    public void update(int startLongIndex, int endLongIndex) {
        this.checkUpdateParameters(startLongIndex, endLongIndex);
        int startNode = startLongIndex + this.myTree.length;
        int endNode = endLongIndex + this.myTree.length;
        int commonNode = startNode >> TreeIntToIntMap.countDigits(startNode ^ endNode);
        this.updateNodeCount(commonNode);
        for (int parent = commonNode >> 1; parent != 0; parent >>= 1) {
            this.myTree[parent] = this.getCountInNode(parent << 1) + this.getCountInNode((parent << 1) + 1);
        }
    }

    private boolean isLastLevel(int node2) {
        return node2 >= this.myTree.length;
    }

    private int updateNodeCount(int node2) {
        if (this.isLastLevel(node2)) {
            return this.getCountInLastLevel(node2);
        }
        int child2 = node2 << 1;
        this.myTree[node2] = this.updateNodeCount(child2) + this.updateNodeCount(child2 + 1);
        return this.myTree[node2];
    }

    private int getCountInLastLevel(int node2) {
        if ((node2 -= this.myTree.length) < this.myLongSize && this.myThisIsVisible.fun((Object)node2)) {
            return 1;
        }
        return 0;
    }

    private int getCountInNode(int node2) {
        if (this.isLastLevel(node2)) {
            return this.getCountInLastLevel(node2);
        }
        return this.myTree[node2];
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "thisIsVisible";
        objectArray2[1] = "com/intellij/vcs/log/graph/utils/impl/TreeIntToIntMap";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "newInstance";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

