/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.util.ValueKey;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.graph.PermanentGraph;
import com.intellij.vcs.log.impl.CommonUiProperties;
import com.intellij.vcs.log.impl.MainVcsLogUiProperties;
import com.intellij.vcs.log.impl.VcsLogApplicationSettings;
import com.intellij.vcs.log.impl.VcsLogUiProperties;
import com.intellij.vcs.log.ui.table.column.TableColumnWidthProperty;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class VcsLogUiPropertiesImpl<S extends State>
implements PersistentStateComponent<S>,
MainVcsLogUiProperties {
    private static final Set<VcsLogUiProperties.VcsLogUiProperty> SUPPORTED_PROPERTIES = ContainerUtil.newHashSet((Object[])new VcsLogUiProperties.VcsLogUiProperty[]{CommonUiProperties.SHOW_DETAILS, MainVcsLogUiProperties.SHOW_LONG_EDGES, MainVcsLogUiProperties.BEK_SORT_TYPE, CommonUiProperties.SHOW_ROOT_NAMES, MainVcsLogUiProperties.SHOW_ONLY_AFFECTED_CHANGES, MainVcsLogUiProperties.TEXT_FILTER_MATCH_CASE, MainVcsLogUiProperties.TEXT_FILTER_REGEX});
    @NotNull
    private final EventDispatcher<VcsLogUiProperties.PropertiesChangeListener> myEventDispatcher;
    @NotNull
    private final VcsLogApplicationSettings myAppSettings;

    public VcsLogUiPropertiesImpl(@NotNull VcsLogApplicationSettings appSettings) {
        if (appSettings == null) {
            VcsLogUiPropertiesImpl.$$$reportNull$$$0(0);
        }
        this.myEventDispatcher = EventDispatcher.create(VcsLogUiProperties.PropertiesChangeListener.class);
        this.myAppSettings = appSettings;
    }

    @NotNull
    public abstract S getState();

    @Override
    @NotNull
    public <T> T get(@NotNull VcsLogUiProperties.VcsLogUiProperty<T> property2) {
        if (property2 == null) {
            VcsLogUiPropertiesImpl.$$$reportNull$$$0(1);
        }
        if (this.myAppSettings.exists(property2)) {
            T t = this.myAppSettings.get(property2);
            if (t == null) {
                VcsLogUiPropertiesImpl.$$$reportNull$$$0(2);
            }
            return t;
        }
        Object state = this.getState();
        if (property2 instanceof MainVcsLogUiProperties.VcsLogHighlighterProperty) {
            Boolean result2 = ((State)state).HIGHLIGHTERS.get(((MainVcsLogUiProperties.VcsLogHighlighterProperty)property2).getId());
            if (result2 == null) {
                Boolean bl = Boolean.TRUE;
                if (bl == null) {
                    VcsLogUiPropertiesImpl.$$$reportNull$$$0(3);
                }
                return (T)bl;
            }
            Boolean bl = result2;
            if (bl == null) {
                VcsLogUiPropertiesImpl.$$$reportNull$$$0(4);
            }
            return (T)bl;
        }
        if (property2 instanceof TableColumnWidthProperty) {
            Integer savedWidth;
            TableColumnWidthProperty tableColumnWidthProperty = (TableColumnWidthProperty)property2;
            if (!((State)state).COLUMN_WIDTH.isEmpty()) {
                tableColumnWidthProperty.moveOldSettings(((State)state).COLUMN_WIDTH, ((State)state).COLUMN_ID_WIDTH);
                ((State)state).COLUMN_WIDTH = new HashMap<Integer, Integer>();
            }
            if ((savedWidth = ((State)state).COLUMN_ID_WIDTH.get(property2.getName())) == null) {
                Integer n = -1;
                if (n == null) {
                    VcsLogUiPropertiesImpl.$$$reportNull$$$0(5);
                }
                return (T)n;
            }
            Integer n = savedWidth;
            if (n == null) {
                VcsLogUiPropertiesImpl.$$$reportNull$$$0(6);
            }
            return (T)n;
        }
        TextFilterSettings filterSettings = this.getTextFilterSettings();
        Object object = property2.match().ifEq(CommonUiProperties.SHOW_DETAILS).then((Object)((State)state).SHOW_DETAILS_IN_CHANGES).ifEq((ValueKey)SHOW_LONG_EDGES).then((Object)((State)state).LONG_EDGES_VISIBLE).ifEq(CommonUiProperties.SHOW_ROOT_NAMES).then((Object)((State)state).SHOW_ROOT_NAMES).ifEq((ValueKey)SHOW_ONLY_AFFECTED_CHANGES).then((Object)((State)state).SHOW_ONLY_AFFECTED_CHANGES).ifEq((ValueKey)BEK_SORT_TYPE).thenGet(() -> VcsLogUiPropertiesImpl.lambda$get$0((State)state)).ifEq((ValueKey)TEXT_FILTER_MATCH_CASE).then((Object)filterSettings.MATCH_CASE).ifEq((ValueKey)TEXT_FILTER_REGEX).then((Object)filterSettings.REGEX).get();
        if (object == null) {
            VcsLogUiPropertiesImpl.$$$reportNull$$$0(7);
        }
        return (T)object;
    }

    @Override
    public <T> void set(@NotNull VcsLogUiProperties.VcsLogUiProperty<T> property2, @NotNull T value2) {
        if (property2 == null) {
            VcsLogUiPropertiesImpl.$$$reportNull$$$0(8);
        }
        if (value2 == null) {
            VcsLogUiPropertiesImpl.$$$reportNull$$$0(9);
        }
        if (this.myAppSettings.exists(property2)) {
            this.myAppSettings.set(property2, value2);
            return;
        }
        if (CommonUiProperties.SHOW_DETAILS.equals(property2)) {
            ((State)this.getState()).SHOW_DETAILS_IN_CHANGES = (Boolean)value2;
        } else if (SHOW_LONG_EDGES.equals(property2)) {
            ((State)this.getState()).LONG_EDGES_VISIBLE = (Boolean)value2;
        } else if (CommonUiProperties.SHOW_ROOT_NAMES.equals(property2)) {
            ((State)this.getState()).SHOW_ROOT_NAMES = (Boolean)value2;
        } else if (SHOW_ONLY_AFFECTED_CHANGES.equals(property2)) {
            ((State)this.getState()).SHOW_ONLY_AFFECTED_CHANGES = (Boolean)value2;
        } else if (BEK_SORT_TYPE.equals(property2)) {
            ((State)this.getState()).BEK_SORT_TYPE = ((PermanentGraph.SortType)value2).ordinal();
        } else if (TEXT_FILTER_REGEX.equals(property2)) {
            this.getTextFilterSettings().REGEX = (Boolean)value2;
        } else if (TEXT_FILTER_MATCH_CASE.equals(property2)) {
            this.getTextFilterSettings().MATCH_CASE = (Boolean)value2;
        } else if (property2 instanceof MainVcsLogUiProperties.VcsLogHighlighterProperty) {
            ((State)this.getState()).HIGHLIGHTERS.put(((MainVcsLogUiProperties.VcsLogHighlighterProperty)property2).getId(), (Boolean)value2);
        } else if (property2 instanceof TableColumnWidthProperty) {
            ((State)this.getState()).COLUMN_ID_WIDTH.put(property2.getName(), (Integer)value2);
        } else {
            throw new UnsupportedOperationException("Property " + property2 + " does not exist");
        }
        this.onPropertyChanged(property2);
    }

    protected <T> void onPropertyChanged(@NotNull VcsLogUiProperties.VcsLogUiProperty<T> property2) {
        if (property2 == null) {
            VcsLogUiPropertiesImpl.$$$reportNull$$$0(10);
        }
        ((VcsLogUiProperties.PropertiesChangeListener)this.myEventDispatcher.getMulticaster()).onPropertyChanged(property2);
    }

    @Override
    public <T> boolean exists(@NotNull VcsLogUiProperties.VcsLogUiProperty<T> property2) {
        if (property2 == null) {
            VcsLogUiPropertiesImpl.$$$reportNull$$$0(11);
        }
        return this.myAppSettings.exists(property2) || SUPPORTED_PROPERTIES.contains(property2) || property2 instanceof MainVcsLogUiProperties.VcsLogHighlighterProperty || property2 instanceof TableColumnWidthProperty;
    }

    @NotNull
    private TextFilterSettings getTextFilterSettings() {
        TextFilterSettings settings2 = ((State)this.getState()).TEXT_FILTER_SETTINGS;
        if (settings2 == null) {
            ((State)this.getState()).TEXT_FILTER_SETTINGS = settings2 = new TextFilterSettings();
        }
        TextFilterSettings textFilterSettings = settings2;
        if (textFilterSettings == null) {
            VcsLogUiPropertiesImpl.$$$reportNull$$$0(12);
        }
        return textFilterSettings;
    }

    @Override
    public void saveFilterValues(@NotNull String filterName, @Nullable List<String> values2) {
        if (filterName == null) {
            VcsLogUiPropertiesImpl.$$$reportNull$$$0(13);
        }
        if (values2 != null) {
            ((State)this.getState()).FILTERS.put(filterName, values2);
        } else {
            ((State)this.getState()).FILTERS.remove(filterName);
        }
    }

    @Override
    @Nullable
    public List<String> getFilterValues(@NotNull String filterName) {
        if (filterName == null) {
            VcsLogUiPropertiesImpl.$$$reportNull$$$0(14);
        }
        return ((State)this.getState()).FILTERS.get(filterName);
    }

    @Override
    public void addChangeListener(@NotNull VcsLogUiProperties.PropertiesChangeListener listener2) {
        if (listener2 == null) {
            VcsLogUiPropertiesImpl.$$$reportNull$$$0(15);
        }
        this.myEventDispatcher.addListener((EventListener)listener2);
        this.myAppSettings.addChangeListener(listener2);
    }

    @Override
    public void removeChangeListener(@NotNull VcsLogUiProperties.PropertiesChangeListener listener2) {
        if (listener2 == null) {
            VcsLogUiPropertiesImpl.$$$reportNull$$$0(16);
        }
        this.myEventDispatcher.removeListener((EventListener)listener2);
        this.myAppSettings.removeChangeListener(listener2);
    }

    private static /* synthetic */ PermanentGraph.SortType lambda$get$0(State state) {
        return PermanentGraph.SortType.values()[state.BEK_SORT_TYPE];
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appSettings";
                break;
            }
            case 1: 
            case 8: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/impl/VcsLogUiPropertiesImpl";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filterName";
                break;
            }
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/impl/VcsLogUiPropertiesImpl";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextFilterSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 12: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "set";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "onPropertyChanged";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "exists";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "saveFilterValues";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getFilterValues";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addChangeListener";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "removeChangeListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class TextFilterSettings {
        public boolean REGEX = false;
        public boolean MATCH_CASE = false;
    }

    public static class State {
        public boolean SHOW_DETAILS_IN_CHANGES = true;
        public boolean LONG_EDGES_VISIBLE = false;
        public int BEK_SORT_TYPE = 0;
        public boolean SHOW_ROOT_NAMES = false;
        public boolean SHOW_ONLY_AFFECTED_CHANGES = false;
        public Map<String, Boolean> HIGHLIGHTERS = new TreeMap<String, Boolean>();
        public Map<String, List<String>> FILTERS = new TreeMap<String, List<String>>();
        public TextFilterSettings TEXT_FILTER_SETTINGS = new TextFilterSettings();
        @Deprecated
        @ApiStatus.ScheduledForRemoval(inVersion="2022.1")
        public Map<Integer, Integer> COLUMN_WIDTH = new HashMap<Integer, Integer>();
        public Map<String, Integer> COLUMN_ID_WIDTH = new HashMap<String, Integer>();
    }
}

