/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.breakpoints;

import com.intellij.icons.AllIcons;
import com.intellij.ide.favoritesTreeView.AbstractFavoritesListProvider;
import com.intellij.ide.favoritesTreeView.FavoritesManager;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.extensions.ExtensionNotApplicableException;
import com.intellij.openapi.project.Project;
import com.intellij.pom.Navigatable;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.CommonActionsPanel;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.util.PlatformUtils;
import com.intellij.util.SingleAlarm;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointGroup;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointGroupingRule;
import com.intellij.xdebugger.impl.DebuggerSupport;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointManagerImpl;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointUtil;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointsDialogState;
import com.intellij.xdebugger.impl.breakpoints.ui.BreakpointItem;
import com.intellij.xdebugger.impl.breakpoints.ui.BreakpointPanelProvider;
import com.intellij.xdebugger.impl.breakpoints.ui.tree.BreakpointItemsTreeController;
import com.intellij.xdebugger.impl.breakpoints.ui.tree.BreakpointsSimpleTree;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BreakpointsFavoriteListProvider
extends AbstractFavoritesListProvider<Object>
implements BreakpointPanelProvider.BreakpointsListener {
    private final List<BreakpointPanelProvider> myBreakpointPanelProviders;
    private final BreakpointItemsTreeController myTreeController;
    private final List<XBreakpointGroupingRule> myRulesAvailable;
    private final Set<XBreakpointGroupingRule> myRulesEnabled;
    private final SingleAlarm myRebuildAlarm;

    public BreakpointsFavoriteListProvider(@NotNull Project project) {
        if (project == null) {
            BreakpointsFavoriteListProvider.$$$reportNull$$$0(0);
        }
        super(project, "Breakpoints");
        this.myRulesAvailable = new ArrayList<XBreakpointGroupingRule>();
        this.myRulesEnabled = new TreeSet<XBreakpointGroupingRule>(XBreakpointGroupingRule.PRIORITY_COMPARATOR);
        this.myRebuildAlarm = new SingleAlarm(this::updateChildren, 100);
        if (PlatformUtils.isDataGrip()) {
            throw ExtensionNotApplicableException.INSTANCE;
        }
        this.myBreakpointPanelProviders = XBreakpointUtil.collectPanelProviders();
        this.myTreeController = new BreakpointItemsTreeController(this.myRulesAvailable);
        this.myTreeController.setTreeView((JTree)((Object)new BreakpointsSimpleTree(this.myProject, this.myTreeController)));
        for (BreakpointPanelProvider provider2 : this.myBreakpointPanelProviders) {
            provider2.addListener(this, this.myProject, (Disposable)this.myProject);
            provider2.createBreakpointsGroupingRules(this.myRulesAvailable);
        }
        this.updateChildren();
    }

    @Override
    public void breakpointsChanged() {
        this.myRebuildAlarm.cancelAndRequest();
    }

    private void getEnabledGroupingRules(Collection<? super XBreakpointGroupingRule> rules) {
        rules.clear();
        XBreakpointsDialogState settings2 = ((XBreakpointManagerImpl)XDebuggerManager.getInstance((Project)this.myProject).getBreakpointManager()).getBreakpointsDialogSettings();
        for (XBreakpointGroupingRule rule : this.myRulesAvailable) {
            if (!rule.isAlwaysEnabled() && (settings2 == null || !settings2.getSelectedGroupingRules().contains(rule.getId()))) continue;
            rules.add((XBreakpointGroupingRule)rule);
        }
    }

    private void updateChildren() {
        if (this.myProject.isDisposed()) {
            return;
        }
        this.myChildren.clear();
        ArrayList<BreakpointItem> items = new ArrayList<BreakpointItem>();
        for (BreakpointPanelProvider provider2 : this.myBreakpointPanelProviders) {
            provider2.provideBreakpointItems(this.myProject, items);
        }
        this.getEnabledGroupingRules(this.myRulesEnabled);
        this.myTreeController.setGroupingRules(this.myRulesEnabled);
        this.myTreeController.rebuildTree(items);
        CheckedTreeNode root = this.myTreeController.getRoot();
        for (int i2 = 0; i2 < root.getChildCount(); ++i2) {
            TreeNode child2 = root.getChildAt(i2);
            if (!(child2 instanceof DefaultMutableTreeNode)) continue;
            this.replicate((DefaultMutableTreeNode)child2, this.myNode, this.myChildren);
        }
        FavoritesManager.getInstance(this.myProject).fireListeners(this.getListName(this.myProject));
    }

    private void replicate(DefaultMutableTreeNode source, AbstractTreeNode<?> destination, List<? super AbstractTreeNode<Object>> destinationChildren) {
        final ArrayList copyChildren = new ArrayList();
        AbstractTreeNode<Object> copy2 = new AbstractTreeNode<Object>(this.myProject, source.getUserObject()){

            @NotNull
            public Collection<? extends AbstractTreeNode<?>> getChildren() {
                List list2 = copyChildren;
                if (list2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return list2;
            }

            protected void update(@NotNull PresentationData presentation2) {
                if (presentation2 == null) {
                    1.$$$reportNull$$$0(1);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/xdebugger/impl/breakpoints/BreakpointsFavoriteListProvider$1";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "presentation";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getChildren";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/xdebugger/impl/breakpoints/BreakpointsFavoriteListProvider$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "update";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        for (int i2 = 0; i2 < source.getChildCount(); ++i2) {
            TreeNode treeNode = source.getChildAt(i2);
            if (!(treeNode instanceof DefaultMutableTreeNode)) continue;
            DefaultMutableTreeNode sourceChild = (DefaultMutableTreeNode)treeNode;
            this.replicate(sourceChild, copy2, copyChildren);
        }
        if (BreakpointsFavoriteListProvider.checkNavigatable(copy2)) {
            destinationChildren.add((AbstractTreeNode<Object>)copy2);
            copy2.setParent(destination);
        }
    }

    private static boolean checkNavigatable(AbstractTreeNode<?> node2) {
        if (node2.getValue() instanceof Navigatable && ((Navigatable)node2.getValue()).canNavigate()) {
            return true;
        }
        return node2.getChildren().stream().anyMatch(BreakpointsFavoriteListProvider::checkNavigatable);
    }

    @Override
    @Nullable
    public String getCustomName(@NotNull CommonActionsPanel.Buttons type) {
        if (type == null) {
            BreakpointsFavoriteListProvider.$$$reportNull$$$0(1);
        }
        switch (type) {
            case EDIT: {
                return ActionsBundle.actionText((String)"EditBreakpoint");
            }
            case REMOVE: {
                return XDebuggerBundle.message((String)"xdebugger.remove.line.breakpoint.action.text", (Object[])new Object[0]);
            }
        }
        return null;
    }

    @Override
    public boolean willHandle(@NotNull CommonActionsPanel.Buttons type, Project project, @NotNull Set<Object> selectedObjects) {
        if (type == null) {
            BreakpointsFavoriteListProvider.$$$reportNull$$$0(2);
        }
        if (selectedObjects == null) {
            BreakpointsFavoriteListProvider.$$$reportNull$$$0(3);
        }
        if (selectedObjects.size() >= 1 && type == CommonActionsPanel.Buttons.REMOVE) {
            for (Object selectedObject : selectedObjects) {
                if (((AbstractTreeNode)selectedObject).getValue() instanceof BreakpointItem) continue;
                return false;
            }
            return true;
        }
        return selectedObjects.size() == 1 && type == CommonActionsPanel.Buttons.EDIT && ((AbstractTreeNode)selectedObjects.iterator().next()).getValue() instanceof BreakpointItem;
    }

    @Override
    public void handle(@NotNull CommonActionsPanel.Buttons type, Project project, @NotNull Set<Object> selectedObjects, JComponent component2) {
        if (type == null) {
            BreakpointsFavoriteListProvider.$$$reportNull$$$0(4);
        }
        if (selectedObjects == null) {
            BreakpointsFavoriteListProvider.$$$reportNull$$$0(5);
        }
        Rectangle bounds2 = component2.getBounds();
        if (component2 instanceof JTree) {
            JTree tree = (JTree)component2;
            bounds2 = tree.getRowBounds(tree.getLeadSelectionRow());
            bounds2.y += bounds2.height / 2;
            bounds2 = tree.getVisibleRect().intersection(bounds2);
        }
        Point whereToShow = new Point((int)bounds2.getCenterX(), (int)bounds2.getCenterY());
        switch (type) {
            case EDIT: {
                BreakpointItem breakpointItem = (BreakpointItem)((AbstractTreeNode)selectedObjects.iterator().next()).getValue();
                DebuggerSupport debuggerSupport = XBreakpointUtil.getDebuggerSupport(this.myProject, breakpointItem);
                if (debuggerSupport == null || breakpointItem == null) {
                    return;
                }
                debuggerSupport.getEditBreakpointAction().editBreakpoint(this.myProject, component2, whereToShow, breakpointItem);
                break;
            }
            case REMOVE: {
                for (Object selectedObject : selectedObjects) {
                    BreakpointItem removeBreakpointItem = (BreakpointItem)((AbstractTreeNode)selectedObject).getValue();
                    removeBreakpointItem.removed(this.myProject);
                }
                break;
            }
        }
    }

    @Override
    public int getWeight() {
        return 200;
    }

    @Override
    public void customizeRenderer(ColoredTreeCellRenderer renderer2, JTree tree, @NotNull Object value2, boolean selected2, boolean expanded, boolean leaf, int row2, boolean hasFocus) {
        if (value2 == null) {
            BreakpointsFavoriteListProvider.$$$reportNull$$$0(6);
        }
        renderer2.clear();
        renderer2.setIcon(AllIcons.Debugger.Db_set_breakpoint);
        if (value2 instanceof BreakpointItem) {
            BreakpointItem breakpointItem = (BreakpointItem)value2;
            breakpointItem.setupGenericRenderer((SimpleColoredComponent)renderer2, true);
        } else if (value2 instanceof XBreakpointGroup) {
            renderer2.append(((XBreakpointGroup)value2).getName());
            renderer2.setIcon(((XBreakpointGroup)value2).getIcon(expanded));
        } else if (value2 instanceof XBreakpointGroupingRule) {
            renderer2.append(((XBreakpointGroupingRule)value2).getPresentableName());
        } else {
            renderer2.append(String.valueOf(value2));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedObjects";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        objectArray2[1] = "com/intellij/xdebugger/impl/breakpoints/BreakpointsFavoriteListProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getCustomName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "willHandle";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "handle";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "customizeRenderer";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

