/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.frame;

import com.intellij.openapi.project.Project;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XSuspendContext;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueContainer;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.XValuePlace;
import com.intellij.xdebugger.frame.presentation.XRegularValuePresentation;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.frame.XDebugView;
import com.intellij.xdebugger.impl.frame.XThreadsView;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTreePanel;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueContainerNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0004\u0018\u0019\u001a\u001bB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000b\u001a\u00020\fH\u0014J\b\u0010\r\u001a\u00020\fH\u0016J\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u0010\u001a\u00020\u0011J\r\u0010\u0012\u001a\u00070\u000f\u00a2\u0006\u0002\b\u0013H\u0002J\u0018\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0004\u001a\u00020\u0017H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/xdebugger/impl/frame/XThreadsView;", "Lcom/intellij/xdebugger/impl/frame/XDebugView;", "project", "Lcom/intellij/openapi/project/Project;", "session", "Lcom/intellij/xdebugger/impl/XDebugSessionImpl;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/xdebugger/impl/XDebugSessionImpl;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "treePanel", "Lcom/intellij/xdebugger/impl/ui/tree/XDebuggerTreePanel;", "clear", "", "dispose", "getDefaultFocusedComponent", "Lcom/intellij/xdebugger/impl/ui/tree/XDebuggerTree;", "getPanel", "Ljavax/swing/JPanel;", "getTree", "Lorg/jetbrains/annotations/NotNull;", "processSessionEvent", "event", "Lcom/intellij/xdebugger/impl/frame/XDebugView$SessionEvent;", "Lcom/intellij/xdebugger/XDebugSession;", "FrameValue", "FramesContainer", "ThreadsContainer", "XThreadsRootNode", "intellij.platform.debugger.impl"})
public final class XThreadsView
extends XDebugView {
    private final XDebuggerTreePanel treePanel;
    @NotNull
    private final Project project;

    private final XDebuggerTree getTree() {
        XDebuggerTree xDebuggerTree = this.treePanel.getTree();
        Intrinsics.checkNotNullExpressionValue((Object)xDebuggerTree, (String)"treePanel.tree");
        return xDebuggerTree;
    }

    @NotNull
    public final JPanel getPanel() {
        JPanel jPanel2 = this.treePanel.getMainPanel();
        Intrinsics.checkNotNullExpressionValue((Object)jPanel2, (String)"treePanel.mainPanel");
        return jPanel2;
    }

    @NotNull
    public final XDebuggerTree getDefaultFocusedComponent() {
        XDebuggerTree xDebuggerTree = this.treePanel.getTree();
        Intrinsics.checkNotNullExpressionValue((Object)xDebuggerTree, (String)"treePanel.tree");
        return xDebuggerTree;
    }

    @Override
    protected void clear() {
        DebuggerUIUtil.invokeLater(new Runnable(this){
            final /* synthetic */ XThreadsView this$0;

            public final void run() {
                XThreadsView.access$getTree(this.this$0).setRoot(new XValueContainerNode<XValueContainer>(this, XThreadsView.access$getTree(this.this$0), null, true, new XValueContainer(){}){
                    final /* synthetic */ clear.1 this$0;
                    {
                        this.this$0 = this$0;
                        super($super_call_param$1, $super_call_param$2, $super_call_param$3, $super_call_param$4);
                    }
                }, false);
            }
            {
                this.this$0 = xThreadsView;
            }
        });
    }

    @Override
    public void processSessionEvent(@NotNull XDebugView.SessionEvent event, @NotNull XDebugSession session2) {
        Intrinsics.checkNotNullParameter((Object)((Object)event), (String)"event");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        if (event == XDebugView.SessionEvent.BEFORE_RESUME) {
            return;
        }
        XSuspendContext suspendContext = session2.getSuspendContext();
        if (suspendContext == null) {
            this.requestClear();
            return;
        }
        if (event == XDebugView.SessionEvent.PAUSED) {
            this.cancelClear();
            this.clear();
        }
        DebuggerUIUtil.invokeLater(new Runnable(this, suspendContext){
            final /* synthetic */ XThreadsView this$0;
            final /* synthetic */ XSuspendContext $suspendContext;

            public final void run() {
                XThreadsView.access$getTree(this.this$0).setRoot(new XThreadsRootNode(XThreadsView.access$getTree(this.this$0), this.$suspendContext), false);
            }
            {
                this.this$0 = xThreadsView;
                this.$suspendContext = xSuspendContext;
            }
        });
    }

    public void dispose() {
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public XThreadsView(@NotNull Project project, @NotNull XDebugSessionImpl session2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        this.project = project;
        XDebugProcess xDebugProcess = session2.getDebugProcess();
        Intrinsics.checkNotNullExpressionValue((Object)xDebugProcess, (String)"session.debugProcess");
        this.treePanel = new XDebuggerTreePanel(this.project, xDebugProcess.getEditorsProvider(), this, null, "", null);
    }

    public static final /* synthetic */ XDebuggerTree access$getTree(XThreadsView $this) {
        return $this.getTree();
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lcom/intellij/xdebugger/impl/frame/XThreadsView$ThreadsContainer;", "Lcom/intellij/xdebugger/frame/XValueContainer;", "suspendContext", "Lcom/intellij/xdebugger/frame/XSuspendContext;", "(Lcom/intellij/xdebugger/frame/XSuspendContext;)V", "getSuspendContext", "()Lcom/intellij/xdebugger/frame/XSuspendContext;", "computeChildren", "", "node", "Lcom/intellij/xdebugger/frame/XCompositeNode;", "intellij.platform.debugger.impl"})
    public static final class ThreadsContainer
    extends XValueContainer {
        @NotNull
        private final XSuspendContext suspendContext;

        public void computeChildren(@NotNull XCompositeNode node2) {
            Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
            this.suspendContext.computeExecutionStacks(new XSuspendContext.XExecutionStackContainer(node2){
                final /* synthetic */ XCompositeNode $node;

                public void errorOccurred(@NotNull String errorMessage) {
                    Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
                }

                /*
                 * WARNING - void declaration
                 */
                public void addExecutionStack(@NotNull List<? extends XExecutionStack> executionStacks, boolean last) {
                    void $this$forEach$iv;
                    void $this$mapTo$iv$iv;
                    Intrinsics.checkNotNullParameter(executionStacks, (String)"executionStacks");
                    XValueChildrenList children2 = new XValueChildrenList();
                    Iterable $this$map$iv = executionStacks;
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        XExecutionStack xExecutionStack = (XExecutionStack)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        FramesContainer framesContainer = new FramesContainer((XExecutionStack)it);
                        collection.add(framesContainer);
                    }
                    $this$map$iv = (List)destination$iv$iv;
                    boolean $i$f$forEach = false;
                    for (E element$iv : $this$forEach$iv) {
                        FramesContainer it = (FramesContainer)((Object)element$iv);
                        boolean bl = false;
                        children2.add("", (XValue)it);
                    }
                    this.$node.addChildren(children2, last);
                }
                {
                    this.$node = $captured_local_variable$0;
                }
            });
        }

        @NotNull
        public final XSuspendContext getSuspendContext() {
            return this.suspendContext;
        }

        public ThreadsContainer(@NotNull XSuspendContext suspendContext) {
            Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
            this.suspendContext = suspendContext;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/xdebugger/impl/frame/XThreadsView$FramesContainer;", "Lcom/intellij/xdebugger/frame/XValue;", "executionStack", "Lcom/intellij/xdebugger/frame/XExecutionStack;", "(Lcom/intellij/xdebugger/frame/XExecutionStack;)V", "computeChildren", "", "node", "Lcom/intellij/xdebugger/frame/XCompositeNode;", "computePresentation", "Lcom/intellij/xdebugger/frame/XValueNode;", "place", "Lcom/intellij/xdebugger/frame/XValuePlace;", "intellij.platform.debugger.impl"})
    public static final class FramesContainer
    extends XValue {
        private final XExecutionStack executionStack;

        public void computeChildren(@NotNull XCompositeNode node2) {
            Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
            this.executionStack.computeStackFrames(0, new XExecutionStack.XStackFrameContainer(node2){
                final /* synthetic */ XCompositeNode $node;

                public void errorOccurred(@NotNull String errorMessage) {
                    Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
                }

                public void addStackFrames(@NotNull List<? extends XStackFrame> stackFrames, boolean last) {
                    Intrinsics.checkNotNullParameter(stackFrames, (String)"stackFrames");
                    XValueChildrenList children2 = new XValueChildrenList();
                    Iterable $this$forEach$iv = stackFrames;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        XStackFrame it = (XStackFrame)element$iv;
                        boolean bl = false;
                        children2.add("", (XValue)new FrameValue(it));
                    }
                    this.$node.addChildren(children2, last);
                }
                {
                    this.$node = $captured_local_variable$0;
                }
            });
        }

        public void computePresentation(@NotNull XValueNode node2, @NotNull XValuePlace place) {
            Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
            Intrinsics.checkNotNullParameter((Object)place, (String)"place");
            node2.setPresentation(this.executionStack.getIcon(), (XValuePresentation)new XRegularValuePresentation(this.executionStack.getDisplayName(), null, ""), true);
        }

        public FramesContainer(@NotNull XExecutionStack executionStack) {
            Intrinsics.checkNotNullParameter((Object)executionStack, (String)"executionStack");
            this.executionStack = executionStack;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lcom/intellij/xdebugger/impl/frame/XThreadsView$FrameValue;", "Lcom/intellij/xdebugger/frame/XValue;", "frame", "Lcom/intellij/xdebugger/frame/XStackFrame;", "(Lcom/intellij/xdebugger/frame/XStackFrame;)V", "getFrame", "()Lcom/intellij/xdebugger/frame/XStackFrame;", "computePresentation", "", "node", "Lcom/intellij/xdebugger/frame/XValueNode;", "place", "Lcom/intellij/xdebugger/frame/XValuePlace;", "intellij.platform.debugger.impl"})
    public static final class FrameValue
    extends XValue {
        @NotNull
        private final XStackFrame frame;

        public void computePresentation(@NotNull XValueNode node2, @NotNull XValuePlace place) {
            Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
            Intrinsics.checkNotNullParameter((Object)place, (String)"place");
            SimpleColoredComponent component2 = new SimpleColoredComponent();
            this.frame.customizePresentation((ColoredTextContainer)component2);
            node2.setPresentation(component2.getIcon(), (XValuePresentation)new XRegularValuePresentation(((Object)component2.getCharSequence(false)).toString(), null, ""), false);
        }

        @NotNull
        public final XStackFrame getFrame() {
            return this.frame;
        }

        public FrameValue(@NotNull XStackFrame frame) {
            Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
            this.frame = frame;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/xdebugger/impl/frame/XThreadsView$XThreadsRootNode;", "Lcom/intellij/xdebugger/impl/ui/tree/nodes/XValueContainerNode;", "Lcom/intellij/xdebugger/impl/frame/XThreadsView$ThreadsContainer;", "tree", "Lcom/intellij/xdebugger/impl/ui/tree/XDebuggerTree;", "suspendContext", "Lcom/intellij/xdebugger/frame/XSuspendContext;", "(Lcom/intellij/xdebugger/impl/ui/tree/XDebuggerTree;Lcom/intellij/xdebugger/frame/XSuspendContext;)V", "intellij.platform.debugger.impl"})
    public static final class XThreadsRootNode
    extends XValueContainerNode<ThreadsContainer> {
        public XThreadsRootNode(@NotNull XDebuggerTree tree, @NotNull XSuspendContext suspendContext) {
            Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
            Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
            super(tree, null, false, (XValueContainer)new ThreadsContainer(suspendContext));
        }
    }
}

