/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.breadcrumbs;

import com.intellij.application.options.colors.ColorAndFontOptions;
import com.intellij.ide.DataManager;
import com.intellij.ide.ui.UISettings;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.options.CompositeConfigurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.colors.pages.GeneralColorsPage;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.breadcrumbs.BreadcrumbsProvider;
import com.intellij.ui.components.ActionLink;
import com.intellij.ui.components.panels.HorizontalLayout;
import com.intellij.ui.components.panels.VerticalLayout;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.SmartList;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

final class BreadcrumbsConfigurable
extends CompositeConfigurable<BreadcrumbsProviderConfigurable>
implements SearchableConfigurable {
    private final HashMap<String, JCheckBox> map = new HashMap();
    private JComponent component;
    private JCheckBox show;
    private JRadioButton above;
    private JRadioButton below;
    private JLabel placement;
    private JLabel languages;

    BreadcrumbsConfigurable() {
    }

    @NotNull
    public String getId() {
        return "editor.breadcrumbs";
    }

    public String getDisplayName() {
        return ApplicationBundle.message((String)"configurable.breadcrumbs", (Object[])new Object[0]);
    }

    public String getHelpTopic() {
        return "reference.settings.editor.general.breadcrumbs";
    }

    public JComponent createComponent() {
        if (this.component == null) {
            for (BreadcrumbsProviderConfigurable configurable2 : this.getConfigurables()) {
                String id2 = configurable2.getId();
                if (this.map.containsKey(id2)) continue;
                this.map.put(id2, configurable2.createComponent());
            }
            JPanel boxes = new JPanel(new GridLayout(0, 3, StartupUiUtil.isUnderDarcula() ? JBUIScale.scale((int)10) : 0, 0));
            this.map.values().stream().sorted((box1, box2) -> StringUtil.naturalCompare((String)box1.getText(), (String)box2.getText())).forEach(box2 -> boxes.add((Component)box2));
            this.show = new JCheckBox(ApplicationBundle.message((String)"checkbox.show.breadcrumbs", (Object[])new Object[0]));
            this.show.addItemListener(event -> this.updateEnabled());
            this.above = new JRadioButton(ApplicationBundle.message((String)"radio.show.breadcrumbs.above", (Object[])new Object[0]));
            this.below = new JRadioButton(ApplicationBundle.message((String)"radio.show.breadcrumbs.below", (Object[])new Object[0]));
            ButtonGroup group2 = new ButtonGroup();
            group2.add(this.above);
            group2.add(this.below);
            this.placement = new JLabel(ApplicationBundle.message((String)"label.breadcrumbs.placement", (Object[])new Object[0]));
            JPanel placementPanel = new JPanel((LayoutManager)new HorizontalLayout(10));
            placementPanel.setBorder((Border)JBUI.Borders.emptyLeft((int)24));
            placementPanel.add(this.placement);
            placementPanel.add(this.above);
            placementPanel.add(this.below);
            this.languages = new JLabel(ApplicationBundle.message((String)"label.breadcrumbs.languages", (Object[])new Object[0]));
            JPanel languagesPanel = new JPanel((LayoutManager)new VerticalLayout(6));
            languagesPanel.setBorder((Border)JBUI.Borders.empty((int)0, (int)24, (int)12, (int)0));
            languagesPanel.add(this.languages);
            languagesPanel.add(boxes);
            this.component = new JPanel((LayoutManager)new VerticalLayout(12, 2));
            this.component.add(this.show);
            this.component.add(placementPanel);
            this.component.add(languagesPanel);
            this.component.add((Component)new ActionLink(ApplicationBundle.message((String)"configure.breadcrumbs.colors", (Object[])new Object[0]), e -> {
                DataContext context2 = DataManager.getInstance().getDataContext((Component)this.component);
                ColorAndFontOptions.selectOrEditColor(context2, "Breadcrumbs//Current", GeneralColorsPage.class);
            }));
        }
        return this.component;
    }

    @Override
    public void reset() {
        EditorSettingsExternalizable settings2 = EditorSettingsExternalizable.getInstance();
        this.setBreadcrumbsAbove(settings2.isBreadcrumbsAbove());
        this.setBreadcrumbsShown(settings2.isBreadcrumbsShown());
        for (Map.Entry<String, JCheckBox> entry2 : this.map.entrySet()) {
            entry2.getValue().setSelected(settings2.isBreadcrumbsShownFor(entry2.getKey()));
        }
        this.updateEnabled();
    }

    @Override
    public boolean isModified() {
        EditorSettingsExternalizable settings2 = EditorSettingsExternalizable.getInstance();
        if (this.isBreadcrumbsAbove() != settings2.isBreadcrumbsAbove()) {
            return true;
        }
        if (this.isBreadcrumbsShown() != settings2.isBreadcrumbsShown()) {
            return true;
        }
        for (Map.Entry<String, JCheckBox> entry2 : this.map.entrySet()) {
            if (settings2.isBreadcrumbsShownFor(entry2.getKey()) == entry2.getValue().isSelected()) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    protected List<BreadcrumbsProviderConfigurable> createConfigurables() {
        SmartList configurables = new SmartList();
        for (BreadcrumbsProvider provider2 : BreadcrumbsProvider.EP_NAME.getExtensionList()) {
            for (Language language : provider2.getLanguages()) {
                configurables.add(new BreadcrumbsProviderConfigurable(provider2, language));
            }
        }
        SmartList smartList = configurables;
        if (smartList == null) {
            BreadcrumbsConfigurable.$$$reportNull$$$0(0);
        }
        return smartList;
    }

    @Override
    public void apply() {
        boolean modified = false;
        EditorSettingsExternalizable settings2 = EditorSettingsExternalizable.getInstance();
        if (settings2.setBreadcrumbsAbove(this.isBreadcrumbsAbove())) {
            modified = true;
        }
        if (settings2.setBreadcrumbsShown(this.isBreadcrumbsShown())) {
            modified = true;
        }
        for (Map.Entry<String, JCheckBox> entry2 : this.map.entrySet()) {
            if (!settings2.setBreadcrumbsShownFor(entry2.getKey(), entry2.getValue().isSelected())) continue;
            modified = true;
        }
        if (modified) {
            UISettings.getInstance().fireUISettingsChanged();
        }
    }

    private boolean isBreadcrumbsAbove() {
        return this.above != null && this.above.isSelected();
    }

    private void setBreadcrumbsAbove(boolean value2) {
        JRadioButton button4;
        JRadioButton jRadioButton = button4 = value2 ? this.above : this.below;
        if (button4 != null) {
            button4.setSelected(true);
        }
    }

    private boolean isBreadcrumbsShown() {
        return this.show != null && this.show.isSelected();
    }

    private void setBreadcrumbsShown(boolean value2) {
        if (this.show != null) {
            this.show.setSelected(value2);
        }
    }

    private void updateEnabled() {
        boolean enabled = this.isBreadcrumbsShown();
        if (this.above != null) {
            this.above.setEnabled(enabled);
        }
        if (this.below != null) {
            this.below.setEnabled(enabled);
        }
        if (this.placement != null) {
            this.placement.setEnabled(enabled);
        }
        if (this.languages != null) {
            this.languages.setEnabled(enabled);
        }
        for (JCheckBox box2 : this.map.values()) {
            box2.setEnabled(enabled);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/breadcrumbs/BreadcrumbsConfigurable", "createConfigurables"));
    }

    static final class BreadcrumbsProviderConfigurable
    implements SearchableConfigurable {
        private final BreadcrumbsProvider myProvider;
        private final Language myLanguage;

        private BreadcrumbsProviderConfigurable(@NotNull BreadcrumbsProvider provider2, @NotNull Language language) {
            if (provider2 == null) {
                BreadcrumbsProviderConfigurable.$$$reportNull$$$0(0);
            }
            if (language == null) {
                BreadcrumbsProviderConfigurable.$$$reportNull$$$0(1);
            }
            this.myProvider = provider2;
            this.myLanguage = language;
        }

        @NotNull
        public JCheckBox createComponent() {
            return new JCheckBox(this.myLanguage.getDisplayName());
        }

        public boolean isModified() {
            return false;
        }

        public void apply() throws ConfigurationException {
        }

        @NotNull
        public String getId() {
            String string = this.myLanguage.getID();
            if (string == null) {
                BreadcrumbsProviderConfigurable.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Nls(capitalization=Nls.Capitalization.Title)
        public String getDisplayName() {
            return this.myLanguage.getDisplayName();
        }

        @NotNull
        public Class<?> getOriginalClass() {
            Class<?> clazz = this.myProvider.getClass();
            if (clazz == null) {
                BreadcrumbsProviderConfigurable.$$$reportNull$$$0(3);
            }
            return clazz;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "provider";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "language";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/xml/breadcrumbs/BreadcrumbsConfigurable$BreadcrumbsProviderConfigurable";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/xml/breadcrumbs/BreadcrumbsConfigurable$BreadcrumbsProviderConfigurable";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getId";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOriginalClass";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

