/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.json.JsonFileType;
import com.intellij.json.pointer.JsonPointerResolver;
import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonContainer;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.paths.WebReference;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileInfoManager;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.jsonSchema.JsonPointerUtil;
import com.jetbrains.jsonSchema.extension.JsonSchemaInfo;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.JsonCachedValues;
import com.jetbrains.jsonSchema.impl.JsonSchemaBaseReference;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaVariantsTreeBuilder;
import com.jetbrains.jsonSchema.remote.JsonFileResolver;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonPointerReferenceProvider
extends PsiReferenceProvider {
    private final boolean myIsSchemaProperty;

    public JsonPointerReferenceProvider(boolean isSchemaProperty) {
        this.myIsSchemaProperty = isSchemaProperty;
    }

    public PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement element2, @NotNull ProcessingContext context2) {
        List<String> parts2;
        List<String> parts1;
        String[] strings;
        String relativePath;
        if (element2 == null) {
            JsonPointerReferenceProvider.$$$reportNull$$$0(0);
        }
        if (context2 == null) {
            JsonPointerReferenceProvider.$$$reportNull$$$0(1);
        }
        if (!(element2 instanceof JsonStringLiteral)) {
            if (PsiReference.EMPTY_ARRAY == null) {
                JsonPointerReferenceProvider.$$$reportNull$$$0(2);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        ArrayList<PsiReference> refs = new ArrayList<PsiReference>();
        List<Pair<TextRange, String>> fragments = ((JsonStringLiteral)element2).getTextFragments();
        if (fragments.size() != 1) {
            if (PsiReference.EMPTY_ARRAY == null) {
                JsonPointerReferenceProvider.$$$reportNull$$$0(3);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        Pair<TextRange, String> fragment2 = fragments.get(0);
        String originalText = element2.getText();
        int hash = originalText.indexOf(35);
        JsonSchemaVariantsTreeBuilder.SchemaUrlSplitter splitter = new JsonSchemaVariantsTreeBuilder.SchemaUrlSplitter((String)fragment2.second);
        String id2 = splitter.getSchemaId();
        if (id2 != null) {
            if (id2.startsWith("#")) {
                refs.add((PsiReference)new JsonSchemaIdReference((JsonValue)element2, id2));
            } else {
                this.addFileOrWebReferences(element2, refs, hash, id2);
            }
        }
        if (!this.myIsSchemaProperty && !StringUtil.isEmpty((String)(relativePath = JsonPointerUtil.normalizeSlashes(JsonPointerUtil.normalizeId(splitter.getRelativePath())))) && (strings = (String[])ContainerUtil.toArray(parts1 = JsonPointerUtil.split(relativePath), String[]::new)).length == (parts2 = JsonPointerUtil.split(JsonPointerUtil.normalizeSlashes(originalText.substring(hash + 1)))).size()) {
            int start2 = hash + 2;
            for (int i2 = 0; i2 < parts2.size(); ++i2) {
                int length = parts2.get(i2).length();
                if (i2 == parts2.size() - 1) {
                    --length;
                }
                if (length <= 0) break;
                refs.add((PsiReference)new JsonPointerReference((JsonValue)element2, new TextRange(start2, start2 + length), (id2 == null ? "" : id2) + "#/" + StringUtil.join((String[])strings, (int)0, (int)(i2 + 1), (String)"/")));
                start2 += length + 1;
            }
        }
        PsiReference[] psiReferenceArray = refs.size() == 0 ? PsiReference.EMPTY_ARRAY : (PsiReference[])ContainerUtil.toArray(refs, PsiReference[]::new);
        if (psiReferenceArray == null) {
            JsonPointerReferenceProvider.$$$reportNull$$$0(4);
        }
        return psiReferenceArray;
    }

    private void addFileOrWebReferences(@NotNull PsiElement element2, List<PsiReference> refs, final int hashIndex, String id2) {
        if (element2 == null) {
            JsonPointerReferenceProvider.$$$reportNull$$$0(5);
        }
        if (JsonFileResolver.isHttpPath(id2)) {
            refs.add((PsiReference)new WebReference(element2, new TextRange(1, hashIndex >= 0 ? hashIndex : id2.length() + 1), id2));
            return;
        }
        final boolean isCompletion = id2.contains("IntellijIdeaRulezzz");
        ContainerUtil.addAll(refs, (Object[])new FileReferenceSet(id2, element2, 1, null, true, true, (FileType[])new JsonFileType[]{JsonFileType.INSTANCE}){

            @Override
            public boolean isEmptyPathAllowed() {
                return true;
            }

            @Override
            protected boolean isSoft() {
                return true;
            }

            @Override
            public FileReference createFileReference(TextRange range2, int index2, String text2) {
                if (hashIndex != -1 && range2.getStartOffset() >= hashIndex) {
                    return null;
                }
                if (hashIndex != -1 && range2.getEndOffset() > hashIndex) {
                    range2 = new TextRange(range2.getStartOffset(), hashIndex);
                    text2 = text2.substring(0, text2.indexOf(35));
                }
                return new FileReference(this, range2, index2, text2){

                    @Override
                    protected Object createLookupItem(PsiElement candidate) {
                        return FileInfoManager.getFileLookupItem(candidate);
                    }

                    @Override
                    public Object @NotNull [] getVariants() {
                        Object[] fileVariants = super.getVariants();
                        if (!isCompletion || this.getRangeInElement().getStartOffset() != 1) {
                            if (fileVariants == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            return fileVariants;
                        }
                        Object[] objectArray = ArrayUtil.mergeArrays((Object[])fileVariants, (Object[])this.collectCatalogVariants());
                        if (objectArray == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        return objectArray;
                    }

                    private Object @NotNull [] collectCatalogVariants() {
                        ArrayList<LookupElement> elements = new ArrayList<LookupElement>();
                        Project project = this.getElement().getProject();
                        List<JsonSchemaInfo> schemas = JsonSchemaService.Impl.get(project).getAllUserVisibleSchemas();
                        for (JsonSchemaInfo schema2 : schemas) {
                            LookupElementBuilder element2 = LookupElementBuilder.create((String)schema2.getUrl(project)).withPresentableText(schema2.getDescription()).withLookupString(schema2.getDescription()).withIcon(AllIcons.General.Web).withTypeText(schema2.getDocumentation(), true);
                            if (schema2.getName() != null) {
                                element2 = element2.withLookupString(schema2.getName());
                            }
                            if (schema2.getDocumentation() != null) {
                                element2 = element2.withLookupString(schema2.getDocumentation());
                            }
                            elements.add(PrioritizedLookupElement.withPriority((LookupElement)element2, (double)-1.0));
                        }
                        Object[] objectArray = elements.toArray();
                        if (objectArray == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        return objectArray;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[2];
                        objectArray2[0] = "com/jetbrains/jsonSchema/impl/JsonPointerReferenceProvider$1$1";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[1] = "getVariants";
                                break;
                            }
                            case 2: {
                                objectArray = objectArray2;
                                objectArray2[1] = "collectCatalogVariants";
                                break;
                            }
                        }
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
                    }
                };
            }
        }.getAllReferences());
    }

    @Nullable
    static PsiElement resolveForPath(PsiElement element2, String text2, boolean alwaysRoot) {
        JsonSchemaService service = JsonSchemaService.Impl.get(element2.getProject());
        JsonSchemaVariantsTreeBuilder.SchemaUrlSplitter splitter = new JsonSchemaVariantsTreeBuilder.SchemaUrlSplitter(text2);
        VirtualFile schemaFile = CompletionUtil.getOriginalOrSelf(element2.getContainingFile()).getVirtualFile();
        if (splitter.isAbsolute()) {
            assert (splitter.getSchemaId() != null);
            schemaFile = service.findSchemaFileByReference(splitter.getSchemaId(), schemaFile);
            if (schemaFile == null) {
                return null;
            }
        }
        PsiFile psiFile = element2.getManager().findFile(schemaFile);
        String normalized = JsonPointerUtil.normalizeId(splitter.getRelativePath());
        if (!alwaysRoot && (StringUtil.isEmptyOrSpaces((String)normalized) || JsonPointerUtil.split(JsonPointerUtil.normalizeSlashes(normalized)).size() == 0) || !(psiFile instanceof JsonFile)) {
            return psiFile;
        }
        List<String> chain = JsonPointerUtil.split(JsonPointerUtil.normalizeSlashes(normalized));
        JsonSchemaObject schemaObject = service.getSchemaObjectForSchemaFile(schemaFile);
        if (schemaObject == null) {
            return null;
        }
        JsonValue value2 = ((JsonFile)psiFile).getTopLevelValue();
        return value2 == null ? psiFile : new JsonPointerResolver(value2, StringUtil.join(chain, (String)"/")).resolve();
    }

    @NotNull
    private static String prepare(String part) {
        String string = part.endsWith("#/") ? part : StringUtil.trimEnd((String)part, (char)'/');
        if (string == null) {
            JsonPointerReferenceProvider.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/jsonSchema/impl/JsonPointerReferenceProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/jsonSchema/impl/JsonPointerReferenceProvider";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencesByElement";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "prepare";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReferencesByElement";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addFileOrWebReferences";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class JsonPointerReference
    extends JsonSchemaBaseReference<JsonValue> {
        private final String myFullPath;

        JsonPointerReference(JsonValue element2, TextRange textRange, String curPath) {
            super(element2, textRange);
            this.myFullPath = curPath;
        }

        @NotNull
        public String getCanonicalText() {
            String string = this.myFullPath;
            if (string == null) {
                JsonPointerReference.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        @Nullable
        public PsiElement resolveInner() {
            return JsonPointerReferenceProvider.resolveForPath(this.myElement, this.getCanonicalText(), false);
        }

        @Override
        protected boolean isIdenticalTo(JsonSchemaBaseReference that) {
            return super.isIdenticalTo(that) && this.getRangeInElement().equals((Object)that.getRangeInElement());
        }

        public Object @NotNull [] getVariants() {
            String text2 = this.getCanonicalText();
            int index2 = text2.indexOf("IntellijIdeaRulezzz");
            if (index2 >= 0) {
                String part = text2.substring(0, index2);
                text2 = JsonPointerReferenceProvider.prepare(part);
                String prefix2 = null;
                PsiElement element2 = JsonPointerReferenceProvider.resolveForPath(this.myElement, text2, true);
                int indexOfSlash = part.lastIndexOf(47);
                if (indexOfSlash != -1 && indexOfSlash < text2.length() - 1 && indexOfSlash < index2) {
                    prefix2 = text2.substring(indexOfSlash + 1);
                    element2 = JsonPointerReferenceProvider.resolveForPath(this.myElement, JsonPointerReferenceProvider.prepare(text2.substring(0, indexOfSlash)), true);
                }
                String finalPrefix = prefix2;
                if (element2 instanceof JsonObject) {
                    Object[] objectArray = ((JsonObject)element2).getPropertyList().stream().filter(p -> p.getValue() instanceof JsonContainer && (finalPrefix == null || p.getName().startsWith(finalPrefix))).map(p -> LookupElementBuilder.create((Object)p, (String)JsonPointerUtil.escapeForJsonPointer(p.getName())).withIcon(JsonPointerReference.getIcon(p.getValue()))).toArray();
                    if (objectArray == null) {
                        JsonPointerReference.$$$reportNull$$$0(1);
                    }
                    return objectArray;
                }
                if (element2 instanceof JsonArray) {
                    List<JsonValue> list2 = ((JsonArray)element2).getValueList();
                    LinkedList<LookupElementBuilder> values2 = new LinkedList<LookupElementBuilder>();
                    for (int i2 = 0; i2 < list2.size(); ++i2) {
                        String stringValue = String.valueOf(i2);
                        if (prefix2 != null && !stringValue.startsWith(prefix2)) continue;
                        values2.add(LookupElementBuilder.create((String)stringValue).withIcon(JsonPointerReference.getIcon(list2.get(i2))));
                    }
                    Object[] objectArray = ContainerUtil.toArray(values2, Object[]::new);
                    if (objectArray == null) {
                        JsonPointerReference.$$$reportNull$$$0(2);
                    }
                    return objectArray;
                }
            }
            if (ArrayUtilRt.EMPTY_OBJECT_ARRAY == null) {
                JsonPointerReference.$$$reportNull$$$0(3);
            }
            return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
        }

        private static Icon getIcon(JsonValue value2) {
            if (value2 instanceof JsonObject) {
                return AllIcons.Json.Object;
            }
            if (value2 instanceof JsonArray) {
                return AllIcons.Json.Array;
            }
            return AllIcons.Nodes.Property;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/jetbrains/jsonSchema/impl/JsonPointerReferenceProvider$JsonPointerReference";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCanonicalText";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVariants";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    public static final class JsonSchemaIdReference
    extends JsonSchemaBaseReference<JsonValue> {
        private final String myText;

        private JsonSchemaIdReference(JsonValue element2, String text2) {
            super(element2, JsonSchemaIdReference.getRange(element2));
            this.myText = text2;
        }

        @NotNull
        private static TextRange getRange(JsonValue element2) {
            TextRange range2 = element2.getTextRange().shiftLeft(element2.getTextOffset());
            return new TextRange(range2.getStartOffset() + 1, range2.getEndOffset() - 1);
        }

        @Override
        @Nullable
        public PsiElement resolveInner() {
            String id2 = JsonCachedValues.resolveId(((JsonValue)this.myElement).getContainingFile(), this.myText);
            if (id2 == null) {
                return null;
            }
            return JsonPointerReferenceProvider.resolveForPath(this.myElement, "#" + id2, false);
        }

        public Object @NotNull [] getVariants() {
            Object[] objectArray = JsonCachedValues.getAllIdsInFile(((JsonValue)this.myElement).getContainingFile()).toArray();
            if (objectArray == null) {
                JsonSchemaIdReference.$$$reportNull$$$0(0);
            }
            return objectArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/jsonSchema/impl/JsonPointerReferenceProvider$JsonSchemaIdReference", "getVariants"));
        }
    }
}

