/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.json.JsonBundle;
import com.intellij.json.psi.JsonElementVisitor;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.openapi.paths.WebReference;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.JsonPointerReferenceProvider;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.inspections.JsonSchemaBasedInspectionBase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonSchemaRefReferenceInspection
extends JsonSchemaBasedInspectionBase {
    @Override
    protected PsiElementVisitor doBuildVisitor(final @NotNull JsonValue root, @Nullable JsonSchemaObject schema2, @NotNull JsonSchemaService service, final @NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session2) {
        if (root == null) {
            JsonSchemaRefReferenceInspection.$$$reportNull$$$0(0);
        }
        if (service == null) {
            JsonSchemaRefReferenceInspection.$$$reportNull$$$0(1);
        }
        if (holder == null) {
            JsonSchemaRefReferenceInspection.$$$reportNull$$$0(2);
        }
        if (session2 == null) {
            JsonSchemaRefReferenceInspection.$$$reportNull$$$0(3);
        }
        final boolean checkRefs = schema2 != null && service.isSchemaFile(schema2);
        return new JsonElementVisitor(){

            public void visitElement(@NotNull PsiElement element2) {
                JsonProperty schemaProp;
                if (element2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (element2 == root && element2 instanceof JsonObject && (schemaProp = ((JsonObject)element2).findProperty("$schema")) != null) {
                    this.doCheck(schemaProp.getValue());
                }
                super.visitElement(element2);
            }

            @Override
            public void visitProperty(@NotNull JsonProperty o) {
                if (o == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (!checkRefs) {
                    return;
                }
                if ("$ref".equals(o.getName())) {
                    this.doCheck(o.getValue());
                }
                super.visitProperty(o);
            }

            private void doCheck(JsonValue value2) {
                if (!(value2 instanceof JsonStringLiteral)) {
                    return;
                }
                for (PsiReference reference2 : value2.getReferences()) {
                    PsiElement resolved2;
                    if (reference2 instanceof WebReference || (resolved2 = reference2.resolve()) != null) continue;
                    holder.registerProblem(reference2, this.getReferenceErrorDesc(reference2), ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
                }
            }

            @InspectionMessage
            private String getReferenceErrorDesc(PsiReference reference2) {
                String text2 = reference2.getCanonicalText();
                if (reference2 instanceof FileReference) {
                    int hash = text2.indexOf(35);
                    return JsonBundle.message("json.schema.ref.file.not.found", hash == -1 ? text2 : text2.substring(0, hash));
                }
                if (reference2 instanceof JsonPointerReferenceProvider.JsonSchemaIdReference) {
                    return JsonBundle.message("json.schema.ref.cannot.resolve.id", text2);
                }
                int lastSlash = text2.lastIndexOf(47);
                if (lastSlash == -1) {
                    return JsonBundle.message("json.schema.ref.cannot.resolve.path", text2);
                }
                String substring = text2.substring(text2.lastIndexOf(47) + 1);
                try {
                    Integer.parseInt(substring);
                    return JsonBundle.message("json.schema.ref.no.array.element", substring);
                }
                catch (Exception e) {
                    return JsonBundle.message("json.schema.ref.no.property", substring);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "o";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/jsonSchema/impl/inspections/JsonSchemaRefReferenceInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitElement";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitProperty";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "root";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "service";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "session";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/jsonSchema/impl/inspections/JsonSchemaRefReferenceInspection";
        objectArray[2] = "doBuildVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

