/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.IncorrectOperationException;
import java.util.Objects;
import org.intellij.lang.regexp.RegExpTT;
import org.intellij.lang.regexp.psi.RegExpElementVisitor;
import org.intellij.lang.regexp.psi.RegExpGroup;
import org.intellij.lang.regexp.psi.RegExpNamedGroupRef;
import org.intellij.lang.regexp.psi.impl.RegExpElementImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RegExpNamedGroupRefImpl
extends RegExpElementImpl
implements RegExpNamedGroupRef {
    private static final TokenSet RUBY_GROUP_REF_TOKENS = TokenSet.create((IElementType[])new IElementType[]{RegExpTT.RUBY_NAMED_GROUP_REF, RegExpTT.RUBY_QUOTED_NAMED_GROUP_REF, RegExpTT.RUBY_NAMED_GROUP_CALL, RegExpTT.RUBY_QUOTED_NAMED_GROUP_CALL});

    public RegExpNamedGroupRefImpl(ASTNode node2) {
        super(node2);
    }

    @Override
    public void accept(RegExpElementVisitor visitor) {
        visitor.visitRegExpNamedGroupRef(this);
    }

    @Override
    @Nullable
    public RegExpGroup resolve() {
        String groupName = this.getGroupName();
        return groupName == null ? null : RegExpNamedGroupRefImpl.resolve(groupName, this.getContainingFile());
    }

    static RegExpGroup resolve(@NotNull String groupName, PsiFile file2) {
        if (groupName == null) {
            RegExpNamedGroupRefImpl.$$$reportNull$$$0(0);
        }
        return (RegExpGroup)SyntaxTraverser.psiTraverser((PsiElement)file2).filter(RegExpGroup.class).filter(group2 -> Objects.equals(groupName, group2.getGroupName())).first();
    }

    @Override
    @Nullable
    public String getGroupName() {
        ASTNode nameNode = this.getNode().findChildByType(RegExpTT.NAME);
        return nameNode != null ? nameNode.getText() : null;
    }

    @Override
    public boolean isPythonNamedGroupRef() {
        return this.getNode().findChildByType(RegExpTT.PYTHON_NAMED_GROUP_REF) != null;
    }

    @Override
    public boolean isRubyNamedGroupRef() {
        ASTNode node2 = this.getNode();
        return node2.findChildByType(RUBY_GROUP_REF_TOKENS) != null;
    }

    @Override
    public boolean isNamedGroupRef() {
        return this.getNode().findChildByType(RegExpTT.RUBY_NAMED_GROUP_REF) != null;
    }

    @Override
    public PsiReference getReference() {
        if (this.getNode().findChildByType(RegExpTT.NAME) == null) {
            return null;
        }
        return new PsiReference(){

            @NotNull
            public PsiElement getElement() {
                RegExpNamedGroupRefImpl regExpNamedGroupRefImpl = RegExpNamedGroupRefImpl.this;
                if (regExpNamedGroupRefImpl == null) {
                    1.$$$reportNull$$$0(0);
                }
                return regExpNamedGroupRefImpl;
            }

            @NotNull
            public TextRange getRangeInElement() {
                ASTNode nameNode = RegExpNamedGroupRefImpl.this.getNode().findChildByType(RegExpTT.NAME);
                assert (nameNode != null);
                int startOffset = RegExpNamedGroupRefImpl.this.getNode().getFirstChildNode().getTextLength();
                return new TextRange(startOffset, startOffset + nameNode.getTextLength());
            }

            public PsiElement resolve() {
                return RegExpNamedGroupRefImpl.this.resolve();
            }

            @NotNull
            public String getCanonicalText() {
                String string = this.getRangeInElement().substring(RegExpNamedGroupRefImpl.this.getText());
                if (string == null) {
                    1.$$$reportNull$$$0(1);
                }
                return string;
            }

            public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
                if (newElementName == null) {
                    1.$$$reportNull$$$0(2);
                }
                throw new UnsupportedOperationException();
            }

            public PsiElement bindToElement(@NotNull PsiElement element2) throws IncorrectOperationException {
                if (element2 == null) {
                    1.$$$reportNull$$$0(3);
                }
                throw new UnsupportedOperationException();
            }

            public boolean isReferenceTo(@NotNull PsiElement element2) {
                if (element2 == null) {
                    1.$$$reportNull$$$0(4);
                }
                return this.resolve() == element2;
            }

            public Object @NotNull [] getVariants() {
                Object[] objectArray = SyntaxTraverser.psiTraverser((PsiElement)RegExpNamedGroupRefImpl.this.getContainingFile()).filter(RegExpGroup.class).filter(RegExpGroup::isAnyNamedGroup).toArray((Object[])new RegExpGroup[0]);
                if (objectArray == null) {
                    1.$$$reportNull$$$0(5);
                }
                return objectArray;
            }

            public boolean isSoft() {
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/intellij/lang/regexp/psi/impl/RegExpNamedGroupRefImpl$1";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "newElementName";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getElement";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getCanonicalText";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/intellij/lang/regexp/psi/impl/RegExpNamedGroupRefImpl$1";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getVariants";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "handleElementRename";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "bindToElement";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "isReferenceTo";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupName", "org/intellij/lang/regexp/psi/impl/RegExpNamedGroupRefImpl", "resolve"));
    }
}

