/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.validation;

import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.AnnotationSession;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.StringEscapesTokenTypes;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.intellij.lang.regexp.RegExpBundle;
import org.intellij.lang.regexp.RegExpHighlighter;
import org.intellij.lang.regexp.RegExpLanguageHost;
import org.intellij.lang.regexp.RegExpLanguageHosts;
import org.intellij.lang.regexp.RegExpTT;
import org.intellij.lang.regexp.psi.RegExpAtom;
import org.intellij.lang.regexp.psi.RegExpBackref;
import org.intellij.lang.regexp.psi.RegExpBoundary;
import org.intellij.lang.regexp.psi.RegExpBranch;
import org.intellij.lang.regexp.psi.RegExpChar;
import org.intellij.lang.regexp.psi.RegExpCharRange;
import org.intellij.lang.regexp.psi.RegExpClass;
import org.intellij.lang.regexp.psi.RegExpClosure;
import org.intellij.lang.regexp.psi.RegExpConditional;
import org.intellij.lang.regexp.psi.RegExpElement;
import org.intellij.lang.regexp.psi.RegExpElementVisitor;
import org.intellij.lang.regexp.psi.RegExpGroup;
import org.intellij.lang.regexp.psi.RegExpNamedCharacter;
import org.intellij.lang.regexp.psi.RegExpNamedGroupRef;
import org.intellij.lang.regexp.psi.RegExpNumber;
import org.intellij.lang.regexp.psi.RegExpOptions;
import org.intellij.lang.regexp.psi.RegExpPattern;
import org.intellij.lang.regexp.psi.RegExpPosixBracketExpression;
import org.intellij.lang.regexp.psi.RegExpProperty;
import org.intellij.lang.regexp.psi.RegExpQuantifier;
import org.intellij.lang.regexp.psi.RegExpRecursiveElementVisitor;
import org.intellij.lang.regexp.psi.RegExpSetOptions;
import org.intellij.lang.regexp.psi.RegExpSimpleClass;
import org.intellij.lang.regexp.validation.SimplifyQuantifierAction;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RegExpAnnotator
extends RegExpElementVisitor
implements Annotator {
    @NonNls
    private static final Set<String> POSIX_CHARACTER_CLASSES = ContainerUtil.newHashSet((Object[])new String[]{"alnum", "alpha", "ascii", "blank", "cntrl", "digit", "graph", "lower", "print", "punct", "space", "upper", "word", "xdigit"});
    private AnnotationHolder myHolder;
    private final RegExpLanguageHosts myLanguageHosts;
    private final Key<Map<String, RegExpGroup>> NAMED_GROUP_MAP = new Key("REG_EXP_NAMED_GROUP_MAP");

    public RegExpAnnotator() {
        this.myLanguageHosts = RegExpLanguageHosts.getInstance();
    }

    public void annotate(@NotNull PsiElement psiElement, @NotNull AnnotationHolder holder) {
        if (psiElement == null) {
            RegExpAnnotator.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            RegExpAnnotator.$$$reportNull$$$0(1);
        }
        assert (this.myHolder == null) : "unsupported concurrent annotator invocation";
        try {
            this.myHolder = holder;
            psiElement.accept((PsiElementVisitor)this);
        }
        finally {
            this.myHolder = null;
        }
    }

    @Override
    public void visitRegExpSetOptions(RegExpSetOptions options2) {
        this.checkValidFlag(options2.getOnOptions(), false);
        this.checkValidFlag(options2.getOffOptions(), true);
    }

    private void checkValidFlag(@Nullable RegExpOptions options2, boolean skipMinus) {
        int start2;
        if (options2 == null) {
            return;
        }
        String text2 = options2.getText();
        int length = text2.length();
        for (int i2 = start2 = skipMinus ? 1 : 0; i2 < length; ++i2) {
            int c = text2.codePointAt(i2);
            if (Character.isBmpCodePoint(c) && this.myLanguageHosts.supportsInlineOptionFlag((char)c, options2)) continue;
            int offset = options2.getTextOffset() + i2;
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, RegExpBundle.message("error.unknown.inline.option.flag", new Object[0])).range(new TextRange(offset, offset + 1)).create();
        }
    }

    @Override
    public void visitRegExpCharRange(RegExpCharRange range2) {
        RegExpChar from2 = range2.getFrom();
        PsiElement hyphen = from2.getNextSibling();
        this.myHolder.newSilentAnnotation(HighlightInfoType.SYMBOL_TYPE_SEVERITY).range(hyphen).textAttributes(RegExpHighlighter.META).create();
        RegExpChar to = range2.getTo();
        if (to == null) {
            return;
        }
        int fromCodePoint = from2.getValue();
        int toCodePoint = to.getValue();
        if (fromCodePoint == -1 || toCodePoint == -1) {
            return;
        }
        if (toCodePoint < fromCodePoint) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, RegExpBundle.message("error.illegal.character.range.to.from", new Object[0])).range((PsiElement)range2).create();
        } else if (toCodePoint == fromCodePoint) {
            this.myHolder.newAnnotation(HighlightSeverity.WARNING, RegExpBundle.message("error.redundant.character.range", new Object[0])).range((PsiElement)range2).create();
        }
    }

    @Override
    public void visitRegExpBoundary(RegExpBoundary boundary) {
        if (!this.myLanguageHosts.supportsBoundary(boundary)) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, RegExpBundle.message("error.this.boundary.is.not.supported.in.this.regex.dialect", new Object[0])).create();
        }
    }

    @Override
    public void visitSimpleClass(RegExpSimpleClass simpleClass) {
        if (!this.myLanguageHosts.supportsSimpleClass(simpleClass)) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, RegExpBundle.message("error.illegal.unsupported.escape.sequence", new Object[0])).create();
        }
    }

    @Override
    public void visitRegExpChar(RegExpChar ch) {
        RegExpChar.Type charType;
        PsiElement child2 = ch.getFirstChild();
        IElementType type = child2.getNode().getElementType();
        if (type == RegExpTT.CHARACTER) {
            if (ch.getTextLength() > 1) {
                this.myHolder.newSilentAnnotation(HighlightInfoType.SYMBOL_TYPE_SEVERITY).range((PsiElement)ch).textAttributes(RegExpHighlighter.ESC_CHARACTER).create();
            }
        } else {
            if (type == StringEscapesTokenTypes.INVALID_CHARACTER_ESCAPE_TOKEN) {
                this.myHolder.newAnnotation(HighlightSeverity.ERROR, RegExpBundle.message("error.illegal.unsupported.escape.sequence", new Object[0])).create();
                return;
            }
            if (type == RegExpTT.BAD_HEX_VALUE) {
                this.myHolder.newAnnotation(HighlightSeverity.ERROR, RegExpBundle.message("error.illegal.hexadecimal.escape.sequence", new Object[0])).create();
                return;
            }
            if (type == RegExpTT.BAD_OCT_VALUE) {
                this.myHolder.newAnnotation(HighlightSeverity.ERROR, RegExpBundle.message("error.illegal.octal.escape.sequence", new Object[0])).create();
                return;
            }
            if (type == StringEscapesTokenTypes.INVALID_UNICODE_ESCAPE_TOKEN) {
                this.myHolder.newAnnotation(HighlightSeverity.ERROR, RegExpBundle.message("error.illegal.unicode.escape.sequence", new Object[0])).create();
                return;
            }
        }
        String text2 = ch.getUnescapedText();
        if (type == RegExpTT.ESC_CTRL_CHARACTER && text2.equals("\\b") && !this.myLanguageHosts.supportsLiteralBackspace(ch)) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, RegExpBundle.message("error.illegal.unsupported.escape.sequence", new Object[0])).create();
        }
        if ((charType = ch.getType()) == RegExpChar.Type.HEX || charType == RegExpChar.Type.UNICODE) {
            if (ch.getValue() == -1) {
                this.myHolder.newAnnotation(HighlightSeverity.ERROR, RegExpBundle.message("error.illegal.unicode.escape.sequence", new Object[0])).create();
                return;
            }
            if (text2.charAt(text2.length() - 1) == '}' && !this.myLanguageHosts.supportsExtendedHexCharacter(ch)) {
                this.myHolder.newAnnotation(HighlightSeverity.ERROR, RegExpBundle.message("error.this.hex.character.syntax.is.not.supported.in.this.regex.dialect", new Object[0])).create();
            }
        }
    }

    @Override
    public void visitRegExpProperty(RegExpProperty property2) {
        ASTNode category = property2.getCategoryNode();
        if (category == null) {
            return;
        }
        if (!this.myLanguageHosts.supportsPropertySyntax(property2)) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, RegExpBundle.message("error.property.escape.sequences.are.not.supported.in.this.regex.dialect", new Object[0])).create();
            return;
        }
        String propertyName = category.getText();
        ASTNode next = category.getTreeNext();
        if (next == null || next.getElementType() != RegExpTT.EQ) {
            if (!this.myLanguageHosts.isValidCategory(category.getPsi(), propertyName)) {
                this.myHolder.newAnnotation(HighlightSeverity.ERROR, RegExpBundle.message("error.unknown.character.category", new Object[0])).range(category).highlightType(ProblemHighlightType.LIKE_UNKNOWN_SYMBOL).create();
            }
        } else {
            if (!this.myLanguageHosts.isValidPropertyName(category.getPsi(), propertyName)) {
                this.myHolder.newAnnotation(HighlightSeverity.ERROR, RegExpBundle.message("error.unknown.property.name", new Object[0])).range(category).highlightType(ProblemHighlightType.LIKE_UNKNOWN_SYMBOL).create();
                return;
            }
            ASTNode valueNode = property2.getValueNode();
            if (valueNode != null && !this.myLanguageHosts.isValidPropertyValue(category.getPsi(), propertyName, valueNode.getText())) {
                this.myHolder.newAnnotation(HighlightSeverity.ERROR, RegExpBundle.message("error.unknown.property.value", new Object[0])).range(valueNode).highlightType(ProblemHighlightType.LIKE_UNKNOWN_SYMBOL).create();
            }
        }
    }

    @Override
    public void visitRegExpNamedCharacter(RegExpNamedCharacter namedCharacter) {
        ASTNode node2;
        if (!this.myLanguageHosts.supportsNamedCharacters(namedCharacter)) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, RegExpBundle.message("error.named.unicode.characters.are.not.allowed.in.this.regex.dialect", new Object[0])).create();
        } else if (!this.myLanguageHosts.isValidNamedCharacter(namedCharacter) && (node2 = namedCharacter.getNameNode()) != null) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, RegExpBundle.message("error.unknown.character.name", new Object[0])).range(node2).highlightType(ProblemHighlightType.LIKE_UNKNOWN_SYMBOL).create();
        }
    }

    @Override
    public void visitRegExpBackref(RegExpBackref backref) {
        RegExpGroup group2 = backref.resolve();
        if (group2 == null) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, RegExpBundle.message("error.unresolved.back.reference", new Object[0])).highlightType(ProblemHighlightType.LIKE_UNKNOWN_SYMBOL).create();
        } else if (PsiTreeUtil.isAncestor((PsiElement)group2, (PsiElement)backref, (boolean)true)) {
            this.myHolder.newAnnotation(HighlightSeverity.WARNING, RegExpBundle.message("error.back.reference.is.nested.into.the.capturing.group.it.refers.to", new Object[0])).create();
        }
    }

    @Override
    public void visitRegExpGroup(RegExpGroup group2) {
        RegExpGroup.Type groupType;
        ASTNode node2;
        AnnotationSession session2;
        Map namedGroups;
        ASTNode node3;
        String name;
        RegExpGroup.Type type;
        RegExpAtom[] atoms;
        RegExpPattern pattern = group2.getPattern();
        RegExpBranch[] branches = pattern.getBranches();
        if (RegExpAnnotator.isEmpty(branches) && group2.getNode().getLastChildNode().getElementType() == RegExpTT.GROUP_END) {
            this.myHolder.newAnnotation(HighlightSeverity.WARNING, RegExpBundle.message("error.empty.group", new Object[0])).create();
        } else if (branches.length == 1 && (atoms = branches[0].getAtoms()).length == 1 && atoms[0] instanceof RegExpGroup && ((type = group2.getType()) == RegExpGroup.Type.CAPTURING_GROUP || type == RegExpGroup.Type.ATOMIC || type == RegExpGroup.Type.NON_CAPTURING)) {
            RegExpGroup innerGroup = (RegExpGroup)atoms[0];
            if (group2.isCapturing() == innerGroup.isCapturing()) {
                this.myHolder.newAnnotation(HighlightSeverity.WARNING, RegExpBundle.message("error.redundant.group.nesting", new Object[0])).create();
            }
        }
        if (group2.isAnyNamedGroup() && !this.myLanguageHosts.supportsNamedGroupSyntax(group2)) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, RegExpBundle.message("error.this.named.group.syntax.is.not.supported.in.this.regex.dialect", new Object[0])).create();
        }
        if (group2.getType() == RegExpGroup.Type.ATOMIC && !this.myLanguageHosts.supportsPossessiveQuantifiers(group2)) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, RegExpBundle.message("error.atomic.groups.are.not.supported.in.this.regex.dialect", new Object[0])).create();
        }
        if ((name = group2.getName()) != null && !this.myLanguageHosts.isValidGroupName(name, group2) && (node3 = group2.getNode().findChildByType(RegExpTT.NAME)) != null) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, RegExpBundle.message("error.invalid.group.name", new Object[0])).range(node3).create();
        }
        if ((namedGroups = (Map)this.NAMED_GROUP_MAP.get((UserDataHolder)(session2 = this.myHolder.getCurrentAnnotationSession()), new HashMap())).isEmpty()) {
            session2.putUserData(this.NAMED_GROUP_MAP, (Object)namedGroups);
        }
        if (namedGroups.put(name, group2) != null && (node2 = group2.getNode().findChildByType(RegExpTT.NAME)) != null) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, RegExpBundle.message("error.group.with.name.0.already.defined", name)).range(node2).create();
        }
        if ((groupType = group2.getType()) == RegExpGroup.Type.POSITIVE_LOOKBEHIND || groupType == RegExpGroup.Type.NEGATIVE_LOOKBEHIND) {
            RegExpLanguageHost.Lookbehind support = this.myLanguageHosts.supportsLookbehind(group2);
            if (support == RegExpLanguageHost.Lookbehind.NOT_SUPPORTED) {
                this.myHolder.newAnnotation(HighlightSeverity.ERROR, RegExpBundle.message("error.look.behind.groups.are.not.supported.in.this.regex.dialect", new Object[0])).create();
            } else {
                group2.accept(new LookbehindVisitor(support, this.myHolder));
            }
        }
    }

    @Override
    public void visitRegExpNamedGroupRef(RegExpNamedGroupRef groupRef) {
        if (!(groupRef.getParent() instanceof RegExpConditional) && !this.myLanguageHosts.supportsNamedGroupRefSyntax(groupRef)) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, RegExpBundle.message("error.this.named.group.reference.syntax.is.not.supported.in.this.regex.dialect", new Object[0])).create();
            return;
        }
        if (groupRef.getGroupName() == null) {
            return;
        }
        RegExpGroup group2 = groupRef.resolve();
        if (group2 == null) {
            ASTNode node2 = groupRef.getNode().findChildByType(RegExpTT.NAME);
            if (node2 != null) {
                this.myHolder.newAnnotation(HighlightSeverity.ERROR, RegExpBundle.message("error.unresolved.named.group.reference", new Object[0])).range(node2).highlightType(ProblemHighlightType.LIKE_UNKNOWN_SYMBOL).create();
            }
        } else if (PsiTreeUtil.isAncestor((PsiElement)group2, (PsiElement)groupRef, (boolean)true)) {
            this.myHolder.newAnnotation(HighlightSeverity.WARNING, RegExpBundle.message("error.group.reference.is.nested.into.the.named.group.it.refers.to", new Object[0])).create();
        }
    }

    public void visitComment(@NotNull PsiComment comment) {
        if (comment == null) {
            RegExpAnnotator.$$$reportNull$$$0(2);
        }
        if (comment.getText().startsWith("(?#") && !this.myLanguageHosts.supportsPerl5EmbeddedComments(comment)) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, RegExpBundle.message("error.embedded.comments.are.not.supported.in.this.regex.dialect", new Object[0])).create();
        }
    }

    @Override
    public void visitRegExpConditional(RegExpConditional conditional) {
        RegExpAtom condition2;
        if (!this.myLanguageHosts.supportsConditionals(conditional)) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, RegExpBundle.message("error.conditionals.are.not.supported.in.this.regex.dialect", new Object[0])).create();
        }
        if (!this.myLanguageHosts.supportConditionalCondition(condition2 = conditional.getCondition())) {
            ASTNode child2;
            IElementType type;
            if (condition2 instanceof RegExpGroup) {
                this.myHolder.newAnnotation(HighlightSeverity.ERROR, RegExpBundle.message("error.lookaround.conditions.in.conditionals.not.supported.in.this.regex.dialect", new Object[0])).range((PsiElement)condition2).create();
            } else if (condition2 != null && ((type = (child2 = condition2.getNode().getFirstChildNode()).getElementType()) == RegExpTT.QUOTED_CONDITION_BEGIN || type == RegExpTT.GROUP_BEGIN || type == RegExpTT.ANGLE_BRACKET_CONDITION_BEGIN)) {
                this.myHolder.newAnnotation(HighlightSeverity.ERROR, RegExpBundle.message("error.this.kind.group.reference.condition.not.supported.in.this.regex.dialect", new Object[0])).range((PsiElement)condition2).create();
            }
        }
    }

    private static boolean isEmpty(RegExpBranch[] branches) {
        return !ContainerUtil.exists((Object[])branches, branch -> branch.getAtoms().length > 0);
    }

    @Override
    public void visitRegExpClosure(RegExpClosure closure) {
        if (closure.getAtom() instanceof RegExpSetOptions) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, RegExpBundle.message("error.dangling.metacharacter", new Object[0])).range((PsiElement)closure.getQuantifier()).create();
        }
    }

    @Override
    public void visitRegExpQuantifier(RegExpQuantifier quantifier) {
        if (quantifier.isCounted()) {
            String max;
            RegExpNumber minElement = quantifier.getMin();
            String min = minElement == null ? "" : minElement.getText();
            RegExpNumber maxElement = quantifier.getMax();
            String string = max = maxElement == null ? "" : maxElement.getText();
            if (!max.isEmpty() && max.equals(min)) {
                if ("1".equals(max)) {
                    this.myHolder.newAnnotation(HighlightSeverity.WEAK_WARNING, RegExpBundle.message("weak.warning.single.repetition", new Object[0])).withFix((IntentionAction)new SimplifyQuantifierAction(quantifier, null)).create();
                } else {
                    ASTNode node2 = quantifier.getNode();
                    if (node2.findChildByType(RegExpTT.COMMA) != null) {
                        this.myHolder.newAnnotation(HighlightSeverity.WEAK_WARNING, RegExpBundle.message("weak.warning.fixed.repetition.range", new Object[0])).withFix((IntentionAction)new SimplifyQuantifierAction(quantifier, "{" + max + "}")).create();
                    }
                }
            } else if (("0".equals(min) || min.isEmpty()) && "1".equals(max)) {
                this.myHolder.newAnnotation(HighlightSeverity.WEAK_WARNING, RegExpBundle.message("weak.warning.repetition.range.replaceable.by.0", "?")).withFix((IntentionAction)new SimplifyQuantifierAction(quantifier, "?")).create();
            } else if (("0".equals(min) || min.isEmpty()) && max.isEmpty()) {
                this.myHolder.newAnnotation(HighlightSeverity.WEAK_WARNING, RegExpBundle.message("weak.warning.repetition.range.replaceable.by.0", "*")).withFix((IntentionAction)new SimplifyQuantifierAction(quantifier, "*")).create();
            } else if ("1".equals(min) && max.isEmpty()) {
                this.myHolder.newAnnotation(HighlightSeverity.WEAK_WARNING, RegExpBundle.message("weak.warning.repetition.range.replaceable.by.0", "+")).withFix((IntentionAction)new SimplifyQuantifierAction(quantifier, "+")).create();
            }
            Number minValue = null;
            if (minElement != null && (minValue = this.myLanguageHosts.getQuantifierValue(minElement)) == null) {
                this.myHolder.newAnnotation(HighlightSeverity.ERROR, RegExpBundle.message("error.repetition.value.too.large", new Object[0])).range((PsiElement)minElement).create();
            }
            Number maxValue = null;
            if (maxElement != null && (maxValue = this.myLanguageHosts.getQuantifierValue(maxElement)) == null) {
                this.myHolder.newAnnotation(HighlightSeverity.ERROR, RegExpBundle.message("error.repetition.value.too.large", new Object[0])).range((PsiElement)maxElement).create();
            }
            if (minValue != null && maxValue != null && (minValue.longValue() > maxValue.longValue() || minValue.doubleValue() > maxValue.doubleValue())) {
                TextRange range2 = new TextRange(minElement.getTextOffset(), maxElement.getTextOffset() + maxElement.getTextLength());
                this.myHolder.newAnnotation(HighlightSeverity.ERROR, RegExpBundle.message("error.illegal.repetition.range.min.max", new Object[0])).range(range2).create();
            }
        }
        if (quantifier.isPossessive() && !this.myLanguageHosts.supportsPossessiveQuantifiers(quantifier)) {
            ASTNode modifier = quantifier.getModifier();
            assert (modifier != null);
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, RegExpBundle.message("error.nested.quantifier.in.regexp", new Object[0])).range(modifier).create();
        }
    }

    @Override
    public void visitPosixBracketExpression(RegExpPosixBracketExpression posixBracketExpression) {
        ASTNode node2;
        String className = posixBracketExpression.getClassName();
        if (!(POSIX_CHARACTER_CLASSES.contains(className) || "<".equals(className) || ">".equals(className) || (node2 = posixBracketExpression.getNode().findChildByType(RegExpTT.NAME)) == null)) {
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, RegExpBundle.message("error.unknown.posix.character.class", new Object[0])).range(node2).highlightType(ProblemHighlightType.LIKE_UNKNOWN_SYMBOL).create();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
        }
        objectArray2[1] = "org/intellij/lang/regexp/validation/RegExpAnnotator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "annotate";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "visitComment";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class LookbehindVisitor
    extends RegExpRecursiveElementVisitor {
        private final RegExpLanguageHost.Lookbehind mySupport;
        private final AnnotationHolder myHolder;
        private int myLength = 0;
        private boolean myStop = false;

        LookbehindVisitor(RegExpLanguageHost.Lookbehind support, AnnotationHolder holder) {
            this.mySupport = support;
            this.myHolder = holder;
        }

        @Override
        public void visitRegExpElement(RegExpElement element2) {
            if (this.myStop) {
                return;
            }
            super.visitRegExpElement(element2);
        }

        @Override
        public void visitRegExpChar(RegExpChar ch) {
            super.visitRegExpChar(ch);
            ++this.myLength;
        }

        @Override
        public void visitSimpleClass(RegExpSimpleClass simpleClass) {
            super.visitSimpleClass(simpleClass);
            ++this.myLength;
        }

        @Override
        public void visitRegExpClass(RegExpClass regExpClass) {
            ++this.myLength;
        }

        @Override
        public void visitRegExpProperty(RegExpProperty property2) {
            super.visitRegExpProperty(property2);
            ++this.myLength;
        }

        @Override
        public void visitRegExpBackref(RegExpBackref backref) {
            super.visitRegExpBackref(backref);
            if (this.mySupport != RegExpLanguageHost.Lookbehind.FULL) {
                this.stopAndReportError(backref, RegExpBundle.message("error.group.reference.not.allowed.inside.lookbehind", new Object[0]));
            }
        }

        @Override
        public void visitRegExpPattern(RegExpPattern pattern) {
            RegExpBranch[] branches;
            if (this.mySupport != RegExpLanguageHost.Lookbehind.FIXED_LENGTH_ALTERNATION) {
                super.visitRegExpPattern(pattern);
                return;
            }
            int length = this.myLength;
            int branchLength = -1;
            for (RegExpBranch branch : branches = pattern.getBranches()) {
                this.myLength = 0;
                super.visitRegExpBranch(branch);
                if (branchLength == -1) {
                    branchLength = this.myLength;
                    continue;
                }
                if (branchLength == this.myLength) continue;
                this.stopAndReportError(pattern, RegExpBundle.message("error.alternation.alternatives.needs.to.have.the.same.length.inside.lookbehind", new Object[0]));
                return;
            }
            this.myLength = length + branchLength;
        }

        @Override
        public void visitRegExpClosure(RegExpClosure closure) {
            if (this.mySupport == RegExpLanguageHost.Lookbehind.FULL) {
                return;
            }
            RegExpQuantifier quantifier = closure.getQuantifier();
            if (quantifier.isCounted()) {
                if (this.mySupport == RegExpLanguageHost.Lookbehind.FIXED_LENGTH_ALTERNATION || this.mySupport == RegExpLanguageHost.Lookbehind.VARIABLE_LENGTH_ALTERNATION) {
                    RegExpNumber minElement = quantifier.getMin();
                    RegExpNumber maxElement = quantifier.getMax();
                    if (minElement != null && maxElement != null) {
                        Number min = minElement.getValue();
                        if (min == null) {
                            this.myStop = true;
                            return;
                        }
                        Number max = maxElement.getValue();
                        if (min.equals(max)) {
                            int length = this.myLength;
                            this.myLength = 0;
                            RegExpAtom atom = closure.getAtom();
                            atom.accept(this);
                            int atomLength = this.myLength;
                            this.myLength = length + atomLength * min.intValue();
                            return;
                        }
                    }
                    this.stopAndReportError(quantifier, RegExpBundle.message("error.unequal.min.and.max.in.counted.quantifier.not.allowed.inside.lookbehind", new Object[0]));
                }
            } else {
                ASTNode token2 = quantifier.getToken();
                assert (token2 != null);
                String tokenText = token2.getText();
                if ("?".equals(tokenText) && this.mySupport == RegExpLanguageHost.Lookbehind.FINITE_REPETITION) {
                    return;
                }
                this.stopAndReportError(quantifier, RegExpBundle.message("error.0.repetition.not.allowed.inside.lookbehind", tokenText));
            }
        }

        @Override
        public void visitRegExpNamedGroupRef(RegExpNamedGroupRef groupRef) {
            super.visitRegExpNamedGroupRef(groupRef);
            if (this.mySupport != RegExpLanguageHost.Lookbehind.FULL) {
                this.stopAndReportError(groupRef, RegExpBundle.message("error.named.group.reference.not.allowed.inside.lookbehind", new Object[0]));
            }
        }

        @Override
        public void visitRegExpConditional(RegExpConditional conditional) {
            super.visitRegExpConditional(conditional);
            if (this.mySupport != RegExpLanguageHost.Lookbehind.FULL) {
                this.stopAndReportError(conditional, RegExpBundle.message("error.conditional.group.reference.not.allowed.inside.lookbehind", new Object[0]));
            }
        }

        @Override
        public void visitPosixBracketExpression(RegExpPosixBracketExpression posixBracketExpression) {
            super.visitPosixBracketExpression(posixBracketExpression);
            ++this.myLength;
        }

        public void stopAndReportError(RegExpElement element2, @NotNull @Nls String message2) {
            if (message2 == null) {
                LookbehindVisitor.$$$reportNull$$$0(0);
            }
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, message2).range((PsiElement)element2).create();
            this.myStop = true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/intellij/lang/regexp/validation/RegExpAnnotator$LookbehindVisitor", "stopAndReportError"));
        }
    }
}

