/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG.model.resolve;

import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.include.FileIncludeManager;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomManager;
import org.intellij.plugins.relaxNG.compact.RncFileType;
import org.intellij.plugins.relaxNG.xml.dom.RngGrammar;
import org.jetbrains.annotations.NotNull;

public class RelaxIncludeIndex {
    public static boolean processForwardDependencies(XmlFile file2, PsiElementProcessor<? super XmlFile> processor2) {
        VirtualFile virtualFile2 = file2.getVirtualFile();
        if (virtualFile2 == null) {
            return processor2.execute((PsiElement)file2);
        }
        Project project = file2.getProject();
        VirtualFile[] files2 = FileIncludeManager.getManager((Project)project).getIncludedFiles(virtualFile2, true);
        return RelaxIncludeIndex.processRelatedFiles((PsiFile)file2, files2, processor2);
    }

    public static boolean processBackwardDependencies(@NotNull XmlFile file2, PsiElementProcessor<? super XmlFile> processor2) {
        VirtualFile virtualFile2;
        if (file2 == null) {
            RelaxIncludeIndex.$$$reportNull$$$0(0);
        }
        if ((virtualFile2 = file2.getVirtualFile()) == null) {
            return processor2.execute((PsiElement)file2);
        }
        Project project = file2.getProject();
        VirtualFile[] files2 = FileIncludeManager.getManager((Project)project).getIncludingFiles(virtualFile2, true);
        return RelaxIncludeIndex.processRelatedFiles((PsiFile)file2, files2, processor2);
    }

    private static boolean processRelatedFiles(PsiFile file2, VirtualFile[] files2, PsiElementProcessor<? super XmlFile> processor2) {
        PsiFile[] psiFiles;
        Project project = file2.getProject();
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        for (PsiFile psiFile : psiFiles = (PsiFile[])ContainerUtil.map2Array((Object[])files2, PsiFile.class, (Function)((NullableFunction)file1 -> psiManager.findFile(file1)))) {
            if (RelaxIncludeIndex.processFile(psiFile, processor2)) continue;
            return false;
        }
        return true;
    }

    private static boolean processFile(PsiFile psiFile, PsiElementProcessor<? super XmlFile> processor2) {
        FileType type = psiFile.getFileType();
        return !(type == XmlFileType.INSTANCE && RelaxIncludeIndex.isRngFile(psiFile) ? !processor2.execute((PsiElement)((XmlFile)psiFile)) : type == RncFileType.getInstance() && !processor2.execute((PsiElement)((XmlFile)psiFile)));
    }

    static boolean isRngFile(PsiFile psiFile) {
        return psiFile instanceof XmlFile && DomManager.getDomManager((Project)psiFile.getProject()).getFileElement((XmlFile)psiFile, RngGrammar.class) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/intellij/plugins/relaxNG/model/resolve/RelaxIncludeIndex", "processBackwardDependencies"));
    }
}

