/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.config;

import com.intellij.credentialStore.Credentials;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.AuthType;
import com.intellij.ssh.config.unified.SshConfig;
import com.intellij.ssh.config.unified.SshConfigManager;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.XCollection;
import com.jetbrains.plugins.webDeployment.config.AccessType;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.config.FileTransferConfig;
import com.jetbrains.plugins.webDeployment.config.OldXmlCredentialProvider;
import com.jetbrains.plugins.webDeployment.config.WebDeploymentCredentialHelper;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerGroupingWrap;
import com.jetbrains.plugins.webDeployment.config.WebServersAuthStorage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import kotlin.Pair;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class WebServersConfigManagerBaseImpl<T extends State>
implements PersistentStateComponent<T> {
    private final List<WebServerConfig> myFlattenedServers = new ArrayList<WebServerConfig>();
    private final List<WebServerGroupingWrap> myGroupedServers = new ArrayList<WebServerGroupingWrap>();
    @Nullable
    private final Project myProject;
    private final boolean isProjectLevel;
    private final List<Listener> myListeners = new SmartList();

    public WebServersConfigManagerBaseImpl(@Nullable Project project, boolean level) {
        this.myProject = project;
        this.isProjectLevel = level;
        MessageBusConnection busConnection = project != null ? project.getMessageBus().connect() : ApplicationManager.getApplication().getMessageBus().connect();
        busConnection.subscribe(SshConfigManager.SSH_CONFIGS, (Object)new SshConfigManager.Listener(){

            public void sshConfigsChanged() {
                SshConfigManager manager = SshConfigManager.getInstance((Project)WebServersConfigManagerBaseImpl.this.myProject);
                for (WebServerConfig server : WebServersConfigManagerBaseImpl.this.myFlattenedServers) {
                    server.loadDataFromSshConfig(manager);
                }
            }
        });
    }

    protected abstract T createState();

    @Deprecated
    @NotNull
    public T getState() {
        T state = this.createState();
        for (WebServerGroupingWrap group : this.myGroupedServers) {
            if (group.isSingleServer()) {
                WebServerConfig server = group.getAsSingleServer();
                server = server.clone();
                server.setIsProjectLevel(false);
                ((State)state).servers.add(server);
                continue;
            }
            GroupingInfo info = new GroupingInfo();
            info.myGroupName = group.getName();
            info.myMayChangeLevel = group.mayChangeLevel();
            for (WebServerConfig server : group.getServers()) {
                info.myServerNames.add(server.getName());
                server = server.clone();
                server.setIsProjectLevel(false);
                ((State)state).servers.add(server);
            }
            ((State)state).groups.add(info);
        }
        T t = state;
        if (t == null) {
            WebServersConfigManagerBaseImpl.$$$reportNull$$$0(0);
        }
        return t;
    }

    public void loadState(@NotNull T state) {
        if (state == null) {
            WebServersConfigManagerBaseImpl.$$$reportNull$$$0(1);
        }
        this.myFlattenedServers.clear();
        this.myGroupedServers.clear();
        ArrayList<com.intellij.openapi.util.Pair> namedServers = new ArrayList<com.intellij.openapi.util.Pair>();
        SshConfigManager sshConfigManager = SshConfigManager.getInstance((Project)this.myProject);
        sshConfigManager.startCollectingNotifications();
        for (WebServerConfig webServerConfig : ((State)state).servers) {
            if (StringUtil.isEmpty((String)webServerConfig.getId())) {
                webServerConfig.setId(WebServerConfig.getNextId());
            }
            webServerConfig.setIsProjectLevel(this.isProjectLevel);
            namedServers.add(com.intellij.openapi.util.Pair.create((Object)webServerConfig.getName(), (Object)webServerConfig));
            if (webServerConfig.getAccessType() == AccessType.SFTP && webServerConfig.getFileTransferConfig().isAnonymous()) {
                webServerConfig.getFileTransferConfig().setAnonymous(false);
                WebDeploymentCredentialHelper.saveCredentials(webServerConfig, "anonymous", "user@example.com", false);
            }
            this.myFlattenedServers.add(webServerConfig);
            if (webServerConfig.getFileTransferConfig().isConfiguredWithSshConfig()) {
                webServerConfig.loadDataFromSshConfigByInitialName(sshConfigManager);
                continue;
            }
            this.ensureSftpServersUseSshConfigs(webServerConfig, sshConfigManager);
        }
        sshConfigManager.handleNotifications(true);
        this.getAuthStorage().initServerAuthIfNeeded(this.myFlattenedServers);
        WebDeploymentCredentialHelper.syncWithPasswordSafe(this.myFlattenedServers, new OldXmlCredentialProvider());
        if (((State)state).groups != null) {
            for (GroupingInfo groupingInfo : ((State)state).groups) {
                List<String> serverNames = groupingInfo.myServerNames;
                if (serverNames.isEmpty()) {
                    this.myGroupedServers.add(WebServerGroupingWrap.create(groupingInfo.myGroupName, (List<WebServerConfig>)new SmartList(), this.isProjectLevel, groupingInfo.myMayChangeLevel));
                    continue;
                }
                String firstName = groupingInfo.myServerNames.get(0);
                while (!namedServers.isEmpty() && !firstName.equals(((com.intellij.openapi.util.Pair)namedServers.get((int)0)).first)) {
                    com.intellij.openapi.util.Pair pair = (com.intellij.openapi.util.Pair)namedServers.remove(0);
                    this.myGroupedServers.add(WebServerGroupingWrap.wrap((WebServerConfig)pair.second));
                }
                ArrayList<WebServerConfig> servers = new ArrayList<WebServerConfig>();
                for (String serverName : serverNames) {
                    if (namedServers.isEmpty() || !serverName.equals(((com.intellij.openapi.util.Pair)namedServers.get((int)0)).first)) break;
                    com.intellij.openapi.util.Pair remove = (com.intellij.openapi.util.Pair)namedServers.remove(0);
                    servers.add((WebServerConfig)remove.second);
                }
                this.myGroupedServers.add(WebServerGroupingWrap.create(groupingInfo.myGroupName, servers, this.isProjectLevel, groupingInfo.myMayChangeLevel));
            }
        }
        for (com.intellij.openapi.util.Pair pair : namedServers) {
            this.myGroupedServers.add(WebServerGroupingWrap.wrap((WebServerConfig)pair.second));
        }
        this.fireServersLoaded();
    }

    private void ensureSftpServersUseSshConfigs(@NotNull WebServerConfig server, @NotNull SshConfigManager sshConfigManager) {
        FileTransferConfig config;
        if (server == null) {
            WebServersConfigManagerBaseImpl.$$$reportNull$$$0(2);
        }
        if (sshConfigManager == null) {
            WebServersConfigManagerBaseImpl.$$$reportNull$$$0(3);
        }
        if ((config = server.getFileTransferConfig()).getAccessType() != AccessType.SFTP || config.isConfiguredWithSshConfig()) {
            return;
        }
        Pair<Credentials, Boolean> credentialsAndMemoryOnlyStatus = WebDeploymentCredentialHelper.getCredentialsAndMemoryOnlyStatus(server, false);
        Credentials credentials = (Credentials)credentialsAndMemoryOnlyStatus.getFirst();
        String username = credentials == null ? null : credentials.getUserName();
        String passwordOrPassphrase = credentials == null ? null : credentials.getPasswordAsString();
        AuthType authType = config.getAuthType();
        String password = authType == AuthType.PASSWORD ? passwordOrPassphrase : null;
        String passphrase = authType == AuthType.KEY_PAIR ? passwordOrPassphrase : null;
        boolean savePassword = authType == AuthType.PASSWORD && (Boolean)credentialsAndMemoryOnlyStatus.getSecond() == false;
        boolean savePassphrase = authType == AuthType.KEY_PAIR && (Boolean)credentialsAndMemoryOnlyStatus.getSecond() == false;
        SshConfig sshConfig = sshConfigManager.register(this.myProject != null, config.getHost(), config.getLiteralPort(), null, username, authType, password, passphrase, savePassword, savePassphrase, config.getPrivateKeyFile(), server.getName());
        config.setSshConfig(sshConfig);
    }

    protected abstract WebServersAuthStorage getAuthStorage();

    private void fireServersLoaded() {
        for (Listener listener : this.myListeners) {
            listener.serversLoaded();
        }
    }

    void addListener(Listener listener, Disposable parentDisposable) {
        ContainerUtil.add((Object)listener, this.myListeners, (Disposable)parentDisposable);
    }

    @NotNull
    List<WebServerConfig> getServers() {
        List<WebServerConfig> list = Collections.unmodifiableList(this.myFlattenedServers);
        if (list == null) {
            WebServersConfigManagerBaseImpl.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    List<WebServerGroupingWrap> getGroupedServers() {
        List<WebServerGroupingWrap> list = Collections.unmodifiableList(this.myGroupedServers);
        if (list == null) {
            WebServersConfigManagerBaseImpl.$$$reportNull$$$0(5);
        }
        return list;
    }

    void addServer(@NotNull WebServerConfig serverConfig) {
        if (serverConfig == null) {
            WebServersConfigManagerBaseImpl.$$$reportNull$$$0(6);
        }
        this.ensureSftpServersUseSshConfigs(serverConfig, SshConfigManager.getInstance((Project)this.myProject));
        serverConfig.loadDataFromSshConfigById(this.myProject);
        this.myFlattenedServers.add(serverConfig);
        this.myGroupedServers.add(WebServerGroupingWrap.wrap(serverConfig));
    }

    void addGroup(@NotNull WebServerGroupingWrap wrap) {
        if (wrap == null) {
            WebServersConfigManagerBaseImpl.$$$reportNull$$$0(7);
        }
        List<WebServerConfig> servers = wrap.getServers();
        SshConfigManager instance = SshConfigManager.getInstance((Project)this.myProject);
        instance.startCollectingNotifications();
        for (WebServerConfig server : servers) {
            this.ensureSftpServersUseSshConfigs(server, instance);
            server.loadDataFromSshConfigById(this.myProject);
        }
        this.myFlattenedServers.addAll(servers);
        this.myGroupedServers.add(wrap);
        instance.handleNotifications(false);
    }

    void addServerToSuitableGroup(@NotNull WebServerConfig server, @NotNull @NlsSafe String groupName, @Nullable WebServerGroupingWrap group, boolean mayChangeLevel) {
        if (server == null) {
            WebServersConfigManagerBaseImpl.$$$reportNull$$$0(8);
        }
        if (groupName == null) {
            WebServersConfigManagerBaseImpl.$$$reportNull$$$0(9);
        }
        SshConfigManager instance = SshConfigManager.getInstance((Project)this.myProject);
        instance.startCollectingNotifications();
        this.ensureSftpServersUseSshConfigs(server, SshConfigManager.getInstance((Project)this.myProject));
        server.loadDataFromSshConfigById(this.myProject);
        if (group == null) {
            group = WebServerGroupingWrap.create(groupName, Collections.singletonList(server), server.isProjectLevel(), mayChangeLevel);
            this.myGroupedServers.add(group);
        } else {
            group.addServer(server);
        }
        this.myFlattenedServers.add(server);
        instance.handleNotifications(false);
    }

    boolean removeServer(@NotNull WebServerConfig serverConfig) {
        if (serverConfig == null) {
            WebServersConfigManagerBaseImpl.$$$reportNull$$$0(10);
        }
        if (this.myFlattenedServers.remove(serverConfig)) {
            for (WebServerGroupingWrap group : this.myGroupedServers) {
                if (group.isSingleServer()) {
                    if (!serverConfig.equals(group.getAsSingleServer())) continue;
                    this.myGroupedServers.remove(group);
                    return true;
                }
                if (!group.removeServer(serverConfig)) continue;
                return true;
            }
        }
        return false;
    }

    void clearServersAndGroups() {
        this.myFlattenedServers.clear();
        this.myGroupedServers.clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/plugins/webDeployment/config/WebServersConfigManagerBaseImpl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "server";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sshConfigManager";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serverConfig";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wrap";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/plugins/webDeployment/config/WebServersConfigManagerBaseImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getServers";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupedServers";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "ensureSftpServersUseSshConfigs";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addServer";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addGroup";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addServerToSuitableGroup";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "removeServer";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static interface Listener {
        public void serversLoaded();
    }

    @com.intellij.openapi.components.State(name="WebServers", storages={@Storage(value="webServers.xml")}, allowLoadInTests=true)
    public static final class App
    extends WebServersConfigManagerBaseImpl<AppState> {
        private final Collection<Deployable> myServerIdsToReauth = Collections.synchronizedSet(new HashSet());
        @Deprecated
        @ApiStatus.ScheduledForRemoval(inVersion="2022.1")
        @Nullable
        private Element mySftpAdvancedOptions;

        public static App getInstance() {
            return (App)ApplicationManager.getApplication().getService(App.class);
        }

        public App() {
            super(null, false);
        }

        @Override
        protected AppState createState() {
            return new AppState();
        }

        @Override
        @NotNull
        public AppState getState() {
            AppState state = (AppState)super.getState();
            state.mySftpAdvancedOptions = this.mySftpAdvancedOptions;
            AppState appState = state;
            if (appState == null) {
                App.$$$reportNull$$$0(0);
            }
            return appState;
        }

        @Override
        public void loadState(@NotNull AppState state) {
            if (state == null) {
                App.$$$reportNull$$$0(1);
            }
            super.loadState(state);
            this.mySftpAdvancedOptions = state.mySftpAdvancedOptions;
        }

        @Override
        protected WebServersAuthStorage getAuthStorage() {
            return WebServersAuthStorage.AppInstance.getInstance();
        }

        public void setDeployableToReauth(Deployable deployable) {
            this.myServerIdsToReauth.add(deployable);
        }

        public boolean shouldReauth(Deployable deployable) {
            return this.myServerIdsToReauth.contains(deployable);
        }

        public void noMoreReauth(Deployable deployable) {
            this.myServerIdsToReauth.remove(deployable);
        }

        void resetReauthCache() {
            this.myServerIdsToReauth.clear();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/plugins/webDeployment/config/WebServersConfigManagerBaseImpl$App";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getState";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/plugins/webDeployment/config/WebServersConfigManagerBaseImpl$App";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "loadState";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class AppState
    extends State {
        @Deprecated
        @Tag(value="sftpAdvancedGlobalOptions")
        @ApiStatus.ScheduledForRemoval(inVersion="2022.1")
        public Element mySftpAdvancedOptions = new Element("sftpAdvancedGlobalOptions");
    }

    @com.intellij.openapi.components.State(name="WebServers", storages={@Storage(value="webServers.xml")}, allowLoadInTests=true)
    public static class ProjectInstance
    extends WebServersConfigManagerBaseImpl<State> {
        @NotNull
        private final Project myProject;

        public static ProjectInstance getInstance(@NotNull Project project) {
            if (project == null) {
                ProjectInstance.$$$reportNull$$$0(0);
            }
            return (ProjectInstance)project.getService(ProjectInstance.class);
        }

        public ProjectInstance(@NotNull Project project) {
            if (project == null) {
                ProjectInstance.$$$reportNull$$$0(1);
            }
            super(project, true);
            this.myProject = project;
        }

        @Override
        protected State createState() {
            return new State();
        }

        @Override
        protected WebServersAuthStorage getAuthStorage() {
            return WebServersAuthStorage.ProjectInstance.getInstance(this.myProject);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "project";
            objectArray2[1] = "com/jetbrains/plugins/webDeployment/config/WebServersConfigManagerBaseImpl$ProjectInstance";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getInstance";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class State {
        @XCollection
        public List<WebServerConfig> servers = new ArrayList<WebServerConfig>();
        @XCollection(style=XCollection.Style.v2, propertyElementName="groups")
        public List<GroupingInfo> groups = new ArrayList<GroupingInfo>();
    }

    @Tag(value="group")
    private static class GroupingInfo {
        @Tag(value="name")
        public String myGroupName;
        @Tag(value="mayChangeLevel")
        public boolean myMayChangeLevel = true;
        @XCollection(style=XCollection.Style.v2, propertyElementName="servers", elementName="name")
        public List<String> myServerNames = new SmartList();

        private GroupingInfo() {
        }
    }
}

