/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.statistic;

import com.intellij.internal.statistic.IdeActivityDefinition;
import com.intellij.internal.statistic.StructuredIdeActivity;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId1;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import com.intellij.openapi.project.Project;
import com.jetbrains.plugins.webDeployment.actions.createproject.CreateProjectModel;
import org.jetbrains.annotations.NotNull;

public final class DeploymentActivitiesUsageTriggerCollector
extends CounterUsagesCollector {
    private static final EventLogGroup GROUP = new EventLogGroup("deployment.activities", 4);
    private static final IdeActivityDefinition DOWNLOAD_ACTIVITY = GROUP.registerIdeActivity("download.action");
    private static final IdeActivityDefinition UPLOAD_ACTIVITY = GROUP.registerIdeActivity("upload.action");
    private static final EventField<Long> START_TIME = EventFields.Long((String)"start_time_ms");
    private static final EventField<Long> FINISH_TIME = EventFields.Long((String)"finish_time_ms");
    private static final EventField<Long> DURATION = EventFields.DurationMs;
    private static final VarargEventId UPLOAD_SESSION_FINISHED = GROUP.registerVarargEvent("autoupload.session.finished", new EventField[]{START_TIME, FINISH_TIME, DURATION});
    private static final EventId1<CreateProjectModel.Scenario> CREATE_PROJECT_FROM_EXISTING_SOURCES = GROUP.registerEvent("create.project.from.existing.sources", (EventField)EventFields.Enum((String)"scenario", CreateProjectModel.Scenario.class));

    public EventLogGroup getGroup() {
        return GROUP;
    }

    @NotNull
    public static StructuredIdeActivity logDownloadBegan(@NotNull Project project) {
        if (project == null) {
            DeploymentActivitiesUsageTriggerCollector.$$$reportNull$$$0(0);
        }
        StructuredIdeActivity structuredIdeActivity = DOWNLOAD_ACTIVITY.started(project);
        if (structuredIdeActivity == null) {
            DeploymentActivitiesUsageTriggerCollector.$$$reportNull$$$0(1);
        }
        return structuredIdeActivity;
    }

    public static void logDownloadFinished(@NotNull StructuredIdeActivity activity) {
        if (activity == null) {
            DeploymentActivitiesUsageTriggerCollector.$$$reportNull$$$0(2);
        }
        activity.finished();
    }

    @NotNull
    public static StructuredIdeActivity logUploadBegan(@NotNull Project project) {
        if (project == null) {
            DeploymentActivitiesUsageTriggerCollector.$$$reportNull$$$0(3);
        }
        StructuredIdeActivity structuredIdeActivity = UPLOAD_ACTIVITY.started(project);
        if (structuredIdeActivity == null) {
            DeploymentActivitiesUsageTriggerCollector.$$$reportNull$$$0(4);
        }
        return structuredIdeActivity;
    }

    public static void logUploadFinished(@NotNull StructuredIdeActivity activity) {
        if (activity == null) {
            DeploymentActivitiesUsageTriggerCollector.$$$reportNull$$$0(5);
        }
        activity.finished();
    }

    public static void logAutoUploadFinished(@NotNull Project project, long startTimestamp) {
        long finishTimestamp;
        long duration;
        if (project == null) {
            DeploymentActivitiesUsageTriggerCollector.$$$reportNull$$$0(6);
        }
        if ((duration = (finishTimestamp = System.currentTimeMillis()) - startTimestamp) < 1000L) {
            return;
        }
        UPLOAD_SESSION_FINISHED.log(project, new EventPair[]{START_TIME.with((Object)startTimestamp), FINISH_TIME.with((Object)finishTimestamp), EventFields.DurationMs.with((Object)duration)});
    }

    public static void logCreateProjectFromExistingSources(@NotNull CreateProjectModel.Scenario scenario) {
        if (scenario == null) {
            DeploymentActivitiesUsageTriggerCollector.$$$reportNull$$$0(7);
        }
        CREATE_PROJECT_FROM_EXISTING_SOURCES.log((Object)scenario);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/plugins/webDeployment/statistic/DeploymentActivitiesUsageTriggerCollector";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activity";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scenario";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/plugins/webDeployment/statistic/DeploymentActivitiesUsageTriggerCollector";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "logDownloadBegan";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "logUploadBegan";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "logDownloadBegan";
                break;
            }
            case 1: 
            case 4: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "logDownloadFinished";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "logUploadBegan";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "logUploadFinished";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "logAutoUploadFinished";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "logCreateProjectFromExistingSources";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

