/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.actions.images;

import com.google.common.base.Strings;
import com.google.common.net.MediaType;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.fileChooser.FileSaverDialog;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssUri;
import com.intellij.psi.css.actions.CssBaseElementAtCaretIntentionAction;
import com.intellij.psi.css.impl.util.CssUtil;
import com.intellij.psi.css.util.CssUriUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.io.URLUtil;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class CssExtractImageFromDataUriIntention
extends CssBaseElementAtCaretIntentionAction {
    private static final Logger LOG = Logger.getInstance(CssExtractImageFromDataUriIntention.class);
    @Nullable
    private VirtualFileWrapper myFileToExtract;

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            CssExtractImageFromDataUriIntention.$$$reportNull$$$0(0);
        }
        if (element == null) {
            CssExtractImageFromDataUriIntention.$$$reportNull$$$0(1);
        }
        return super.isAvailable(project, editor, element) && CssUriUtil.isDataUri(PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{CssUri.class}));
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        VirtualFileWrapper savedFile;
        CssUri cssUri;
        if (project == null) {
            CssExtractImageFromDataUriIntention.$$$reportNull$$$0(2);
        }
        if (element == null) {
            CssExtractImageFromDataUriIntention.$$$reportNull$$$0(3);
        }
        if ((cssUri = (CssUri)PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{CssUri.class})) == null || !CssUriUtil.isDataUri((PsiElement)cssUri)) {
            return;
        }
        String cssUriValue = cssUri.getValue();
        byte[] imageBytes = URLUtil.getBytesFromDataUri((String)cssUriValue);
        if (imageBytes == null) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)CssBundle.message((String)"css.intentions.extract.image.cannot.read.data.uri", (Object[])new Object[0]), (String)"", null);
            return;
        }
        MediaType mediaType = CssUtil.getMediaTypeFromDataUri(cssUriValue);
        if (mediaType == null) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)CssBundle.message((String)"css.intentions.extract.image.cannot.define.image.type", (Object[])new Object[0]), (String)"", null);
            return;
        }
        if (this.myFileToExtract == null) {
            String fileExtension = mediaType.subtype().replace('+', '.');
            FileSaverDescriptor descriptor = new FileSaverDescriptor(CssBundle.message((String)"css.intentions.extract.image.save.dialog.title", (Object[])new Object[0]), "", new String[]{fileExtension});
            FileSaverDialog saverDialog = FileChooserFactory.getInstance().createSaveFileDialog(descriptor, project);
            savedFile = saverDialog.save(project.getBaseDir(), null);
        } else {
            savedFile = this.myFileToExtract;
        }
        if (savedFile == null) {
            return;
        }
        try {
            Boolean r = FileUtil.isAncestor((String)project.getBasePath(), (String)savedFile.getFile().getPath(), (boolean)true) ? (Boolean)WriteCommandAction.writeCommandAction((Project)project, (PsiFile[])new PsiFile[]{element.getContainingFile()}).withName(CssBundle.message((String)"css.intentions.extract.image.title", (Object[])new Object[0])).compute(() -> {
                PsiFile createdPsiFile;
                PsiDirectory directory;
                VirtualFile createdFile = savedFile.getVirtualFile();
                CssExtractImageFromDataUriIntention.deleteFileIfExists(createdFile, project);
                File createdIoFile = savedFile.getFile();
                VirtualFile virtualDirectory = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(createdIoFile.getParentFile());
                if (virtualDirectory != null && (directory = PsiManager.getInstance((Project)project).findDirectory(virtualDirectory)) != null && (createdFile = (createdPsiFile = directory.createFile(createdIoFile.getName())).getVirtualFile()) != null) {
                    createdFile.setBinaryContent(imageBytes);
                    CssExtractImageFromDataUriIntention.replaceCssUriWithReferenceToFile(cssUri, createdFile, project);
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }) : (Boolean)WriteCommandAction.writeCommandAction((Project)project, (PsiFile[])new PsiFile[]{element.getContainingFile()}).withName(CssBundle.message((String)"css.intentions.extract.image.title", (Object[])new Object[0])).compute(() -> {
                VirtualFile file = savedFile.getVirtualFile(true);
                if (file != null) {
                    file.setBinaryContent(imageBytes);
                    cssUri.setValue(Strings.nullToEmpty((String)file.getCanonicalPath()));
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            });
            if (!r.booleanValue()) {
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)CssBundle.message((String)"css.intentions.extract.image.cannot.save.file", (Object[])new Object[0]), (String)"", null);
            }
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    @TestOnly
    public void setFileToExtract(@Nullable VirtualFileWrapper fileToExtract) {
        this.myFileToExtract = fileToExtract;
    }

    private static void deleteFileIfExists(@Nullable VirtualFile createdFile, @NotNull Project project) {
        PsiFile existingFile;
        if (project == null) {
            CssExtractImageFromDataUriIntention.$$$reportNull$$$0(4);
        }
        if (createdFile != null && (existingFile = PsiManager.getInstance((Project)project).findFile(createdFile)) != null) {
            existingFile.delete();
        }
    }

    private static void replaceCssUriWithReferenceToFile(@NotNull CssUri cssUri, @NotNull VirtualFile createdFile, @NotNull Project project) {
        String path;
        if (cssUri == null) {
            CssExtractImageFromDataUriIntention.$$$reportNull$$$0(5);
        }
        if (createdFile == null) {
            CssExtractImageFromDataUriIntention.$$$reportNull$$$0(6);
        }
        if (project == null) {
            CssExtractImageFromDataUriIntention.$$$reportNull$$$0(7);
        }
        if ((path = VfsUtilCore.getRelativePath((VirtualFile)createdFile, (VirtualFile)project.getBaseDir(), (char)'/')) != null) {
            PsiElement newValueElement = cssUri.setValue("/" + path);
            PsiFile referenceTarget = PsiManager.getInstance((Project)project).findFile(createdFile);
            if (newValueElement != null && referenceTarget != null) {
                CssUtil.rebindFileReference(newValueElement, referenceTarget);
            }
        }
    }

    @NotNull
    public String getText() {
        String string = CssBundle.message((String)"css.intentions.extract.image", (Object[])new Object[0]);
        if (string == null) {
            CssExtractImageFromDataUriIntention.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = CssBundle.message((String)"css.intentions.extract.image", (Object[])new Object[0]);
        if (string == null) {
            CssExtractImageFromDataUriIntention.$$$reportNull$$$0(9);
        }
        return string;
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cssUri";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "createdFile";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/actions/images/CssExtractImageFromDataUriIntention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/actions/images/CssExtractImageFromDataUriIntention";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "deleteFileIfExists";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "replaceCssUriWithReferenceToFile";
                break;
            }
            case 8: 
            case 9: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

