/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl;

import com.intellij.css.util.CssPsiUtil;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.css.CssElementFactory;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.CssString;
import com.intellij.psi.css.CssTerm;
import com.intellij.psi.css.CssUri;
import com.intellij.psi.css.impl.CssElementImpl;
import com.intellij.psi.css.impl.CssElementTypes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class CssUriImpl
extends CssElementImpl
implements CssUri {
    CssUriImpl() {
        super(CssElementTypes.CSS_URI);
    }

    @NotNull
    public String getValue() {
        PsiElement element = this.getValueElement();
        return element != null ? element.getText() : "";
    }

    @Nullable
    public PsiElement getValueElement() {
        PsiElement element;
        PsiElement[] children = this.getChildren();
        PsiElement psiElement = element = children.length > 2 ? children[2] : null;
        if (element instanceof PsiWhiteSpace) {
            element = element.getNextSibling();
        }
        if (element instanceof PsiErrorElement) {
            return null;
        }
        if (element instanceof CssTerm && (children = element.getChildren()).length == 1) {
            return (element = element.getFirstChild()) instanceof CssString ? element : null;
        }
        return element;
    }

    @Nullable
    public PsiElement setValue(@NotNull String newValueString) {
        if (newValueString == null) {
            CssUriImpl.$$$reportNull$$$0(0);
        }
        PsiElement valueElement = this.getValueElement();
        if (this.isValid() && valueElement != null) {
            Language language = CssPsiUtil.getStylesheetLanguage((PsiElement)this);
            CssElementFactory elementFactory = CssElementFactory.getInstance((Project)this.getProject());
            String text = valueElement.getText().trim();
            Object newValueElement = StringUtil.isQuotedString((String)text) ? elementFactory.createString(text.charAt(0), newValueString, language) : elementFactory.createUri(newValueString, language).getValueElement();
            if (newValueElement != null) {
                return valueElement.replace(newValueElement);
            }
        }
        return null;
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            CssUriImpl.$$$reportNull$$$0(1);
        }
        if (visitor instanceof CssElementVisitor) {
            ((CssElementVisitor)visitor).visitCssUri((CssUri)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public boolean isValidHost() {
        return true;
    }

    public PsiLanguageInjectionHost updateText(@NotNull String text) {
        if (text == null) {
            CssUriImpl.$$$reportNull$$$0(2);
        }
        return (PsiLanguageInjectionHost)ElementManipulators.handleContentChange((PsiElement)this, (String)text);
    }

    @NotNull
    public LiteralTextEscaper<? extends PsiLanguageInjectionHost> createLiteralTextEscaper() {
        LiteralTextEscaper literalTextEscaper = LiteralTextEscaper.createSimple((PsiLanguageInjectionHost)this);
        if (literalTextEscaper == null) {
            CssUriImpl.$$$reportNull$$$0(3);
        }
        return literalTextEscaper;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newValueString";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/impl/CssUriImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/impl/CssUriImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createLiteralTextEscaper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setValue";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "updateText";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

