/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util.references;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.css.CssAttribute;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssPropertyDescriptor;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.util.CssUtil;
import com.intellij.psi.css.reference.CssReference;
import com.intellij.psi.impl.source.resolve.reference.impl.PsiPolyVariantCachingReference;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssIdentifierReference
extends PsiPolyVariantCachingReference
implements CssReference {
    private static final TokenSet FUNCTION_TYPES = TokenSet.create((IElementType[])new IElementType[]{CssElementTypes.CSS_FUNCTION_TOKEN, CssElementTypes.CSS_FUNCTION});
    private final PsiElement myElement;

    public CssIdentifierReference(PsiElement element) {
        this.myElement = element;
    }

    @NotNull
    public PsiElement getElement() {
        PsiElement psiElement = this.myElement;
        if (psiElement == null) {
            CssIdentifierReference.$$$reportNull$$$0(0);
        }
        return psiElement;
    }

    @NotNull
    public TextRange getRangeInElement() {
        return new TextRange(0, this.myElement.getTextLength());
    }

    protected ResolveResult @NotNull [] resolveInner(boolean incompleteCode, @NotNull PsiFile containingFile) {
        if (containingFile == null) {
            CssIdentifierReference.$$$reportNull$$$0(1);
        }
        ResolveResult[] resolveResultArray = PsiElementResolveResult.createResults((PsiElement[])this.findDeclarations());
        if (resolveResultArray == null) {
            CssIdentifierReference.$$$reportNull$$$0(2);
        }
        return resolveResultArray;
    }

    private PsiElement[] findDeclarations() {
        CssDeclaration psiElement;
        if (CssUtil.isCssDeclaration(this.myElement)) {
            CssDeclaration parent = (CssDeclaration)this.myElement.getParent();
            CssPropertyDescriptor descriptor = parent.getDescriptor();
            if (descriptor != null) {
                PsiElement[] psiElementArray;
                PsiElement[] declaration = descriptor.getDeclarations((PsiElement)parent);
                if (declaration.length > 0) {
                    psiElementArray = declaration;
                } else {
                    PsiElement[] psiElementArray2 = new PsiElement[1];
                    psiElementArray = psiElementArray2;
                    psiElementArray2[0] = parent;
                }
                return psiElementArray;
            }
        } else if (FUNCTION_TYPES.contains(this.myElement.getNode().getElementType()) && (psiElement = CssUtil.getDeclaration(this.myElement)) != null && !psiElement.getDescriptors().isEmpty()) {
            return new PsiElement[]{psiElement};
        }
        return PsiElement.EMPTY_ARRAY;
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.myElement.getText();
        if (string == null) {
            CssIdentifierReference.$$$reportNull$$$0(3);
        }
        return string;
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        if (newElementName == null) {
            CssIdentifierReference.$$$reportNull$$$0(4);
        }
        return null;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            CssIdentifierReference.$$$reportNull$$$0(5);
        }
        return null;
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        ResolveResult[] results;
        if (element == null) {
            CssIdentifierReference.$$$reportNull$$$0(6);
        }
        for (ResolveResult result : results = this.multiResolve(false)) {
            if (!this.getElement().getManager().areElementsEquivalent(element, result.getElement())) continue;
            return true;
        }
        return false;
    }

    private static boolean isAttribute(@Nullable PsiElement element) {
        return element != null && element.getParent() instanceof CssAttribute;
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        return "";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/impl/util/references/CssIdentifierReference";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/impl/util/references/CssIdentifierReference";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveInner";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "resolveInner";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

