/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.inspections.invalid;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.CssTerm;
import com.intellij.psi.css.impl.CssTermTypes;
import com.intellij.psi.css.impl.util.table.CssPropertyUtil;
import com.intellij.psi.css.inspections.CssBaseInspection;
import com.intellij.psi.css.resolve.CssComposesClassReference;
import com.intellij.psi.css.resolve.CssResolveManager;
import com.intellij.psi.css.resolve.CssValueReference;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;

public class CssUnresolvedClassInComposesRuleInspection
extends CssBaseInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            CssUnresolvedClassInComposesRuleInspection.$$$reportNull$$$0(0);
        }
        return new CssElementVisitor(){

            public void visitCssDeclaration(CssDeclaration declaration) {
                if (!CssPropertyUtil.isComposesProperty(declaration) || declaration.getValue() == null) {
                    return;
                }
                CssTerm[] terms = declaration.getValue().getTerms();
                if (!CssUnresolvedClassInComposesRuleInspection.isFilePathResolved(terms)) {
                    return;
                }
                for (CssTerm term : terms) {
                    CssUnresolvedClassInComposesRuleInspection.checkTerm(holder, term);
                }
            }
        };
    }

    private static void checkTerm(@NotNull ProblemsHolder holder, @NotNull CssTerm term) {
        if (holder == null) {
            CssUnresolvedClassInComposesRuleInspection.$$$reportNull$$$0(1);
        }
        if (term == null) {
            CssUnresolvedClassInComposesRuleInspection.$$$reportNull$$$0(2);
        }
        PsiElement child = term.getFirstChild();
        PsiReference[] references = child.getReferences();
        for (int i = 0; i < references.length; ++i) {
            PsiReference reference = references[i];
            if (reference instanceof CssValueReference && reference.resolve() != null) {
                return;
            }
            if (!(reference instanceof CssComposesClassReference) || !ArrayUtil.isEmpty((Object[])((CssComposesClassReference)reference).multiResolve(false))) continue;
            for (int j = i + 1; j < references.length; ++j) {
                PsiReference otherReference = references[j];
                if (!(otherReference instanceof CssValueReference) || otherReference.resolve() == null) continue;
                return;
            }
            holder.registerProblem(child, ((CssComposesClassReference)reference).getUnresolvedMessagePattern(), new LocalQuickFix[0]);
        }
    }

    private static boolean isFilePathResolved(CssTerm @NotNull [] terms) {
        CssTerm lastTerm;
        if (terms == null) {
            CssUnresolvedClassInComposesRuleInspection.$$$reportNull$$$0(3);
        }
        if ((lastTerm = (CssTerm)ArrayUtil.getLastElement((Object[])terms)) == null) {
            return false;
        }
        return lastTerm.getTermType() != CssTermTypes.STRING || !ArrayUtil.isEmpty((Object[])CssResolveManager.getInstance().resolveFiles(lastTerm.getFirstChild()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "term";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "terms";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/css/inspections/invalid/CssUnresolvedClassInComposesRuleInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "checkTerm";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isFilePathResolved";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

