/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.less.fileStructure;

import com.intellij.css.util.CssPsiUtil;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.treeView.smartTree.Filter;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.CssRuleset;
import com.intellij.psi.css.impl.structure.CssStructureViewElement;
import com.intellij.psi.css.impl.structure.CssStructureViewElementsProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.less.LESSLanguage;
import org.jetbrains.plugins.less.fileStructure.LessVariableStructureViewElement;
import org.jetbrains.plugins.less.fileStructure.LessVariablesFilter;
import org.jetbrains.plugins.less.psi.LESSVariableDeclaration;
import org.jetbrains.plugins.less.psi.LessParameter;
import org.jetbrains.plugins.less.psi.impl.LESSPrimitiveMixin;
import org.jetbrains.plugins.less.psi.impl.LESSRegularMixin;

public class LessStructureViewElementsProvider
extends CssStructureViewElementsProvider {
    private static final Filter[] LESS_FILTERS = new Filter[]{new LessVariablesFilter()};
    private static final Class[] LESS_SUITABLE_CLASSES = new Class[]{LESSVariableDeclaration.class, LESSRegularMixin.class, LESSPrimitiveMixin.class};

    @NotNull
    public Collection<? extends CssStructureViewElement> createStructureViewElements(@NotNull PsiElement element) {
        if (element == null) {
            LessStructureViewElementsProvider.$$$reportNull$$$0(0);
        }
        if (element.getLanguage() != LESSLanguage.INSTANCE || this.shouldSkipElement(element)) {
            List list = Collections.emptyList();
            if (list == null) {
                LessStructureViewElementsProvider.$$$reportNull$$$0(1);
            }
            return list;
        }
        if (element instanceof LESSVariableDeclaration) {
            List<LessVariableStructureViewElement> list = Collections.singletonList(new LessVariableStructureViewElement((LESSVariableDeclaration)element));
            if (list == null) {
                LessStructureViewElementsProvider.$$$reportNull$$$0(2);
            }
            return list;
        }
        if (element instanceof LESSRegularMixin) {
            List<CssStructureViewElement> list = Collections.singletonList(CssStructureViewElement.create((PsiElement)element));
            if (list == null) {
                LessStructureViewElementsProvider.$$$reportNull$$$0(3);
            }
            return list;
        }
        if (element instanceof LESSPrimitiveMixin) {
            CssRuleset[] rulesets;
            ArrayList<CssStructureViewElement> result = new ArrayList<CssStructureViewElement>();
            for (CssRuleset ruleset : rulesets = ((LESSPrimitiveMixin)element).getRulesets()) {
                String presentableText = ruleset.getPresentableText();
                if (presentableText.isEmpty()) continue;
                result.add(CssStructureViewElement.create((PsiElement)ruleset, (PsiElement)element, (Icon)AllIcons.Xml.Css_class, (String)presentableText));
            }
            ArrayList<CssStructureViewElement> arrayList = result;
            if (arrayList == null) {
                LessStructureViewElementsProvider.$$$reportNull$$$0(4);
            }
            return arrayList;
        }
        List list = Collections.emptyList();
        if (list == null) {
            LessStructureViewElementsProvider.$$$reportNull$$$0(5);
        }
        return list;
    }

    public boolean isMyContext(PsiElement element) {
        return LESSLanguage.INSTANCE.is(CssPsiUtil.getStylesheetLanguage((PsiElement)element));
    }

    public Filter @NotNull [] getFilters() {
        if (LESS_FILTERS == null) {
            LessStructureViewElementsProvider.$$$reportNull$$$0(6);
        }
        return LESS_FILTERS;
    }

    public Class @NotNull [] getSuitableClasses() {
        if (LESS_SUITABLE_CLASSES == null) {
            LessStructureViewElementsProvider.$$$reportNull$$$0(7);
        }
        return LESS_SUITABLE_CLASSES;
    }

    public boolean hasInnerStructure(@NotNull PsiElement element) {
        if (element == null) {
            LessStructureViewElementsProvider.$$$reportNull$$$0(8);
        }
        return false;
    }

    public boolean shouldSkipElement(@NotNull PsiElement element) {
        if (element == null) {
            LessStructureViewElementsProvider.$$$reportNull$$$0(9);
        }
        return element instanceof LESSVariableDeclaration && element.getParent() instanceof LessParameter;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/less/fileStructure/LessStructureViewElementsProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/less/fileStructure/LessStructureViewElementsProvider";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createStructureViewElements";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilters";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuitableClasses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createStructureViewElements";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "hasInnerStructure";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "shouldSkipElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

