/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.nativeplatform.tooling.model.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.DefaultExternalTask;
import org.jetbrains.plugins.gradle.model.ExternalTask;
import org.jetbrains.plugins.gradle.nativeplatform.tooling.model.CompilationDetails;
import org.jetbrains.plugins.gradle.nativeplatform.tooling.model.MacroDirective;
import org.jetbrains.plugins.gradle.nativeplatform.tooling.model.SourceFile;
import org.jetbrains.plugins.gradle.nativeplatform.tooling.model.impl.MacroDirectiveImpl;
import org.jetbrains.plugins.gradle.nativeplatform.tooling.model.impl.SourceFileImpl;

public class CompilationDetailsImpl
implements CompilationDetails {
    private File compilerExecutable;
    private ExternalTask compileTask;
    private File compileWorkingDir;
    @NotNull
    private List<File> frameworkSearchPaths;
    @NotNull
    private List<File> systemHeaderSearchPaths;
    @NotNull
    private List<File> userHeaderSearchPaths;
    @NotNull
    private Set<SourceFile> sources;
    @NotNull
    private Set<File> headerDirs;
    @NotNull
    private Set<MacroDirective> macroDefines;
    @NotNull
    private Set<String> macroUndefines;
    @NotNull
    private List<String> additionalArgs;

    public CompilationDetailsImpl() {
        this.frameworkSearchPaths = Collections.emptyList();
        this.systemHeaderSearchPaths = Collections.emptyList();
        this.userHeaderSearchPaths = Collections.emptyList();
        this.sources = Collections.emptySet();
        this.headerDirs = Collections.emptySet();
        this.macroDefines = Collections.emptySet();
        this.macroUndefines = Collections.emptySet();
        this.additionalArgs = Collections.emptyList();
    }

    public CompilationDetailsImpl(CompilationDetails compilationDetails) {
        this.compilerExecutable = compilationDetails.getCompilerExecutable();
        this.compileTask = new DefaultExternalTask(compilationDetails.getCompileTask());
        this.compileWorkingDir = compilationDetails.getCompileWorkingDir();
        this.frameworkSearchPaths = new ArrayList<File>(compilationDetails.getFrameworkSearchPaths());
        this.systemHeaderSearchPaths = new ArrayList<File>(compilationDetails.getSystemHeaderSearchPaths());
        this.userHeaderSearchPaths = new ArrayList<File>(compilationDetails.getUserHeaderSearchPaths());
        this.sources = new LinkedHashSet<SourceFile>(compilationDetails.getSources().size());
        for (SourceFile sourceFile : compilationDetails.getSources()) {
            this.sources.add(new SourceFileImpl(sourceFile));
        }
        this.headerDirs = new LinkedHashSet<File>(compilationDetails.getHeaderDirs());
        this.macroDefines = new LinkedHashSet<MacroDirective>(compilationDetails.getMacroDefines().size());
        for (MacroDirective macroDirective : compilationDetails.getMacroDefines()) {
            this.macroDefines.add(new MacroDirectiveImpl(macroDirective));
        }
        this.macroUndefines = new LinkedHashSet<String>(compilationDetails.getMacroUndefines());
        this.additionalArgs = new ArrayList<String>(compilationDetails.getAdditionalArgs());
    }

    @Override
    public ExternalTask getCompileTask() {
        return this.compileTask;
    }

    public void setCompileTask(ExternalTask compileTask) {
        this.compileTask = compileTask;
    }

    @Override
    @Nullable
    public File getCompilerExecutable() {
        return this.compilerExecutable;
    }

    public void setCompilerExecutable(File compilerExecutable) {
        this.compilerExecutable = compilerExecutable;
    }

    @Override
    public File getCompileWorkingDir() {
        return this.compileWorkingDir;
    }

    public void setCompileWorkingDir(File compileWorkingDir) {
        this.compileWorkingDir = compileWorkingDir;
    }

    @Override
    @NotNull
    public List<File> getFrameworkSearchPaths() {
        List<File> list = this.frameworkSearchPaths;
        if (list == null) {
            CompilationDetailsImpl.$$$reportNull$$$0(0);
        }
        return list;
    }

    public void setFrameworkSearchPaths(@NotNull List<File> frameworkSearchPaths) {
        if (frameworkSearchPaths == null) {
            CompilationDetailsImpl.$$$reportNull$$$0(1);
        }
        this.frameworkSearchPaths = frameworkSearchPaths;
    }

    @Override
    @NotNull
    public List<File> getSystemHeaderSearchPaths() {
        List<File> list = this.systemHeaderSearchPaths;
        if (list == null) {
            CompilationDetailsImpl.$$$reportNull$$$0(2);
        }
        return list;
    }

    public void setSystemHeaderSearchPaths(@NotNull List<File> systemHeaderSearchPaths) {
        if (systemHeaderSearchPaths == null) {
            CompilationDetailsImpl.$$$reportNull$$$0(3);
        }
        this.systemHeaderSearchPaths = systemHeaderSearchPaths;
    }

    @Override
    @NotNull
    public List<File> getUserHeaderSearchPaths() {
        List<File> list = this.userHeaderSearchPaths;
        if (list == null) {
            CompilationDetailsImpl.$$$reportNull$$$0(4);
        }
        return list;
    }

    public void setUserHeaderSearchPaths(@NotNull List<File> userHeaderSearchPaths) {
        if (userHeaderSearchPaths == null) {
            CompilationDetailsImpl.$$$reportNull$$$0(5);
        }
        this.userHeaderSearchPaths = userHeaderSearchPaths;
    }

    @Override
    @NotNull
    public Set<? extends SourceFile> getSources() {
        Set<SourceFile> set = this.sources;
        if (set == null) {
            CompilationDetailsImpl.$$$reportNull$$$0(6);
        }
        return set;
    }

    public void setSources(@NotNull Set<SourceFile> sources) {
        if (sources == null) {
            CompilationDetailsImpl.$$$reportNull$$$0(7);
        }
        this.sources = sources;
    }

    @Override
    @NotNull
    public Set<File> getHeaderDirs() {
        Set<File> set = this.headerDirs;
        if (set == null) {
            CompilationDetailsImpl.$$$reportNull$$$0(8);
        }
        return set;
    }

    public void setHeaderDirs(@NotNull Set<File> headerDirs) {
        if (headerDirs == null) {
            CompilationDetailsImpl.$$$reportNull$$$0(9);
        }
        this.headerDirs = headerDirs;
    }

    @Override
    @NotNull
    public Set<? extends MacroDirective> getMacroDefines() {
        Set<MacroDirective> set = this.macroDefines;
        if (set == null) {
            CompilationDetailsImpl.$$$reportNull$$$0(10);
        }
        return set;
    }

    public void setMacroDefines(@NotNull Set<MacroDirective> macroDefines) {
        if (macroDefines == null) {
            CompilationDetailsImpl.$$$reportNull$$$0(11);
        }
        this.macroDefines = macroDefines;
    }

    @Override
    @NotNull
    public Set<String> getMacroUndefines() {
        Set<String> set = this.macroUndefines;
        if (set == null) {
            CompilationDetailsImpl.$$$reportNull$$$0(12);
        }
        return set;
    }

    public void setMacroUndefines(@NotNull Set<String> macroUndefines) {
        if (macroUndefines == null) {
            CompilationDetailsImpl.$$$reportNull$$$0(13);
        }
        this.macroUndefines = macroUndefines;
    }

    @Override
    @NotNull
    public List<String> getAdditionalArgs() {
        List<String> list = this.additionalArgs;
        if (list == null) {
            CompilationDetailsImpl.$$$reportNull$$$0(14);
        }
        return list;
    }

    public void setAdditionalArgs(@NotNull List<String> additionalArgs) {
        if (additionalArgs == null) {
            CompilationDetailsImpl.$$$reportNull$$$0(15);
        }
        this.additionalArgs = additionalArgs;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/nativeplatform/tooling/model/impl/CompilationDetailsImpl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frameworkSearchPaths";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "systemHeaderSearchPaths";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "userHeaderSearchPaths";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sources";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "headerDirs";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "macroDefines";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "macroUndefines";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalArgs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFrameworkSearchPaths";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/nativeplatform/tooling/model/impl/CompilationDetailsImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemHeaderSearchPaths";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getUserHeaderSearchPaths";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSources";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getHeaderDirs";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getMacroDefines";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getMacroUndefines";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalArgs";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setFrameworkSearchPaths";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setSystemHeaderSearchPaths";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setUserHeaderSearchPaths";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setSources";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setHeaderDirs";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setMacroDefines";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setMacroUndefines";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setAdditionalArgs";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

