/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.events;

import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.BaseEventId;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.ListEventField;
import com.intellij.internal.statistic.eventLog.events.ObjectEventField;
import com.intellij.internal.statistic.eventLog.events.ObjectListEventField;
import com.intellij.internal.statistic.eventLog.events.PrimitiveEventField;
import com.intellij.internal.statistic.eventLog.events.StringEventField;
import com.intellij.internal.statistic.eventLog.events.StringListEventField;
import com.intellij.internal.statistic.service.fus.collectors.ApplicationUsagesCollector;
import com.intellij.internal.statistic.service.fus.collectors.FUCounterUsageLogger;
import com.intellij.internal.statistic.service.fus.collectors.FeatureUsagesCollector;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.openapi.extensions.ExtensionPointName;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0005'()*+B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0007J6\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b0\u0007j\b\u0012\u0004\u0012\u00020\b`\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0002J?\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u00102\u0006\u0010\u0011\u001a\u00020\r2\u0012\u0010\u0012\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00140\u00132\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0002\u00a2\u0006\u0002\u0010\u0015J\"\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00050\u00172\u0006\u0010\u0018\u001a\u00020\r2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aJ.\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\b0\u00042\u0006\u0010\u001f\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0002J2\u0010 \u001a\b\u0012\u0004\u0012\u00020\b0\u00102\n\u0010!\u001a\u0006\u0012\u0002\b\u00030\u00142\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0002J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u001bH\u0002J\u0010\u0010%\u001a\u00020#2\u0006\u0010&\u001a\u00020\rH\u0002\u00a8\u0006,"}, d2={"Lcom/intellij/internal/statistic/eventLog/events/EventsSchemeBuilder;", "", "()V", "buildEventsScheme", "", "Lcom/intellij/internal/statistic/eventLog/events/EventsSchemeBuilder$GroupDescriptor;", "buildFields", "Ljava/util/HashSet;", "Lcom/intellij/internal/statistic/eventLog/events/EventsSchemeBuilder$FieldDescriptor;", "Lkotlin/collections/HashSet;", "events", "Lcom/intellij/internal/statistic/eventLog/events/BaseEventId;", "eventName", "", "groupId", "buildObjectEvenScheme", "", "fieldName", "fields", "", "Lcom/intellij/internal/statistic/eventLog/events/EventField;", "(Ljava/lang/String;[Lcom/intellij/internal/statistic/eventLog/events/EventField;Ljava/lang/String;Ljava/lang/String;)Ljava/util/Set;", "collectGroupsFromExtensions", "", "groupType", "collectors", "", "Lcom/intellij/internal/statistic/service/fus/collectors/FeatureUsagesCollector;", "defineDataType", "Lcom/intellij/internal/statistic/eventLog/events/EventsSchemeBuilder$FieldDataType;", "values", "name", "fieldSchema", "field", "validateGroupId", "", "collector", "validateRegexp", "regexp", "EventDescriptor", "EventsScheme", "FieldDataType", "FieldDescriptor", "GroupDescriptor", "intellij.platform.statistics"})
public final class EventsSchemeBuilder {
    @NotNull
    public static final EventsSchemeBuilder INSTANCE;

    private final Set<FieldDescriptor> fieldSchema(EventField<?> field, String fieldName, String eventName, String groupId) {
        Set set;
        if (StringsKt.contains$default((CharSequence)field.getName(), (CharSequence)".", (boolean)false, (int)2, null)) {
            throw (Throwable)new IllegalStateException("Field name should not contains dots, because dots are used to express hierarchy. " + "Group=" + groupId + ", event=" + eventName + ", field=" + field.getName());
        }
        if (Intrinsics.areEqual(field, EventFields.PluginInfo) || Intrinsics.areEqual(field, EventFields.PluginInfoFromInstance)) {
            return SetsKt.hashSetOf((Object[])new FieldDescriptor[]{new FieldDescriptor("plugin", SetsKt.hashSetOf((Object[])new String[]{"{util#plugin}"}), null, 4, null), new FieldDescriptor("plugin_type", SetsKt.hashSetOf((Object[])new String[]{"{util#plugin_type}"}), null, 4, null), new FieldDescriptor("plugin_version", SetsKt.hashSetOf((Object[])new String[]{"{util#plugin_version}"}), null, 4, null)});
        }
        EventField<?> eventField = field;
        if (eventField instanceof ObjectEventField) {
            set = this.buildObjectEvenScheme(fieldName, ((ObjectEventField)field).getFields(), eventName, groupId);
        } else if (eventField instanceof ObjectListEventField) {
            set = this.buildObjectEvenScheme(fieldName, ((ObjectListEventField)field).getFields(), eventName, groupId);
        } else if (eventField instanceof ListEventField) {
            if (field instanceof StringListEventField.ValidatedByInlineRegexp) {
                this.validateRegexp(((StringListEventField.ValidatedByInlineRegexp)field).getRegexp());
            }
            set = SetsKt.hashSetOf((Object[])new FieldDescriptor[]{new FieldDescriptor(fieldName, CollectionsKt.toHashSet((Iterable)((ListEventField)field).getValidationRule()), FieldDataType.ARRAY)});
        } else if (eventField instanceof PrimitiveEventField) {
            if (field instanceof StringEventField.ValidatedByInlineRegexp) {
                this.validateRegexp(((StringEventField.ValidatedByInlineRegexp)field).getRegexp());
            }
            set = SetsKt.hashSetOf((Object[])new FieldDescriptor[]{new FieldDescriptor(fieldName, CollectionsKt.toHashSet((Iterable)((PrimitiveEventField)field).getValidationRule()), null, 4, null)});
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return set;
    }

    private final void validateRegexp(String regexp) {
        if (Intrinsics.areEqual((Object)regexp, (Object)".*")) {
            throw (Throwable)new IllegalStateException("Regexp should be more strict to prevent accidentally reporting sensitive data.");
        }
        Pattern.compile(regexp);
    }

    private final Set<FieldDescriptor> buildObjectEvenScheme(String fieldName, EventField<?>[] fields, String eventName, String groupId) {
        boolean bl = false;
        HashSet fieldsDescriptors = new HashSet();
        for (EventField<?> eventField : fields) {
            fieldsDescriptors.addAll(this.fieldSchema(eventField, fieldName + "." + eventField.getName(), eventName, groupId));
        }
        return fieldsDescriptors;
    }

    @JvmStatic
    @NotNull
    public static final List<GroupDescriptor> buildEventsScheme() {
        boolean bl = false;
        List result = new ArrayList();
        List<FeatureUsagesCollector> list = FUCounterUsageLogger.instantiateCounterCollectors();
        Intrinsics.checkNotNullExpressionValue(list, (String)"FUCounterUsageLogger.ins\u2026ntiateCounterCollectors()");
        result.addAll((Collection)INSTANCE.collectGroupsFromExtensions("counter", (Collection<? extends FeatureUsagesCollector>)list));
        ExtensionPointName<ApplicationUsagesCollector> extensionPointName = ApplicationUsagesCollector.EP_NAME;
        Intrinsics.checkNotNullExpressionValue(extensionPointName, (String)"ApplicationUsagesCollector.EP_NAME");
        List list2 = extensionPointName.getExtensionList();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"ApplicationUsagesCollector.EP_NAME.extensionList");
        result.addAll((Collection)INSTANCE.collectGroupsFromExtensions("state", list2));
        ExtensionPointName<ProjectUsagesCollector> extensionPointName2 = ProjectUsagesCollector.EP_NAME;
        Intrinsics.checkNotNullExpressionValue(extensionPointName2, (String)"ProjectUsagesCollector.EP_NAME");
        List list3 = extensionPointName2.getExtensionList();
        Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"ProjectUsagesCollector.EP_NAME.extensionList");
        result.addAll((Collection)INSTANCE.collectGroupsFromExtensions("state", list3));
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<GroupDescriptor> collectGroupsFromExtensions(@NotNull String groupType, @NotNull Collection<? extends FeatureUsagesCollector> collectors) {
        Intrinsics.checkNotNullParameter((Object)groupType, (String)"groupType");
        Intrinsics.checkNotNullParameter(collectors, (String)"collectors");
        boolean bl = false;
        List result = new ArrayList();
        for (FeatureUsagesCollector featureUsagesCollector : collectors) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Object answer$iv$iv$iv;
            Object key$iv$iv;
            void $this$groupByTo$iv$iv;
            EventLogGroup group;
            Class<?> collectorClass = featureUsagesCollector.getClass().getEnclosingClass() != null ? featureUsagesCollector.getClass().getEnclosingClass() : featureUsagesCollector.getClass();
            this.validateGroupId(featureUsagesCollector);
            if (featureUsagesCollector.getGroup() == null) {
                continue;
            }
            Object $this$groupBy$iv = group.getEvents();
            boolean $i$f$groupBy = false;
            Iterable iterable = $this$groupBy$iv;
            Object destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object;
                BaseEventId it = (BaseEventId)element$iv$iv;
                boolean bl2 = false;
                key$iv$iv = it.getEventId();
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl3 = false;
                    answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object;
                list$iv$iv.add(element$iv$iv);
            }
            $this$groupBy$iv = destination$iv$iv;
            boolean $i$f$map = false;
            $this$groupByTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv;
            boolean bl4 = false;
            for (Map.Entry item$iv$iv : iterator.entrySet()) {
                void eventName;
                void $dstr$eventName$events;
                key$iv$iv = item$iv$iv;
                Object object = destination$iv$iv;
                boolean bl5 = false;
                void var20_25 = $dstr$eventName$events;
                boolean bl6 = false;
                answer$iv$iv$iv = (String)var20_25.getKey();
                var20_25 = $dstr$eventName$events;
                bl6 = false;
                List events = (List)var20_25.getValue();
                EventDescriptor eventDescriptor = new EventDescriptor((String)eventName, (Set<FieldDescriptor>)INSTANCE.buildFields(events, (String)eventName, group.getId()));
                object.add(eventDescriptor);
            }
            HashSet eventsDescriptors = CollectionsKt.toHashSet((Iterable)((List)destination$iv$iv));
            String string = group.getId();
            int n = group.getVersion();
            Set set = eventsDescriptors;
            Class<?> clazz = collectorClass;
            Intrinsics.checkNotNullExpressionValue(clazz, (String)"collectorClass");
            String string2 = clazz.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"collectorClass.name");
            GroupDescriptor groupDescriptor = new GroupDescriptor(string, groupType, n, set, string2);
            result.add(groupDescriptor);
        }
        return result;
    }

    private final void validateGroupId(FeatureUsagesCollector collector) {
        try {
            collector.getGroupId();
        }
        catch (IllegalStateException e) {
            throw (Throwable)new IllegalStateException(e.getMessage() + " in " + collector.getClass().getName());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final HashSet<FieldDescriptor> buildFields(List<? extends BaseEventId> events, String eventName, String groupId) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object answer$iv$iv$iv;
        Object value$iv$iv$iv22;
        Object key$iv$iv;
        void $this$groupByTo$iv$iv;
        Object $this$groupBy$iv;
        Iterable list$iv$iv;
        Object it;
        Iterable $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = events;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (BaseEventId)element$iv$iv;
            boolean bl = false;
            list$iv$iv = ((BaseEventId)it).getFields();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        $i$f$flatMap = false;
        $this$flatMapTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            EventField field = (EventField)element$iv$iv;
            boolean bl = false;
            list$iv$iv = INSTANCE.fieldSchema(field, field.getName(), eventName, groupId);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$groupBy = false;
        $this$flatMapTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            it = (FieldDescriptor)element$iv$iv;
            boolean bl = false;
            key$iv$iv = ((FieldDescriptor)it).getPath();
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            value$iv$iv$iv22 = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv22 == null) {
                boolean bl2 = false;
                answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv22;
            }
            list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        $this$groupBy$iv = destination$iv$iv;
        boolean $i$f$map = false;
        $this$groupByTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv;
        boolean bl = false;
        for (Map.Entry item$iv$iv : iterator.entrySet()) {
            void $this$flatMapTo$iv$iv2;
            void $this$flatMap$iv2;
            void name;
            void $dstr$name$values;
            key$iv$iv = item$iv$iv;
            Object object = destination$iv$iv;
            boolean bl3 = false;
            void $i$f$getOrPut = $dstr$name$values;
            boolean value$iv$iv$iv22 = false;
            answer$iv$iv$iv = (String)$i$f$getOrPut.getKey();
            $i$f$getOrPut = $dstr$name$values;
            value$iv$iv$iv22 = false;
            List values = (List)$i$f$getOrPut.getValue();
            FieldDataType type = INSTANCE.defineDataType(values, (String)name, eventName, groupId);
            value$iv$iv$iv22 = values;
            void var19_25 = name;
            boolean $i$f$flatMap2 = false;
            void var23_27 = $this$flatMap$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$flatMapTo2 = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv2) {
                FieldDescriptor it2 = (FieldDescriptor)element$iv$iv;
                boolean bl4 = false;
                Iterable list$iv$iv2 = it2.getValue();
                CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv2);
            }
            List list = (List)destination$iv$iv2;
            FieldDataType fieldDataType = type;
            Set set = CollectionsKt.toHashSet((Iterable)list);
            void var35_39 = var19_25;
            FieldDescriptor fieldDescriptor = new FieldDescriptor((String)var35_39, set, fieldDataType);
            object.add(fieldDescriptor);
        }
        return CollectionsKt.toHashSet((Iterable)((List)destination$iv$iv));
    }

    private final FieldDataType defineDataType(List<FieldDescriptor> values, String name, String eventName, String groupId) {
        boolean bl;
        FieldDataType dataType;
        block4: {
            dataType = ((FieldDescriptor)CollectionsKt.first(values)).getDataType();
            Iterable $this$any$iv = values;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    FieldDescriptor it = (FieldDescriptor)element$iv;
                    boolean bl2 = false;
                    if (!(it.getDataType() != dataType)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        if (bl) {
            throw (Throwable)new IllegalStateException("Field couldn't have multiple types (group=" + groupId + ", event=" + eventName + ", field=" + name + ')');
        }
        return dataType;
    }

    private EventsSchemeBuilder() {
    }

    static {
        EventsSchemeBuilder eventsSchemeBuilder;
        INSTANCE = eventsSchemeBuilder = new EventsSchemeBuilder();
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lcom/intellij/internal/statistic/eventLog/events/EventsSchemeBuilder$FieldDataType;", "", "(Ljava/lang/String;I)V", "ARRAY", "PRIMITIVE", "intellij.platform.statistics"})
    public static final class FieldDataType
    extends Enum<FieldDataType> {
        public static final /* enum */ FieldDataType ARRAY;
        public static final /* enum */ FieldDataType PRIMITIVE;
        private static final /* synthetic */ FieldDataType[] $VALUES;

        static {
            FieldDataType[] fieldDataTypeArray = new FieldDataType[2];
            FieldDataType[] fieldDataTypeArray2 = fieldDataTypeArray;
            fieldDataTypeArray[0] = ARRAY = new FieldDataType();
            fieldDataTypeArray[1] = PRIMITIVE = new FieldDataType();
            $VALUES = fieldDataTypeArray;
        }

        public static FieldDataType[] values() {
            return (FieldDataType[])$VALUES.clone();
        }

        public static FieldDataType valueOf(String string) {
            return Enum.valueOf(FieldDataType.class, string);
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J-\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lcom/intellij/internal/statistic/eventLog/events/EventsSchemeBuilder$FieldDescriptor;", "", "path", "", "value", "", "dataType", "Lcom/intellij/internal/statistic/eventLog/events/EventsSchemeBuilder$FieldDataType;", "(Ljava/lang/String;Ljava/util/Set;Lcom/intellij/internal/statistic/eventLog/events/EventsSchemeBuilder$FieldDataType;)V", "getDataType", "()Lcom/intellij/internal/statistic/eventLog/events/EventsSchemeBuilder$FieldDataType;", "getPath", "()Ljava/lang/String;", "getValue", "()Ljava/util/Set;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.platform.statistics"})
    public static final class FieldDescriptor {
        @NotNull
        private final String path;
        @NotNull
        private final Set<String> value;
        @NotNull
        private final FieldDataType dataType;

        @NotNull
        public final String getPath() {
            return this.path;
        }

        @NotNull
        public final Set<String> getValue() {
            return this.value;
        }

        @NotNull
        public final FieldDataType getDataType() {
            return this.dataType;
        }

        public FieldDescriptor(@NotNull String path, @NotNull Set<String> value, @NotNull FieldDataType dataType) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter(value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)((Object)dataType), (String)"dataType");
            this.path = path;
            this.value = value;
            this.dataType = dataType;
        }

        public /* synthetic */ FieldDescriptor(String string, Set set, FieldDataType fieldDataType, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                fieldDataType = FieldDataType.PRIMITIVE;
            }
            this(string, set, fieldDataType);
        }

        @NotNull
        public final String component1() {
            return this.path;
        }

        @NotNull
        public final Set<String> component2() {
            return this.value;
        }

        @NotNull
        public final FieldDataType component3() {
            return this.dataType;
        }

        @NotNull
        public final FieldDescriptor copy(@NotNull String path, @NotNull Set<String> value, @NotNull FieldDataType dataType) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter(value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)((Object)dataType), (String)"dataType");
            return new FieldDescriptor(path, value, dataType);
        }

        public static /* synthetic */ FieldDescriptor copy$default(FieldDescriptor fieldDescriptor, String string, Set set, FieldDataType fieldDataType, int n, Object object) {
            if ((n & 1) != 0) {
                string = fieldDescriptor.path;
            }
            if ((n & 2) != 0) {
                set = fieldDescriptor.value;
            }
            if ((n & 4) != 0) {
                fieldDataType = fieldDescriptor.dataType;
            }
            return fieldDescriptor.copy(string, set, fieldDataType);
        }

        @NotNull
        public String toString() {
            return "FieldDescriptor(path=" + this.path + ", value=" + this.value + ", dataType=" + (Object)((Object)this.dataType) + ")";
        }

        public int hashCode() {
            String string = this.path;
            Set<String> set = this.value;
            FieldDataType fieldDataType = this.dataType;
            return ((string != null ? string.hashCode() : 0) * 31 + (set != null ? ((Object)set).hashCode() : 0)) * 31 + (fieldDataType != null ? ((Object)((Object)fieldDataType)).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof FieldDescriptor)) break block3;
                    FieldDescriptor fieldDescriptor = (FieldDescriptor)object;
                    if (!Intrinsics.areEqual((Object)this.path, (Object)fieldDescriptor.path) || !Intrinsics.areEqual(this.value, fieldDescriptor.value) || !Intrinsics.areEqual((Object)((Object)this.dataType), (Object)((Object)fieldDescriptor.dataType))) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/intellij/internal/statistic/eventLog/events/EventsSchemeBuilder$EventDescriptor;", "", "event", "", "fields", "", "Lcom/intellij/internal/statistic/eventLog/events/EventsSchemeBuilder$FieldDescriptor;", "(Ljava/lang/String;Ljava/util/Set;)V", "getEvent", "()Ljava/lang/String;", "getFields", "()Ljava/util/Set;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.platform.statistics"})
    public static final class EventDescriptor {
        @NotNull
        private final String event;
        @NotNull
        private final Set<FieldDescriptor> fields;

        @NotNull
        public final String getEvent() {
            return this.event;
        }

        @NotNull
        public final Set<FieldDescriptor> getFields() {
            return this.fields;
        }

        public EventDescriptor(@NotNull String event, @NotNull Set<FieldDescriptor> fields) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Intrinsics.checkNotNullParameter(fields, (String)"fields");
            this.event = event;
            this.fields = fields;
        }

        @NotNull
        public final String component1() {
            return this.event;
        }

        @NotNull
        public final Set<FieldDescriptor> component2() {
            return this.fields;
        }

        @NotNull
        public final EventDescriptor copy(@NotNull String event, @NotNull Set<FieldDescriptor> fields) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Intrinsics.checkNotNullParameter(fields, (String)"fields");
            return new EventDescriptor(event, fields);
        }

        public static /* synthetic */ EventDescriptor copy$default(EventDescriptor eventDescriptor, String string, Set set, int n, Object object) {
            if ((n & 1) != 0) {
                string = eventDescriptor.event;
            }
            if ((n & 2) != 0) {
                set = eventDescriptor.fields;
            }
            return eventDescriptor.copy(string, set);
        }

        @NotNull
        public String toString() {
            return "EventDescriptor(event=" + this.event + ", fields=" + this.fields + ")";
        }

        public int hashCode() {
            String string = this.event;
            Set<FieldDescriptor> set = this.fields;
            return (string != null ? string.hashCode() : 0) * 31 + (set != null ? ((Object)set).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof EventDescriptor)) break block3;
                    EventDescriptor eventDescriptor = (EventDescriptor)object;
                    if (!Intrinsics.areEqual((Object)this.event, (Object)eventDescriptor.event) || !Intrinsics.areEqual(this.fields, eventDescriptor.fields)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0006\u0010\n\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0006H\u00c6\u0003J\u000f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003JA\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\b\b\u0002\u0010\n\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u0006H\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001f"}, d2={"Lcom/intellij/internal/statistic/eventLog/events/EventsSchemeBuilder$GroupDescriptor;", "", "id", "", "type", "version", "", "schema", "", "Lcom/intellij/internal/statistic/eventLog/events/EventsSchemeBuilder$EventDescriptor;", "className", "(Ljava/lang/String;Ljava/lang/String;ILjava/util/Set;Ljava/lang/String;)V", "getClassName", "()Ljava/lang/String;", "getId", "getSchema", "()Ljava/util/Set;", "getType", "getVersion", "()I", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "toString", "intellij.platform.statistics"})
    public static final class GroupDescriptor {
        @NotNull
        private final String id;
        @NotNull
        private final String type;
        private final int version;
        @NotNull
        private final Set<EventDescriptor> schema;
        @NotNull
        private final String className;

        @NotNull
        public final String getId() {
            return this.id;
        }

        @NotNull
        public final String getType() {
            return this.type;
        }

        public final int getVersion() {
            return this.version;
        }

        @NotNull
        public final Set<EventDescriptor> getSchema() {
            return this.schema;
        }

        @NotNull
        public final String getClassName() {
            return this.className;
        }

        public GroupDescriptor(@NotNull String id, @NotNull String type, int version, @NotNull Set<EventDescriptor> schema, @NotNull String className) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter(schema, (String)"schema");
            Intrinsics.checkNotNullParameter((Object)className, (String)"className");
            this.id = id;
            this.type = type;
            this.version = version;
            this.schema = schema;
            this.className = className;
        }

        @NotNull
        public final String component1() {
            return this.id;
        }

        @NotNull
        public final String component2() {
            return this.type;
        }

        public final int component3() {
            return this.version;
        }

        @NotNull
        public final Set<EventDescriptor> component4() {
            return this.schema;
        }

        @NotNull
        public final String component5() {
            return this.className;
        }

        @NotNull
        public final GroupDescriptor copy(@NotNull String id, @NotNull String type, int version, @NotNull Set<EventDescriptor> schema, @NotNull String className) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter(schema, (String)"schema");
            Intrinsics.checkNotNullParameter((Object)className, (String)"className");
            return new GroupDescriptor(id, type, version, schema, className);
        }

        public static /* synthetic */ GroupDescriptor copy$default(GroupDescriptor groupDescriptor, String string, String string2, int n, Set set, String string3, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = groupDescriptor.id;
            }
            if ((n2 & 2) != 0) {
                string2 = groupDescriptor.type;
            }
            if ((n2 & 4) != 0) {
                n = groupDescriptor.version;
            }
            if ((n2 & 8) != 0) {
                set = groupDescriptor.schema;
            }
            if ((n2 & 0x10) != 0) {
                string3 = groupDescriptor.className;
            }
            return groupDescriptor.copy(string, string2, n, set, string3);
        }

        @NotNull
        public String toString() {
            return "GroupDescriptor(id=" + this.id + ", type=" + this.type + ", version=" + this.version + ", schema=" + this.schema + ", className=" + this.className + ")";
        }

        public int hashCode() {
            String string = this.id;
            String string2 = this.type;
            Set<EventDescriptor> set = this.schema;
            String string3 = this.className;
            return ((((string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + Integer.hashCode(this.version)) * 31 + (set != null ? ((Object)set).hashCode() : 0)) * 31 + (string3 != null ? string3.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof GroupDescriptor)) break block3;
                    GroupDescriptor groupDescriptor = (GroupDescriptor)object;
                    if (!Intrinsics.areEqual((Object)this.id, (Object)groupDescriptor.id) || !Intrinsics.areEqual((Object)this.type, (Object)groupDescriptor.type) || this.version != groupDescriptor.version || !Intrinsics.areEqual(this.schema, groupDescriptor.schema) || !Intrinsics.areEqual((Object)this.className, (Object)groupDescriptor.className)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B'\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\u000b\u0010\u000e\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u000f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u00c6\u0003J1\u0010\u0011\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0018"}, d2={"Lcom/intellij/internal/statistic/eventLog/events/EventsSchemeBuilder$EventsScheme;", "", "commitHash", "", "buildNumber", "scheme", "", "Lcom/intellij/internal/statistic/eventLog/events/EventsSchemeBuilder$GroupDescriptor;", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/List;)V", "getBuildNumber", "()Ljava/lang/String;", "getCommitHash", "getScheme", "()Ljava/util/List;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.platform.statistics"})
    public static final class EventsScheme {
        @Nullable
        private final String commitHash;
        @Nullable
        private final String buildNumber;
        @NotNull
        private final List<GroupDescriptor> scheme;

        @Nullable
        public final String getCommitHash() {
            return this.commitHash;
        }

        @Nullable
        public final String getBuildNumber() {
            return this.buildNumber;
        }

        @NotNull
        public final List<GroupDescriptor> getScheme() {
            return this.scheme;
        }

        public EventsScheme(@Nullable String commitHash, @Nullable String buildNumber, @NotNull List<GroupDescriptor> scheme) {
            Intrinsics.checkNotNullParameter(scheme, (String)"scheme");
            this.commitHash = commitHash;
            this.buildNumber = buildNumber;
            this.scheme = scheme;
        }

        @Nullable
        public final String component1() {
            return this.commitHash;
        }

        @Nullable
        public final String component2() {
            return this.buildNumber;
        }

        @NotNull
        public final List<GroupDescriptor> component3() {
            return this.scheme;
        }

        @NotNull
        public final EventsScheme copy(@Nullable String commitHash, @Nullable String buildNumber, @NotNull List<GroupDescriptor> scheme) {
            Intrinsics.checkNotNullParameter(scheme, (String)"scheme");
            return new EventsScheme(commitHash, buildNumber, scheme);
        }

        public static /* synthetic */ EventsScheme copy$default(EventsScheme eventsScheme, String string, String string2, List list, int n, Object object) {
            if ((n & 1) != 0) {
                string = eventsScheme.commitHash;
            }
            if ((n & 2) != 0) {
                string2 = eventsScheme.buildNumber;
            }
            if ((n & 4) != 0) {
                list = eventsScheme.scheme;
            }
            return eventsScheme.copy(string, string2, list);
        }

        @NotNull
        public String toString() {
            return "EventsScheme(commitHash=" + this.commitHash + ", buildNumber=" + this.buildNumber + ", scheme=" + this.scheme + ")";
        }

        public int hashCode() {
            String string = this.commitHash;
            String string2 = this.buildNumber;
            List<GroupDescriptor> list = this.scheme;
            return ((string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (list != null ? ((Object)list).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof EventsScheme)) break block3;
                    EventsScheme eventsScheme = (EventsScheme)object;
                    if (!Intrinsics.areEqual((Object)this.commitHash, (Object)eventsScheme.commitHash) || !Intrinsics.areEqual((Object)this.buildNumber, (Object)eventsScheme.buildNumber) || !Intrinsics.areEqual(this.scheme, eventsScheme.scheme)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

