/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.validator.storage.persistence;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseEventLogMetadataPersistence {
    private static final Logger LOG = Logger.getInstance(BaseEventLogMetadataPersistence.class);
    public static final String DEPRECATED_FUS_METADATA_DIR = "event-log-whitelist";
    public static final String FUS_METADATA_DIR = "event-log-metadata";

    @Nullable
    public abstract String getCachedEventsScheme();

    public static Path getDefaultMetadataFile(@NotNull String recorderId, @NotNull String fileName, @Nullable String deprecatedFileName) throws IOException {
        Path deprecated;
        Path file;
        if (recorderId == null) {
            BaseEventLogMetadataPersistence.$$$reportNull$$$0(0);
        }
        if (fileName == null) {
            BaseEventLogMetadataPersistence.$$$reportNull$$$0(1);
        }
        if (!Files.exists(file = BaseEventLogMetadataPersistence.getMetadataByDir(FUS_METADATA_DIR, recorderId, fileName), new LinkOption[0]) && Strings.isNotEmpty((String)deprecatedFileName) && Files.exists(deprecated = BaseEventLogMetadataPersistence.getMetadataByDir(DEPRECATED_FUS_METADATA_DIR, recorderId, deprecatedFileName), new LinkOption[0])) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Moving deprecated metadata file to new directory: " + fileName);
            }
            try {
                Files.createDirectories(file.getParent(), new FileAttribute[0]);
            }
            catch (IOException ignored) {
                LOG.info("Cannot create directories for event log metadata");
                return file;
            }
            Files.copy(deprecated, file, new CopyOption[0]);
            Files.deleteIfExists(deprecated);
        }
        return file;
    }

    @NotNull
    public static Path getDeprecatedMetadataDir() {
        return BaseEventLogMetadataPersistence.getMetadataConfigRoot(DEPRECATED_FUS_METADATA_DIR);
    }

    @NotNull
    private static Path getMetadataByDir(@NotNull String dir, @NotNull String recorderId, @NotNull String fileName) throws IOException {
        if (dir == null) {
            BaseEventLogMetadataPersistence.$$$reportNull$$$0(2);
        }
        if (recorderId == null) {
            BaseEventLogMetadataPersistence.$$$reportNull$$$0(3);
        }
        if (fileName == null) {
            BaseEventLogMetadataPersistence.$$$reportNull$$$0(4);
        }
        Path metadataDir = BaseEventLogMetadataPersistence.getMetadataConfigRoot(dir);
        Path path = metadataDir.resolve(StringUtil.toLowerCase((String)recorderId)).resolve(fileName).normalize().toAbsolutePath();
        if (path == null) {
            BaseEventLogMetadataPersistence.$$$reportNull$$$0(5);
        }
        return path;
    }

    @NotNull
    private static Path getMetadataConfigRoot(@NotNull String dir) {
        if (dir == null) {
            BaseEventLogMetadataPersistence.$$$reportNull$$$0(6);
        }
        Path path = PathManager.getConfigDir().resolve(dir);
        if (path == null) {
            BaseEventLogMetadataPersistence.$$$reportNull$$$0(7);
        }
        return path;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recorderId";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/eventLog/validator/storage/persistence/BaseEventLogMetadataPersistence";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/eventLog/validator/storage/persistence/BaseEventLogMetadataPersistence";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getMetadataByDir";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getMetadataConfigRoot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultMetadataFile";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getMetadataByDir";
                break;
            }
            case 5: 
            case 7: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getMetadataConfigRoot";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

