/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdba.jdbc;

import com.intellij.database.remote.jdba.core.ConnectionInfo;
import com.intellij.database.remote.jdba.exceptions.DBIsNotConnected;
import com.intellij.database.remote.jdba.intermediate.DBExceptionRecognizer;
import com.intellij.database.remote.jdba.jdbc.JdbcConnectionProvider;
import com.intellij.database.remote.jdba.jdbc.JdbcIntermediateFacade;
import com.intellij.database.remote.jdba.jdbc.JdbcIntermediateSession;
import com.intellij.database.remote.jdba.jdbc.UnknownDatabaseInfo;
import com.intellij.database.remote.jdba.jdbc.UnknownDatabaseInfoHelper;
import com.intellij.database.remote.jdbc.helpers.JdbcHelperImpl;
import java.sql.Connection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnknownDatabaseIntermediateFacade
extends JdbcIntermediateFacade {
    @Nullable
    private UnknownDatabaseInfo myUnknownInfo;

    public UnknownDatabaseIntermediateFacade(@NotNull JdbcConnectionProvider dataSource, @NotNull DBExceptionRecognizer exceptionRecognizer, @NotNull JdbcHelperImpl helper) {
        if (dataSource == null) {
            UnknownDatabaseIntermediateFacade.$$$reportNull$$$0(0);
        }
        if (exceptionRecognizer == null) {
            UnknownDatabaseIntermediateFacade.$$$reportNull$$$0(1);
        }
        if (helper == null) {
            UnknownDatabaseIntermediateFacade.$$$reportNull$$$0(2);
        }
        super(dataSource, exceptionRecognizer, helper);
        this.myUnknownInfo = null;
    }

    @Override
    public synchronized void connect() {
        super.connect();
        if (this.myUnknownInfo == null) {
            this.myUnknownInfo = UnknownDatabaseInfoHelper.obtainDatabaseInfo(this);
        }
    }

    @Override
    public ConnectionInfo obtainConnectionInfoNatively() {
        assert (this.myUnknownInfo != null);
        if (this.myUnknownInfo.isDB2) {
            return this.getConnectionInfoSmartly("select rtrim(current_server), rtrim(current schema), rtrim(current_user) from sysibm.sysdummy1");
        }
        if (this.myUnknownInfo.isHsql) {
            return this.getConnectionInfoSmartly("select database(), current_schema, current_user from information_schema.schemata limit 1");
        }
        return super.obtainConnectionInfoNatively();
    }

    @NotNull
    UnknownDatabaseInfo getUnknownInfo() {
        if (this.myUnknownInfo == null) {
            if (!this.isConnected()) {
                throw new DBIsNotConnected("Facade is not connected to DB");
            }
            throw new RuntimeException("The special internal info is not obtained. Possible the Facade was not initialized properly");
        }
        UnknownDatabaseInfo unknownDatabaseInfo = this.myUnknownInfo;
        if (unknownDatabaseInfo == null) {
            UnknownDatabaseIntermediateFacade.$$$reportNull$$$0(3);
        }
        return unknownDatabaseInfo;
    }

    @Override
    @NotNull
    protected JdbcIntermediateSession instantiateSession(@NotNull Connection connection) {
        if (connection == null) {
            UnknownDatabaseIntermediateFacade.$$$reportNull$$$0(4);
        }
        return new JdbcIntermediateSession(this, this.getExceptionRecognizer(), connection);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptionRecognizer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helper";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/remote/jdba/jdbc/UnknownDatabaseIntermediateFacade";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/remote/jdba/jdbc/UnknownDatabaseIntermediateFacade";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnknownInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "instantiateSession";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

