/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc.helpers;

import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.database.remote.jdbc.helpers.MysqlBaseJdbcHelper;
import java.sql.Connection;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GBaseJdbcHelper
extends MysqlBaseJdbcHelper {
    protected static final Pattern GITBASE_VERSION_PATTERN = Pattern.compile("(?:\\d+(?:\\.\\d+)+)-v(\\d+(?:\\.\\d+)+)");

    public GBaseJdbcHelper(@Nullable String version, @Nullable Connection connection) {
        super("GITBASE", version, connection);
    }

    public GBaseJdbcHelper() {
        this(null, null);
    }

    @Override
    @Nullable
    public String parseVersion(@Nullable String version) {
        return GBaseJdbcHelper.extractVersion(version);
    }

    @Override
    public boolean supportsEscape() {
        return false;
    }

    @NotNull
    protected static GBaseJdbcHelper create(@Nullable Connection delegate, @Nullable String versionStr) {
        String version = GBaseJdbcHelper.extractVersion(versionStr);
        return new GBaseJdbcHelper(version, delegate);
    }

    @Nullable
    public static String extractVersion(@Nullable String str) {
        return JdbcNativeUtil.findVersion(str, GITBASE_VERSION_PATTERN);
    }
}

