/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc.helpers;

import com.intellij.database.remote.jdbc.helpers.JdbcHelperImpl;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.util.Properties;
import java.util.logging.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenericJdbcHelper
extends JdbcHelperImpl {
    public GenericJdbcHelper(@Nullable String dbmsName, @Nullable String version, @Nullable Connection connection) {
        super(dbmsName == null ? "UNKNOWN" : dbmsName, version, connection);
    }

    public GenericJdbcHelper() {
        this(null, null, null);
    }

    @Override
    @Nullable
    public String parseVersion(@Nullable String version) {
        return JdbcNativeUtil.findVersion(version, JdbcNativeUtil.DEFAULT_VERSION_PATTERN);
    }

    @Override
    @NotNull
    public final GenericJdbcHelper detect(@Nullable Connection delegate, @Nullable String product, @Nullable String productVer) throws Exception {
        DatabaseMetaData md = delegate == null ? null : delegate.getMetaData();
        String version = null;
        if (md != null) {
            try {
                version = md.getDatabaseMajorVersion() + "." + md.getDatabaseMinorVersion();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (version == null) {
            version = JdbcNativeUtil.findVersion(productVer, JdbcNativeUtil.DEFAULT_VERSION_PATTERN);
        }
        JdbcNativeUtil.logInfo("getDatabaseProductName: " + product + "\ngetDatabaseMajorVersion.getDatabaseMinorVersion: " + version);
        return new GenericJdbcHelper(product, version, delegate);
    }

    @Override
    protected void setDriverLogLevel(Driver driver, Properties properties, @Nullable Level level, @Nullable String logPath) {
        super.setDriverLogLevel(driver, properties, level, logPath);
        GenericJdbcHelper.configureSimbaLogging(properties, level, logPath);
    }

    @Override
    public boolean isZonedTimeColumn(@Nullable String typeName) {
        return StringUtilRt.equal((CharSequence)"time with time zone", (CharSequence)typeName, (boolean)false);
    }

    @Override
    public boolean isZonedTimestampColumn(@Nullable String typeName, int jdbcType) {
        return StringUtilRt.equal((CharSequence)"timestamp with time zone", (CharSequence)typeName, (boolean)false);
    }
}

