/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator;

import a.d.la;
import com.intellij.analysis.AnalysisScope;
import com.intellij.dupLocator.DupLocatorBundle;
import com.intellij.dupLocator.DuplicatesProfile;
import com.intellij.dupLocator.DuplocateVisitor;
import com.intellij.dupLocator.DuplocatorState;
import com.intellij.dupLocator.treeHash.FragmentsCollector;
import com.intellij.dupLocator.util.DuplocatorUtil;
import com.intellij.dupLocator.util.PsiFragment;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.project.ProjectUtilCore;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.ExternalIntegerKeyDescriptor;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DuplicatesIndex
implements Disposable {
    private static final Logger LOG;
    private static final int MAX_COST = 7000;
    private final PersistentHashMap<Integer, List<MyEntry>> myPersistentHashMap;
    private final DuplicatesProfile[] myProfiles;
    @NotNull
    private final Project myProject;
    private static final long a;

    public DuplicatesIndex(@NotNull Project project, DuplicatesProfile @NotNull [] profiles) throws IOException {
        long l2 = a ^ 0x5A79D4BB17B7L;
        if (project == null) {
            DuplicatesIndex.a(0);
        }
        if (profiles == null) {
            DuplicatesIndex.a(1);
        }
        this.myProfiles = profiles;
        this.myProject = project;
        File file = ProjectUtil.getProjectCachePath((Project)project, (String)"duplicates").toFile();
        IOUtil.deleteAllFilesStartingWith((File)file);
        this.myPersistentHashMap = new PersistentHashMap(file.toPath(), (KeyDescriptor)ExternalIntegerKeyDescriptor.INSTANCE, (DataExternalizer)new MyDataExternalizer());
        this.myPersistentHashMap.force();
    }

    public void dispose() {
        try {
            this.myPersistentHashMap.closeAndClean();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void update(@NotNull AnalysisScope scope) {
        long l2 = a ^ 0x2E376B342B16L;
        if (scope == null) {
            DuplicatesIndex.a(2);
        }
        final ProgressIndicator progressIndicator2 = ProgressManager.getInstance().getProgressIndicator();
        final int n2 = scope.getFileCount();
        if (progressIndicator2 != null) {
            progressIndicator2.setText(DupLocatorBundle.message((String)"duplicates.indexing.progress", (Object[])new Object[0]));
        }
        scope.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){
            private int myFileCount = 0;
            private static final long a = la.a(-2642001309130496556L, -8983994512033142361L, MethodHandles.lookup().lookupClass()).a(167655826564787L);

            public void visitFile(@NotNull PsiFile baseFile) {
                String string;
                Int2ObjectMap<Set<MyEntry>> int2ObjectMap;
                if (baseFile == null) {
                    1.a(0);
                }
                Project project = baseFile.getProject();
                ++this.myFileCount;
                if (progressIndicator2 != null) {
                    int2ObjectMap = baseFile.getVirtualFile();
                    if (int2ObjectMap != null) {
                        string = int2ObjectMap.getPresentableUrl();
                        String string2 = ProjectUtilCore.displayUrlRelativeToProject(int2ObjectMap, (String)string, (Project)project, (boolean)true, (boolean)false);
                        progressIndicator2.setText2(string2);
                    }
                    progressIndicator2.setFraction((double)this.myFileCount / (double)n2);
                }
                int2ObjectMap = DuplicatesIndex.this.a(project, baseFile);
                string = int2ObjectMap.keySet().iterator();
                while (string.hasNext()) {
                    int n22 = string.nextInt();
                    Set set = (Set)int2ObjectMap.get(n22);
                    try {
                        ArrayList arrayList = (ArrayList)DuplicatesIndex.this.myPersistentHashMap.get((Object)n22);
                        if (arrayList == null) {
                            arrayList = new ArrayList();
                        }
                        arrayList.addAll(set);
                        DuplicatesIndex.this.myPersistentHashMap.put((Object)n22, new ArrayList(arrayList));
                    }
                    catch (IOException iOException) {
                        LOG.error((Throwable)iOException);
                    }
                }
            }

            private static /* synthetic */ void a(int n22) {
                long l2 = a ^ 0x1A0E70F5A48CL;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseFile", "com/intellij/dupLocator/DuplicatesIndex$1", "visitFile"));
            }
        });
    }

    private Int2ObjectMap<Set<MyEntry>> a(Project project, PsiFile psiFile) {
        try {
            VirtualFile virtualFile = psiFile.getVirtualFile();
            if (virtualFile == null) {
                return Int2ObjectMaps.emptyMap();
            }
            MyIndexingFragmentsCollector myIndexingFragmentsCollector = new MyIndexingFragmentsCollector();
            DuplocateVisitor[] duplocateVisitorArray = DuplicatesIndex.a(this.myProfiles, myIndexingFragmentsCollector);
            for (PsiFile psiFile2 : psiFile.getViewProvider().getAllFiles()) {
                for (DuplocateVisitor duplocateVisitor : duplocateVisitorArray) {
                    duplocateVisitor.visitNode((PsiElement)psiFile2);
                }
                InjectedLanguageManager.getInstance((Project)project).dropFileCaches(psiFile2);
            }
            return myIndexingFragmentsCollector.getResult();
        }
        catch (ProcessCanceledException processCanceledException) {
            throw processCanceledException;
        }
        catch (RuntimeException runtimeException) {
            LOG.error((Throwable)runtimeException);
            return Int2ObjectMaps.emptyMap();
        }
    }

    public void processAll(@NotNull AnalysisScope scope, @NotNull FragmentsCollector collector) {
        long l2 = a ^ 0x3A58656EEA8DL;
        if (scope == null) {
            DuplicatesIndex.a(3);
        }
        if (collector == null) {
            DuplicatesIndex.a(4);
        }
        try {
            IntArrayList intArrayList = new IntArrayList();
            this.myPersistentHashMap.processKeys(arg_0 -> DuplicatesIndex.a((IntList)intArrayList, arg_0));
            final Map<VirtualFile, Map<Language, IntSet>> map = this.a((IntList)intArrayList);
            final DuplocateVisitor[] duplocateVisitorArray = DuplicatesIndex.a(this.myProfiles, new MyProcessingFragmentsCollector(map, collector));
            final ProgressIndicator progressIndicator2 = ProgressManager.getInstance().getProgressIndicator();
            if (progressIndicator2 != null) {
                progressIndicator2.setText(DupLocatorBundle.message((String)"duplicates.searching.progress", (Object[])new Object[0]));
            }
            final int n2 = map.size();
            final Set<VirtualFile> set = map.keySet();
            scope.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){
                private int myIndex = 0;
                private static final long a = la.a(-3146226066461680504L, -8016944924584844925L, MethodHandles.lookup().lookupClass()).a(113975017499673L);

                public void visitFile(@NotNull PsiFile baseFile) {
                    if (baseFile == null) {
                        2.a(0);
                    }
                    if (!baseFile.isValid()) {
                        return;
                    }
                    VirtualFile virtualFile = baseFile.getVirtualFile();
                    if (virtualFile == null || !set.contains(virtualFile)) {
                        return;
                    }
                    if (progressIndicator2 != null) {
                        String string = virtualFile.getPresentableUrl();
                        String string2 = ProjectUtilCore.displayUrlRelativeToProject((VirtualFile)virtualFile, (String)string, (Project)DuplicatesIndex.this.myProject, (boolean)true, (boolean)false);
                        progressIndicator2.setText2(string2);
                        progressIndicator2.setFraction((double)this.myIndex / (double)n2);
                    }
                    ++this.myIndex;
                    for (String string2 : ((Map)map.get(virtualFile)).keySet()) {
                        PsiFile psiFile = baseFile.getViewProvider().getPsi((Language)string2);
                        if (psiFile == null || !psiFile.isValid()) continue;
                        for (DuplocateVisitor duplocateVisitor : duplocateVisitorArray) {
                            duplocateVisitor.visitNode((PsiElement)psiFile);
                        }
                        InjectedLanguageManager.getInstance((Project)DuplicatesIndex.this.myProject).dropFileCaches(psiFile);
                    }
                }

                private static /* synthetic */ void a(int n22) {
                    long l2 = a ^ 0xF9C379991CCL;
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseFile", "com/intellij/dupLocator/DuplicatesIndex$2", "visitFile"));
                }
            });
        }
        catch (IOException iOException) {
            LOG.error((Throwable)iOException);
        }
    }

    @Nullable
    private static IntSet a(@NotNull Map<VirtualFile, Map<Language, IntSet>> map, @NotNull PsiFragment psiFragment) {
        Map<Language, IntSet> map2;
        VirtualFile virtualFile;
        PsiFile psiFile;
        Language language;
        if (map == null) {
            DuplicatesIndex.a(5);
        }
        if (psiFragment == null) {
            DuplicatesIndex.a(6);
        }
        if ((language = psiFragment.getLanguage()) != null && (psiFile = psiFragment.getFile()) != null && (virtualFile = psiFile.getVirtualFile()) != null && (map2 = map.get(virtualFile)) != null) {
            return map2.get(language);
        }
        return null;
    }

    private Map<VirtualFile, Map<Language, IntSet>> a(@NotNull IntList intList) throws IOException {
        if (intList == null) {
            DuplicatesIndex.a(7);
        }
        Map map = CollectionFactory.createSmallMemoryFootprintMap();
        int n2 = intList.size();
        for (int i10 = 0; i10 < n2; ++i10) {
            int n3 = intList.getInt(i10);
            List list2 = (List)this.myPersistentHashMap.get((Object)n3);
            if (list2.size() < 2) continue;
            for (MyEntry myEntry : list2) {
                IntSet intSet;
                VirtualFile virtualFile;
                Language language;
                if (myEntry.getTextRanges().length == 0 || (language = Language.findLanguageByID((String)myEntry.getLanguageId())) == null || (virtualFile = ManagingFS.getInstance().findFileById(myEntry.getFileId())) == null) continue;
                Map map2 = (Map)map.get(virtualFile);
                if (map2 == null) {
                    map2 = CollectionFactory.createSmallMemoryFootprintMap();
                    map.put(virtualFile, map2);
                }
                if ((intSet = (IntSet)map2.get(language)) == null) {
                    intSet = new IntOpenHashSet();
                    map2.put(language, intSet);
                }
                intSet.add(DuplicatesIndex.a(myEntry.getTextRanges()));
            }
        }
        map.entrySet().removeIf(entry -> ((Map)entry.getValue()).isEmpty());
        return map;
    }

    private static int a(TextRange @NotNull [] textRangeArray) {
        if (textRangeArray == null) {
            DuplicatesIndex.a(8);
        }
        int n2 = 0;
        for (TextRange textRange : textRangeArray) {
            n2 = n2 * 31 + textRange.getStartOffset();
            n2 = n2 * 31 + textRange.getEndOffset();
        }
        return n2;
    }

    private static DuplocateVisitor[] a(DuplicatesProfile[] duplicatesProfileArray, FragmentsCollector fragmentsCollector) {
        DuplocateVisitor[] duplocateVisitorArray = new DuplocateVisitor[duplicatesProfileArray.length];
        for (int i10 = 0; i10 < duplocateVisitorArray.length; ++i10) {
            duplocateVisitorArray[i10] = duplicatesProfileArray[i10].createVisitor(fragmentsCollector);
        }
        return duplocateVisitorArray;
    }

    private static TextRange @NotNull [] a(@NotNull PsiFragment psiFragment) {
        if (psiFragment == null) {
            DuplicatesIndex.a(9);
        }
        PsiElement[] psiElementArray = psiFragment.getElements();
        ArrayList<TextRange> arrayList = new ArrayList<TextRange>(psiElementArray.length);
        for (PsiElement psiElement : psiElementArray) {
            arrayList.add(psiElement != null ? psiElement.getTextRange() : TextRange.EMPTY_RANGE);
        }
        TextRange[] textRangeArray = arrayList.toArray(TextRange.EMPTY_ARRAY);
        if (textRangeArray == null) {
            DuplicatesIndex.a(10);
        }
        return textRangeArray;
    }

    private static /* synthetic */ boolean a(IntList intList, Integer n2) {
        intList.add(n2.intValue());
        return true;
    }

    static {
        a = la.a(8238369214717915204L, 419084420862939443L, MethodHandles.lookup().lookupClass()).a(24531379547374L);
        LOG = Logger.getInstance(DuplicatesIndex.class);
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = a ^ 0x173390B5A4BFL;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 10: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profiles";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collector";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragment";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hashes";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ranges";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/dupLocator/DuplicatesIndex";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/dupLocator/DuplicatesIndex";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextRanges";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processAll";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getFragmentsSet";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getMap";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "computeHash";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getTextRanges";
                break;
            }
            case 10: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyProcessingFragmentsCollector
    implements FragmentsCollector {
        private final Map<VirtualFile, Map<Language, IntSet>> myMap;
        private final FragmentsCollector myCollector;

        MyProcessingFragmentsCollector(Map<VirtualFile, Map<Language, IntSet>> map, FragmentsCollector collector) {
            this.myMap = map;
            this.myCollector = collector;
        }

        public void add(int hash, int cost, @Nullable PsiFragment frag) {
            DuplocatorState duplocatorState = DuplocatorUtil.getDuplocatorState((PsiFragment)frag);
            if (duplocatorState == null) {
                return;
            }
            if (cost < duplocatorState.getLowerBound() || cost > 7000) {
                return;
            }
            IntSet intSet = DuplicatesIndex.a(this.myMap, frag);
            if (intSet != null) {
                boolean bl2 = false;
                TextRange[] textRangeArray = DuplicatesIndex.a(frag);
                int n2 = DuplicatesIndex.a(textRangeArray);
                if (intSet.contains(n2)) {
                    bl2 = true;
                }
                if (bl2) {
                    this.myCollector.add(hash, cost, frag);
                }
                return;
            }
            this.myCollector.add(hash, cost, frag);
        }
    }

    private static final class MyIndexingFragmentsCollector
    implements FragmentsCollector {
        private final Int2ObjectMap<Set<MyEntry>> myMap = new Int2ObjectOpenHashMap();
        private static final long a = la.a(-4936783096934190441L, -9068858534006282870L, MethodHandles.lookup().lookupClass()).a(212352967937025L);

        private MyIndexingFragmentsCollector() {
        }

        @NotNull
        public Int2ObjectMap<Set<MyEntry>> getResult() {
            Int2ObjectMap<Set<MyEntry>> int2ObjectMap = this.myMap;
            if (int2ObjectMap == null) {
                MyIndexingFragmentsCollector.a(0);
            }
            return int2ObjectMap;
        }

        public void add(int hash, int cost, @Nullable PsiFragment frag) {
            if (frag == null) {
                return;
            }
            PsiFile psiFile = frag.getFile();
            if (psiFile == null) {
                return;
            }
            VirtualFile virtualFile = psiFile.getVirtualFile();
            if (virtualFile == null) {
                return;
            }
            DuplocatorState duplocatorState = DuplocatorUtil.getDuplocatorState((PsiFragment)frag);
            if (duplocatorState == null) {
                return;
            }
            int n2 = duplocatorState.getLowerBound();
            if (cost < n2 || cost > 7000) {
                return;
            }
            TextRange[] textRangeArray = DuplicatesIndex.a(frag);
            Language language = frag.getLanguage();
            if (language == null) {
                return;
            }
            HashSet<MyEntry> hashSet = (HashSet<MyEntry>)this.myMap.get(hash);
            if (hashSet == null) {
                hashSet = new HashSet<MyEntry>();
                this.myMap.put(hash, hashSet);
            }
            int n3 = FileBasedIndex.getFileId((VirtualFile)virtualFile);
            hashSet.add(new MyEntry(n3, language.getID(), textRangeArray));
        }

        private static /* synthetic */ void a(int n2) {
            long l2 = a ^ 0x70C2E114DFC4L;
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dupLocator/DuplicatesIndex$MyIndexingFragmentsCollector", "getResult"));
        }
    }

    private static class MyDataExternalizer
    implements DataExternalizer<List<MyEntry>> {
        private static final long a = la.a(-3331162736614732374L, -1482211167791674267L, MethodHandles.lookup().lookupClass()).a(93698038656944L);

        private MyDataExternalizer() {
        }

        public void save(@NotNull DataOutput out, List<MyEntry> entryList) throws IOException {
            if (out == null) {
                MyDataExternalizer.a(0);
            }
            out.writeInt(entryList.size());
            for (MyEntry myEntry : entryList) {
                out.writeInt(myEntry.getFileId());
                out.writeUTF(myEntry.getLanguageId());
                TextRange[] textRangeArray = myEntry.getTextRanges();
                out.writeInt(textRangeArray.length);
                for (TextRange textRange : textRangeArray) {
                    if (textRange == null) {
                        out.writeInt(0);
                        out.writeInt(0);
                        continue;
                    }
                    out.writeInt(textRange.getStartOffset());
                    out.writeInt(textRange.getEndOffset());
                }
            }
        }

        public List<MyEntry> read(@NotNull DataInput in2) throws IOException {
            if (in2 == null) {
                MyDataExternalizer.a(1);
            }
            int n2 = in2.readInt();
            ArrayList<MyEntry> arrayList = new ArrayList<MyEntry>(n2);
            for (int i10 = 0; i10 < n2; ++i10) {
                int n3 = in2.readInt();
                String string = in2.readUTF();
                int n4 = in2.readInt();
                TextRange[] textRangeArray = new TextRange[n4];
                for (int i11 = 0; i11 < n4; ++i11) {
                    int n5 = in2.readInt();
                    int n6 = in2.readInt();
                    textRangeArray[i11] = n5 == -1 || n6 == -1 ? null : new TextRange(n5, n6);
                }
                MyEntry myEntry = new MyEntry(n3, string, textRangeArray);
                arrayList.add(myEntry);
            }
            return arrayList;
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            long l2 = a ^ 0x7FCE35FE7044L;
            Object[] objectArray3 = new Object[3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/dupLocator/DuplicatesIndex$MyDataExternalizer";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class MyEntry {
        private final int myFileId;
        private final String myLanguageId;
        private final TextRange[] myTextRanges;
        private static final long a = la.a(-1397659947025550956L, -6663049409969339735L, MethodHandles.lookup().lookupClass()).a(189208251611372L);

        private MyEntry(int fileId, @NotNull String languageId, TextRange @NotNull [] textRanges) {
            if (languageId == null) {
                MyEntry.a(0);
            }
            if (textRanges == null) {
                MyEntry.a(1);
            }
            this.myFileId = fileId;
            this.myLanguageId = languageId;
            this.myTextRanges = textRanges;
        }

        public int getFileId() {
            return this.myFileId;
        }

        @NotNull
        @NlsSafe
        public String getLanguageId() {
            String string = this.myLanguageId;
            if (string == null) {
                MyEntry.a(2);
            }
            return string;
        }

        public TextRange @NotNull [] getTextRanges() {
            if (this.myTextRanges == null) {
                MyEntry.a(3);
            }
            return this.myTextRanges;
        }

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (o2 == null || this.getClass() != o2.getClass()) {
                return false;
            }
            MyEntry myEntry = (MyEntry)o2;
            if (this.myFileId != myEntry.myFileId) {
                return false;
            }
            if (!this.myLanguageId.equals(myEntry.myLanguageId)) {
                return false;
            }
            return Arrays.equals(this.myTextRanges, myEntry.myTextRanges);
        }

        public int hashCode() {
            int n2 = this.myFileId;
            n2 = 31 * n2 + this.myLanguageId.hashCode();
            n2 = 31 * n2 + Arrays.hashCode(this.myTextRanges);
            return n2;
        }

        private static /* synthetic */ void a(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            long l2 = a ^ 0x5FE64F0DBF16L;
            switch (n2) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "languageId";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "textRanges";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/dupLocator/DuplicatesIndex$MyEntry";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/dupLocator/DuplicatesIndex$MyEntry";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLanguageId";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTextRanges";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

