/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator;

import a.d.la;
import com.intellij.analysis.AnalysisScope;
import com.intellij.analysis.PerformAnalysisInBackgroundOption;
import com.intellij.codeInspection.actions.RunInspectionAction;
import com.intellij.dupLocator.DupInfo;
import com.intellij.dupLocator.DupLocatorBundle;
import com.intellij.dupLocator.DuplicatesIndex;
import com.intellij.dupLocator.DuplicatesProfile;
import com.intellij.dupLocator.DuplocateVisitor;
import com.intellij.dupLocator.DuplocatorSettings;
import com.intellij.dupLocator.resultUI.CodeNode;
import com.intellij.dupLocator.resultUI.ContentPanel;
import com.intellij.dupLocator.resultUI.DuplicatesForm;
import com.intellij.dupLocator.resultUI.InvalidatedException;
import com.intellij.dupLocator.treeHash.DuplocatorHashCallback;
import com.intellij.dupLocator.treeHash.FragmentsCollector;
import com.intellij.ide.impl.ContentManagerWatcher;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.TreeTraversal;
import com.intellij.util.ui.DeprecationStripePanel;
import com.intellij.util.ui.tree.TreeUtil;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Service
public final class DuplocateManager {
    private static final Logger LOG;
    private final Project myProject;
    private ContentManager myContentManager;
    private static final long a;

    public DuplocateManager(@NotNull Project p2) {
        if (p2 == null) {
            DuplocateManager.a(0);
        }
        this.myProject = p2;
        StartupManager.getInstance((Project)p2).runWhenProjectIsInitialized(() -> {
            long l2 = a ^ 0x38256B9A79EDL;
            ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)this.myProject);
            ToolWindow toolWindow = toolWindowManager.registerToolWindow("Duplicates", true, ToolWindowAnchor.BOTTOM, (Disposable)p2);
            this.myContentManager = toolWindow.getContentManager();
            ContentManagerWatcher.watchContentManager((ToolWindow)toolWindow, (ContentManager)this.myContentManager);
        });
    }

    public static DuplocateManager getInstance(@NotNull Project project) {
        if (project == null) {
            DuplocateManager.a(1);
        }
        return (DuplocateManager)project.getService(DuplocateManager.class);
    }

    private static DuplocateVisitor[] a(DuplicatesProfile[] duplicatesProfileArray, FragmentsCollector fragmentsCollector, DuplocatorSettings duplocatorSettings) {
        DuplocatorSettings.getInstance().loadState(duplocatorSettings);
        DuplocateVisitor[] duplocateVisitorArray = new DuplocateVisitor[duplicatesProfileArray.length];
        for (int i10 = 0; i10 < duplocateVisitorArray.length; ++i10) {
            duplocateVisitorArray[i10] = duplicatesProfileArray[i10].createVisitor(fragmentsCollector);
        }
        return duplocateVisitorArray;
    }

    public static void hash(DuplocatorHashCallback duplicateCollector, DuplocatorSettings settings, @NotNull AnalysisScope scope) {
        DuplicatesProfile duplicatesProfile;
        Language language;
        long l2 = a ^ 0x57AE304A54E4L;
        if (scope == null) {
            DuplocateManager.a(2);
        }
        if ((language = Language.findLanguageByID((String)"JAVA")) != null && (duplicatesProfile = DuplicatesProfile.findProfileForLanguage((Language)language)) != null) {
            DuplocateManager.hash(scope, (FragmentsCollector)duplicateCollector, Collections.singletonList(duplicatesProfile), settings);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void hash(@NotNull AnalysisScope scope, FragmentsCollector collector, List<? extends DuplicatesProfile> profiles, DuplocatorSettings settings) {
        long l2 = a ^ 0x3B08AD215239L;
        if (scope == null) {
            DuplocateManager.a(3);
        }
        ArrayList<DuplicatesProfile> arrayList = new ArrayList<DuplicatesProfile>();
        ArrayList<DuplicatesProfile> arrayList2 = new ArrayList<DuplicatesProfile>();
        boolean bl2 = scope.getFileCount() > 500;
        for (DuplicatesProfile duplicatesProfileArray2 : profiles) {
            if (bl2 && duplicatesProfileArray2.supportIndex()) {
                arrayList.add(duplicatesProfileArray2);
                continue;
            }
            arrayList2.add(duplicatesProfileArray2);
        }
        Project project = scope.getProject();
        if (!arrayList.isEmpty()) {
            DuplicatesIndex duplicatesIndex;
            DuplicatesProfile[] duplicatesProfileArray = arrayList.toArray(new DuplicatesProfile[0]);
            try {
                duplicatesIndex = new DuplicatesIndex(project, duplicatesProfileArray);
            }
            catch (IOException iOException) {
                LOG.warn("Duplicates index cannot be used", (Throwable)iOException);
                duplicatesIndex = null;
            }
            if (duplicatesIndex != null) {
                try {
                    duplicatesIndex.update(scope);
                    duplicatesIndex.processAll(scope, collector);
                }
                finally {
                    Disposer.dispose((Disposable)duplicatesIndex);
                }
            } else {
                arrayList2.addAll(arrayList);
            }
        }
        if (!arrayList2.isEmpty()) {
            DuplicatesProfile[] duplicatesProfileArray = arrayList2.toArray(new DuplicatesProfile[0]);
            DuplocateManager.a(scope, collector, duplicatesProfileArray, settings);
        }
    }

    private static void a(@NotNull AnalysisScope analysisScope, FragmentsCollector fragmentsCollector, DuplicatesProfile[] duplicatesProfileArray, DuplocatorSettings duplocatorSettings) {
        DuplocateVisitor[] duplocateVisitorArray;
        if (analysisScope == null) {
            DuplocateManager.a(4);
        }
        for (DuplocateVisitor duplocateVisitor : duplocateVisitorArray = DuplocateManager.a(analysisScope, fragmentsCollector, duplicatesProfileArray, duplocatorSettings)) {
            duplocateVisitor.hashingFinished();
        }
    }

    private static DuplocateVisitor[] a(@NotNull AnalysisScope analysisScope, FragmentsCollector fragmentsCollector, DuplicatesProfile[] duplicatesProfileArray, DuplocatorSettings duplocatorSettings) {
        long l2 = a ^ 0x3262ABA03DFCL;
        if (analysisScope == null) {
            DuplocateManager.a(5);
        }
        final int n2 = analysisScope.getFileCount();
        final ProgressIndicator progressIndicator2 = ProgressManager.getInstance().getProgressIndicator();
        if (progressIndicator2 != null) {
            progressIndicator2.setIndeterminate(false);
            progressIndicator2.setText(DupLocatorBundle.message((String)"duplicates.searching.progress", (Object[])new Object[0]));
        }
        final DuplocateVisitor[] duplocateVisitorArray = DuplocateManager.a(duplicatesProfileArray, fragmentsCollector, duplocatorSettings);
        final int[] nArray = new int[]{0};
        analysisScope.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){
            private static final long a = la.a(-9064676559018675544L, -6827837118715247972L, MethodHandles.lookup().lookupClass()).a(188442515693761L);

            public void visitFile(@NotNull PsiFile baseFile) {
                if (baseFile == null) {
                    1.a(0);
                }
                Project project = baseFile.getProject();
                nArray[0] = nArray[0] + 1;
                if (progressIndicator2 != null) {
                    VirtualFile virtualFile = baseFile.getVirtualFile();
                    if (virtualFile != null) {
                        progressIndicator2.setText2(ProjectUtil.calcRelativeToProjectPath((VirtualFile)virtualFile, (Project)project));
                    }
                    progressIndicator2.setFraction((double)nArray[0] / (double)n2);
                }
                try {
                    for (PsiFile psiFile : baseFile.getViewProvider().getAllFiles()) {
                        for (DuplocateVisitor duplocateVisitor : duplocateVisitorArray) {
                            duplocateVisitor.visitNode((PsiElement)psiFile);
                        }
                        InjectedLanguageManager.getInstance((Project)project).dropFileCaches(psiFile);
                    }
                }
                catch (ProcessCanceledException | IndexNotReadyException throwable) {
                    throw throwable;
                }
                catch (Exception exception) {
                    LOG.error((Throwable)exception);
                }
            }

            private static /* synthetic */ void a(int n22) {
                long l2 = a ^ 0x502D31DAE3F4L;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseFile", "com/intellij/dupLocator/DuplocateManager$1", "visitFile"));
            }
        });
        return duplocateVisitorArray;
    }

    void findAndShow(AnalysisScope scope, DuplocatorSettings settings, List<DuplicatesProfile> profiles) {
        long l2 = a ^ 0xE15C7C239F6L;
        PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
        DuplocatorHashCallback duplocatorHashCallback = new DuplocatorHashCallback(-1, -1);
        final Runnable runnable = () -> {
            long l2 = a ^ 0x649250FD5069L;
            try {
                DuplocateManager.hash(scope, (FragmentsCollector)duplocatorHashCallback, profiles, settings);
            }
            catch (IndexNotReadyException indexNotReadyException) {
                DumbService.getInstance((Project)this.myProject).showDumbModeNotification(DupLocatorBundle.message((String)"duplication.unavailable.without.indices", (Object[])new Object[0]));
                throw new ProcessCanceledException();
            }
        };
        final Runnable runnable2 = () -> ApplicationManager.getApplication().invokeLater(() -> {
            long l2 = a ^ 0x455C9D5C33EDL;
            DupInfo dupInfo = duplocatorHashCallback.getInfo();
            if (dupInfo.getPatterns() > 0) {
                int n2 = -1;
                this.a(dupInfo, scope, settings, -1, null, scope != null ? scope.getDisplayName() : "", profiles, true);
            } else {
                Messages.showInfoMessage((Project)this.myProject, (String)DupLocatorBundle.message((String)"duplication.none.found.message", (Object[])new Object[0]), (String)DupLocatorBundle.message((String)"duplication.none.found.title", (Object[])new Object[0]));
            }
        });
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(this.myProject, DupLocatorBundle.message((String)"duplication.progress", (Object[])new Object[0]), true, (PerformInBackgroundOption)new PerformAnalysisInBackgroundOption(this.myProject)){
            private static final long a = la.a(7691847420502666211L, 1631730844222117948L, MethodHandles.lookup().lookupClass()).a(152770813164347L);

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    2.a(0);
                }
                runnable.run();
            }

            public void onSuccess() {
                runnable2.run();
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x4D686880AFC6L;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/dupLocator/DuplocateManager$2", "run"));
            }
        });
    }

    public void showDuplicates(DupInfo info, AnalysisScope scope, DuplocatorSettings settings) {
        int n2 = -1;
        this.a(info, scope, settings, -1, null, scope != null ? scope.getDisplayName() : "", DuplicatesProfile.getAllProfiles(), false);
    }

    public void showDuplicates(DupInfo info, int caretOffset, VirtualFile virtualFile, @NlsContexts.TabTitle String title) {
        this.a(info, null, null, caretOffset, virtualFile, title, DuplicatesProfile.getAllProfiles(), false);
    }

    private void a(DupInfo dupInfo, AnalysisScope analysisScope, DuplocatorSettings duplocatorSettings, int n2, VirtualFile virtualFile, @NlsContexts.TabTitle String string, List<DuplicatesProfile> list2, boolean bl2) {
        Object object;
        Object object2;
        JTree jTree;
        long l2 = a ^ 0x1645AE1E2CCBL;
        DuplicatesForm duplicatesForm = DuplicatesForm.create(this.myProject, dupInfo);
        if (n2 != -1 && virtualFile != null) {
            jTree = duplicatesForm.getDuplicatesTree();
            TreeUtil.treeNodeTraverser((TreeNode)((TreeNode)jTree.getModel().getRoot())).traverse(TreeTraversal.POST_ORDER_DFS).processEach(treeNode -> {
                if (treeNode instanceof CodeNode) {
                    CodeNode codeNode = (CodeNode)treeNode;
                    try {
                        if (Comparing.equal((Object)codeNode.getVirtualFile(), (Object)virtualFile) && codeNode.getTextRange().contains(n2)) {
                            TreeUtil.selectNode((JTree)jTree, (TreeNode)codeNode);
                            return false;
                        }
                    }
                    catch (InvalidatedException invalidatedException) {
                        return true;
                    }
                }
                return true;
            });
        }
        jTree = new DeprecationStripePanel(DupLocatorBundle.message((String)"label.locate.duplicates.action.deprecated", (Object[])new Object[0]), null);
        if (PlatformUtils.isIdeaUltimate()) {
            object2 = DupLocatorBundle.message((String)"link.label.duplicated.code.fragment", (Object[])new Object[0]);
            object = DupLocatorBundle.message((String)"link.label.use.duplicate.coded.fragment.inspection", (Object[])new Object[]{object2});
            jTree = jTree.withAlternativeAction((String)object, (AnAction)new RunInspectionAction((String)object2));
        }
        object2 = new ContentPanel(duplicatesForm.getComponent());
        if (analysisScope != null && list2 != null) {
            ((ContentPanel)object2).addRerunAction(() -> {
                Content content = this.myContentManager.getSelectedContent();
                if (content != null) {
                    this.myContentManager.removeContent(content, true);
                }
                this.findAndShow(analysisScope, duplocatorSettings, list2);
            });
        }
        object = bl2 ? jTree.wrap(((ContentPanel)object2).getComponent()) : ((ContentPanel)object2).getComponent();
        Content content = this.myContentManager.getFactory().createContent((JComponent)object, string, true);
        content.setHelpId("find.locateDuplicates.result");
        content.setDisposer((Disposable)duplicatesForm);
        this.myContentManager.addContent(content);
        this.myContentManager.setSelectedContent(content);
        ((ContentPanel)object2).addCloseAction(this.myContentManager, content);
        duplicatesForm.addToolbarActionsTo((ContentPanel)object2);
        ToolWindowManager.getInstance((Project)this.myProject).getToolWindow("Duplicates").activate(null);
    }

    static {
        a = la.a(-804205744720630966L, -3118403548189574169L, MethodHandles.lookup().lookupClass()).a(258053228983064L);
        LOG = Logger.getInstance(DuplocateManager.class);
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l2 = a ^ 0x7449799DB6CFL;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
        }
        objectArray2[1] = "com/intellij/dupLocator/DuplocateManager";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getInstance";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "hash";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "doHash";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "visitAll";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

