/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr;

import a.d.la;
import com.google.common.collect.Maps;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.cidr.PathTreeBase;
import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PathTree<Self extends PathTree<Self, T>, T>
extends PathTreeBase<Self>
implements Cloneable {
    @Nullable
    protected Set<T> myItems;
    private static final long a = la.a(6921665145010619341L, 2649384125795385388L, MethodHandles.lookup().lookupClass()).a(20696872004336L);

    public PathTree() {
        this(true);
    }

    public PathTree(boolean resolveSymlinksIfNecessary) {
        super(resolveSymlinksIfNecessary);
    }

    @NotNull
    protected Set<T> createItemsSet(@Nullable Set<T> existing) {
        return existing != null ? new HashSet<T>(existing) : new HashSet();
    }

    public void addItem(@NotNull String path, @NotNull T item) {
        if (path == null) {
            PathTree.b(0);
        }
        if (item == null) {
            PathTree.b(1);
        }
        PathTree pathTree = (PathTree)this.getNotNullSubTree(path);
        pathTree.getItemsForWrite().add(item);
    }

    public void addItems(@NotNull String path, T ... items) {
        if (path == null) {
            PathTree.b(2);
        }
        if (items == null) {
            PathTree.b(3);
        }
        PathTree pathTree = (PathTree)this.getNotNullSubTree(path);
        ContainerUtil.addAll(pathTree.getItemsForWrite(), (Object[])items);
    }

    public int removeItem(@NotNull String path, @NotNull T ref) {
        Set<T> set;
        PathTree pathTree;
        if (path == null) {
            PathTree.b(4);
        }
        if (ref == null) {
            PathTree.b(5);
        }
        if ((pathTree = (PathTree)this.getSubTree(path, PathTreeBase.SearchStrategy.NULL_IF_NOT_FOUND)) != null && (set = pathTree.myItems) != null) {
            set.remove(ref);
            return set.size();
        }
        return 0;
    }

    @NotNull
    public Set<T> getItems() {
        Set set = this.myItems == null ? Collections.emptySet() : this.myItems;
        if (set == null) {
            PathTree.b(6);
        }
        return set;
    }

    @NotNull
    Set<T> getItemsForWrite() {
        Set<T> set = this.myItems == null ? (this.myItems = this.createItemsSet(null)) : this.myItems;
        if (set == null) {
            PathTree.b(7);
        }
        return set;
    }

    @Override
    Self clone(@Nullable Self parent) {
        PathTree pathTree = (PathTree)super.clone(parent);
        Set<T> set = this.myItems;
        pathTree.myItems = set == null ? null : this.createItemsSet(set);
        return (Self)pathTree;
    }

    @Override
    protected void mergeInto(@NotNull Self mergedTree, @NotNull MultiMap<String, Self> childrenPerKey) {
        if (mergedTree == null) {
            PathTree.b(8);
        }
        if (childrenPerKey == null) {
            PathTree.b(9);
        }
        super.mergeInto(mergedTree, childrenPerKey);
        Set<T> set = this.myItems;
        if (set != null) {
            ((PathTree)mergedTree).getItemsForWrite().addAll(set);
        }
    }

    @Override
    public String toString() {
        long l2 = a ^ 0xCF1FF436ECEL;
        if (this.guaranteedToBeEmpty()) {
            return "{}";
        }
        StringBuilder stringBuilder = new StringBuilder(1024).append('{');
        this.accept(new PathTreeBase.ToStringVisitor(stringBuilder));
        return stringBuilder.append('}').toString();
    }

    @Override
    protected boolean isLeaf() {
        return !ContainerUtil.isEmpty(this.myItems);
    }

    @Override
    protected void nodeToString(@NotNull StringBuilder sb, @Nullable String path) {
        if (sb == null) {
            PathTree.b(10);
        }
        super.nodeToString(sb, path);
        sb.append('=').append(this.myItems);
    }

    @Override
    @NotNull
    protected Object nodeDebugRenderer(@Nullable String path) {
        Map.Entry entry = Maps.immutableEntry((Object)super.nodeDebugRenderer(path), this.myItems);
        if (entry == null) {
            PathTree.b(11);
        }
        return entry;
    }

    private static /* synthetic */ void b(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = a ^ 0x723737A5FEAL;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 11: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 6: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/PathTree";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mergedTree";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childrenPerKey";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sb";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/PathTree";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getItems";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getItemsForWrite";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "nodeDebugRenderer";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addItem";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addItems";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "removeItem";
                break;
            }
            case 6: 
            case 7: 
            case 11: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "mergeInto";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "nodeToString";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

