/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.rsa;

import a.d.la;
import java.math.BigInteger;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class RSAEncoder {
    private final BigInteger privateExponent;
    private final BigInteger privateModulus;
    private final int chunkSize;
    private final int digitsPerChunk;
    private int digitsGenerated = 0;
    private final BigInteger myDigitsMod;
    private final boolean myAddDashes;
    private static final long a = la.a(-1609666667983529983L, 2724788113235017498L, null).a(231148596180032L);

    public RSAEncoder(BigInteger privateExponent, BigInteger privateModulus, int alphabetSize, boolean addDashes) {
        this.privateExponent = privateExponent;
        this.privateModulus = privateModulus;
        this.myAddDashes = addDashes;
        int n2 = privateModulus.bitLength();
        this.myDigitsMod = new BigInteger(String.valueOf(alphabetSize));
        int n3 = (int)Math.ceil((double)n2 / Math.log(alphabetSize) * Math.log(2.0));
        if (n3 % 5 != 0) {
            n3 = (n3 / 5 + 1) * 5;
        }
        this.digitsPerChunk = n3;
        this.chunkSize = n2 / 8 - 1;
    }

    public String encode(byte[] data) {
        byte[] byArray;
        long l2 = a ^ 0x985955CE4F1L;
        long l3 = l2 ^ 0x93AE8EC3BC9L;
        int n2 = (int)(l3 >>> 56);
        int n3 = (int)(l3 << 8 >>> 32);
        int n4 = (int)(l3 << 40 >>> 40);
        int n5 = data.length % this.chunkSize;
        if (n5 == 0) {
            byArray = data;
        } else {
            byArray = new byte[data.length + this.chunkSize - n5];
            System.arraycopy(data, 0, byArray, this.chunkSize - n5, data.length);
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i10 = 0; i10 < byArray.length; i10 += this.chunkSize) {
            this.a(byArray, stringBuilder, i10, this.chunkSize, (byte)n2, n3, n4);
        }
        return stringBuilder.toString();
    }

    private void a(byte[] byArray, StringBuilder stringBuilder, int n2, int n3, byte by2, int n4, int n5) {
        long l2 = ((long)by2 << 56 | (long)n4 << 32 >>> 8 | (long)n5 << 40 >>> 40) ^ a;
        if (n3 == 0) {
            return;
        }
        byte[] byArray2 = new byte[this.chunkSize];
        System.arraycopy(byArray, n2, byArray2, 0, n3);
        BigInteger bigInteger = new BigInteger(1, byArray2);
        if (bigInteger.compareTo(this.privateModulus) >= 0) {
            throw new IllegalArgumentException("result is too long");
        }
        BigInteger bigInteger2 = bigInteger.modPow(this.privateExponent, this.privateModulus);
        this.a(stringBuilder, this.a(bigInteger2));
    }

    private void a(StringBuilder stringBuilder, CharSequence charSequence) {
        for (int i10 = 0; i10 < charSequence.length(); ++i10) {
            this.a(stringBuilder);
            stringBuilder.append(charSequence.charAt(i10));
        }
    }

    private CharSequence a(BigInteger bigInteger) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i10 = 0; i10 < this.digitsPerChunk; ++i10) {
            stringBuilder.append(RSAEncoder.a(bigInteger.mod(this.myDigitsMod)));
            bigInteger = bigInteger.divide(this.myDigitsMod);
        }
        return new ReverseCharSequence(stringBuilder);
    }

    private void a(StringBuilder stringBuilder) {
        if (this.digitsGenerated > 0 && this.digitsGenerated % 5 == 0) {
            if (this.digitsGenerated % 30 == 0) {
                stringBuilder.append('\n');
            } else if (this.myAddDashes) {
                stringBuilder.append('-');
            }
        }
        ++this.digitsGenerated;
    }

    private static char a(BigInteger bigInteger) {
        int n2 = bigInteger.intValue();
        char c10 = n2 < 10 ? (char)(48 + n2) : (n2 < 36 ? (char)(65 + n2 - 10) : (n2 < 62 ? (char)(97 + n2 - 36) : (char)(33 + n2 - 62)));
        return c10;
    }

    private static class ReverseCharSequence
    implements CharSequence {
        private final CharSequence mySequence;

        public ReverseCharSequence(CharSequence sequence) {
            this.mySequence = sequence;
        }

        public int length() {
            return this.mySequence.length();
        }

        public char charAt(int index) {
            return this.mySequence.charAt(this.mySequence.length() - index - 1);
        }

        public CharSequence subSequence(int start2, int end) {
            int n2 = this.mySequence.length();
            return new ReverseCharSequence(this.mySequence.subSequence(n2 - end, n2 - start2));
        }
    }
}

