/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.clangFormat.settings;

import com.intellij.application.options.CodeStyle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.modifier.CodeStyleSettingsModifier;
import com.intellij.psi.codeStyle.modifier.CodeStyleStatusBarUIContributor;
import com.intellij.psi.codeStyle.modifier.TransientCodeStyleSettings;
import com.jetbrains.cidr.lang.daemon.clang.format.ClangFormatChangeSettingsProvider;
import com.jetbrains.cidr.lang.ui.OCLongActionUtil;
import com.jetbrains.clangFormat.ClangFormatUtils;
import com.jetbrains.clangFormat.components.ClangFormatModificationTracker;
import com.jetbrains.clangFormat.messages.ClangFormatBundle;
import com.jetbrains.clangFormat.settings.ClangFormatSettings;
import com.jetbrains.clangFormat.settings.ClangFormatStatusUIContributor;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClangFormatCodeStyleSettingsModifier
implements CodeStyleSettingsModifier {
    public boolean modifySettings(@NotNull TransientCodeStyleSettings settings, @NotNull PsiFile source) {
        ClangFormatChangeSettingsProvider formatProvider;
        if (settings == null) {
            ClangFormatCodeStyleSettingsModifier.$$$reportNull$$$0(0);
        }
        if (source == null) {
            ClangFormatCodeStyleSettingsModifier.$$$reportNull$$$0(1);
        }
        if ((formatProvider = ClangFormatUtils.findApplicableClangFormatProvider(source)) != null) {
            settings.addDependency((ModificationTracker)ClangFormatModificationTracker.getInstance());
            return OCLongActionUtil.execWithTimeoutProgressInDispatch((String)ClangFormatBundle.message("progressbar.long.clang.settings", new Object[0]), (Project)source.getProject(), () -> {
                String clangFormatConfigurationContentAsYaml = ClangFormatUtils.getContent(source);
                ClangFormatUtils.applySettings(formatProvider, settings, source, clangFormatConfigurationContentAsYaml, source.getName());
                return true;
            }) == Boolean.TRUE;
        }
        return false;
    }

    @Nullable
    public CodeStyleStatusBarUIContributor getStatusBarUiContributor(@NotNull TransientCodeStyleSettings transientSettings) {
        if (transientSettings == null) {
            ClangFormatCodeStyleSettingsModifier.$$$reportNull$$$0(2);
        }
        return new ClangFormatStatusUIContributor(transientSettings);
    }

    public String getName() {
        return "ClangFormat";
    }

    public boolean mayOverrideSettingsOf(@NotNull Project project) {
        if (project == null) {
            ClangFormatCodeStyleSettingsModifier.$$$reportNull$$$0(3);
        }
        return ((ClangFormatSettings)CodeStyle.getSettings((Project)project).getCustomSettings(ClangFormatSettings.class)).ENABLED;
    }

    @Nullable
    public Consumer<CodeStyleSettings> getDisablingFunction() {
        return settings -> {
            ClangFormatSettings clangFormatSettings = (ClangFormatSettings)settings.getCustomSettings(ClangFormatSettings.class);
            clangFormatSettings.ENABLED = false;
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transientSettings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/clangFormat/settings/ClangFormatCodeStyleSettingsModifier";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "modifySettings";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getStatusBarUiContributor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "mayOverrideSettingsOf";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

