/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.console;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.impl.ConsoleViewUtil;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.LafManagerListener;
import com.intellij.ide.ui.UISettings;
import com.intellij.javascript.debugger.console.ConsoleHtmlPanel;
import com.intellij.javascript.debugger.console.DOMNode;
import com.intellij.javascript.debugger.console.DeferredEntity;
import com.intellij.javascript.debugger.console.HyperLink;
import com.intellij.javascript.debugger.console.JSBridge;
import com.intellij.javascript.debugger.console.Node;
import com.intellij.javascript.debugger.console.PrintableEntity;
import com.intellij.javascript.debugger.console.ResourcesStaticServer;
import com.intellij.javascript.debugger.console.StylesConversionKt;
import com.intellij.javascript.debugger.console.TreeRoot;
import com.intellij.javascript.debugger.console.Variable;
import com.intellij.javascript.debugger.console.WebConsoleFilterForm;
import com.intellij.javascript.debugger.console.WebConsoleHistoryView;
import com.intellij.javascript.debugger.console.WebConsoleView;
import com.intellij.javascript.debugger.console.WebConsoleViewSettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsListener;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.colors.impl.DelegateColorScheme;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.DeferredIcon;
import com.intellij.util.Function;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.frame.XDebuggerTreeNodeHyperlink;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.nodes.MessageTreeNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XDebuggerTreeNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueContainerNode;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.event.KeyAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u00b2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000 p2\u00020\u0001:\u0002pqB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u00107\u001a\u0002082\u0006\u00109\u001a\u00020:J\b\u0010;\u001a\u000208H\u0002J\u0010\u0010<\u001a\u00020$2\u0006\u0010=\u001a\u00020-H\u0002J+\u0010>\u001a\u0004\u0018\u00010\u000e2\u0006\u0010?\u001a\u00020\f2\u0012\u0010@\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\r\"\u00020\u000eH\u0002\u00a2\u0006\u0002\u0010AJ\u0006\u0010B\u001a\u000208J\b\u0010C\u001a\u000208H\u0016J\u0006\u0010D\u001a\u000208J\u0006\u0010E\u001a\u000208J$\u0010F\u001a\u0002082\u0006\u0010G\u001a\u00020\f2\u0006\u0010H\u001a\u00020\u00102\f\u0010I\u001a\b\u0012\u0004\u0012\u00020\u00100JJ\u0014\u0010K\u001a\u0002082\f\u0010L\u001a\b\u0012\u0004\u0012\u00020-0MJ\u0017\u0010N\u001a\u0004\u0018\u00010 2\u0006\u0010O\u001a\u00020\fH\u0000\u00a2\u0006\u0002\bPJ\b\u0010Q\u001a\u00020RH\u0002J\u0006\u0010S\u001a\u000208J\u0006\u0010T\u001a\u00020\u0010J\u001c\u0010U\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u000e0\u001e2\u0006\u0010=\u001a\u00020-H\u0002J\u0006\u0010V\u001a\u000208J\u001c\u0010W\u001a\u0002082\u0012\u0010X\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u000e0\u001eH\u0002J\u0014\u0010Y\u001a\u0002082\f\u0010Z\u001a\b\u0012\u0004\u0012\u0002080\u001fJ\u0014\u0010[\u001a\u0002082\f\u0010Z\u001a\b\u0012\u0004\u0012\u0002080\u001fJ\u0006\u0010\\\u001a\u000208J\u0006\u0010]\u001a\u000208J\u0006\u0010^\u001a\u000208J\u000e\u0010_\u001a\u0002082\u0006\u0010`\u001a\u00020\u0010J\u0016\u0010a\u001a\u0002082\u0006\u0010b\u001a\u00020\f2\u0006\u0010c\u001a\u00020\u0010J\u001e\u0010d\u001a\u0002082\u0006\u0010e\u001a\u00020f2\u0006\u0010g\u001a\u00020\f2\u0006\u0010h\u001a\u00020\fJ\u0006\u0010i\u001a\u000208J\u000e\u0010j\u001a\u0002082\u0006\u0010k\u001a\u00020lJ\b\u0010m\u001a\u000208H\u0002J\u0012\u0010n\u001a\u0002082\b\b\u0002\u0010o\u001a\u00020\u0010H\u0002R(\u0010\t\u001a\u001c\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\f\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\r0\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0013\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u001d\u001a\u0016\u0012\u0004\u0012\u00020\f\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010 0\u001f0\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u000e\u0010)\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010+\u001a\u0012\u0012\u0004\u0012\u00020-0,j\b\u0012\u0004\u0012\u00020-`.X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100R$\u00102\u001a\u00020\u00102\u0006\u00101\u001a\u00020\u0010@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u00104\"\u0004\b5\u00106\u00a8\u0006r"}, d2={"Lcom/intellij/javascript/debugger/console/WebConsoleHistoryView;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "settings", "Lcom/intellij/javascript/debugger/console/WebConsoleViewSettings;", "htmlPanel", "Lcom/intellij/javascript/debugger/console/ConsoleHtmlPanel;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/javascript/debugger/console/WebConsoleViewSettings;Lcom/intellij/javascript/debugger/console/ConsoleHtmlPanel;)V", "batch", "", "Lkotlin/Pair;", "", "", "", "batchRequests", "", "colorScheme", "Lcom/intellij/openapi/editor/colors/impl/DelegateColorScheme;", "component", "Ljava/awt/Component;", "getComponent", "()Ljava/awt/Component;", "domPresentationProvider", "Lcom/intellij/javascript/debugger/console/WebConsoleView$DOMPresentationProvider;", "getDomPresentationProvider$intellij_javascript_debugger", "()Lcom/intellij/javascript/debugger/console/WebConsoleView$DOMPresentationProvider;", "setDomPresentationProvider$intellij_javascript_debugger", "(Lcom/intellij/javascript/debugger/console/WebConsoleView$DOMPresentationProvider;)V", "iconCache", "", "Lkotlin/Function0;", "Ljavax/swing/Icon;", "jsBridge", "Lcom/intellij/javascript/debugger/console/WebConsoleHistoryView$JSBridgeImpl;", "lastId", "", "getProject", "()Lcom/intellij/openapi/project/Project;", "getSettings", "()Lcom/intellij/javascript/debugger/console/WebConsoleViewSettings;", "stickToEnd", "stylesRegistered", "systemMessageCache", "Ljava/util/ArrayList;", "Lcom/intellij/javascript/debugger/console/PrintableEntity;", "Lkotlin/collections/ArrayList;", "getSystemMessageCache$intellij_javascript_debugger", "()Ljava/util/ArrayList;", "value", "useSoftWraps", "getUseSoftWraps", "()Z", "setUseSoftWraps", "(Z)V", "addKeyListener", "", "keyAdapter", "Ljava/awt/event/KeyAdapter;", "attachStyles", "cachePrintable", "printable", "callJS", "method", "args", "(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/Object;", "clear", "dispose", "endGroup", "endTrace", "findText", "text", "caseSensitive", "result", "Lorg/jetbrains/concurrency/AsyncPromise;", "flush", "printables", "", "getCachedIcon", "filename", "getCachedIcon$intellij_javascript_debugger", "getConsoleFont", "Ljava/awt/Font;", "increaseLastMessageRepeatCount", "isStickToEnd", "prepareJSProps", "resetAllFilters", "resolveDeferred", "resolvedJsProps", "runInBatch", "function", "runWhenPageReady", "scrollToEnd", "selectNextFindItem", "selectPrevFindItem", "setStickToEnd", "state", "startGroup", "groupName", "collapsed", "startMessage", "type", "Lcom/intellij/javascript/debugger/console/WebConsoleView$MessageType;", "level", "source", "startTrace", "updateFromFilterSettingsUI", "filterForm", "Lcom/intellij/javascript/debugger/console/WebConsoleFilterForm;", "updateLafStyles", "updateStyles", "forceUpdate", "Companion", "JSBridgeImpl", "intellij.javascript.debugger"})
public final class WebConsoleHistoryView
implements Disposable {
    @NotNull
    private final ArrayList<PrintableEntity> systemMessageCache;
    private final JSBridgeImpl jsBridge;
    private int stylesRegistered;
    private int lastId;
    private final DelegateColorScheme colorScheme;
    private boolean stickToEnd;
    private volatile boolean batchRequests;
    private final List<Pair<String, Object[]>> batch;
    @Nullable
    private WebConsoleView.DOMPresentationProvider domPresentationProvider;
    private final Map<String, Function0<Icon>> iconCache;
    private boolean useSoftWraps;
    @NotNull
    private final Project project;
    @NotNull
    private final WebConsoleViewSettings settings;
    private final ConsoleHtmlPanel htmlPanel;
    private static final Logger log;
    private static final Gson gson;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public final ArrayList<PrintableEntity> getSystemMessageCache$intellij_javascript_debugger() {
        return this.systemMessageCache;
    }

    @Nullable
    public final WebConsoleView.DOMPresentationProvider getDomPresentationProvider$intellij_javascript_debugger() {
        return this.domPresentationProvider;
    }

    public final void setDomPresentationProvider$intellij_javascript_debugger(@Nullable WebConsoleView.DOMPresentationProvider dOMPresentationProvider) {
        this.domPresentationProvider = dOMPresentationProvider;
    }

    public final boolean getUseSoftWraps() {
        return this.useSoftWraps;
    }

    public final void setUseSoftWraps(boolean value) {
        this.useSoftWraps = value;
        this.htmlPanel.runWhenPageReady((Function0<Unit>)((Function0)new Function0<Unit>(this, value){
            final /* synthetic */ WebConsoleHistoryView this$0;
            final /* synthetic */ boolean $value;

            public final void invoke() {
                WebConsoleHistoryView.access$getHtmlPanel$p(this.this$0).callJS("softWrap", this.$value);
            }
            {
                this.this$0 = webConsoleHistoryView;
                this.$value = bl;
                super(0);
            }
        }));
    }

    @NotNull
    public final Component getComponent() {
        return this.htmlPanel.getComponent();
    }

    public final void updateFromFilterSettingsUI(@NotNull WebConsoleFilterForm filterForm) {
        Intrinsics.checkNotNullParameter((Object)filterForm, (String)"filterForm");
        this.settings.setShowErrors(filterForm.isShowErrors());
        this.settings.setShowWarnings(filterForm.isShowWarnings());
        this.settings.setShowInfo(filterForm.isShowInfo());
        this.settings.setShowLog(filterForm.isShowLog());
        this.settings.setShowDebug(filterForm.isShowDebug());
        this.settings.setShowNetwork(filterForm.isShowNetwork());
        this.runWhenPageReady((Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ WebConsoleHistoryView this$0;

            public final void invoke() {
                WebConsoleHistoryView.access$updateStyles(this.this$0, true);
            }
            {
                this.this$0 = webConsoleHistoryView;
                super(0);
            }
        }));
    }

    public final void resetAllFilters() {
        this.settings.setShowErrors(true);
        this.settings.setShowWarnings(true);
        this.settings.setShowInfo(true);
        this.settings.setShowLog(true);
        this.settings.setShowDebug(false);
        this.settings.setShowNetwork(true);
        this.runWhenPageReady((Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ WebConsoleHistoryView this$0;

            public final void invoke() {
                WebConsoleHistoryView.access$updateStyles(this.this$0, true);
            }
            {
                this.this$0 = webConsoleHistoryView;
                super(0);
            }
        }));
    }

    private final void attachStyles() {
        String lafCss = UIUtil.isUnderDarcula() ? "darcula.css" : "light.css";
        this.htmlPanel.executeScript("window._lafStyle = document.createElement(\"link\");\nwindow._lafStyle.rel = 'stylesheet';\nwindow._lafStyle.type = 'text/css';\n" + "window._lafStyle.href = '" + lafCss + "';\n" + "document.getElementsByTagName('head')[0].appendChild(window._lafStyle)");
        this.htmlPanel.executeScript("window._styles = document.createElement('style');\nwindow._styles.type = 'text/css';\ndocument.getElementsByTagName('head')[0].appendChild(window._styles);");
    }

    private final void updateStyles(boolean forceUpdate) {
        int size = ConsoleViewContentType.getRegisteredTypes().size();
        if (this.stylesRegistered != size || forceUpdate) {
            FontMetrics fontMetrics = this.getComponent().getFontMetrics(this.getConsoleFont());
            EditorColorsScheme editorColorsScheme = (EditorColorsScheme)this.colorScheme;
            FontMetrics fontMetrics2 = fontMetrics;
            Intrinsics.checkNotNullExpressionValue((Object)fontMetrics2, (String)"fontMetrics");
            String styleSheetContent = StylesConversionKt.convertIDEStylesToCss("message-wrapper", editorColorsScheme, fontMetrics2, this.settings);
            this.htmlPanel.executeScript("window._styles.innerHTML = `" + styleSheetContent + "`;");
            this.htmlPanel.executeScript("updateIcons();");
            this.stylesRegistered = size;
        }
    }

    static /* synthetic */ void updateStyles$default(WebConsoleHistoryView webConsoleHistoryView, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        webConsoleHistoryView.updateStyles(bl);
    }

    private final Font getConsoleFont() {
        Font font = this.colorScheme.getFont(EditorFontType.CONSOLE_PLAIN);
        Intrinsics.checkNotNullExpressionValue((Object)font, (String)"colorScheme.getFont(EditorFontType.CONSOLE_PLAIN)");
        Font schemeFont = font;
        return new Font(schemeFont.getFontName(), schemeFont.getStyle(), Math.round((float)this.colorScheme.getConsoleFontSize() / UISettings.Companion.getDefFontScale()));
    }

    private final void updateLafStyles() {
        String lafCss = UIUtil.isUnderDarcula() ? "darcula.css" : "light.css";
        this.htmlPanel.executeScript("window._lafStyle.href = '" + lafCss + "';");
    }

    public final boolean isStickToEnd() {
        return this.stickToEnd;
    }

    public final void setStickToEnd(boolean state) {
        this.stickToEnd = state;
        this.runWhenPageReady((Function0<Unit>)((Function0)new Function0<Unit>(this, state){
            final /* synthetic */ WebConsoleHistoryView this$0;
            final /* synthetic */ boolean $state;

            public final void invoke() {
                WebConsoleHistoryView.access$callJS(this.this$0, "setStickToEnd", this.$state);
            }
            {
                this.this$0 = webConsoleHistoryView;
                this.$state = bl;
                super(0);
            }
        }));
    }

    public final void clear() {
        this.runWhenPageReady((Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ WebConsoleHistoryView this$0;

            public final void invoke() {
                WebConsoleHistoryView.access$callJS(this.this$0, "clear", new Object[0]);
            }
            {
                this.this$0 = webConsoleHistoryView;
                super(0);
            }
        }));
        this.systemMessageCache.clear();
        this.lastId = 0;
    }

    /*
     * WARNING - void declaration
     */
    public final void flush(@NotNull List<? extends PrintableEntity> printables) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(printables, (String)"printables");
        Iterable iterable = printables;
        WebConsoleHistoryView webConsoleHistoryView = this;
        boolean $i$f$map = false;
        void var5_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p1;
            PrintableEntity printableEntity = (PrintableEntity)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Map<String, Object> map2 = webConsoleHistoryView.prepareJSProps((PrintableEntity)p1);
            collection.add(map2);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map it = (Map)element$iv;
            boolean bl = false;
            this.callJS("print", it);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, Object> prepareJSProps(PrintableEntity printable) {
        void readyPrintable;
        Pair pair = printable instanceof DeferredEntity ? ((DeferredEntity)printable).get() : new Pair((Object)printable, (Object)false);
        PrintableEntity printableEntity = (PrintableEntity)pair.component1();
        boolean deferred = (Boolean)pair.component2();
        Map<String, Object> jsProps = readyPrintable.getJSProps();
        int id = this.cachePrintable((PrintableEntity)readyPrintable);
        jsProps.put("id", id);
        if (readyPrintable instanceof Node && ((Node)readyPrintable).hasIcon()) {
            jsProps.put("iconURL", ResourcesStaticServer.Companion.cacheIconId$intellij_javascript_debugger(this, id + ".png"));
        }
        if (deferred) {
            jsProps.put("deferred", true);
            AppUIUtil.invokeOnEdt((Runnable)new Runnable(this, printable, id){
                final /* synthetic */ WebConsoleHistoryView this$0;
                final /* synthetic */ PrintableEntity $printable;
                final /* synthetic */ int $id;

                public final void run() {
                    PrintableEntity printableEntity = this.$printable;
                    if (printableEntity == null) {
                        throw new NullPointerException("null cannot be cast to non-null type com.intellij.javascript.debugger.console.DeferredEntity");
                    }
                    ((DeferredEntity)printableEntity).getPromise().then(new Function(this){
                        final /* synthetic */ prepareJSProps.1 this$0;

                        public final void fun(PrintableEntity resolved) {
                            WebConsoleHistoryView webConsoleHistoryView = this.this$0.this$0;
                            PrintableEntity printableEntity = resolved;
                            Intrinsics.checkNotNullExpressionValue((Object)printableEntity, (String)"resolved");
                            Map resolvedJsProps = WebConsoleHistoryView.access$prepareJSProps(webConsoleHistoryView, printableEntity);
                            resolvedJsProps.put("deferredID", this.this$0.$id);
                            WebConsoleHistoryView.access$resolveDeferred(this.this$0.this$0, resolvedJsProps);
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    });
                }
                {
                    this.this$0 = webConsoleHistoryView;
                    this.$printable = printableEntity;
                    this.$id = n;
                }
            });
        }
        return jsProps;
    }

    @Nullable
    public final Icon getCachedIcon$intellij_javascript_debugger(@NotNull String filename) {
        Icon icon;
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        Integer n = StringsKt.toIntOrNull((String)StringsKt.substringBeforeLast$default((String)filename, (String)".png", null, (int)2, null));
        if (n != null) {
            Icon icon2;
            Integer n2 = n;
            boolean bl = false;
            boolean bl2 = false;
            int id = ((Number)n2).intValue();
            boolean bl3 = false;
            PrintableEntity printableEntity = this.systemMessageCache.get(id);
            if (!(printableEntity instanceof Node)) {
                printableEntity = null;
            }
            Node node = (Node)printableEntity;
            Icon icon3 = icon2 = node != null ? node.getIcon() : null;
            if (icon2 instanceof DeferredIcon) {
                boolean $i$f$runReadAction = false;
                icon = (Icon)ApplicationManager.getApplication().runReadAction(new Computable(icon2){
                    final /* synthetic */ Icon $icon$inlined;
                    {
                        this.$icon$inlined = icon;
                    }

                    public final T compute() {
                        boolean bl = false;
                        return (T)((DeferredIcon)this.$icon$inlined).evaluate();
                    }
                });
            } else {
                icon = icon2;
            }
        } else {
            icon = null;
        }
        return icon;
    }

    private final int cachePrintable(PrintableEntity printable) {
        if (printable instanceof Node || printable instanceof HyperLink) {
            this.systemMessageCache.add(printable);
            this.lastId = this.systemMessageCache.size();
            return this.lastId - 1;
        }
        return -1;
    }

    public final void scrollToEnd() {
        this.runWhenPageReady((Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ WebConsoleHistoryView this$0;

            public final void invoke() {
                WebConsoleHistoryView.access$getHtmlPanel$p(this.this$0).callJS("scrollDown", new Object[0]);
            }
            {
                this.this$0 = webConsoleHistoryView;
                super(0);
            }
        }));
    }

    public final void increaseLastMessageRepeatCount() {
        this.runWhenPageReady((Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ WebConsoleHistoryView this$0;

            public final void invoke() {
                WebConsoleHistoryView.access$callJS(this.this$0, "increaseLastMessageRepeatCount", new Object[0]);
            }
            {
                this.this$0 = webConsoleHistoryView;
                super(0);
            }
        }));
    }

    public final void findText(@NotNull String text, boolean caseSensitive, @NotNull AsyncPromise<Boolean> result2) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter(result2, (String)"result");
        this.runWhenPageReady((Function0<Unit>)((Function0)new Function0<Unit>(this, text, caseSensitive, result2){
            final /* synthetic */ WebConsoleHistoryView this$0;
            final /* synthetic */ String $text;
            final /* synthetic */ boolean $caseSensitive;
            final /* synthetic */ AsyncPromise $result;

            public final void invoke() {
                WebConsoleHistoryView.access$getHtmlPanel$p(this.this$0).callJS("findText", new Object[]{this.$text, this.$caseSensitive}, (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(this){
                    final /* synthetic */ findText.1 this$0;

                    public final void invoke(@NotNull String it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        String string = it;
                        boolean bl = false;
                        this.this$0.$result.setResult((Object)Boolean.parseBoolean(string));
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                }));
            }
            {
                this.this$0 = webConsoleHistoryView;
                this.$text = string;
                this.$caseSensitive = bl;
                this.$result = asyncPromise;
                super(0);
            }
        }));
    }

    private final void resolveDeferred(Map<String, Object> resolvedJsProps) {
        this.runWhenPageReady((Function0<Unit>)((Function0)new Function0<Unit>(this, resolvedJsProps){
            final /* synthetic */ WebConsoleHistoryView this$0;
            final /* synthetic */ Map $resolvedJsProps;

            public final void invoke() {
                WebConsoleHistoryView.access$callJS(this.this$0, "resolveDeferred", this.$resolvedJsProps);
            }
            {
                this.this$0 = webConsoleHistoryView;
                this.$resolvedJsProps = map2;
                super(0);
            }
        }));
    }

    public final void selectNextFindItem() {
        this.runWhenPageReady((Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ WebConsoleHistoryView this$0;

            public final void invoke() {
                WebConsoleHistoryView.access$getHtmlPanel$p(this.this$0).callJS("findNext", new Object[0]);
            }
            {
                this.this$0 = webConsoleHistoryView;
                super(0);
            }
        }));
    }

    public final void selectPrevFindItem() {
        this.runWhenPageReady((Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ WebConsoleHistoryView this$0;

            public final void invoke() {
                WebConsoleHistoryView.access$getHtmlPanel$p(this.this$0).callJS("findPrev", new Object[0]);
            }
            {
                this.this$0 = webConsoleHistoryView;
                super(0);
            }
        }));
    }

    public final void addKeyListener(@NotNull KeyAdapter keyAdapter) {
        Intrinsics.checkNotNullParameter((Object)keyAdapter, (String)"keyAdapter");
        this.htmlPanel.addKeyListener(keyAdapter);
    }

    public final void runWhenPageReady(@NotNull Function0<Unit> function) {
        Intrinsics.checkNotNullParameter(function, (String)"function");
        this.htmlPanel.runWhenPageReady(function);
    }

    public final void runInBatch(@NotNull Function0<Unit> function) {
        Intrinsics.checkNotNullParameter(function, (String)"function");
        this.runWhenPageReady((Function0<Unit>)((Function0)new Function0<Unit>(this, function){
            final /* synthetic */ WebConsoleHistoryView this$0;
            final /* synthetic */ Function0 $function;

            public final void invoke() {
                WebConsoleHistoryView.access$setBatchRequests$p(this.this$0, true);
                this.$function.invoke();
                WebConsoleHistoryView.updateStyles$default(this.this$0, false, 1, null);
                if (this.this$0.isStickToEnd()) {
                    WebConsoleHistoryView.access$callJS(this.this$0, "scrollDown", new Object[0]);
                }
                WebConsoleHistoryView.access$setBatchRequests$p(this.this$0, false);
                WebConsoleHistoryView.access$getHtmlPanel$p(this.this$0).runRequestsBatch(WebConsoleHistoryView.access$getBatch$p(this.this$0));
                WebConsoleHistoryView.access$getBatch$p(this.this$0).clear();
            }
            {
                this.this$0 = webConsoleHistoryView;
                this.$function = function0;
                super(0);
            }
        }));
    }

    private final Object callJS(String method, Object ... args) {
        if (!this.batchRequests) {
            this.htmlPanel.callJS(method, Arrays.copyOf(args, args.length));
            return Unit.INSTANCE;
        }
        this.batch.add((Pair<String, Object[]>)new Pair((Object)method, (Object)args));
        return null;
    }

    public void dispose() {
        this.systemMessageCache.clear();
        this.iconCache.clear();
        ResourcesStaticServer.Companion.clearConsoleCaches$intellij_javascript_debugger(this);
    }

    public final void startTrace() {
        this.callJS("startTrace", new Object[0]);
    }

    public final void endTrace() {
        this.callJS("endTrace", new Object[0]);
    }

    public final void startMessage(@NotNull WebConsoleView.MessageType type, @NotNull String level, @NotNull String source) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this.callJS("startMessage", new Object[]{type, level, source});
    }

    public final void startGroup(@NotNull String groupName, boolean collapsed) {
        Intrinsics.checkNotNullParameter((Object)groupName, (String)"groupName");
        this.callJS("startGroup", groupName, collapsed);
    }

    public final void endGroup() {
        this.callJS("endGroup", new Object[0]);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final WebConsoleViewSettings getSettings() {
        return this.settings;
    }

    public WebConsoleHistoryView(@NotNull Project project, @NotNull WebConsoleViewSettings settings, @NotNull ConsoleHtmlPanel htmlPanel) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)htmlPanel, (String)"htmlPanel");
        this.project = project;
        this.settings = settings;
        this.htmlPanel = htmlPanel;
        boolean bl = false;
        this.systemMessageCache = new ArrayList();
        this.jsBridge = new JSBridgeImpl(this);
        this.stickToEnd = true;
        bl = false;
        this.batch = new ArrayList();
        this.iconCache = new HashMap();
        this.useSoftWraps = true;
        Disposer.register((Disposable)this, (Disposable)this.htmlPanel);
        this.htmlPanel.load(ResourcesStaticServer.Companion.getMainUrl());
        EditorColorsManager editorColorsManager = EditorColorsManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsManager, (String)"EditorColorsManager.getInstance()");
        DelegateColorScheme delegateColorScheme = ConsoleViewUtil.updateConsoleColorScheme((EditorColorsScheme)editorColorsManager.getGlobalScheme());
        Intrinsics.checkNotNullExpressionValue((Object)delegateColorScheme, (String)"updateConsoleColorScheme\u2026tInstance().globalScheme)");
        this.colorScheme = delegateColorScheme;
        if (UISettings.Companion.getInstance().getPresentationMode()) {
            this.colorScheme.setEditorFontSize(UISettings.Companion.getInstance().getPresentationModeFontSize());
        }
        Color color = this.colorScheme.getDefaultBackground();
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"colorScheme.defaultBackground");
        this.htmlPanel.setBackground(color);
        this.htmlPanel.onInit((Function0<Unit>)((Function0)new Function0<Unit>(){

            public final void invoke() {
                htmlPanel.setBridge(jsBridge);
                this.attachStyles();
                WebConsoleHistoryView.updateStyles$default(this, false, 1, null);
                this.callJS("setMaxRenderedCount", Registry.get((String)"js.debugger.webconsole.maxRenderedCount").asInteger());
                log.info("WebConsole page initialization complete");
            }
        }));
        MessageBusConnection messageBusConnection = this.project.getMessageBus().connect((Disposable)this.htmlPanel);
        Intrinsics.checkNotNullExpressionValue((Object)messageBusConnection, (String)"project.messageBus.connect(htmlPanel)");
        MessageBusConnection connection = messageBusConnection;
        connection.subscribe(EditorColorsManager.TOPIC, (Object)new EditorColorsListener(){

            public final void globalSchemeChange(final @Nullable EditorColorsScheme scheme) {
                this.runWhenPageReady((Function0<Unit>)((Function0)new Function0<Unit>(){

                    public final void invoke() {
                        if (scheme != null) {
                            colorScheme.setDelegate(scheme);
                            ConsoleHtmlPanel consoleHtmlPanel = htmlPanel;
                            Color color = colorScheme.getDefaultBackground();
                            Intrinsics.checkNotNullExpressionValue((Object)color, (String)"colorScheme.defaultBackground");
                            consoleHtmlPanel.setBackground(color);
                        }
                        this.updateStyles(true);
                    }
                }));
            }
        });
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        application.getMessageBus().connect((Disposable)connection).subscribe(LafManagerListener.TOPIC, (Object)new LafManagerListener(){

            public final void lookAndFeelChanged(@NotNull LafManager it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.runWhenPageReady((Function0<Unit>)((Function0)new Function0<Unit>(){

                    public final void invoke() {
                        this.updateLafStyles();
                    }
                }));
            }
        });
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(WebConsoleHistoryView.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(WebCo\u2026eHistoryView::class.java)");
        log = logger;
        Gson gson = new GsonBuilder().create();
        Intrinsics.checkNotNullExpressionValue((Object)gson, (String)"GsonBuilder().create()");
        WebConsoleHistoryView.gson = gson;
    }

    public static final /* synthetic */ boolean access$getStickToEnd$p(WebConsoleHistoryView $this) {
        return $this.stickToEnd;
    }

    public static final /* synthetic */ Gson access$getGson$cp() {
        return gson;
    }

    public static final /* synthetic */ void access$resolveDeferred(WebConsoleHistoryView $this, Map resolvedJsProps) {
        $this.resolveDeferred(resolvedJsProps);
    }

    public static final /* synthetic */ boolean access$getBatchRequests$p(WebConsoleHistoryView $this) {
        return $this.batchRequests;
    }

    public static final /* synthetic */ void access$setBatchRequests$p(WebConsoleHistoryView $this, boolean bl) {
        $this.batchRequests = bl;
    }

    public static final /* synthetic */ List access$getBatch$p(WebConsoleHistoryView $this) {
        return $this.batch;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J/\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00072\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002\u00a2\u0006\u0002\u0010\u0011J\u0010\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0007H\u0016J\u0018\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0007H\u0016J\u0018\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000b\u001a\u00020\u0007H\u0002J \u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0007H\u0002J\u0010\u0010\u001b\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0007H\u0016J\u0010\u0010\u001c\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0007H\u0016J%\u0010\u001d\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00072\u000e\u0010\u001e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\rH\u0002\u00a2\u0006\u0002\u0010\u001fJ\u0012\u0010 \u001a\u00020\n2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0016J\u0010\u0010#\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0007H\u0016J\u0010\u0010$\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0007H\u0016J\u0010\u0010%\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0007H\u0016J\u0018\u0010&\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\u0007H\u0002J\u0010\u0010'\u001a\u00020\n2\u0006\u0010(\u001a\u00020)H\u0016R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/intellij/javascript/debugger/console/WebConsoleHistoryView$JSBridgeImpl;", "Lcom/intellij/javascript/debugger/console/JSBridge;", "webConsoleHistoryView", "Lcom/intellij/javascript/debugger/console/WebConsoleHistoryView;", "(Lcom/intellij/javascript/debugger/console/WebConsoleHistoryView;)V", "treeListeners", "", "", "Ljavax/swing/event/TreeModelListener;", "addChildren", "", "callbackId", "children", "", "", "childIndices", "", "(I[Ljava/lang/Object;[I)V", "collapse", "id", "expand", "expandDOM", "printableInfo", "Lcom/intellij/javascript/debugger/console/DOMNode;", "expandVariable", "variableNode", "Lcom/intellij/xdebugger/impl/ui/tree/nodes/XDebuggerTreeNode;", "hideHighlight", "highlight", "invokeCallback", "args", "(I[Ljava/lang/Object;)V", "log", "text", "", "messageNodeCallback", "navigate", "nodeLinkClick", "removeChildren", "updateStickToEnd", "stickToEnd", "", "intellij.javascript.debugger"})
    public static final class JSBridgeImpl
    implements JSBridge {
        private final Map<Integer, TreeModelListener> treeListeners;
        private final WebConsoleHistoryView webConsoleHistoryView;

        @Override
        public void navigate(int id) {
            block1: {
                PrintableEntity printableEntity = this.webConsoleHistoryView.getSystemMessageCache$intellij_javascript_debugger().get(id);
                if (printableEntity == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.intellij.javascript.debugger.console.HyperLink");
                }
                HyperLink printableInfo = (HyperLink)printableEntity;
                HyperlinkInfo hyperlinkInfo = printableInfo.getHyperlink();
                if (hyperlinkInfo == null) break block1;
                HyperlinkInfo hyperlinkInfo2 = hyperlinkInfo;
                boolean bl = false;
                boolean bl2 = false;
                HyperlinkInfo it = hyperlinkInfo2;
                boolean bl3 = false;
                ApplicationManager.getApplication().invokeLater(new Runnable(it, this){
                    final /* synthetic */ HyperlinkInfo $it;
                    final /* synthetic */ JSBridgeImpl this$0;
                    {
                        this.$it = hyperlinkInfo;
                        this.this$0 = jSBridgeImpl;
                    }

                    public final void run() {
                        this.$it.navigate(JSBridgeImpl.access$getWebConsoleHistoryView$p(this.this$0).getProject());
                    }
                });
            }
        }

        @Override
        public void expand(int id, int callbackId) {
            block1: {
                PrintableEntity printableInfo;
                block2: {
                    block0: {
                        PrintableEntity printableEntity = this.webConsoleHistoryView.getSystemMessageCache$intellij_javascript_debugger().get(id);
                        Intrinsics.checkNotNullExpressionValue((Object)printableEntity, (String)"webConsoleHistoryView.systemMessageCache[id]");
                        printableInfo = printableEntity;
                        if (!(printableInfo instanceof Variable)) break block0;
                        this.expandVariable(((Variable)printableInfo).getVariable(), id, callbackId);
                        break block1;
                    }
                    if (!(printableInfo instanceof TreeRoot)) break block2;
                    this.expandVariable(((TreeRoot)printableInfo).getRoot(), id, callbackId);
                    break block1;
                }
                if (!(printableInfo instanceof DOMNode)) break block1;
                this.expandDOM((DOMNode)printableInfo, callbackId);
            }
        }

        @Override
        public void highlight(int id) {
            PrintableEntity printableEntity = this.webConsoleHistoryView.getSystemMessageCache$intellij_javascript_debugger().get(id);
            if (printableEntity == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.javascript.debugger.console.DOMNode");
            }
            DOMNode printableInfo = (DOMNode)printableEntity;
            printableInfo.getProvider().highlight(printableInfo.getNode());
        }

        @Override
        public void hideHighlight(int id) {
            PrintableEntity printableEntity = this.webConsoleHistoryView.getSystemMessageCache$intellij_javascript_debugger().get(id);
            if (printableEntity == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.javascript.debugger.console.DOMNode");
            }
            DOMNode printableInfo = (DOMNode)printableEntity;
            printableInfo.getProvider().hideHighlight(printableInfo.getNode());
        }

        /*
         * WARNING - void declaration
         */
        private final void expandDOM(DOMNode printableInfo, int callbackId) {
            Collection<Pair> collection;
            void $this$mapIndexedTo$iv$iv;
            void $this$mapIndexed$iv;
            List<DOMNode> children2 = printableInfo.getChildren();
            Object[] objectArray = new Object[2];
            objectArray[0] = true;
            Iterable iterable = children2;
            int n = 1;
            Object[] objectArray2 = objectArray;
            Object[] objectArray3 = objectArray;
            boolean $i$f$mapIndexed = false;
            void var7_9 = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void ind;
                void it;
                int n2 = index$iv$iv++;
                boolean bl = false;
                if (n2 < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                DOMNode dOMNode = (DOMNode)item$iv$iv;
                int n3 = n2;
                collection = destination$iv$iv;
                boolean bl2 = false;
                Pair pair = new Pair((Object)this.webConsoleHistoryView.prepareJSProps((PrintableEntity)it), (Object)((int)ind));
                collection.add(pair);
            }
            collection = (List)destination$iv$iv;
            objectArray2[n] = collection;
            Object[] args = objectArray3;
            this.invokeCallback(callbackId, args);
        }

        private final void expandVariable(XDebuggerTreeNode variableNode, int id, int callbackId) {
            TreeModelListener listener2 = new TreeModelListener(this, variableNode, callbackId){
                final /* synthetic */ JSBridgeImpl this$0;
                final /* synthetic */ XDebuggerTreeNode $variableNode;
                final /* synthetic */ int $callbackId;

                public void treeNodesInserted(@NotNull TreeModelEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    TreePath treePath = e.getTreePath();
                    Intrinsics.checkNotNullExpressionValue((Object)treePath, (String)"e.treePath");
                    Object object = treePath.getLastPathComponent();
                    TreePath treePath2 = this.$variableNode.getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)treePath2, (String)"variableNode.path");
                    if (Intrinsics.areEqual((Object)object, (Object)treePath2.getLastPathComponent())) {
                        Object[] objectArray = e.getChildren();
                        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"e.children");
                        JSBridgeImpl.access$addChildren(this.this$0, this.$callbackId, objectArray, e.getChildIndices());
                    }
                }

                public void treeStructureChanged(@Nullable TreeModelEvent e) {
                }

                public void treeNodesChanged(@NotNull TreeModelEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    TreePath treePath = e.getTreePath();
                    Intrinsics.checkNotNullExpressionValue((Object)treePath, (String)"e.treePath");
                    Object object = treePath.getLastPathComponent();
                    TreePath treePath2 = this.$variableNode.getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)treePath2, (String)"variableNode.path");
                    if (Intrinsics.areEqual((Object)object, (Object)treePath2.getLastPathComponent()) && e.getChildIndices() != null) {
                        int[] nArray = e.getChildIndices();
                        Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"e.childIndices");
                        JSBridgeImpl.access$removeChildren(this.this$0, nArray, this.$callbackId);
                        Object[] objectArray = e.getChildren();
                        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"e.children");
                        JSBridgeImpl.access$addChildren(this.this$0, this.$callbackId, objectArray, e.getChildIndices());
                    }
                }

                public void treeNodesRemoved(@NotNull TreeModelEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    TreePath treePath = e.getTreePath();
                    Intrinsics.checkNotNullExpressionValue((Object)treePath, (String)"e.treePath");
                    Object object = treePath.getLastPathComponent();
                    TreePath treePath2 = this.$variableNode.getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)treePath2, (String)"variableNode.path");
                    if (Intrinsics.areEqual((Object)object, (Object)treePath2.getLastPathComponent())) {
                        int[] nArray = e.getChildIndices();
                        Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"e.childIndices");
                        JSBridgeImpl.access$removeChildren(this.this$0, nArray, this.$callbackId);
                    }
                }
                {
                    this.this$0 = this$0;
                    this.$variableNode = $captured_local_variable$1;
                    this.$callbackId = $captured_local_variable$2;
                }
            };
            this.treeListeners.put(id, listener2);
            List list = variableNode.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"variableNode.children");
            Collection $this$toTypedArray$iv = list;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            Object[] objectArray = thisCollection$iv.toArray(new Object[0]);
            if (objectArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            Object[] children2 = objectArray;
            XDebuggerTree xDebuggerTree = variableNode.getTree();
            Intrinsics.checkNotNullExpressionValue((Object)xDebuggerTree, (String)"variableNode.tree");
            xDebuggerTree.getTreeModel().addTreeModelListener(listener2);
            JSBridgeImpl.addChildren$default(this, callbackId, children2, null, 4, null);
        }

        @Override
        public void collapse(int id) {
            XDebuggerTreeNode xDebuggerTreeNode;
            PrintableEntity printableEntity = this.webConsoleHistoryView.getSystemMessageCache$intellij_javascript_debugger().get(id);
            Intrinsics.checkNotNullExpressionValue((Object)printableEntity, (String)"webConsoleHistoryView.systemMessageCache[id]");
            PrintableEntity printableInfo = printableEntity;
            if (printableInfo instanceof TreeRoot) {
                xDebuggerTreeNode = ((TreeRoot)printableInfo).getRoot();
            } else {
                PrintableEntity printableEntity2 = printableInfo;
                if (printableEntity2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.intellij.javascript.debugger.console.Variable");
                }
                xDebuggerTreeNode = ((Variable)printableEntity2).getVariable();
            }
            XDebuggerTreeNode variableNode = xDebuggerTreeNode;
            XDebuggerTree xDebuggerTree = variableNode.getTree();
            Intrinsics.checkNotNullExpressionValue((Object)xDebuggerTree, (String)"variableNode.tree");
            xDebuggerTree.getTreeModel().removeTreeModelListener(this.treeListeners.get(id));
            this.treeListeners.remove(id);
        }

        @Override
        public void messageNodeCallback(int id) {
            TreeNode parent;
            PrintableEntity printableEntity = this.webConsoleHistoryView.getSystemMessageCache$intellij_javascript_debugger().get(id);
            if (printableEntity == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.javascript.debugger.console.Variable");
            }
            Variable printableInfo = (Variable)printableEntity;
            XDebuggerTreeNode xDebuggerTreeNode = printableInfo.getVariable();
            if (xDebuggerTreeNode == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.xdebugger.impl.ui.tree.nodes.MessageTreeNode");
            }
            MessageTreeNode node = (MessageTreeNode)xDebuggerTreeNode;
            if (node.isEllipsis() && (parent = node.getParent()) instanceof XValueContainerNode) {
                ((XValueContainerNode)parent).startComputingChildren();
            }
        }

        @Override
        public void updateStickToEnd(boolean stickToEnd) {
            this.webConsoleHistoryView.stickToEnd = stickToEnd;
        }

        @Override
        public void nodeLinkClick(int id) {
            PrintableEntity printableEntity = this.webConsoleHistoryView.getSystemMessageCache$intellij_javascript_debugger().get(id);
            if (printableEntity == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.javascript.debugger.console.Variable");
            }
            Variable printableInfo = (Variable)printableEntity;
            XDebuggerTreeNode node = printableInfo.getVariable();
            AppUIUtil.invokeOnEdt((Runnable)new Runnable(this, node){
                final /* synthetic */ JSBridgeImpl this$0;
                final /* synthetic */ XDebuggerTreeNode $node;

                public final void run() {
                    XDebuggerTreeNodeHyperlink xDebuggerTreeNodeHyperlink = this.$node.getLink();
                    Intrinsics.checkNotNull((Object)xDebuggerTreeNodeHyperlink);
                    xDebuggerTreeNodeHyperlink.onClick(new MouseEvent(JSBridgeImpl.access$getWebConsoleHistoryView$p(this.this$0).getComponent(), 0, 0L, 0, 0, 0, 1, false));
                }
                {
                    this.this$0 = jSBridgeImpl;
                    this.$node = xDebuggerTreeNode;
                }
            });
        }

        /*
         * WARNING - void declaration
         */
        private final void addChildren(int callbackId, Object[] children2, int[] childIndices) {
            Collection<Pair> collection;
            void $this$mapIndexedTo$iv$iv;
            void $this$mapIndexed$iv;
            Object[] objectArray = new Object[2];
            objectArray[0] = true;
            Object[] objectArray2 = children2;
            int n = 1;
            Object[] objectArray3 = objectArray;
            Object[] objectArray4 = objectArray;
            boolean $i$f$mapIndexed = false;
            void var7_9 = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(((void)$this$mapIndexed$iv).length);
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (void item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void ind;
                void it;
                int n2 = index$iv$iv++;
                void var15_17 = item$iv$iv;
                int n3 = n2;
                collection = destination$iv$iv;
                boolean bl = false;
                void v2 = it;
                if (v2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.intellij.xdebugger.impl.ui.tree.nodes.XDebuggerTreeNode");
                }
                XDebuggerTreeNode child = (XDebuggerTreeNode)v2;
                String string = child.getText().toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"child.text.toString()");
                ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.NORMAL_OUTPUT;
                Intrinsics.checkNotNullExpressionValue((Object)consoleViewContentType, (String)"ConsoleViewContentType.NORMAL_OUTPUT");
                Variable printable = new Variable(string, consoleViewContentType, child, child.getText());
                Map jsMessage = this.webConsoleHistoryView.prepareJSProps(printable);
                Pair pair = new Pair((Object)jsMessage, (Object)(childIndices != null ? Integer.valueOf(childIndices[ind]) : null));
                collection.add(pair);
            }
            collection = (List)destination$iv$iv;
            objectArray3[n] = collection;
            Object[] args = objectArray4;
            this.invokeCallback(callbackId, args);
        }

        static /* synthetic */ void addChildren$default(JSBridgeImpl jSBridgeImpl, int n, Object[] objectArray, int[] nArray, int n2, Object object) {
            if ((n2 & 4) != 0) {
                nArray = null;
            }
            jSBridgeImpl.addChildren(n, objectArray, nArray);
        }

        private final void removeChildren(int[] children2, int callbackId) {
            Object[] args = new Serializable[]{Boolean.valueOf(false), (Serializable)children2};
            this.invokeCallback(callbackId, args);
        }

        private final void invokeCallback(int callbackId, Object[] args) {
            this.webConsoleHistoryView.htmlPanel.runWhenPageReady((Function0<Unit>)((Function0)new Function0<Unit>(this, callbackId, args){
                final /* synthetic */ JSBridgeImpl this$0;
                final /* synthetic */ int $callbackId;
                final /* synthetic */ Object[] $args;

                public final void invoke() {
                    WebConsoleHistoryView.access$getHtmlPanel$p(JSBridgeImpl.access$getWebConsoleHistoryView$p(this.this$0)).executeScript("window.callback(" + this.$callbackId + ", " + WebConsoleHistoryView.access$getGson$cp().toJson((Object)this.$args) + ");");
                }
                {
                    this.this$0 = jSBridgeImpl;
                    this.$callbackId = n;
                    this.$args = objectArray;
                    super(0);
                }
            }));
        }

        @Override
        public void log(@Nullable String text) {
            Logger.getInstance(JSBridgeImpl.class).warn(text);
        }

        public JSBridgeImpl(@NotNull WebConsoleHistoryView webConsoleHistoryView) {
            Intrinsics.checkNotNullParameter((Object)webConsoleHistoryView, (String)"webConsoleHistoryView");
            this.webConsoleHistoryView = webConsoleHistoryView;
            boolean bl = false;
            this.treeListeners = new LinkedHashMap();
        }

        public static final /* synthetic */ WebConsoleHistoryView access$getWebConsoleHistoryView$p(JSBridgeImpl $this) {
            return $this.webConsoleHistoryView;
        }

        public static final /* synthetic */ void access$addChildren(JSBridgeImpl $this, int callbackId, Object[] children2, int[] childIndices) {
            $this.addChildren(callbackId, children2, childIndices);
        }

        public static final /* synthetic */ void access$removeChildren(JSBridgeImpl $this, int[] children2, int callbackId) {
            $this.removeChildren(children2, callbackId);
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/javascript/debugger/console/WebConsoleHistoryView$Companion;", "", "()V", "gson", "Lcom/google/gson/Gson;", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.javascript.debugger"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

