/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.scripts;

import com.intellij.javascript.debugger.JSDebuggerBundle;
import com.intellij.javascript.debugger.RemoteUrlMappingHelper;
import com.intellij.javascript.debugger.scripts.FileInfo;
import com.intellij.javascript.debugger.scripts.FileNode;
import com.intellij.javascript.debugger.scripts.ScriptTreeActionBase;
import com.intellij.javascript.debugger.scripts.SourcesTreeComponent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Url;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0014J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014R\u0014\u0010\u0005\u001a\u00020\u0006X\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u0006X\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0013"}, d2={"Lcom/intellij/javascript/debugger/scripts/SetLocalPathForScriptAction;", "Lcom/intellij/javascript/debugger/scripts/ScriptTreeActionBase;", "treeComponent", "Lcom/intellij/javascript/debugger/scripts/SourcesTreeComponent;", "(Lcom/intellij/javascript/debugger/scripts/SourcesTreeComponent;)V", "invisibleIfDisabled", "", "getInvisibleIfDisabled", "()Z", "isOnlyFile", "isApplicable", "info", "Lcom/intellij/javascript/debugger/scripts/FileInfo;", "perform", "", "node", "Lcom/intellij/javascript/debugger/scripts/FileNode;", "context", "Lcom/intellij/openapi/actionSystem/DataContext;", "intellij.javascript.debugger"})
public final class SetLocalPathForScriptAction
extends ScriptTreeActionBase {
    private final boolean isOnlyFile;
    private final boolean invisibleIfDisabled;

    @Override
    protected boolean isOnlyFile() {
        return this.isOnlyFile;
    }

    @Override
    protected boolean getInvisibleIfDisabled() {
        return this.invisibleIfDisabled;
    }

    @Override
    protected boolean isApplicable(@NotNull FileInfo info) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        Url url = info.getUrl();
        return !url.isInLocalFileSystem() && url.getScheme() != null && Intrinsics.areEqual((Object)url.getScheme(), (Object)"vm") ^ true && (!StringUtil.isEmpty((String)url.getAuthority()) || !StringUtil.isEmpty((String)url.getPath()));
    }

    @Override
    protected void perform(@NotNull FileNode node, @NotNull DataContext context) {
        Intrinsics.checkNotNullParameter((Object)((Object)node), (String)"node");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        FileInfo fileInfo = node.getFileInfo();
        RemoteUrlMappingHelper.showSetLocalPathDialog(this.getTreeComponent().getDebugProcess(), fileInfo.getUrl(), fileInfo.isFile());
    }

    public SetLocalPathForScriptAction(@NotNull SourcesTreeComponent treeComponent) {
        Intrinsics.checkNotNullParameter((Object)treeComponent, (String)"treeComponent");
        super(treeComponent, JSDebuggerBundle.message("js.scripts.set.local.path", new Object[0]));
    }
}

