/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.debugger.jdi;

import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.debugger.ui.tree.render.ClassRenderer;
import com.intellij.util.SmartList;
import com.intellij.util.ThreeState;
import com.jetbrains.debugger.jdi.AsyncResultCommand;
import com.jetbrains.debugger.jdi.JdiValueManager;
import com.sun.jdi.Field;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.TypeComponent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.debugger.Variable;
import org.jetbrains.debugger.VariableImpl;
import org.jetbrains.debugger.VariablesHost;
import org.jetbrains.debugger.values.ObjectValueBase;
import org.jetbrains.debugger.values.Value;
import org.jetbrains.debugger.values.ValueType;

public class JdiObject
extends ObjectValueBase<JdiValueManager> {
    protected final ObjectReference objectReference;
    protected VariablesHost<JdiValueManager> childrenManager;

    @NotNull
    protected VariablesHost<JdiValueManager> getChildrenManager() {
        VariablesHost<JdiValueManager> variablesHost = this.childrenManager;
        if (variablesHost == null) {
            JdiObject.$$$reportNull$$$0(0);
        }
        return variablesHost;
    }

    public JdiObject(@NotNull ValueType type, @NotNull ObjectReference objectReference, @NotNull JdiValueManager valueManager) {
        if (type == null) {
            JdiObject.$$$reportNull$$$0(1);
        }
        if (objectReference == null) {
            JdiObject.$$$reportNull$$$0(2);
        }
        if (valueManager == null) {
            JdiObject.$$$reportNull$$$0(3);
        }
        super(type);
        this.objectReference = objectReference;
        this.initChildManager(valueManager);
    }

    protected void initChildManager(@NotNull JdiValueManager valueManager) {
        if (valueManager == null) {
            JdiObject.$$$reportNull$$$0(4);
        }
        this.childrenManager = new VariablesHost<JdiValueManager>(valueManager){

            @NotNull
            protected Promise<List<Variable>> load() {
                AsyncPromise promise2 = new AsyncPromise();
                ((JdiValueManager)this.valueManager).getManagerThread().schedule((DebuggerCommandImpl)new AsyncResultCommand<List<Variable>>(promise2){

                    @Override
                    protected void doAction() throws Exception {
                        List<Field> allFields = JdiObject.this.objectReference.referenceType().allFields();
                        if (allFields.isEmpty()) {
                            this.updateCacheStamp();
                            this.promise.setResult(Collections.emptyList());
                            return;
                        }
                        ClassRenderer classRenderer = NodeRendererSettings.getInstance().getClassRenderer();
                        SmartList fields = new SmartList();
                        for (Field field : allFields) {
                            if (!JdiObject.shouldDisplay(classRenderer, field)) continue;
                            fields.add(field);
                        }
                        ArrayList<VariableImpl> variables = new ArrayList<VariableImpl>(fields.size());
                        Map<Field, com.sun.jdi.Value> fieldToValue = JdiObject.this.objectReference.getValues((List<? extends Field>)fields);
                        for (Field field : fields) {
                            Value value = ((JdiValueManager)valueManager).createValue(fieldToValue.get(field));
                            variables.add(new VariableImpl(field.name(), value, null));
                        }
                        this.updateCacheStamp();
                        this.promise.setResult(variables);
                    }
                });
                AsyncPromise asyncPromise = promise2;
                if (asyncPromise == null) {
                    1.$$$reportNull$$$0(0);
                }
                return asyncPromise;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/debugger/jdi/JdiObject$1", "load"));
            }
        };
    }

    private static boolean shouldDisplay(@NotNull ClassRenderer classRenderer, @NotNull Field field) {
        if (classRenderer == null) {
            JdiObject.$$$reportNull$$$0(5);
        }
        if (field == null) {
            JdiObject.$$$reportNull$$$0(6);
        }
        boolean isSynthetic = DebuggerUtils.isSynthetic((TypeComponent)field);
        if (!classRenderer.SHOW_SYNTHETICS && isSynthetic) {
            return false;
        }
        if (!classRenderer.SHOW_STATIC && field.isStatic()) {
            return false;
        }
        return classRenderer.SHOW_STATIC_FINAL || !field.isStatic() || !field.isFinal();
    }

    @Nullable
    public String getClassName() {
        return null;
    }

    @NotNull
    public ObjectReference getReference() {
        ObjectReference objectReference = this.objectReference;
        if (objectReference == null) {
            JdiObject.$$$reportNull$$$0(7);
        }
        return objectReference;
    }

    @NotNull
    public ThreeState hasProperties() {
        ThreeState threeState = this.getReference().referenceType().allFields().isEmpty() ? ThreeState.NO : ThreeState.YES;
        if (threeState == null) {
            JdiObject.$$$reportNull$$$0(8);
        }
        return threeState;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/debugger/jdi/JdiObject";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objectReference";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueManager";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classRenderer";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildrenManager";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/debugger/jdi/JdiObject";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getReference";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "hasProperties";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "initChildManager";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "shouldDisplay";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

