/*****
 NAME
	ccmdparser.h - header file for CCmdParser class
 VERSION
	$Id$
 CHANGELOG
	$Log$
 */

#if !defined(CCMDPARSER_H_INCLUDED)
#define CCMDPARSER_H_INCLUDED

#include <coconut/cxmlparser.h>
#include <coconut/cxmlnode.h>
#include <coconut/pcommand.h>

@interface CCmdParser : CXMLParser <PCmdParserIF>
{
}

- parseEnvNode: (id <PTree>) dst node: (id <PXMLNode>) node ;
- parseExitNode: (id <PTree>) dst node: (id <PXMLNode>) node ;
- parsePrintNode: (id <PTree>) dst node: (id <PXMLNode>) node ;
- parsePrintChildNode: (id <PCmdPrint>) print node: (id <PXMLNode>) node ;
- parsePrintText: (id <PCmdPrint>) print str: (id <PConstStr>) str ;

  /* if you give true to "dowarn", warning message will be displayed
     when the attribute is not found. */
- (id <PExp>) getValueAttr: (id <PXMLNode>) node warning: (boolean) dowarn ;
- (id <PString>) getNameAttr: (id <PXMLNode>) node warning: (boolean) dowarn ;
- (id <PString>) getStringAttr: (id <PXMLNode>) node warning: (boolean) dowarn ;

- (id <PString>) getAttr: (id <PXMLNode>) node name: (const utf8_char *) name
   warning: (boolean) dowarn ;

@end

#endif /* !defined(CCMDPARSER_H_INCLUDED) */

