/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.NamespaceMap;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.QNameValue;

public class ResolveQName
extends SystemFunction {
    @Override
    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        AtomicValue lex = (AtomicValue)arguments[0].head();
        if (lex == null) {
            return EmptySequence.getInstance();
        }
        return ResolveQName.resolveQName(lex.getStringValue(), (NodeInfo)arguments[1].head());
    }

    public static QNameValue resolveQName(String lexicalQName, NodeInfo element) throws XPathException {
        NamespaceMap resolver = element.getAllNamespaces();
        StructuredQName qName = StructuredQName.fromLexicalQName(lexicalQName, true, false, resolver);
        return new QNameValue(qName, BuiltInAtomicType.QNAME);
    }
}

